# バッチ設計書: CICSCNCS (sampncs.jcl)

## 1. 基本情報

| 項目 | 内容 |
|------|------|
| バッチ名 | CICSCNCS |
| JCLファイル | sampncs.jcl |
| カテゴリ | CICSサーバー起動 |
| 説明 | Named Counterサーバーの起動 |

## 2. 処理概要

このバッチは、GENAPPアプリケーションで使用するNamed Counterサーバーを起動します。Named Counterは、複数のCICSリージョン間で共有可能なカウンターを提供し、一意の番号生成やシーケンス管理に使用されます。

## 3. 実行ステップ

### ステップ一覧

| ステップ名 | 実行プログラム | 処理内容 |
|------------|----------------|----------|
| NCSERVER | DFHNCMN | Named Counterサーバーの起動 |

### ステップ詳細

#### NCSERVER ステップ

DFHNCMNプログラムを使用してNamed Counterサーバーを起動します。

| 項目 | 内容 |
|------|------|
| プログラム | DFHNCMN |
| 機能 | Named Counter管理サーバー |

## 4. 起動パラメータ

| パラメータ | 設定値 | 説明 |
|------------|--------|------|
| POOLNAME | GENA | Named Counterプール名 |

### パラメータ詳細

#### POOLNAME

- GENAPPアプリケーション用のNamed Counterプール識別子
- CICSリージョンからこのプール名を指定してアクセス
- TSキューサーバー（samptsq.jcl）と同じプール名を使用

## 5. DD文定義

| DD名 | 説明 | データセット |
|------|------|-------------|
| STEPLIB | CICSライブラリ | `<CICSHLQ>.SDFHAUTH`、`<CICSLIC>.SDFHLIC` |
| SYSPRINT | 出力リスト | SYSOUT=* |
| SYSIN | 入力(ダミー) | DUMMY |

## 6. 置換変数

| 変数名 | 説明 |
|--------|------|
| `<CICSHLQ>` | CICS高レベル修飾子 |
| `<CICSLIC>` | CICSライセンスライブラリ修飾子 |

## 7. Named Counterの仕組み

```
┌─────────────┐     ┌─────────────┐     ┌─────────────┐
│  CICS       │     │  CICS       │     │  CICS       │
│ Region A    │     │ Region B    │     │ Region C    │
└──────┬──────┘     └──────┬──────┘     └──────┬──────┘
       │                   │                   │
       │ GET_NEXT          │ GET_NEXT          │ GET_NEXT
       │                   │                   │
       └───────────────────┼───────────────────┘
                           │
                           ▼
            ┌─────────────────────────────┐
            │  DFHNCMN                    │
            │  Named Counterサーバー      │
            │  POOLNAME=GENA             │
            │                             │
            │  Counter1: 1000001 → ...   │
            │  Counter2: 2000001 → ...   │
            └─────────────────────────────┘
```

## 8. Named Counterの用途

### 一意番号生成

- 顧客番号の自動採番
- 保険証券番号の自動採番
- トランザクション識別子の生成

### シーケンス管理

- 複数CICSリージョン間で一意の連番を保証
- 重複のない番号割り当て

## 9. 前提条件

1. CICSライブラリ(`<CICSHLQ>.SDFHAUTH`)が利用可能であること
2. CICSライセンスライブラリ(`<CICSLIC>.SDFHLIC`)が利用可能であること
3. APF認証が設定されていること(SDFHAUTHはAPF認証が必要)

## 10. 実行後の確認事項

1. サーバーが正常に起動していること
2. SYSPRINTに起動完了メッセージが出力されていること
3. 指定されたプール名でCICSリージョンからアクセス可能であること

## 11. CICSリージョンでの設定

CICSリージョンがこのNamed Counterサーバーを使用するには、以下の設定が必要です:

### システム初期化パラメータ

```
NCPLDFT=GENA
```

### CICSプログラムからの使用

```cobol
EXEC CICS GET COUNTER(counter-name)
          POOL(GENA)
          VALUE(ws-value)
END-EXEC.

EXEC CICS UPDATE COUNTER(counter-name)
           POOL(GENA)
           VALUE(new-value)
END-EXEC.
```

## 12. 障害時の対応

### サーバー起動失敗

- STEPLIBのライブラリパスを確認
- APF認証の設定を確認
- SYSPRINTのエラーメッセージを確認

### プール名競合

- 同じPOOLNAMEで既にサーバーが起動していないか確認
- 既存のサーバーを停止してから再起動

### カウンター値の不整合

- サーバーを再起動してもカウンター値は保持される（永続化される場合）
- 必要に応じてカウンター値をリセット

## 13. 関連バッチ

| バッチ名 | 関係 |
|----------|------|
| samptsq.jcl | 同じプール名（GENA）を使用 |
| sampwui.jcl | Named Counterを使用するCICSリージョン（NCPLDFT=GENA設定） |

## 14. 運用上の注意

### 起動順序

1. Named Counterサーバー（このジョブ）を先に起動
2. その後、このサーバーを使用するCICSリージョンを起動

### 停止順序

1. CICSリージョンを先に停止
2. その後、Named Counterサーバーを停止

### 常駐サーバー

- このジョブは常駐サーバーとして継続稼働します
- ジョブ終了 = サーバー停止となります
- 停止する場合は P (STOP) コマンドまたはキャンセルを使用

## 15. TSキューサーバーとの違い

| 項目 | TSキューサーバー | Named Counterサーバー |
|------|-----------------|---------------------|
| プログラム | DFHXQMN | DFHNCMN |
| 用途 | 一時データ共有 | 連番生成 |
| データ | キューデータ | カウンター値 |
| パラメータ | MAXQUEUES, BUFFERS | (なし) |
