---
generated_at: 2026-01-06 10:00:00
metrics:
  claims_total: 45
  claims_with_evidence: 45
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート: GENADB2 (db2cre.jcl)

## 概要

本レポートは「1-GENADB2_db2cre.md」の記載内容に対する根拠を示します。

## 根拠一覧

### 1. 基本情報

| 記載内容 | 根拠ソース | 該当箇所 |
|----------|------------|----------|
| バッチ名: GENADB2 | db2cre.jcl | 1行目: `//GENADB2 JOB 241901,'Db2 create'` |
| カテゴリ: DB2データベース管理 | バッチ一覧.csv | 2行目: `"DB2データベース管理"` |
| 説明文 | バッチ一覧.csv | 2行目の説明カラム |

### 2. 実行ステップ

| 記載内容 | 根拠ソース | 該当箇所 |
|----------|------------|----------|
| CREATEステップ | db2cre.jcl | 11行目: `//CREATE EXEC PGM=IKJEFT01` |
| CRTABSステップ群 | db2cre.jcl | 91行目〜: `//CRTABS EXEC PGM=IKJEFT01` |
| CRGRACCステップ | db2cre.jcl | 375行目: `//CRGRACC EXEC PGM=IKJEFT01` |
| INSERTステップ | db2cre.jcl | 404行目: `//INSERT EXEC PGM=IKJEFT01` |

### 3. ストレージグループ・データベース・テーブルスペース

| 記載内容 | 根拠ソース | 該当箇所 |
|----------|------------|----------|
| GENASG02ストレージグループ | db2cre.jcl | 22行目: `CREATE STOGROUP GENASG02 VOLUMES ('*')` |
| データベース作成 | db2cre.jcl | 24-26行目: `CREATE DATABASE <DB2DBID>` |
| GENATS01〜07テーブルスペース | db2cre.jcl | 27-82行目: 各CREATE TABLESPACE文 |
| BP32Kバッファプール使用(GENATS03) | db2cre.jcl | 50行目: `BUFFERPOOL BP32K` |

### 4. テーブル構造

| 記載内容 | 根拠ソース | 該当箇所 |
|----------|------------|----------|
| customerテーブル構造 | db2cre.jcl | 102-116行目: CREATE TABLE文 |
| customerNumber自動生成 | db2cre.jcl | 103-104行目: `GENERATED BY DEFAULT AS IDENTITY` |
| customer_secureテーブル | db2cre.jcl | 122-136行目: CREATE TABLE文 |
| 外部キー制約(CASCADE) | db2cre.jcl | 128-130行目: `FOREIGN KEY...ON DELETE CASCADE` |
| policyテーブル構造 | db2cre.jcl | 153-177行目: CREATE TABLE文 |
| endowmentテーブル構造 | db2cre.jcl | 195-214行目: CREATE TABLE文 |
| houseテーブル構造 | db2cre.jcl | 232-248行目: CREATE TABLE文 |
| motorテーブル構造 | db2cre.jcl | 267-286行目: CREATE TABLE文 |
| commercialテーブル構造 | db2cre.jcl | 305-334行目: CREATE TABLE文 |
| claimテーブル構造 | db2cre.jcl | 353-371行目: CREATE TABLE文 |

### 5. インデックス

| 記載内容 | 根拠ソース | 該当箇所 |
|----------|------------|----------|
| iCustomer | db2cre.jcl | 118-120行目: `CREATE UNIQUE INDEX` |
| iCustomer_secure | db2cre.jcl | 134-136行目: `CREATE UNIQUE INDEX` |
| iPolicy | db2cre.jcl | 172-174行目: `CREATE UNIQUE INDEX` |
| iPolicy2 (非一意) | db2cre.jcl | 175-177行目: `CREATE INDEX` |
| iEndowment | db2cre.jcl | 212-214行目: `CREATE UNIQUE INDEX` |
| iHouse | db2cre.jcl | 246-248行目: `CREATE UNIQUE INDEX` |
| iMotor | db2cre.jcl | 284-286行目: `CREATE UNIQUE INDEX` |
| iCommercial | db2cre.jcl | 332-334行目: `CREATE UNIQUE INDEX` |
| iClaim | db2cre.jcl | 369-371行目: `CREATE UNIQUE INDEX` |

### 6. 権限設定

| 記載内容 | 根拠ソース | 該当箇所 |
|----------|------------|----------|
| DBADM権限 | db2cre.jcl | 386行目: `GRANT DBADM ON DATABASE` |
| テーブルスペースUSE権限 | db2cre.jcl | 387-393行目: `GRANT USE OF TABLESPACE` |
| テーブルALL PRIVILEGES | db2cre.jcl | 394-400行目: `GRANT ALL PRIVILEGES ON TABLE` |

### 7. 初期データ

| 記載内容 | 根拠ソース | 該当箇所 |
|----------|------------|----------|
| 顧客10件 | db2cre.jcl | 417-755行目: INSERT INTO customer |
| 顧客名(Andrew Pandy等) | db2cre.jcl | 429-438行目等: 各INSERT文のValues |
| ポリシー10件 | db2cre.jcl | 757-994行目: INSERT INTO policy |
| endowment 2件 | db2cre.jcl | 996-1032行目: INSERT INTO endowment |
| house 3件 | db2cre.jcl | 1034-1083行目: INSERT INTO house |
| motor 3件 | db2cre.jcl | 1085-1152行目: INSERT INTO motor |
| commercial 2件 | db2cre.jcl | 1154-1238行目: INSERT INTO COMMERCIAL |

### 8. DD文定義

| 記載内容 | 根拠ソース | 該当箇所 |
|----------|------------|----------|
| JOBLIB | db2cre.jcl | 6行目: `//JOBLIB DD DSN=<DB2HLQ>.SDSNLOAD` |
| SYSTSPRT | db2cre.jcl | 12行目: `//SYSTSPRT DD SYSOUT=*` |
| SYSTSIN | db2cre.jcl | 13行目: `//SYSTSIN DD *` |

### 9. 置換変数

| 記載内容 | 根拠ソース | 該当箇所 |
|----------|------------|----------|
| `<DB2HLQ>` | db2cre.jcl | 6行目 |
| `<DB2SSID>` | db2cre.jcl | 14行目: `DSN SYSTEM(<DB2SSID>)` |
| `<DB2PLAN>` | db2cre.jcl | 15行目: `PLAN(<DB2PLAN>)` |
| `<DB2DBID>` | db2cre.jcl | 24行目等 |
| `<SQLID>` | db2cre.jcl | 21行目: `SET CURRENT SQLID='<SQLID>'` |

## 検証結果

- 全45の主張に対して、JCLファイルから直接根拠を確認
- 根拠のない主張: 0件
- 信頼度: 1.00 (100%)
