---
generated_at: 2026-01-06 18:30:00
metrics:
  claims_total: 18
  claims_with_evidence: 16
  claims_without_evidence: 2
confidence_derived: 0.89
---

# 根拠レポート：11-CMASサーバー起動

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.89**
  - 根拠あり：16 / 18、根拠なし：2
- 優先レビュー（高）
  1. **目標処理時間**：実測値なし、推定値
  2. **監視閾値**：運用要件からの推定

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。

- E-01: `base/cntl/sampcma.jcl` - CMASサーバー起動JCL
- E-02: `docs/code-to-docs/バッチ一覧/バッチ一覧.csv` - バッチ一覧定義
- E-03: `base/cntl/defdrep.jcl` - データリポジトリ定義JCL（参照関係）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | EYU9XECSプログラムを使用 | E-01 (行6) | ○ |
| C-02 | START=INITIALパラメータ | E-01 (行7) | ○ |
| C-03 | APPLID、SYSIDNTパラメータ使用 | E-01 (行7-8) | ○ |
| C-04 | STEPLIBにSEYUAUTH含む | E-01 (行9-12) | ○ |
| C-05 | DFHRPLにSEYULOAD含む | E-01 (行14-17) | ○ |
| C-06 | EYUDREP接続 | E-01 (行19) | ○ |
| C-07 | SEC(YES)設定 | E-01 (行22) | ○ |
| C-08 | SECLOGMSG(YES)設定 | E-01 (行23) | ○ |
| C-09 | DFHCSD接続 | E-01 (行41) | ○ |
| C-10 | TIME=1440設定 | E-01 (行6) | ○ |
| C-11 | REGION=0M設定 | E-01 (行6) | ○ |
| C-12 | MEMLIMIT=10G設定 | E-01 (行6) | ○ |
| C-13 | CPSMCONN=CMAS設定 | E-01 (行64) | ○ |
| C-14 | TCPIP=YES設定 | E-01 (行60) | ○ |
| C-15 | EDSALIM=500M設定 | E-01 (行65) | ○ |
| C-16 | MXT=400設定 | E-01 (行66) | ○ |
| C-17 | 目標処理時間5分以内 | **根拠なし** | △ |
| C-18 | 監視閾値300秒 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- 目標処理時間：実際の起動時間の計測データがないため、一般的なCMAS起動時間から推定
  - 候補：運用ログ / 性能テスト結果 / IBM公式ドキュメント
- 監視閾値：運用要件定義書が存在しないため、目標処理時間から設定
  - 候補：運用要件定義書 / SLA定義書 / 監視設計書

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - JCL構造、パラメータ設定は明確に根拠あり
- 1: 中リスク - パフォーマンス要件、監視設定は推定値

## 6) レビュアーチェックリスト（最小）
- [ ] JCLパラメータ（CMASAPPL、CMASYSID等）の実環境値確認
- [ ] 目標処理時間の妥当性確認
- [ ] 監視閾値の運用要件との整合性確認
- [ ] セキュリティ設定（SEC、SECLOGMSG）の要件適合確認
