---
generated_at: 2026-01-06 18:34:00
metrics:
  claims_total: 18
  claims_with_evidence: 17
  claims_without_evidence: 1
confidence_derived: 0.94
---

# 根拠レポート：13-CMASデータリポジトリ定義

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.94**
  - 根拠あり：17 / 18、根拠なし：1
- 優先レビュー（高）
  1. **目標処理時間2分以内**：実測値なし、推定値

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。

- E-01: `base/cntl/defdrep.jcl` - CMASデータリポジトリ定義JCL
- E-02: `docs/code-to-docs/バッチ一覧/バッチ一覧.csv` - バッチ一覧定義

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | IDCAMSによるクラスタ削除 | E-01 (行9, EXEC PGM=IDCAMS) | ○ |
| C-02 | DELETE文で既存クラスタ削除 | E-01 (行13) | ○ |
| C-03 | SET MAXCC=0でエラー無視 | E-01 (行14) | ○ |
| C-04 | DEFINE CLUSTERでクラスタ定義 | E-01 (行22-34) | ○ |
| C-05 | STORCLAS(STANDARD)指定 | E-01 (行24) | ○ |
| C-06 | RECORDS(500 3000)指定 | E-01 (行25) | ○ |
| C-07 | CONTROLINTERVALSIZE(8192)指定 | E-01 (行26) | ○ |
| C-08 | RECSZ(200,6550)指定 | E-01 (行27) | ○ |
| C-09 | KEYS(64,0)指定 | E-01 (行28) | ○ |
| C-10 | SHR(2)指定 | E-01 (行29) | ○ |
| C-11 | SPEED/REUSE/ERASE指定 | E-01 (行30-32) | ○ |
| C-12 | INDEXED指定 | E-01 (行33) | ○ |
| C-13 | EYU9XDUTによる初期化 | E-01 (行37) | ○ |
| C-14 | COND=(8,LT)条件 | E-01 (行38) | ○ |
| C-15 | CMASNAMEパラメータ | E-01 (行39) | ○ |
| C-16 | TIMEZONE/DAYLIGHT/ZONEOFFSET設定 | E-01 (行40-43) | ○ |
| C-17 | WUIサーバー情報登録（EYUXDPRM） | E-01 (行44-47) | ○ |
| C-18 | 目標処理時間2分以内 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- 目標処理時間：VSAM定義および初期化処理の実測データがないため、一般的な処理時間から推定
  - 候補：運用ログ / 性能テスト結果 / z/OS性能ガイドライン

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - JCL構造、IDCAMSパラメータは明確に根拠あり
- 0: 低リスク - 初期化ユーティリティのパラメータは全て確認可能

## 6) レビュアーチェックリスト（最小）
- [ ] USRHLQ、CMASAPPL、CMASYSIDの実環境値確認
- [ ] WUIAPPL、WUISYSIDの実環境値確認
- [ ] STANDARDストレージクラスの存在確認
- [ ] タイムゾーン設定の妥当性確認
