---
generated_at: 2026-01-06 18:36:00
metrics:
  claims_total: 12
  claims_with_evidence: 11
  claims_without_evidence: 1
confidence_derived: 0.92
---

# 根拠レポート：14-ITPログリスト出力

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.92**
  - 根拠あり：11 / 12、根拠なし：1
- 優先レビュー（高）
  1. **目標処理時間5分以内**：実測値なし、推定値

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。

- E-01: `base/cntl/itpll.jcl` - ITPログリスト出力JCL
- E-02: `docs/code-to-docs/バッチ一覧/バッチ一覧.csv` - バッチ一覧定義

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | ITPLLプログラムを使用 | E-01 (行6, EXEC PGM=ITPLL) | ○ |
| C-02 | SITPLOADライブラリ参照 | E-01 (行7) | ○ |
| C-03 | SYSPRINT出力先SYSOUT=A | E-01 (行8) | ○ |
| C-04 | SYSUT1でWSIMLGX参照 | E-01 (行9) | ○ |
| C-05 | CNSLパラメータ | E-01 (行11) | ○ |
| C-06 | FMTSNAパラメータ | E-01 (行12) | ○ |
| C-07 | DSPLYパラメータ | E-01 (行13) | ○ |
| C-08 | DATAパラメータ | E-01 (行14) | ○ |
| C-09 | RUNパラメータ | E-01 (行15) | ○ |
| C-10 | ENDパラメータ | E-01 (行16) | ○ |
| C-11 | ジョブ名GENALL | E-01 (行1) | ○ |
| C-12 | 目標処理時間5分以内 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- 目標処理時間：ログファイルサイズに依存するため、実測データがないため推定
  - 候補：性能テスト結果 / 運用ログ / IBM ITPドキュメント

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - JCL構造、パラメータ設定は明確に根拠あり
- 0: 低リスク - 読み取り専用処理のため副作用なし

## 6) レビュアーチェックリスト（最小）
- [ ] WSIMHLQの実環境値確認
- [ ] WSIMLGXデータセットの存在確認
- [ ] SITPLOADライブラリのアクセス権確認
