---
generated_at: 2026-01-06 18:38:00
metrics:
  claims_total: 16
  claims_with_evidence: 15
  claims_without_evidence: 1
confidence_derived: 0.94
---

# 根拠レポート：15-ITPスクリプトコンパイル

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.94**
  - 根拠あり：15 / 16、根拠なし：1
- 優先レビュー（高）
  1. **目標処理時間5分以内**：実測値なし、推定値

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。

- E-01: `base/cntl/itpstl.jcl` - ITPスクリプトコンパイルJCL
- E-02: `docs/code-to-docs/バッチ一覧/バッチ一覧.csv` - バッチ一覧定義

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | ITPSTLプログラムを使用 | E-01 (行7, EXEC PGM=ITPSTL) | ○ |
| C-02 | SITPLOADライブラリ参照 | E-01 (行8) | ○ |
| C-03 | REGION=7M設定 | E-01 (行1) | ○ |
| C-04 | SYSUT1ワークファイル定義 | E-01 (行14) | ○ |
| C-05 | SYSIN参照でWSIMWSX(&MEM) | E-01 (行11) | ○ |
| C-06 | SYSLIB参照でWSIMWSX | E-01 (行12) | ○ |
| C-07 | MSGDD参照でWSIMMSX | E-01 (行13) | ○ |
| C-08 | #ONCICS コンパイル | E-01 (行17) | ○ |
| C-09 | #SSVARS コンパイル | E-01 (行18) | ○ |
| C-10 | 顧客スクリプト（SSC1A1, SSC1I1） | E-01 (行19-20) | ○ |
| C-11 | ポリシー追加スクリプト（SSP1A1-SSP4A1） | E-01 (行21,25,29,33) | ○ |
| C-12 | ポリシー削除スクリプト（SSP1D1-SSP4D1） | E-01 (行22,26,30,34) | ○ |
| C-13 | ポリシー照会スクリプト（SSP1I1-SSP4I1） | E-01 (行23,27,31,35) | ○ |
| C-14 | ポリシー更新スクリプト（SSP1U1-SSP3U1） | E-01 (行24,28,32) | ○ |
| C-15 | STOPスクリプト | E-01 (行36) | ○ |
| C-16 | 目標処理時間5分以内 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- 目標処理時間：コンパイル対象数と複雑さに依存するため、実測データがないため推定
  - 候補：性能テスト結果 / 運用ログ / IBM ITPドキュメント

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - JCL構造、コンパイル対象は明確に根拠あり
- 0: 低リスク - コンパイル処理のため副作用なし

## 6) レビュアーチェックリスト（最小）
- [ ] WSIMHLQの実環境値確認
- [ ] WSIMWSXデータセットの存在確認
- [ ] 全コンパイル対象メンバーの存在確認
- [ ] WSIMMSXメッセージライブラリの存在確認
