---
generated_at: 2026-01-06 18:40:00
metrics:
  claims_total: 14
  claims_with_evidence: 12
  claims_without_evidence: 2
confidence_derived: 0.86
---

# 根拠レポート：16-ワークロードシミュレーション実行

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.86**
  - 根拠あり：12 / 14、根拠なし：2
- 優先レビュー（高）
  1. **DB操作内容**：実際のスクリプト内容による
  2. **テスト計画依存のパフォーマンス要件**：テスト計画書が必要

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。

- E-01: `base/cntl/itpentr.jcl` - ワークロードシミュレーション実行JCL
- E-02: `docs/code-to-docs/バッチ一覧/バッチ一覧.csv` - バッチ一覧定義
- E-03: `base/cntl/itpstl.jcl` - スクリプトコンパイルJCL（参照）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | ITPENTERプログラムを使用 | E-01 (行6, EXEC PGM=ITPENTER) | ○ |
| C-02 | PARM='NTWRK=GENAPP'指定 | E-01 (行6) | ○ |
| C-03 | SITPLOADライブラリ参照 | E-01 (行7) | ○ |
| C-04 | INITDDでWSIMWSX参照 | E-01 (行8) | ○ |
| C-05 | MSGDDでWSIMMSX, WSIMWSX参照 | E-01 (行9-10) | ○ |
| C-06 | LOGDDでWSIMLGX参照 | E-01 (行11) | ○ |
| C-07 | AUTOLOG DD DUMMY | E-01 (行12) | ○ |
| C-08 | SYSUDUMP出力 | E-01 (行13) | ○ |
| C-09 | SYSPRINT出力 | E-01 (行14) | ○ |
| C-10 | REGION=0M設定 | E-01 (行1) | ○ |
| C-11 | ジョブ名GENAWSIM | E-01 (行1) | ○ |
| C-12 | シミュレートされるDB操作内容 | **根拠不足** | △ |
| C-13 | テスト計画依存の処理時間 | **根拠なし** | △ |
| C-14 | スクリプトコンパイル必須 | E-03（参照） | ○ |

## 4) 不足情報（Unknown / Missing）
- DB操作内容：実際のテストスクリプト（WSIMWSX内のメンバー）の解析が必要
  - 候補：スクリプトソース / テスト仕様書
- パフォーマンス要件：テスト計画書が存在しないため推定
  - 候補：テスト計画書 / 性能要件定義書

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - JCL構造は明確に根拠あり
- 1: 中リスク - シミュレーション内容はスクリプト依存

## 6) レビュアーチェックリスト（最小）
- [ ] WSIMHLQの実環境値確認
- [ ] WSIMWSX、WSIMMSX、WSIMLGXデータセットの存在確認
- [ ] GENAPPネットワーク定義の内容確認
- [ ] 対象CICS環境の起動状態確認
- [ ] テスト実行前のデータバックアップ確認
