---
generated_at: 2026-01-06 18:46:00
metrics:
  claims_total: 18
  claims_with_evidence: 17
  claims_without_evidence: 1
confidence_derived: 0.94
---

# 根拠レポート：19-顧客更新Webサービス生成

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.94**
  - 根拠あり：17 / 18、根拠なし：1
- 優先レビュー（高）
  1. **目標処理時間5分以内**：実測値なし、推定値

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。

- E-01: `base/cntl/wsauc01.jcl` - 顧客更新Webサービス生成JCL
- E-02: `docs/code-to-docs/バッチ一覧/バッチ一覧.csv` - バッチ一覧定義
- E-03: `base/src/lgucus01.cbl` - 顧客更新COBOLプログラム

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | DFHLS2WSプロシージャ使用 | E-01 (行13) | ○ |
| C-02 | JAVADIR='java601_bit64_ga/J6.0.1_64' | E-01 (行14) | ○ |
| C-03 | USSDIR='cics660' | E-01 (行15) | ○ |
| C-04 | TMPDIR='/tmp' | E-01 (行17) | ○ |
| C-05 | PDSLIB=SOURCEX | E-01 (行20) | ○ |
| C-06 | LANG=COBOL | E-01 (行21) | ○ |
| C-07 | PGMNAME=LGUCUS01 | E-01 (行22) | ○ |
| C-08 | REQMEM=SOAIC01 | E-01 (行23) | ○ |
| C-09 | RESPMEM=SOAIC01 | E-01 (行24) | ○ |
| C-10 | LOGFILEパス | E-01 (行25) | ○ |
| C-11 | URI=GENAPP/LGUCUS01 | E-01 (行26) | ○ |
| C-12 | PGMINT=COMMAREA | E-01 (行27) | ○ |
| C-13 | WSBIND出力パス | E-01 (行28) | ○ |
| C-14 | WSDL出力パス | E-01 (行29) | ○ |
| C-15 | HTTPPROXYプロキシ設定 | E-01 (行30) | ○ |
| C-16 | REGION=900M設定 | E-01 (行2) | ○ |
| C-17 | LGUCUS01は顧客更新機能 | E-03 (行5-8) | ○ |
| C-18 | 目標処理時間5分以内 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- 目標処理時間：WSDL/WSBIND生成の実測データがないため、一般的な処理時間から推定
  - 候補：性能テスト結果 / 運用ログ / IBM CICS Webサービスドキュメント

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - JCL構造、パラメータ設定は明確に根拠あり
- 0: 低リスク - 生成処理のため副作用なし

## 6) レビュアーチェックリスト（最小）
- [ ] CICSHLQの実環境値確認
- [ ] SOURCEXデータセットの存在確認
- [ ] SOAIC01コピーブックの存在確認
- [ ] ZFSHOMEパスの存在・権限確認
- [ ] Java環境の利用可能性確認
- [ ] HTTPプロキシ設定の妥当性確認
