---
generated_at: 2026-01-06 18:36:00
metrics:
  claims_total: 15
  claims_with_evidence: 14
  claims_without_evidence: 1
confidence_derived: 0.93
---

# 根拠レポート：24-GENASOAP_wsavc01.md

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.93**
  - 根拠あり：14 / 15、根拠なし：1
- 優先レビュー（高）
  1. **バッチ一覧との名称不整合**：要確認（バッチ一覧では「商業保険照会」、JCLでは「VSAM顧客番号取得」）

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `base/cntl/wsavc01.jcl` - VSAM顧客照会Webサービス生成JCL
- E-02: `base/src/lgicvs01.cbl` - VSAM顧客照会COBOLプログラム
- E-03: JCL内コメント「Obtain CUSTOMER number from VSAM file」
- E-04: `docs/code-to-docs/バッチ一覧/バッチ一覧.csv` - バッチ一覧

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 顧客照会プログラムはLGICVS01である | E-01, E-02 | ○ |
| C-02 | VSAMファイルから顧客番号を取得する | E-02, E-03 | ○ |
| C-03 | DFHLS2WSプロシージャを使用する | E-01 | ○ |
| C-04 | Java 6.0.1 64bitを使用する | E-01 | ○ |
| C-05 | CICS TS 6.6（cics660）を使用する | E-01 | ○ |
| C-06 | PGMINTはCOMMAREAである | E-01, E-02 | ○ |
| C-07 | 出力先は{ZFSHOME}/genapp/wsdir/である | E-01 | ○ |
| C-08 | ログ出力先は{ZFSHOME}/genapp/logs/である | E-01 | ○ |
| C-09 | REGIONは900Mである | E-01 | ○ |
| C-10 | リクエストCOPYBOOKはSOAVCIIである | E-01 | ○ |
| C-11 | レスポンスCOPYBOOKはSOAVCIOである | E-01 | ○ |
| C-12 | VSAMファイルKSDSCUSTを使用する | E-02 | ○ |
| C-13 | TSキュー（GENACNTL）で範囲を管理 | E-02 | ○ |
| C-14 | URIはGENAPP/LGICVS01である | E-01 | ○ |
| C-15 | 商業保険照会機能である | E-04 vs E-03 | △ |

## 4) 不足情報（Unknown / Missing）
- バッチ一覧との名称整合性確認が必要
  - バッチ一覧：「商業保険照会Webサービス生成」
  - JCLコメント：「Obtain CUSTOMER number from VSAM file」
  - 実際の機能はVSAMからの顧客番号取得であり、名称の見直しが必要な可能性あり

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - JCL構造とパラメータは実コードから確認済み
- 1: 中リスク - バッチ一覧との名称不整合の確認が必要
- 0: 低リスク - プログラムの機能（VSAM顧客照会）は明確

## 6) レビュアーチェックリスト（最小）
- [ ] バッチ一覧の名称（商業保険照会）とJCLの実際の機能（VSAM顧客番号取得）の整合性を確認
- [ ] 実際の環境でのパス（ZFSHOME等）が正しく置換されているか確認
- [ ] COPYBOOK（SOAVCII, SOAVCIO）が実在し、内容が正しいか確認
- [ ] VSAMファイル（KSDSCUST）が正しく定義されているか確認
