---
generated_at: 2026-01-06 18:38:00
metrics:
  claims_total: 22
  claims_with_evidence: 21
  claims_without_evidence: 1
confidence_derived: 0.95
---

# 根拠レポート：25-GENACSD_cdef122.md

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.95**
  - 根拠あり：21 / 22、根拠なし：1
- 優先レビュー（高）
  1. **パフォーマンス監視閾値**：根拠不足（推定値）

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `base/cntl/cdef122.jcl` - CSD定義JCL（バージョン2）
- E-02: `base/cntl/cdef121.jcl` - CSD定義JCL（バージョン1、比較用）
- E-03: JCL内コメント「CSD definitions for TOR-AOR-DOR configuration」

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | DFHCSUDPプログラムを使用する | E-01 | ○ |
| C-02 | TOR-AOR-DOR構成のCSD定義である | E-01, E-03 | ○ |
| C-03 | グループGENATORT, GENATORP等を定義 | E-01 | ○ |
| C-04 | 既存グループを削除してから再定義 | E-01 | ○ |
| C-05 | TOR用トランザクション（SSC1, SSP1-4等）を定義 | E-01 | ○ |
| C-06 | プログラムにDynamic(Yes)を設定 | E-01 | ○ |
| C-07 | プログラムにTransIDを設定 | E-01 | ○ |
| C-08 | DOR用トランザクションはDFHMIRSを使用 | E-01 | ○ |
| C-09 | DB2Conn定義を含む | E-01 | ○ |
| C-10 | DB2Entry定義を含む | E-01 | ○ |
| C-11 | DB2プランはGENAONE | E-01 | ○ |
| C-12 | ThreadLimitは250 | E-01 | ○ |
| C-13 | TCBlimitは400 | E-01 | ○ |
| C-14 | VSAMファイル KSDSCUST を定義 | E-01 | ○ |
| C-15 | VSAMファイル KSDSPOLY を定義 | E-01 | ○ |
| C-16 | KSDSCUSTのレコードサイズは82 | E-01 | ○ |
| C-17 | KSDSPOLYのレコードサイズは64 | E-01 | ○ |
| C-18 | ENQmodel（GENAMOD）を定義 | E-01 | ○ |
| C-19 | REGIONは1M | E-01 | ○ |
| C-20 | cdef121との差分はDynamic/TransID設定 | E-01, E-02 | ○ |
| C-21 | TORLISTにGENATORT, GENATORP, GENAを追加 | E-01 | ○ |
| C-22 | パフォーマンス監視閾値は5分 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- パフォーマンス監視閾値の根拠が不明
  - 候補：監視設計書 / 運用マニュアル / アラート設定書

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - JCL構造とCSDコマンドは実コードから確認済み
- 0: 低リスク - TOR-AOR-DOR構成の定義は明確
- 0: 低リスク - DB2接続定義、ファイル定義は詳細に記載あり
- 1: 中リスク - パフォーマンス監視閾値は推定値

## 6) レビュアーチェックリスト（最小）
- [ ] 実際の環境変数（CICSHLQ, CSDNAME, DB2SSID等）が正しく設定されているか確認
- [ ] cdef121.jclとの定義の違い（Dynamic/TransID設定）が意図通りか確認
- [ ] DB2接続定義のパラメータ（ThreadLimit, TCBlimit等）が運用要件に合致しているか確認
- [ ] VSAMファイル定義のパラメータ（Recordsize, Keylength等）が実ファイルと一致しているか確認
