---
generated_at: 2026-01-06 18:40:00
metrics:
  claims_total: 14
  claims_with_evidence: 13
  claims_without_evidence: 1
confidence_derived: 0.93
---

# 根拠レポート：26-GENACSD_cdef123.md

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.93**
  - 根拠あり：13 / 14、根拠なし：1
- 優先レビュー（高）
  1. **Webサービスエンドポイント形式**：推定値（CICSの標準動作に基づく）

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `base/cntl/cdef123.jcl` - Webサービス用CSD定義JCL
- E-02: JCL内コメント「CSD definitions for WEBSERVICES」

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | DFHCSUDPプログラムを使用する | E-01 | ○ |
| C-02 | Webサービス用のCSD定義である | E-01, E-02 | ○ |
| C-03 | GENAWSRVグループをAORLISTに追加 | E-01 | ○ |
| C-04 | TCPIPサービスGENATCP1を定義 | E-01 | ○ |
| C-05 | ポート番号は4321 | E-01 | ○ |
| C-06 | プロトコルはHTTP | E-01 | ○ |
| C-07 | トランザクションはCWXN | E-01 | ○ |
| C-08 | URMはNONE | E-01 | ○ |
| C-09 | パイプラインGENAPIP1を定義 | E-01 | ○ |
| C-10 | パイプライン設定ファイルはbasicsoap11provider.xml | E-01 | ○ |
| C-11 | Shelf は /var/cicstsge/ | E-01 | ○ |
| C-12 | WSdir は /u/s8smith/genapp/wsdir | E-01 | ○ |
| C-13 | REGIONは1M | E-01 | ○ |
| C-14 | エンドポイントは http://{hostname}:4321/GENAPP/{サービス名} | **推定** | △ |

## 4) 不足情報（Unknown / Missing）
- Webサービスエンドポイントの形式はCICS標準動作に基づく推定
  - 候補：CICS Webサービス設計書 / テスト結果 / IBM文書

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - JCL構造とCSDコマンドは実コードから確認済み
- 0: 低リスク - TCPIPサービスとパイプライン設定は明確
- 1: 中リスク - パス（/u/s8smith等）は環境依存のため要確認

## 6) レビュアーチェックリスト（最小）
- [ ] 実際の環境変数（CICSHLQ, CSDNAME）が正しく設定されているか確認
- [ ] ポート番号4321が環境で利用可能か確認
- [ ] パイプライン設定ファイルのパスが実環境と一致しているか確認
- [ ] WSdirのパスが実環境と一致しているか確認
- [ ] CICS起動後にWebサービスが正常に動作するかテスト
