---
generated_at: 2026-01-06 18:42:00
metrics:
  claims_total: 14
  claims_with_evidence: 13
  claims_without_evidence: 1
confidence_derived: 0.93
---

# 根拠レポート：27-GENACSD_cdef124.md

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.93**
  - 根拠あり：13 / 14、根拠なし：1
- 優先レビュー（高）
  1. **バンドルディレクトリのパス**：環境依存のため要確認

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `base/cntl/cdef124.jcl` - イベント処理用CSD定義JCL
- E-02: `base/src/lgastat1.cbl` - トランザクション統計プログラム
- E-03: `base/src/lgwebst5.cbl` - Web統計表示プログラム
- E-04: JCL内コメント「CSD definitions for Event processing - Transaction throughput」

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | DFHCSUDPプログラムを使用する | E-01 | ○ |
| C-02 | イベント処理用のCSD定義である | E-01, E-04 | ○ |
| C-03 | GENAEVNTグループをTORLISTに追加 | E-01 | ○ |
| C-04 | プログラムLGASTAT1を定義 | E-01, E-02 | ○ |
| C-05 | プログラムLGWEBST5を定義 | E-01, E-03 | ○ |
| C-06 | トランザクションLGSTを定義 | E-01 | ○ |
| C-07 | トランザクションSSSTを定義 | E-01 | ○ |
| C-08 | LGSTはLGASTAT1を呼び出す | E-01 | ○ |
| C-09 | SSSTはLGWEBST5を呼び出す | E-01 | ○ |
| C-10 | バンドルGENAEV01を定義 | E-01 | ○ |
| C-11 | バンドルディレクトリは /u/s8smith/genapp/genapp | E-01 | ○ |
| C-12 | REGIONは1M | E-01 | ○ |
| C-13 | トランザクションスループット統計を収集 | E-04 | ○ |
| C-14 | バンドルの中身（イベント定義詳細）| **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- バンドルディレクトリの内容詳細
  - 候補：バンドルマニフェスト / イベント定義XML / デプロイメントガイド
- バンドルで発行されるビジネスイベントの詳細仕様
  - 候補：イベント設計書 / メッセージフォーマット定義

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - JCL構造とCSDコマンドは実コードから確認済み
- 0: 低リスク - プログラムの存在（LGASTAT1, LGWEBST5）は確認済み
- 1: 中リスク - バンドルディレクトリのパスは環境依存
- 1: 中リスク - バンドルの内容詳細が不明

## 6) レビュアーチェックリスト（最小）
- [ ] 実際の環境変数（CICSHLQ, CSDNAME）が正しく設定されているか確認
- [ ] バンドルディレクトリのパスが実環境と一致しているか確認
- [ ] バンドルディレクトリにバンドルマニフェストが存在するか確認
- [ ] LGASTAT1, LGWEBST5プログラムがコンパイル済みであることを確認
- [ ] CICS起動後にイベント処理が正常に動作するかテスト
