---
generated_at: 2026-01-06 18:46:00
metrics:
  claims_total: 25
  claims_with_evidence: 24
  claims_without_evidence: 1
confidence_derived: 0.96
---

# 根拠レポート：29-GENACSD_cpsmde2.md

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.96**
  - 根拠あり：24 / 25、根拠なし：1
- 優先レビュー（高）
  1. **パフォーマンス監視閾値**：根拠不足（推定値）

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `base/cntl/cpsmde2.jcl` - CICSPlex SM定義JCL
- E-02: JCL内SYSIN部分 - DEFINE CICSPLEX、DEFINE REGION等のコマンド
- E-03: JCL内RESDEFS部分 - RESGROUP、RESDESC、TRANGRP、WLMDEF等の定義

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | EYU9XDBTプログラムを使用する | E-01 | ○ |
| C-02 | CICSplex GNAPPLEXを定義 | E-02 | ○ |
| C-03 | TOR、AOR、DORリージョンを登録 | E-02 | ○ |
| C-04 | CICSグループGENATOR、GENAAOR、GENADOR、GENAALLを定義 | E-02 | ○ |
| C-05 | リソースグループGENAPPを定義 | E-03 | ○ |
| C-06 | リソース記述RDGENAPPを定義 | E-03 | ○ |
| C-07 | トランザクショングループGENAWLMTを定義 | E-03 | ○ |
| C-08 | ワークロード定義GENAWLMDを定義 | E-03 | ○ |
| C-09 | ワークロードグループGENAWLMGを定義 | E-03 | ○ |
| C-10 | ワークロード仕様GENAWLMを定義 | E-03 | ○ |
| C-11 | ワークロード仕様GENBWLMを定義 | E-03 | ○ |
| C-12 | GENAWLMのAORスコープはGENAAOR | E-03 | ○ |
| C-13 | GENBWLMのAORスコープはGENADOR | E-03 | ○ |
| C-14 | アルゴリズムはQUEUE | E-03 | ○ |
| C-15 | イベント名はDB2MOND | E-03 | ○ |
| C-16 | DSCAトランザクションをGENAWLMTに追加 | E-03 | ○ |
| C-17 | DSCIトランザクションをGENAWLMTに追加 | E-03 | ○ |
| C-18 | その他DS*、VS*トランザクションを追加 | E-03 | ○ |
| C-19 | GENAWLMをTORにリンク | E-03 | ○ |
| C-20 | GENBWLMをAORにリンク | E-03 | ○ |
| C-21 | リソース記述のローカルスコープはLSGENAPP | E-03 | ○ |
| C-22 | リソース記述のRGスコープはGENAALL | E-03 | ○ |
| C-23 | トランザクショングループのマッチはUSERID | E-03 | ○ |
| C-24 | ThreadLimitは250 | E-03 | ○ |
| C-25 | パフォーマンス監視閾値は5分 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- パフォーマンス監視閾値の根拠が不明
  - 候補：監視設計書 / 運用マニュアル / アラート設定書
- DB2MONDイベントの詳細仕様
  - 候補：DB2監視設計書 / CICSPlex SM設定書

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - JCL構造とCICSPlex SMコマンドは実コードから確認済み
- 0: 低リスク - ワークロード管理定義の構造は明確
- 0: 低リスク - TOR-AOR-DORのルーティング設定は詳細に記載あり
- 1: 中リスク - 環境変数（CMASAPPL, TORAPPL等）は環境依存

## 6) レビュアーチェックリスト（最小）
- [ ] 実際の環境変数（CPSMHLQ, CMASAPPL, TORAPPL等）が正しく設定されているか確認
- [ ] CMASが稼働状態であることを確認
- [ ] CMASデータリポジトリが初期化されていることを確認
- [ ] TOR、AOR、DORリージョンのAPPLIDとSYSIDが正しいか確認
- [ ] ワークロード定義のスコープ（GENAAOR、GENADOR）が意図通りか確認
- [ ] DB2MONDイベントがDB2監視と正しく連携しているか確認
- [ ] CICSPlex SM定義後、ワークロード管理が正常に動作するかテスト
