---
generated_at: 2026-01-06 19:15:00
metrics:
  claims_total: 110
  claims_with_evidence: 110
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：copybook.csv

## 本レポートについて

### 目的
本レポートは、生成された単体テストケース一覧の信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：110 / 110、根拠なし：0
- 優先レビュー（高）
  1. **UT-CPY-102〜110**：REDEFINES整合性およびコピーブック間整合性検証（実際のバイト計算の確認が推奨）
  2. **UT-CPY-071〜072**：soaipb1.cpyでの型定義がx型（小文字）であることの確認
  3. **UT-CPY-031〜038**：lgpolicy.cpyの長さ定数とDB2構造のサイズ整合性

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `base/src/lgcmarea.cpy` - 共通エリア定義（COMMAREA構造）
- E-02: `base/src/lgpolicy.cpy` - 保険契約データ定義（DB2マッピング構造）
- E-03: `base/src/pollook.cpy` - 保険契約参照定義
- E-04: `base/src/polloo2.cpy` - 保険契約参照定義2（複数契約対応）
- E-05: `base/src/soaic01.cpy` - SOA顧客インターフェース
- E-06: `base/src/soaipb1.cpy` - SOA保険インターフェース(ビジネス/商業)
- E-07: `base/src/soaipe1.cpy` - SOA保険インターフェース(エンドウメント)
- E-08: `base/src/soaiph1.cpy` - SOA保険インターフェース(住宅)
- E-09: `base/src/soaipm1.cpy` - SOA保険インターフェース(モーター)
- E-10: `base/src/soavcii.cpy` - SOA顧客入力インターフェース
- E-11: `base/src/soavcio.cpy` - SOA顧客出力インターフェース
- E-12: `base/src/soavpii.cpy` - SOA保険入力インターフェース
- E-13: `base/src/soavpio.cpy` - SOA保険出力インターフェース
- E-14: `docs/code-to-docs/単体テストケース一覧/plan.md` - 生成プラン

## 3) Claims と根拠の対応（レビューの主戦場）

### lgcmarea.cpy関連テストケース
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-001 | CA-REQUEST-IDが6文字PIC X(6)で定義 | E-01 L10 | ○ |
| C-002 | CA-RETURN-CODEが2桁PIC 9(2)で定義 | E-01 L11 | ○ |
| C-003 | CA-CUSTOMER-NUMが10桁PIC 9(10)で定義 | E-01 L12 | ○ |
| C-004 | CA-CUSTOMER-NUM境界値（最大） | E-01 L12 | ○ |
| C-005 | CA-CUSTOMER-NUM境界値（最小） | E-01 L12 | ○ |
| C-006 | CA-REQUEST-SPECIFICが32482バイト | E-01 L13 | ○ |
| C-007 | CA-CUSTOMER-REQUESTのREDEFINES | E-01 L15-26 | ○ |
| C-008 | CA-FIRST-NAMEが10文字 | E-01 L16 | ○ |
| C-009 | CA-LAST-NAMEが20文字 | E-01 L17 | ○ |
| C-010 | CA-DOBが10文字 | E-01 L18 | ○ |
| C-011 | CA-EMAIL-ADDRESSが100文字 | E-01 L25 | ○ |
| C-012 | CA-CUSTSECR-REQUESTのREDEFINES | E-01 L28-32 | ○ |
| C-013 | CA-CUSTSECR-PASSが32文字 | E-01 L29 | ○ |
| C-014 | CA-POLICY-REQUESTのREDEFINES | E-01 L34-44 | ○ |
| C-015 | CA-POLICY-NUMが10桁 | E-01 L35 | ○ |
| C-016 | CA-ISSUE-DATEが10文字 | E-01 L38 | ○ |
| C-017 | CA-EXPIRY-DATEが10文字 | E-01 L39 | ○ |
| C-018 | CA-LASTCHANGEDが26文字 | E-01 L40 | ○ |
| C-019 | CA-PAYMENTが6桁 | E-01 L43 | ○ |
| C-020 | CA-ENDOWMENTのREDEFINES | E-01 L46-54 | ○ |
| C-021 | CA-E-SUM-ASSUREDが6桁 | E-01 L52 | ○ |
| C-022 | CA-HOUSEのREDEFINES | E-01 L56-63 | ○ |
| C-023 | CA-H-VALUEが8桁 | E-01 L59 | ○ |
| C-024 | CA-MOTORのREDEFINES | E-01 L65-75 | ○ |
| C-025 | CA-M-VALUEが6桁 | E-01 L68 | ○ |
| C-026 | CA-M-REGNUMBERが7文字 | E-01 L69 | ○ |
| C-027 | CA-COMMERCIALのREDEFINES | E-01 L77-94 | ○ |
| C-028 | CA-B-FirePremiumが8桁 | E-01 L85 | ○ |
| C-029 | CA-CLAIMのREDEFINES | E-01 L96-103 | ○ |
| C-030 | CA-C-Valueが8桁 | E-01 L100 | ○ |

### lgpolicy.cpy関連テストケース
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-031 | WS-POLICY-LENGTHS長さ定数群 | E-02 L16-29 | ○ |
| C-032 | WS-CUSTOMER-LEN=72 | E-02 L17 | ○ |
| C-033 | WS-POLICY-LEN=72 | E-02 L18 | ○ |
| C-034 | WS-ENDOW-LEN=52 | E-02 L19 | ○ |
| C-035 | WS-HOUSE-LEN=58 | E-02 L20 | ○ |
| C-036 | WS-MOTOR-LEN=65 | E-02 L21 | ○ |
| C-037 | WS-COMM-LEN=1102 | E-02 L22 | ○ |
| C-038 | WS-CLAIM-LEN=546 | E-02 L23 | ○ |
| C-039 | DB2-CUSTOMER構造定義 | E-02 L31-40 | ○ |
| C-040 | DB2-FIRSTNAMEが10文字 | E-02 L32 | ○ |
| C-041 | DB2-LASTNAMEが20文字 | E-02 L33 | ○ |
| C-042 | DB2-POLICY構造定義 | E-02 L42-51 | ○ |
| C-043 | DB2-POLICYTYPEが1文字 | E-02 L43 | ○ |
| C-044 | DB2-POLICYNUMBERが10桁 | E-02 L44 | ○ |
| C-045 | DB2-ENDOWMENT構造定義 | E-02 L53-62 | ○ |
| C-046 | DB2-E-SUMASSUREDが6桁 | E-02 L60 | ○ |
| C-047 | DB2-HOUSE構造定義 | E-02 L64-70 | ○ |
| C-048 | DB2-H-VALUEが8桁 | E-02 L67 | ○ |
| C-049 | DB2-MOTOR構造定義 | E-02 L72-81 | ○ |
| C-050 | DB2-M-VALUEが6桁 | E-02 L75 | ○ |
| C-051 | DB2-COMMERCIAL構造定義 | E-02 L83-99 | ○ |
| C-052 | DB2-B-FirePremiumが8桁 | E-02 L91 | ○ |
| C-053 | DB2-CLAIM構造定義 | E-02 L101-107 | ○ |
| C-054 | DB2-C-Valueが8桁 | E-02 L105 | ○ |

### pollook.cpy関連テストケース
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-055 | REQUEST構造定義 | E-03 L6-9 | ○ |
| C-056 | CA-REQUEST-IDが6文字 | E-03 L7 | ○ |
| C-057 | CA-CUSTOMER-NUMが10桁DISPLAY | E-03 L8 | ○ |

### polloo2.cpy関連テストケース
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-058 | REQUEST構造定義(複数契約) | E-04 L6-11 | ○ |
| C-059 | CA-POLICIES OCCURS 5 TIMES | E-04 L8-10 | ○ |
| C-060 | CA-POLICY-NUMBERが10桁DISPLAY | E-04 L9 | ○ |
| C-061 | CA-POLICY-TYPEが1文字DISPLAY | E-04 L10 | ○ |

### SOAインターフェース関連テストケース
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-062 | soaic01.cpy CA構造定義 | E-05 L6-21 | ○ |
| C-063 | soaic01.cpy CA-REQUEST-ID | E-05 L7 | ○ |
| C-064 | soaic01.cpy CA-RETURN-CODE | E-05 L8 | ○ |
| C-065 | soaic01.cpy CA-CUSTOMER-NUM | E-05 L9 | ○ |
| C-066 | soaic01.cpy CA-POLICY-DATA 30000バイト | E-05 L21 | ○ |
| C-067 | soaipb1.cpy CA-REQUEST-ID | E-06 L6 | ○ |
| C-068 | soaipb1.cpy CA-B-Address 255文字 | E-06 L17 | ○ |
| C-069 | soaipb1.cpy CA-B-Latitude 11文字 | E-06 L19 | ○ |
| C-070 | soaipb1.cpy CA-B-Longitude 11文字 | E-06 L20 | ○ |
| C-071 | soaipb1.cpy CA-B-FirePremium x(8) | E-06 L24 | ○ |
| C-072 | soaipb1.cpy CA-B-Status x(4) | E-06 L31 | ○ |
| C-073 | soaipe1.cpy CA-REQUEST-ID | E-07 L6 | ○ |
| C-074 | soaipe1.cpy CA-E-WITH-PROFITS | E-07 L18 | ○ |
| C-075 | soaipe1.cpy CA-E-TERM | E-07 L22 | ○ |
| C-076 | soaipe1.cpy CA-E-SUM-ASSURED | E-07 L23 | ○ |
| C-077 | soaipe1.cpy CA-E-LIFE-ASSURED | E-07 L24 | ○ |
| C-078 | soaiph1.cpy CA-REQUEST-ID | E-08 L6 | ○ |
| C-079 | soaiph1.cpy CA-H-PROPERTY-TYPE | E-08 L18 | ○ |
| C-080 | soaiph1.cpy CA-H-BEDROOMS | E-08 L19 | ○ |
| C-081 | soaiph1.cpy CA-H-VALUE | E-08 L20 | ○ |
| C-082 | soaiph1.cpy CA-PAYMENT | E-08 L16 | ○ |
| C-083 | soaipm1.cpy CA-REQUEST-ID | E-09 L6 | ○ |
| C-084 | soaipm1.cpy CA-M-MAKE | E-09 L18 | ○ |
| C-085 | soaipm1.cpy CA-M-MODEL | E-09 L19 | ○ |
| C-086 | soaipm1.cpy CA-M-VALUE | E-09 L20 | ○ |
| C-087 | soaipm1.cpy CA-M-CC | E-09 L23 | ○ |
| C-088 | soaipm1.cpy CA-M-PREMIUM | E-09 L25 | ○ |
| C-089 | soaipm1.cpy CA-M-ACCIDENTS | E-09 L26 | ○ |
| C-090 | soavcii.cpy COMMA-DATA構造 | E-10 L6-8 | ○ |
| C-091 | soavcii.cpy Customer-Number | E-10 L7 | ○ |
| C-092 | soavcio.cpy COMMA-DATA構造 | E-11 L6-9 | ○ |
| C-093 | soavcio.cpy Comma-Data-Text | E-11 L7 | ○ |
| C-094 | soavcio.cpy Comma-Data-High | E-11 L8 | ○ |
| C-095 | soavpii.cpy COMMA-DATA構造 | E-12 L13-16 | ○ |
| C-096 | soavpii.cpy Type | E-12 L14 | ○ |
| C-097 | soavpii.cpy Cust-Num | E-12 L15 | ○ |
| C-098 | soavpio.cpy COMMA-DATA構造 | E-13 L13-19 | ○ |
| C-099 | soavpio.cpy Comma-Data-Text | E-13 L14 | ○ |
| C-100 | soavpio.cpy Comma-Data-Key構造 | E-13 L15-18 | ○ |
| C-101 | soavpio.cpy Pol-Num | E-13 L18 | ○ |

### 整合性検証テストケース
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-102 | lgcmarea.cpy REDEFINES整合性（32482バイト） | E-01 L13-103 | ○ |
| C-103 | lgcmarea.cpy POLICY-SPECIFIC整合性（32400バイト） | E-01 L44-103 | ○ |
| C-104 | lgpolicy.cpy 長さ定数とDB2構造の整合性 | E-02 L16-107 | ○ |
| C-105 | lgcmarea.cpyとsoaic01.cpyの顧客フィールド整合性 | E-01, E-05 | ○ |
| C-106 | lgcmarea.cpyとlgpolicy.cpyの保険契約フィールド整合性 | E-01, E-02 | ○ |
| C-107 | soaipm1.cpyとlgcmarea.cpyのモーター保険整合性 | E-01, E-09 | ○ |
| C-108 | soaipe1.cpyとlgcmarea.cpyのエンダウメント保険整合性 | E-01, E-07 | ○ |
| C-109 | soaiph1.cpyとlgcmarea.cpyの住宅保険整合性 | E-01, E-08 | ○ |
| C-110 | soaipb1.cpyとlgcmarea.cpyの商業保険整合性 | E-01, E-06 | ○ |

## 4) 不足情報（Unknown / Missing）
- 全テストケースに対してソースコード（コピーブック）から根拠を特定できた
- 追加の根拠が必要な項目：なし

**注意事項**：
- コピーブックは単独でのテスト対象ではなく、参照するプログラムとの整合性確認用として定義されている（plan.md記載）
- 本テストケース一覧は、コピーブックのデータ構造定義の妥当性と、コピーブック間の整合性を検証するためのものである

## 5) リスクフラグ（レビュー観点）

| リスクレベル | 項目 | 理由 |
|---|---|---|
| 1: 中リスク | UT-CPY-071〜072 | soaipb1.cpyで金額フィールドがPIC x(8)（小文字、文字型）で定義されており、他のコピーブックのPIC 9(8)（数値型）と異なる |
| 1: 中リスク | UT-CPY-102〜103 | REDEFINES句のバイトサイズ整合性は手動計算での確認が推奨される |
| 1: 中リスク | UT-CPY-104 | WS-CUSTOMER-LEN=72だがDB2-CUSTOMERの実サイズは212バイト（10+20+10+20+4+8+20+20+100）であり、定数の意図確認が必要 |
| 0: 低リスク | その他 | ソースコードから直接確認可能な定義 |

## 6) レビュアーチェックリスト（最小）
- [ ] lgcmarea.cpyのREDEFINES構造のバイトサイズが実際に32482バイト/32400バイトであることを確認
- [ ] lgpolicy.cpyの長さ定数（WS-*-LEN）が実際のDB2テーブル構造と整合しているか確認
- [ ] soaipb1.cpyの金額フィールド（PIC x型）が意図的な文字型定義であるか確認
- [ ] SOAインターフェース用コピーブック（soai*.cpy）とlgcmarea.cpyのフィールド定義が整合しているか確認
- [ ] OCCURS句（polloo2.cpy）の配列サイズ（5件）が業務要件と整合しているか確認
- [ ] WSIM（WebSphere Integration Monitor）サポートのための32K制限（soaic01.cpy等のコメント記載）が現在も有効な要件か確認
