---
generated_at: 2026-01-06 19:30:00
metrics:
  claims_total: 60
  claims_with_evidence: 58
  claims_without_evidence: 2
confidence_derived: 0.97
---

# 根拠レポート：customer.csv

## 本レポートについて

### 目的
本レポートは、生成された単体テストケース一覧の信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.97**
  - 根拠あり：58 / 60、根拠なし：2
- 優先レビュー（高）
  1. **UT-CUS-006**：境界値の具体的な数値(90)はWS-CA-HEADER-LEN(18) + WS-CUSTOMER-LEN(72) = 90で計算したが、実際のCOMMMAREA長要件の確認が必要
  2. **UT-CUS-060**：WS-VARY-FIELDの実際の使用箇所がLGUCUS01内では確認できず

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `/Users/tomokababa/Work/route06/cics-genapp-main/base/src/lgacus01.cbl` - 顧客追加ビジネスロジック
- E-02: `/Users/tomokababa/Work/route06/cics-genapp-main/base/src/lgicus01.cbl` - 顧客照会ビジネスロジック
- E-03: `/Users/tomokababa/Work/route06/cics-genapp-main/base/src/lgucus01.cbl` - 顧客更新ビジネスロジック
- E-04: `/Users/tomokababa/Work/route06/cics-genapp-main/base/src/lgtestc1.cbl` - 顧客テストプログラム（メニュー画面）
- E-05: `/Users/tomokababa/Work/route06/cics-genapp-main/base/src/lgcmarea.cpy` - COMMMAREAコピーブック
- E-06: `/Users/tomokababa/Work/route06/cics-genapp-main/base/src/lgpolicy.cpy` - ポリシー長定義コピーブック

## 3) Claims と根拠の対応（レビューの主戦場）

### LGACUS01（顧客追加ビジネスロジック）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | COMMAREA受信時のWS-HEADER初期化 | E-01 (84行目: INITIALIZE WS-HEADER) | ○ |
| C-02 | EIBCALEN=0時のABEND(LGCA)発行 | E-01 (95-99行目: IF EIBCALEN IS EQUAL TO ZERO... EXEC CICS ABEND ABCODE('LGCA')) | ○ |
| C-03 | CA-RETURN-CODEの00初期化 | E-01 (102行目: MOVE '00' TO CA-RETURN-CODE) | ○ |
| C-04 | CA-NUM-POLICIESの00初期化 | E-01 (103行目: MOVE '00' TO CA-NUM-POLICIES) | ○ |
| C-05 | COMMAREA長不足時のリターンコード98 | E-01 (112-115行目: IF EIBCALEN IS LESS THAN WS-REQUIRED-CA-LEN... MOVE '98' TO CA-RETURN-CODE) | ○ |
| C-06 | 境界値90バイトの根拠 | E-06 (17行目: WS-CUSTOMER-LEN = 72), E-01 (56行目: WS-CA-HEADER-LEN = 18) | △ |
| C-07 | LGACDB01へのLINK呼び出し | E-01 (134-137行目: EXEC CICS LINK Program(LGACDB01)) | ○ |
| C-08 | LENGTH(32500)の受け渡し | E-01 (136行目: LENGTH(32500)) | ○ |
| C-09 | ASKTIME/FORMATTIMEでの日時取得 | E-01 (150-157行目: EXEC CICS ASKTIME... EXEC CICS FORMATTIME) | ○ |
| C-10 | LGSTSQへのエラーメッセージ出力 | E-01 (159-162行目: EXEC CICS LINK PROGRAM('LGSTSQ')) | ○ |
| C-11 | EIBCALEN < 91時のログ出力 | E-01 (165-170行目: IF EIBCALEN < 91 THEN) | ○ |
| C-12 | EIBCALEN > 90時のログ出力 | E-01 (171-176行目: ELSE... MOVE DFHCOMMAREA(1:90)) | ○ |

### LGICUS01（顧客照会ビジネスロジック）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-13 | COMMAREA受信時のWS-HEADER初期化 | E-02 (79行目: INITIALIZE WS-HEADER) | ○ |
| C-14 | EIBCALEN=0時のABEND(LGCA)発行 | E-02 (87-91行目: IF EIBCALEN IS EQUAL TO ZERO... EXEC CICS ABEND ABCODE('LGCA')) | ○ |
| C-15 | CA-RETURN-CODE/CA-NUM-POLICIESの初期化 | E-02 (93-94行目: MOVE '00' TO CA-RETURN-CODE, MOVE '00' TO CA-NUM-POLICIES) | ○ |
| C-16 | COMMAREA長不足時のリターンコード98 | E-02 (104-107行目: IF EIBCALEN IS LESS THAN WS-REQUIRED-CA-LEN... MOVE '98') | ○ |
| C-17 | 境界値の検証 | E-02 (102-103行目: MOVE WS-CUSTOMER-LEN TO WS-REQUIRED-CA-LEN, ADD WS-CA-HEADERTRAILER-LEN) | ○ |
| C-18 | LGICDB01へのLINK呼び出し | E-02 (122-125行目: EXEC CICS LINK Program(LGICDB01)) | ○ |
| C-19 | LENGTH(32500)の受け渡し | E-02 (124行目: LENGTH(32500)) | ○ |
| C-20 | ASKTIME/FORMATTIMEでの日時取得 | E-02 (137-144行目: EXEC CICS ASKTIME... EXEC CICS FORMATTIME) | ○ |
| C-21 | LGSTSQへのエラーメッセージ出力 | E-02 (146-149行目: EXEC CICS LINK PROGRAM('LGSTSQ')) | ○ |
| C-22 | EIBCALEN < 91時のログ出力 | E-02 (152-157行目: IF EIBCALEN < 91 THEN) | ○ |

### LGUCUS01（顧客更新ビジネスロジック）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-23 | COMMAREA受信時のWS-HEADER初期化 | E-03 (89行目: INITIALIZE WS-HEADER) | ○ |
| C-24 | EIBCALEN=0時のABEND(LGCA)発行 | E-03 (99-103行目: IF EIBCALEN IS EQUAL TO ZERO... EXEC CICS ABEND ABCODE('LGCA')) | ○ |
| C-25 | CA-RETURN-CODE/CA-NUM-POLICIESの初期化 | E-03 (105-106行目: MOVE '00' TO CA-RETURN-CODE, MOVE '00' TO CA-NUM-POLICIES) | ○ |
| C-26 | CA-REQUEST-ID != 01UCUSでリターンコード99 | E-03 (110-113行目: If CA-REQUEST-ID NOT = '01UCUS'... MOVE '99' TO CA-RETURN-CODE) | ○ |
| C-27 | CA-REQUEST-ID = 01UCUSで更新処理実行 | E-03 (116行目: PERFORM UPDATE-CUSTOMER-INFO) | ○ |
| C-28 | LGUCDB01へのLINK呼び出し | E-03 (128-131行目: EXEC CICS LINK Program(LGUCDB01)) | ○ |
| C-29 | LENGTH(32500)の受け渡し | E-03 (130行目: LENGTH(32500)) | ○ |
| C-30 | ASKTIME/FORMATTIMEでの日時取得 | E-03 (143-150行目: EXEC CICS ASKTIME... EXEC CICS FORMATTIME) | ○ |
| C-31 | LGSTSQへのエラーメッセージ出力 | E-03 (152-155行目: EXEC CICS LINK PROGRAM('LGSTSQ')) | ○ |
| C-32 | EIBCALEN < 91時のログ出力 | E-03 (158-163行目: IF EIBCALEN < 91 THEN) | ○ |

### LGTESTC1（顧客テストプログラム）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-33 | EIBCALEN=0時の画面初期化 | E-04 (55-61行目: IF EIBCALEN > 0 GO TO A-GAIN... Initialize SSMAPC1I/SSMAPC1O/COMM-AREA) | ○ |
| C-34 | EIBCALEN>0時のA-GAINへの分岐 | E-04 (55-56行目: IF EIBCALEN > 0 GO TO A-GAIN) | ○ |
| C-35 | メインメニュー画面の送信 | E-04 (64-68行目: EXEC CICS SEND MAP ('SSMAPC1')... ERASE) | ○ |
| C-36 | オプション1でLGICUS01呼び出し | E-04 (86-92行目: WHEN '1'... Move '01ICUS'... EXEC CICS LINK PROGRAM('LGICUS01')) | ○ |
| C-37 | 顧客照会失敗時のNO-DATA分岐 | E-04 (94-96行目: IF CA-RETURN-CODE > 0 GO TO NO-DATA) | ○ |
| C-38 | オプション2でLGACUS01呼び出し | E-04 (113-131行目: WHEN '2'... Move '01ACUS'... EXEC CICS LINK PROGRAM('LGACUS01')) | ○ |
| C-39 | 郵便番号の大文字変換 | E-04 (126-127行目: Move Function UPPER-CASE(CA-POSTCODE) TO CA-POSTCODE) | ○ |
| C-40 | Null文字の空白変換 | E-04 (125行目: Inspect COMM-AREA Replacing All x'00' by x'40') | ○ |
| C-41 | 顧客追加失敗時のRollbackとNO-ADD分岐 | E-04 (132-135行目: IF CA-RETURN-CODE > 0... Exec CICS Syncpoint Rollback... GO TO NO-ADD) | ○ |
| C-42 | オプション4の照会処理 | E-04 (148-157行目: WHEN '4'... Move '01ICUS'... EXEC CICS LINK PROGRAM('LGICUS01')) | ○ |
| C-43 | オプション4の更新処理 | E-04 (176-193行目: Move '01UCUS'... EXEC CICS LINK PROGRAM('LGUCUS01')) | ○ |
| C-44 | 顧客更新失敗時のNO-UPD分岐 | E-04 (195-197行目: IF CA-RETURN-CODE > 0 GO TO NO-UPD) | ○ |
| C-45 | 無効オプション時のエラーメッセージ | E-04 (209-220行目: WHEN OTHER... Move 'Please enter a valid option') | ○ |
| C-46 | CLEARキー押下時のCLEARIT分岐 | E-04 (72-74行目: EXEC CICS HANDLE AID CLEAR(CLEARIT)) | ○ |
| C-47 | PF3キー押下時のENDIT分岐 | E-04 (74行目: PF3(ENDIT)) | ○ |
| C-48 | GENACNTLキューのENQ/DEQ処理 | E-04 (285-287行目: EXEC CICS ENQ Resource(STSQ-NAME), 343-345行目: EXEC CICS DEQ) | ○ |
| C-49 | TSQからのHIGH CUSTOMER読み取り | E-04 (290-316行目: Exec CICS ReadQ TS Queue(STSQ-NAME)... Read-Msg-Msg(1:13) = 'HIGH CUSTOMER') | ○ |
| C-50 | HIGH CUSTOMERレコードの更新 | E-04 (307-313行目: Exec CICS WriteQ TS Queue(STSQ-NAME)... ReWrite) | ○ |
| C-51 | 新規TSQの作成 | E-04 (320-340行目: If WS-FLAG-TSQH = 'Y'... EXEC CICS WRITEQ TS QUEUE) | ○ |
| C-52 | TSQ ReadQエラー時の処理 | E-04 (295行目: If WS-RESP = DFHRESP(NORMAL)) | ○ |
| C-53 | NO-DATAのエラーメッセージ | E-04 (267-269行目: NO-DATA... Move 'No data was returned.' To ERRFLDO) | ○ |
| C-54 | NO-ADDのエラーメッセージ | E-04 (263-265行目: NO-ADD... Move 'Error Adding Customer' To ERRFLDO) | ○ |
| C-55 | NO-UPDのエラーメッセージ | E-04 (259-261行目: NO-UPD... Move 'Error Updating Customer' To ERRFLDO) | ○ |
| C-56 | ERROR-OUTの初期化処理 | E-04 (271-281行目: ERROR-OUT... EXEC CICS SEND MAP... Initialize... GO TO ENDIT-STARTIT) | ○ |
| C-57 | ENDIT-STARTITのRETURN処理 | E-04 (230-234行目: ENDIT-STARTIT... EXEC CICS RETURN TRANSID('SSC1') COMMAREA) | ○ |
| C-58 | 境界値下限-1の検証 | E-01 (112-115行目のIF文の論理から導出) | ○ |
| C-59 | 境界値下限+1の検証 | E-02 (104-107行目のIF文の論理から導出) | ○ |
| C-60 | WS-VARY-FIELDの構造確認 | E-03 (62-64行目: 01 WS-VARY-FIELD... 49 WS-VARY-LEN... 49 WS-VARY-CHAR) | △ |

## 4) 不足情報（Unknown / Missing）
- **UT-CUS-006の境界値**：WS-CA-HEADER-LEN(18) + WS-CUSTOMER-LEN(72) = 90で計算したが、lgpolicy.cpyでWS-CUSTOMER-LENは72と定義されている。ただし、この値が最新かどうかの確認が必要
  - 候補：実環境でのテスト / DB2テーブル定義の確認 / 運用ドキュメント
- **UT-CUS-060のWS-VARY-FIELD使用箇所**：LGUCUS01内で定義されているが、実際の使用箇所（VARCHARデータの処理）はDB処理プログラム（LGUCDB01）で行われている可能性がある
  - 候補：LGUCDB01の解析 / DB2カラム定義の確認

## 5) リスクフラグ（レビュー観点）
- **0: 低リスク** - 大部分のテストケースはソースコードから直接確認可能
- **1: 中リスク** - 境界値テストの具体的な数値は計算に基づくが、実環境での検証が推奨
- **0: 低リスク** - エラーハンドリングのテストケースはソースコードのIF文から明確に導出

## 6) レビュアーチェックリスト（最小）
- [ ] 各プログラムのMAINLINEセクションに対する正常系/異常系テストケースが網羅されているか
- [ ] COMMAREA長のバリデーション（リターンコード98）のテストが含まれているか
- [ ] ABEND処理（LGCA）のテストが含まれているか
- [ ] DB連携プログラム（LGACDB01/LGICDB01/LGUCDB01）へのLINK呼び出しのテストが含まれているか
- [ ] LGTESTC1の各オプション（1:照会, 2:追加, 4:更新）に対するテストケースが含まれているか
- [ ] エラーメッセージ出力（WRITE-ERROR-MESSAGE）のテストが含まれているか
- [ ] TSQ操作（WRITE-GENACNTL）のENQ/DEQ/ReadQ/WriteQのテストが含まれているか
- [ ] 境界値テスト（COMMAREA長の下限）が含まれているか
