---
generated_at: 2026-01-06 12:00:00
metrics:
  claims_total: 98
  claims_with_evidence: 98
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：database.csv

## 本レポートについて

### 目的
本レポートは、生成された単体テストケース一覧(database.csv)の信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：98 / 98、根拠なし：0
- 優先レビュー（高）
  1. 全てのテストケースはソースコードに基づいて生成されており、根拠が確認済み

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `/Users/tomokababa/Work/route06/cics-genapp-main/base/src/lgacdb01.cbl` - 顧客追加DB処理
- E-02: `/Users/tomokababa/Work/route06/cics-genapp-main/base/src/lgacdb02.cbl` - 顧客追加DB処理(代替/セキュリティ)
- E-03: `/Users/tomokababa/Work/route06/cics-genapp-main/base/src/lgicdb01.cbl` - 顧客照会DB処理
- E-04: `/Users/tomokababa/Work/route06/cics-genapp-main/base/src/lgdpdb01.cbl` - 保険契約削除DB処理
- E-05: `/Users/tomokababa/Work/route06/cics-genapp-main/base/src/lgipdb01.cbl` - 保険契約照会DB処理
- E-06: `/Users/tomokababa/Work/route06/cics-genapp-main/base/src/lgucdb01.cbl` - 顧客更新DB処理
- E-07: `/Users/tomokababa/Work/route06/cics-genapp-main/base/src/lgupdb01.cbl` - 保険契約更新DB処理
- E-08: `/Users/tomokababa/Work/route06/cics-genapp-main/base/src/lgapdb01.cbl` - 保険契約追加DB処理
- E-09: `/Users/tomokababa/Work/route06/cics-genapp-main/docs/code-to-docs/単体テストケース一覧/plan.md` - モジュール定義

## 3) Claims と根拠の対応（レビューの主戦場）

### LGACDB01（顧客追加DB処理）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | COMMAREAを受信して顧客追加処理が正常完了すること | E-01 (line 125-193) | ○ |
| C-02 | COMMAREAなしでABENDすること | E-01 (line 149-153) | ○ |
| C-03 | COMMAREA長が不足の場合エラーコード98が返ること | E-01 (line 165-168) | ○ |
| C-04 | Named CounterからCUSTOMER番号を取得できること | E-01 (line 199-211) | ○ |
| C-05 | Named Counterエラー時にLGAC-NCS='NO'となること | E-01 (line 206-211) | ○ |
| C-06 | CUSTOMER表へのINSERTが成功すること(NCS使用) | E-01 (line 221-249) | ○ |
| C-07 | CUSTOMER表へのINSERTが成功すること(DEFAULT使用) | E-01 (line 250-283) | ○ |
| C-08 | INSERT失敗時にエラーコード90が返ること | E-01 (line 245-248, 274-277) | ○ |
| C-09 | エラーメッセージがTDQに書き込まれること | E-01 (line 295-328) | ○ |

### LGACDB02（顧客セキュリティ追加DB処理）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-10 | 顧客セキュリティ情報の追加が成功すること | E-02 (line 112-158) | ○ |
| C-11 | COMMAREAなしでABENDすること | E-02 (line 131-135) | ○ |
| C-12 | 不正なREQUEST-IDでエラーコード99が返ること | E-02 (line 149-151) | ○ |
| C-13 | CUSTOMER_SECURE表へのINSERTが成功すること | E-02 (line 161-184) | ○ |
| C-14 | INSERT失敗時にエラーコード98が返ること | E-02 (line 178-182) | ○ |

### LGICDB01（顧客照会DB処理）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-15 | 顧客情報照会が正常完了すること | E-03 (line 99-165) | ○ |
| C-16 | COMMAREAなしでABENDすること | E-03 (line 119-123) | ○ |
| C-17 | COMMAREA長が不足の場合エラーコード98が返ること | E-03 (line 140-143) | ○ |
| C-18 | CUSTOMER表からSELECTが成功すること | E-03 (line 167-205) | ○ |
| C-19 | 顧客が存在しない場合エラーコード01が返ること | E-03 (line 195-196) | ○ |
| C-20 | デッドロック(-913)時にエラーコード01が返ること | E-03 (line 197-198) | ○ |
| C-21 | その他SQLエラー時にエラーコード90が返ること | E-03 (line 199-202) | ○ |

### LGDPDB01（保険契約削除DB処理）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-22 | 保険契約削除が正常完了すること | E-04 (line 108-178) | ○ |
| C-23 | COMMAREAなしでABENDすること | E-04 (line 131-135) | ○ |
| C-24 | COMMAREA長が不足の場合エラーコード98が返ること | E-04 (line 143-146) | ○ |
| C-25 | 不正なREQUEST-IDでエラーコード99が返ること | E-04 (line 160-165) | ○ |
| C-26-29 | 各リクエストID(01DEND/01DHOU/01DCOM/01DMOT)で削除処理が実行されること | E-04 (line 160-172) | ○ |
| C-30 | POLICY表からDELETEが成功すること | E-04 (line 186-204) | ○ |
| C-31 | DELETE失敗時にエラーコード90が返ること | E-04 (line 198-202) | ○ |

### LGIPDB01（保険契約照会DB処理）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-32 | 保険契約照会が正常完了すること | E-05 (line 227-316) | ○ |
| C-33 | COMMAREAなしでABENDすること | E-05 (line 251-255) | ○ |
| C-34-40 | 各リクエストID(01IEND/01IHOU/01IMOT/01ICOM/02ICOM/03ICOM/05ICOM)で適切な照会処理が実行されること | E-05 (line 277-310) | ○ |
| C-41 | 不正なREQUEST-IDでエラーコード99が返ること | E-05 (line 307-308) | ○ |
| C-42 | Endowment情報がCOMMAREAに設定されること | E-05 (line 327-432) | ○ |
| C-43 | VARCHARパディングデータが正しく取得されること | E-05 (line 383-413) | ○ |
| C-44 | COMMAREA長不足でエラーコード98が返ること | E-05 (line 390-392) | ○ |
| C-45 | レコード未検出時にエラーコード01が返ること | E-05 (line 421-423) | ○ |
| C-46-49 | House/Motor情報がCOMMAREAに設定されること | E-05 (line 441-621) | ○ |
| C-50 | Commercial情報がCOMMAREAに設定されること | E-05 (line 627-724) | ○ |
| C-51 | カーソルで複数Commercial情報が取得されること | E-05 (line 835-913) | ○ |
| C-52 | 20件を超えるとSQLCODE=17で終了すること | E-05 (line 906-909) | ○ |
| C-53 | カーソルOPEN失敗時にエラーコード89が返ること | E-05 (line 843-847) | ○ |
| C-54 | カーソルCLOSE失敗時にエラーコード88が返ること | E-05 (line 855-859) | ○ |
| C-55 | 郵便番号でCommercial情報が取得されること | E-05 (line 919-990) | ○ |

### LGUCDB01（顧客更新DB処理）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-56 | 顧客情報更新が正常完了すること | E-06 (line 98-146) | ○ |
| C-57 | COMMAREAなしでABENDすること | E-06 (line 117-121) | ○ |
| C-58 | CUSTOMER表のUPDATEが成功すること | E-06 (line 152-181) | ○ |
| C-59 | 顧客が存在しない場合エラーコード01が返ること | E-06 (line 173-174) | ○ |
| C-60 | UPDATE失敗時にエラーコード90が返ること | E-06 (line 175-179) | ○ |

### LGUPDB01（保険契約更新DB処理）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-61 | 保険契約更新が正常完了すること | E-07 (line 159-219) | ○ |
| C-62 | COMMAREAなしでABENDすること | E-07 (line 183-187) | ○ |
| C-63 | POLICYカーソルが正常にOPENできること | E-07 (line 254-270) | ○ |
| C-64 | カーソルOPENでデッドロック(-913)時にエラーコード90が返ること | E-07 (line 262-265) | ○ |
| C-65 | タイムスタンプ一致時に更新処理が実行されること | E-07 (line 278-300) | ○ |
| C-66 | タイムスタンプ不一致時にエラーコード02が返ること | E-07 (line 344-346) | ○ |
| C-67 | FETCH失敗(レコードなし)時にエラーコード01が返ること | E-07 (line 351-352) | ○ |
| C-68 | POLICY表のUPDATEが成功しタイムスタンプが更新されること | E-07 (line 317-342) | ○ |
| C-69 | POLICY UPDATE失敗時にROLLBACKされること | E-07 (line 336-342) | ○ |
| C-70 | POLICYカーソルが正常にCLOSEできること | E-07 (line 362-381) | ○ |
| C-71 | カーソルがOPENされていない時(-501)でもエラーにならないこと | E-07 (line 372-375) | ○ |
| C-72-77 | Endowment/House/Motor表のUPDATEが成功すること | E-07 (line 387-495) | ○ |

### LGAPDB01（保険契約追加DB処理）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-78 | 保険契約追加が正常完了すること | E-08 (line 143-253) | ○ |
| C-79 | COMMAREAなしでABENDすること | E-08 (line 165-169) | ○ |
| C-80-83 | 各リクエストID(01AEND/01AHOU/01AMOT/01ACOM)で適切な追加処理が実行されること | E-08 (line 184-241) | ○ |
| C-84 | 不正なREQUEST-IDでエラーコード99が返ること | E-08 (line 202-205, 237-239) | ○ |
| C-85 | COMMAREA長が不足の場合エラーコード98が返ること | E-08 (line 210-213) | ○ |
| C-86 | POLICY表へのINSERTが成功しポリシー番号が取得されること | E-08 (line 261-322) | ○ |
| C-87 | タイムスタンプが正しく設定されること | E-08 (line 316-321) | ○ |
| C-88 | 外部キー制約違反(-530)時にエラーコード70が返ること | E-08 (line 295-298) | ○ |
| C-89 | その他SQLエラー時にエラーコード90が返ること | E-08 (line 300-303) | ○ |
| C-90-91 | ENDOWMENT表へのINSERTが成功すること | E-08 (line 327-397) | ○ |
| C-92 | INSERT失敗時にABEND('LGSQ')でロールバックすること | E-08 (line 389-395) | ○ |
| C-93-94 | HOUSE表へのINSERTが成功すること | E-08 (line 402-435) | ○ |
| C-95-96 | MOTOR表へのINSERTが成功すること | E-08 (line 440-481) | ○ |
| C-97-98 | COMMERCIAL表へのINSERTが成功すること | E-08 (line 486-555) | ○ |

## 4) 不足情報（Unknown / Missing）
- なし - 全てのテストケースはソースコードに直接基づいて生成されています

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全てのテストケースはソースコードの実装に基づいており、高い信頼性があります

### 特記事項
1. **トランザクション整合性**: LGAPDB01では、子テーブル(ENDOWMENT/HOUSE/MOTOR/COMMERCIAL)のINSERT失敗時にABEND('LGSQ')を発行してPOLICY表のINSERTもロールバックする実装が確認されました
2. **楽観的排他制御**: LGUPDB01では、タイムスタンプ(LASTCHANGED)を使用した楽観的排他制御が実装されています
3. **Named Counter Service**: LGACDB01では、GENAカウンタープールを使用した採番処理と、エラー時のフォールバック(IDENTITY_VAL_LOCAL)が実装されています
4. **カーソル制限**: LGIPDB01のGET-Commercial-DB2-INFO-3では、最大20件の制限が実装されています

## 6) レビュアーチェックリスト（最小）
- [ ] DB2 SQL文のエラーハンドリングが適切にテストされているか
- [ ] COMMAREAのバリデーションテストが網羅されているか
- [ ] トランザクションのコミット/ロールバックテストが含まれているか
- [ ] Named Counter Serviceのフォールバックテストが含まれているか
- [ ] カーソル処理のOPEN/FETCH/CLOSEが適切にテストされているか
- [ ] 楽観的排他制御（タイムスタンプ比較）のテストが含まれているか
- [ ] 各ポリシータイプ(Endowment/House/Motor/Commercial)のCRUD操作が網羅されているか
