---
generated_at: 2026-01-06 19:30:00
metrics:
  claims_total: 60
  claims_with_evidence: 60
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：policy.csv（保険契約管理モジュール単体テストケース一覧）

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：60 / 60、根拠なし：0
- 優先レビュー（高）
  1. なし（全てのClaimに根拠が存在）

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `/Users/tomokababa/Work/route06/cics-genapp-main/base/src/lgapol01.cbl` - 保険契約追加ビジネスロジック
- E-02: `/Users/tomokababa/Work/route06/cics-genapp-main/base/src/lgipol01.cbl` - 保険契約照会ビジネスロジック
- E-03: `/Users/tomokababa/Work/route06/cics-genapp-main/base/src/lgdpol01.cbl` - 保険契約削除ビジネスロジック
- E-04: `/Users/tomokababa/Work/route06/cics-genapp-main/base/src/lgupol01.cbl` - 保険契約更新ビジネスロジック
- E-05: `/Users/tomokababa/Work/route06/cics-genapp-main/base/src/lgtestp1.cbl` - Motor保険テストプログラム
- E-06: `/Users/tomokababa/Work/route06/cics-genapp-main/base/src/lgtestp2.cbl` - Endowment保険テストプログラム
- E-07: `/Users/tomokababa/Work/route06/cics-genapp-main/base/src/lgtestp3.cbl` - House保険テストプログラム
- E-08: `/Users/tomokababa/Work/route06/cics-genapp-main/base/src/lgtestp4.cbl` - Commercial保険テストプログラム
- E-09: `/Users/tomokababa/Work/route06/cics-genapp-main/base/src/lgcmarea.cpy` - COMMAREA構造体定義（コピーブック）
- E-10: `/Users/tomokababa/Work/route06/cics-genapp-main/base/src/lgpolicy.cpy` - 保険契約データ定義（コピーブック）

## 3) Claims と根拠の対応（レビューの主戦場）

### LGAPOL01（保険契約追加）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 保険契約追加処理でLGAPDB01が呼び出される | E-01 (121-124行目: EXEC CICS Link Program(LGAPDB01)) | ○ |
| C-02 | COMMAREAなしでABEND('LGCA')が発生 | E-01 (98-102行目: IF EIBCALEN IS EQUAL TO ZERO...EXEC CICS ABEND ABCODE('LGCA')) | ○ |
| C-03 | COMMAREA長不足でCA-RETURN-CODE='98' | E-01 (113-116行目: IF EIBCALEN IS LESS THAN WS-REQUIRED-CA-LEN...MOVE '98' TO CA-RETURN-CODE) | ○ |
| C-04 | WS-HEADERが初期化される | E-01 (86行目: INITIALIZE WS-HEADER) | ○ |
| C-05 | EIB情報がWS-HEADERに設定される | E-01 (88-91行目: MOVE EIBTRNID TO WS-TRANSID等) | ○ |
| C-06 | エラーメッセージがLGSTSQに書き込まれる | E-01 (149-152行目: EXEC CICS LINK PROGRAM('LGSTSQ')) | ○ |
| C-07 | COMMAREA90バイト未満で部分転送 | E-01 (155-160行目: IF EIBCALEN < 91...MOVE DFHCOMMAREA(1:EIBCALEN)) | ○ |
| C-08 | COMMAREA90バイト以上で90バイト転送 | E-01 (161-166行目: MOVE DFHCOMMAREA(1:90)) | ○ |

### LGIPOL01（保険契約照会）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-09 | 保険契約照会処理でLGIPDB01が呼び出される | E-02 (91-94行目: EXEC CICS LINK Program(LGIPDB01)) | ○ |
| C-10 | COMMAREAなしでABEND('LGCA')が発生 | E-02 (79-83行目: IF EIBCALEN IS EQUAL TO ZERO...EXEC CICS ABEND ABCODE('LGCA')) | ○ |
| C-11 | CA-RETURN-CODEが'00'に初期化される | E-02 (86行目: MOVE '00' TO CA-RETURN-CODE) | ○ |
| C-12 | 日時がFORMATTIMEで設定される | E-02 (110-117行目: EXEC CICS ASKTIME/FORMATTIME) | ○ |

### LGDPOL01（保険契約削除）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-13 | Endowment保険削除で'01DEND'が認識される | E-03 (119行目: CA-REQUEST-ID NOT EQUAL TO '01DEND') | ○ |
| C-14 | Motor保険削除で'01DMOT'が認識される | E-03 (120行目: CA-REQUEST-ID NOT EQUAL TO '01DMOT') | ○ |
| C-15 | House保険削除で'01DHOU'が認識される | E-03 (121行目: CA-REQUEST-ID NOT EQUAL TO '01DHOU') | ○ |
| C-16 | Commercial保険削除で'01DCOM'が認識される | E-03 (122行目: CA-REQUEST-ID NOT EQUAL TO '01DCOM') | ○ |
| C-17 | COMMAREAなしでABEND('LGCA')が発生 | E-03 (95-99行目: IF EIBCALEN IS EQUAL TO ZERO...EXEC CICS ABEND ABCODE('LGCA')) | ○ |
| C-18 | COMMAREA長不足でCA-RETURN-CODE='98' | E-03 (107-110行目: IF EIBCALEN IS LESS THAN WS-CA-HEADER-LEN...MOVE '98') | ○ |
| C-19 | 不正REQUEST-IDでCA-RETURN-CODE='99' | E-03 (124行目: MOVE '99' TO CA-RETURN-CODE) | ○ |
| C-20 | REQUEST-IDが大文字に変換される | E-03 (117行目: MOVE FUNCTION UPPER-CASE(CA-REQUEST-ID) TO CA-REQUEST-ID) | ○ |
| C-21 | LGDPDB01が呼び出される | E-03 (141-144行目: EXEC CICS LINK PROGRAM(LGDPDB01)) | ○ |

### LGUPOL01（保険契約更新）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-22 | Endowment更新で'01UEND'が認識される | E-04 (115行目: WHEN '01UEND') | ○ |
| C-23 | House更新で'01UHOU'が認識される | E-04 (123行目: WHEN '01UHOU') | ○ |
| C-24 | Motor更新で'01UMOT'が認識される | E-04 (131行目: WHEN '01UMOT') | ○ |
| C-25 | COMMAREAなしでABEND('LGCA')が発生 | E-04 (99-103行目: IF EIBCALEN IS EQUAL TO ZERO...EXEC CICS ABEND ABCODE('LGCA')) | ○ |
| C-26 | Endowment用COMMAREA長不足でCA-RETURN-CODE='98' | E-04 (116-121行目: ADD WS-CA-HEADER-LEN...IF EIBCALEN IS LESS THAN...MOVE '98') | ○ |
| C-27 | House用COMMAREA長不足でCA-RETURN-CODE='98' | E-04 (124-129行目) | ○ |
| C-28 | Motor用COMMAREA長不足でCA-RETURN-CODE='98' | E-04 (132-137行目) | ○ |
| C-29 | 不正REQUEST-IDでCA-RETURN-CODE='99' | E-04 (139-141行目: WHEN OTHER...MOVE '99' TO CA-RETURN-CODE) | ○ |
| C-30 | LGUPDB01が呼び出される | E-04 (157-160行目: EXEC CICS LINK Program(LGUPDB01)) | ○ |

### LGTESTP1（Motor保険テスト）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-31 | オプション1でLGIPOL01が呼び出される | E-05 (72-75行目: WHEN '1'...EXEC CICS LINK PROGRAM('LGIPOL01')) | ○ |
| C-32 | オプション2でLGAPOL01が呼び出される | E-05 (115-118行目: WHEN '2'...EXEC CICS LINK PROGRAM('LGAPOL01')) | ○ |
| C-33 | オプション3でLGDPOL01が呼び出される | E-05 (139-142行目: WHEN '3'...EXEC CICS LINK PROGRAM('LGDPOL01')) | ○ |
| C-34 | オプション4でLGUPOL01が呼び出される | E-05 (216-219行目: EXEC CICS LINK PROGRAM('LGUPOL01')) | ○ |
| C-35 | 無効オプションで'Please enter a valid option'表示 | E-05 (238-239行目: WHEN OTHER...Move 'Please enter a valid option') | ○ |
| C-36 | 顧客不存在時エラーコード70で'Customer does not exist'表示 | E-05 (287-290行目: When 70...Move 'Customer does not exist') | ○ |
| C-37 | 追加エラー時にSyncpoint Rollback実行 | E-05 (120行目: Exec CICS Syncpoint Rollback End-Exec) | ○ |
| C-38 | CLEARIT処理でSSMAPP1I初期化 | E-05 (275行目: Initialize SSMAPP1I) | ○ |

### LGTESTP2（Endowment保険テスト）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-39 | オプション1でCA-REQUEST-ID='01IEND'設定 | E-06 (64行目: Move '01IEND' To CA-REQUEST-ID) | ○ |
| C-40 | オプション2でCA-REQUEST-ID='01AEND'設定 | E-06 (91行目: Move '01AEND' To CA-REQUEST-ID) | ○ |
| C-41 | オプション3でCA-REQUEST-ID='01DEND'設定 | E-06 (126行目: Move '01DEND' To CA-REQUEST-ID) | ○ |
| C-42 | オプション4でCA-REQUEST-ID='01UEND'設定 | E-06 (184行目: Move '01UEND' To CA-REQUEST-ID) | ○ |
| C-43 | 無効オプションで'Please enter a valid option'表示 | E-06 (220-221行目: WHEN OTHER...Move 'Please enter a valid option') | ○ |

### LGTESTP3（House保険テスト）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-44 | オプション1でCA-REQUEST-ID='01IHOU'設定 | E-07 (67行目: Move '01IHOU' To CA-REQUEST-ID) | ○ |
| C-45 | オプション2でCA-REQUEST-ID='01AHOU'設定 | E-07 (93行目: Move '01AHOU' To CA-REQUEST-ID) | ○ |
| C-46 | オプション3でCA-REQUEST-ID='01DHOU'設定 | E-07 (126行目: Move '01DHOU' To CA-REQUEST-ID) | ○ |
| C-47 | オプション4でCA-REQUEST-ID='01UHOU'設定 | E-07 (183行目: Move '01UHOU' To CA-REQUEST-ID) | ○ |
| C-48 | 無効オプションで'Please enter a valid option'表示 | E-07 (219-220行目: WHEN OTHER...Move 'Please enter a valid option') | ○ |

### LGTESTP4（Commercial保険テスト）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-49 | 顧客番号+契約番号でCA-REQUEST-ID='01ICOM'設定 | E-08 (87行目: Move '01ICOM' To CA-REQUEST-ID) | ○ |
| C-50 | 契約番号のみでCA-REQUEST-ID='02ICOM'設定 | E-08 (97行目: Move '02ICOM' To CA-REQUEST-ID) | ○ |
| C-51 | 顧客番号のみでCA-REQUEST-ID='03ICOM'設定 | E-08 (106行目: Move '03ICOM' To CA-REQUEST-ID) | ○ |
| C-52 | 郵便番号でCA-REQUEST-ID='05ICOM'設定 | E-08 (115行目: Move '05ICOM' To CA-REQUEST-ID) | ○ |
| C-53 | オプション2でCA-REQUEST-ID='01ACOM'設定 | E-08 (157行目: Move '01ACOM' To CA-REQUEST-ID) | ○ |
| C-54 | オプション3でCA-REQUEST-ID='01DCOM'設定 | E-08 (198行目: Move '01DCOM' To CA-REQUEST-ID) | ○ |
| C-55 | 無効オプションで'Please enter a valid option'表示 | E-08 (238-239行目: WHEN OTHER...Move 'Please enter a valid option') | ○ |
| C-56 | 顧客不存在時エラーコード70で'Customer does not exist'表示 | E-08 (288-290行目: When 70...Move 'Customer does not exist') | ○ |

### 境界値テスト
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-57 | LGAPOL01でCOMMAREA最小長検証 | E-01 (109-116行目: WS-CA-HEADER-LEN使用) | ○ |
| C-58 | Endowment更新で必要長=28+124=152 | E-04 (38-39行目: WS-FULL-ENDOW-LEN VALUE +124, WS-CA-HEADER-LEN VALUE +28) | ○ |
| C-59 | House更新で必要長=28+130=158 | E-04 (40行目: WS-FULL-HOUSE-LEN VALUE +130) | ○ |
| C-60 | Motor更新で必要長=28+137=165 | E-04 (41行目: WS-FULL-MOTOR-LEN VALUE +137) | ○ |

## 4) 不足情報（Unknown / Missing）
- 該当なし（全てのClaimに対して根拠が存在）

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク
  - 全てのテストケースがソースコードに基づいて抽出されており、根拠が明確
  - COBOLプログラムのPARAGRAPH/SECTIONレベルでのテストケース網羅性は高い

## 6) レビュアーチェックリスト（最小）
- [ ] テストケースがCOMMAREAバリデーション（EIBCALEN=0、長さ不足）を網羅しているか確認
- [ ] 各保険タイプ（Endowment/House/Motor/Commercial）のCRUD操作が網羅されているか確認
- [ ] エラーコード（'98'、'99'、'70'）の処理が正しくテストケース化されているか確認
- [ ] 境界値テスト（COMMAREA長の境界）が適切に設定されているか確認
- [ ] トランザクション制御（Syncpoint Rollback）のテストケースが含まれているか確認
