---
generated_at: 2026-01-06 19:30:00
metrics:
  claims_total: 70
  claims_with_evidence: 70
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：vsam.csv（VSAMファイルアクセス層 単体テストケース一覧）

## 本レポートについて

### 目的
本レポートは、生成された単体テストケース一覧の信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：70 / 70、根拠なし：0
- 優先レビュー（高）
  1. 該当なし - すべてのテストケースにソースコード根拠あり

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `/Users/tomokababa/Work/route06/cics-genapp-main/base/src/lgacvs01.cbl` - 顧客追加VSAM処理プログラム
- E-02: `/Users/tomokababa/Work/route06/cics-genapp-main/base/src/lgicvs01.cbl` - 顧客照会VSAM処理プログラム
- E-03: `/Users/tomokababa/Work/route06/cics-genapp-main/base/src/lgdpvs01.cbl` - 保険契約削除VSAM処理プログラム
- E-04: `/Users/tomokababa/Work/route06/cics-genapp-main/base/src/lgipvs01.cbl` - 保険契約照会VSAM処理プログラム
- E-05: `/Users/tomokababa/Work/route06/cics-genapp-main/base/src/lgucvs01.cbl` - 顧客更新VSAM処理プログラム
- E-06: `/Users/tomokababa/Work/route06/cics-genapp-main/base/src/lgupvs01.cbl` - 保険契約更新VSAM処理プログラム
- E-07: `/Users/tomokababa/Work/route06/cics-genapp-main/base/src/lgapvs01.cbl` - 保険契約追加VSAM処理プログラム
- E-08: `/Users/tomokababa/Work/route06/cics-genapp-main/base/src/lgcmarea.cpy` - 共通エリア定義コピーブック
- E-09: `/Users/tomokababa/Work/route06/cics-genapp-main/docs/code-to-docs/単体テストケース一覧/plan.md` - 単体テストケース生成プラン

## 3) Claims と根拠の対応（レビューの主戦場）

### LGACVS01（顧客追加VSAM処理）- UT-VSM-001〜008
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | MAINLINE SECTIONでKSDSCUSTへのWrite処理が実装されている | E-01 (行68-74) | ○ |
| C-02 | WS-RESP!=NORMALの場合CA-RETURN-CODE='80'を設定 | E-01 (行75-77) | ○ |
| C-03 | エラー時にABEND ABCODE('LGV0')を実行 | E-01 (行79) | ○ |
| C-04 | WRITE-ERROR-MESSAGE段落でASKTIME/FORMATTIMEを使用 | E-01 (行90-95) | ○ |
| C-05 | LGSTSQプログラムへのLINK処理が存在 | E-01 (行102-105) | ○ |
| C-06 | EIBCALEN条件分岐によるログ出力制御が存在 | E-01 (行106-120) | ○ |
| C-07 | CUSTOMER-RECORD-SIZE=225の定義 | E-01 (行49) | ○ |
| C-08 | KeyLength(10)でのWrite処理 | E-01 (行72) | ○ |

### LGICVS01（顧客照会VSAM処理）- UT-VSM-009〜019
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-09 | WS-STARTCODE/WS-Invokeprogによる呼び出し元判定 | E-02 (行97-121) | ○ |
| C-10 | GENACNTLキューからのLOW/HIGH CUSTOMER読み取り | E-02 (行132-156) | ○ |
| C-11 | WS-Cust-Low/WS-Cust-Highのデフォルト値0001000001 | E-02 (行123-124) | ○ |
| C-12 | TSQが空の場合のWRITEQ TS処理 | E-02 (行162-187) | ○ |
| C-13 | Function Randomによる乱数生成 | E-02 (行193-196) | ○ |
| C-14 | KSDSCUSTからのGTEQ Read処理 | E-02 (行199-206) | ○ |
| C-15 | ENQ/DEQによる排他制御 | E-02 (行129-131, 189-191) | ○ |
| C-16 | WS-FLAGによる出力先切り替え（COMMAREA/SEND TEXT） | E-02 (行211-222) | ○ |

### LGDPVS01（保険契約削除VSAM処理）- UT-VSM-020〜025
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-17 | WF-Policy-Keyの構築（Request-ID+Customer-Num+Policy-Num） | E-03 (行77-79) | ○ |
| C-18 | KSDSPOLYへのDelete処理（KeyLength=21） | E-03 (行81-85) | ○ |
| C-19 | エラー時にCA-RETURN-CODE='81'を設定 | E-03 (行88) | ○ |
| C-20 | WRITE-ERROR-MESSAGE段落の実装 | E-03 (行99-132) | ○ |
| C-21 | EM-POLNUM/EM-CUSNUMへの値設定 | E-03 (行109-110) | ○ |

### LGIPVS01（保険契約照会VSAM処理）- UT-VSM-026〜035
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-22 | WS-STARTCODE/WS-Invokeprogによる呼び出し元判定 | E-04 (行79-105) | ○ |
| C-23 | PART-KEYによる部分キー検索（KeyLength=11, Generic） | E-04 (行111-119) | ○ |
| C-24 | 保険種別（M/E/H/C）でのGTEQ Read処理 | E-04 (行111-119) | ○ |
| C-25 | Policy-Type不一致時のエラーメッセージ設定 | E-04 (行121-128) | ○ |
| C-26 | WS-FLAGによる出力先切り替え | E-04 (行130-141) | ○ |

### LGUCVS01（顧客更新VSAM処理）- UT-VSM-036〜042
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-27 | Read File with Updateオプション | E-05 (行69-76) | ○ |
| C-28 | ReWrite File処理（CUSTOMER-RECORD-SIZE=225） | E-05 (行85-89) | ○ |
| C-29 | Read失敗時にCA-RETURN-CODE='81'/ABEND('LGV1') | E-05 (行77-83) | ○ |
| C-30 | ReWrite失敗時にCA-RETURN-CODE='82'/ABEND('LGV2') | E-05 (行90-96) | ○ |
| C-31 | WRITE-ERROR-MESSAGE段落の実装 | E-05 (行104-136) | ○ |

### LGUPVS01（保険契約更新VSAM処理）- UT-VSM-043〜053
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-32 | WF-Request-IDによるEVALUATE分岐（C/E/H/M/Other） | E-06 (行106-135) | ○ |
| C-33 | Commercial保険（'C'）のフィールドマッピング | E-06 (行108-111) | ○ |
| C-34 | Endowment保険（'E'）のフィールドマッピング | E-06 (行113-118) | ○ |
| C-35 | House保険（'H'）のフィールドマッピング | E-06 (行120-125) | ○ |
| C-36 | Motor保険（'M'）のフィールドマッピング | E-06 (行127-131) | ○ |
| C-37 | Other時のWF-Policy-Data=SPACES設定 | E-06 (行133-134) | ○ |
| C-38 | Read File with Updateオプション（KeyLength=21） | E-06 (行139-146) | ○ |
| C-39 | ReWrite File処理（WS-Commarea-LenF=64） | E-06 (行155-159) | ○ |
| C-40 | Read失敗時にCA-RETURN-CODE='81'/ABEND('LGV3') | E-06 (行147-153) | ○ |
| C-41 | ReWrite失敗時にCA-RETURN-CODE='82'/ABEND('LGV4') | E-06 (行160-166) | ○ |

### LGAPVS01（保険契約追加VSAM処理）- UT-VSM-054〜070
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-42 | WF-Request-IDによるEVALUATE分岐（C/E/H/M/Other） | E-07 (行103-132) | ○ |
| C-43 | Commercial保険（'C'）のフィールドマッピング | E-07 (行105-108) | ○ |
| C-44 | Endowment保険（'E'）のフィールドマッピング | E-07 (行110-115) | ○ |
| C-45 | House保険（'H'）のフィールドマッピング | E-07 (行117-122) | ○ |
| C-46 | Motor保険（'M'）のフィールドマッピング | E-07 (行124-128) | ○ |
| C-47 | Other時のWF-Policy-Data=SPACES設定 | E-07 (行130-131) | ○ |
| C-48 | WF-Policy-Keyの構築 | E-07 (行99-101) | ○ |
| C-49 | Write File処理（Length=64, KeyLength=21） | E-07 (行135-141) | ○ |
| C-50 | エラー時にCA-RETURN-CODE='80'を設定 | E-07 (行144) | ○ |
| C-51 | WRITE-ERROR-MESSAGE段落の実装 | E-07 (行155-188) | ○ |
| C-52 | EIBCALEN条件分岐によるログ出力制御 | E-07 (行173-186) | ○ |

### 共通データ定義（LGCMAREAコピーブック）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-53 | CA-REQUEST-ID(6バイト)の定義 | E-08 (行10) | ○ |
| C-54 | CA-RETURN-CODE(2桁数字)の定義 | E-08 (行11) | ○ |
| C-55 | CA-CUSTOMER-NUM(10桁数字)の定義 | E-08 (行12) | ○ |
| C-56 | CA-POLICY-NUM(10桁数字)の定義 | E-08 (行35) | ○ |
| C-57 | 保険種別固有フィールド（Endowment/House/Motor/Commercial）の定義 | E-08 (行46-103) | ○ |

## 4) 不足情報（Unknown / Missing）
- 該当なし - すべてのテストケースはソースコードから直接導出

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - すべてのテストケースにソースコード根拠あり

### 注意点
1. **VSAMファイルエラー処理**: DFHRESP(NORMAL)以外のレスポンスコードに対するテストは、CICSのモック環境が必要
2. **排他制御テスト（LGICVS01）**: ENQ/DEQの動作確認には複数タスクの同時実行環境が必要
3. **乱数生成（LGICVS01）**: Function Randomの結果は確率的であり、境界テストには特別な考慮が必要
4. **ABENDテスト**: ABEND処理のテストはCICS環境固有の設定が必要

## 6) レビュアーチェックリスト（最小）
- [ ] テストID（UT-VSM-xxx）の連番が正しいか確認
- [ ] 各プログラムのMAINLINE SECTIONとWRITE-ERROR-MESSAGE段落がカバーされているか
- [ ] 正常系/異常系/境界値の観点が適切に分類されているか
- [ ] VSAMファイル操作（Write/Read/ReWrite/Delete）のテストケースが網羅されているか
- [ ] 保険種別（C/E/H/M）ごとのテストケースがLGAPVS01/LGUPVSで網羅されているか
- [ ] エラーコード（80/81/82）とABENDコード（LGV0-LGV4）の対応が正しいか
- [ ] LGSTSQプログラムへの連携テストが含まれているか

## 補足情報

### VSAMファイル一覧
| ファイル名 | 用途 | キー長 | レコード長 |
|-----------|------|--------|-----------|
| KSDSCUST | 顧客マスタ | 10バイト | 225バイト |
| KSDSPOLY | 保険契約マスタ | 21バイト | 64バイト |

### プログラム機能マトリクス
| プログラム | CRUD | 対象ファイル | ABENDコード |
|-----------|------|-------------|-------------|
| LGACVS01 | Create | KSDSCUST | LGV0 |
| LGICVS01 | Read | KSDSCUST | - |
| LGUCVS01 | Update | KSDSCUST | LGV1, LGV2 |
| LGAPVS01 | Create | KSDSPOLY | - |
| LGIPVS01 | Read | KSDSPOLY | - |
| LGUPVS01 | Update | KSDSPOLY | LGV3, LGV4 |
| LGDPVS01 | Delete | KSDSPOLY | - |

### エラーコード体系
| エラーコード | 意味 | 発生プログラム |
|-------------|------|---------------|
| 80 | Write失敗 | LGACVS01, LGAPVS01 |
| 81 | Read/Delete失敗 | LGUCVS01, LGUPVS01, LGDPVS01 |
| 82 | ReWrite失敗 | LGUCVS01, LGUPVS01 |
