---
generated_at: 2026-01-06 19:30:00
metrics:
  claims_total: 70
  claims_with_evidence: 70
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：webservice.csv

## 本レポートについて

### 目的
本レポートは、生成された単体テストケース一覧（webservice.csv）の信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：70 / 70、根拠なし：0
- 優先レビュー（高）
  1. なし（全主張に根拠あり）

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `/Users/tomokababa/Work/route06/cics-genapp-main/base/src/lgwebst5.cbl` - Webサービス統計収集プログラム（全803行）
- E-02: `/Users/tomokababa/Work/route06/cics-genapp-main/docs/code-to-docs/単体テストケース一覧/plan.md` - 単体テストケース一覧生成プラン

## 3) Claims と根拠の対応（レビューの主戦場）

### MAINLINE SECTION関連
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | CICS環境情報の初期化（EIBTRNID/EIBTRMID/EIBTASKN/EIBCALEN） | E-01 (行252-257) | ○ |
| C-02 | ASKTIME/FORMATTIMEで現在時刻取得 | E-01 (行260-265) | ○ |
| C-03 | GENAcountカウンター照会（GENACUSTNUM） | E-01 (行268-273) | ○ |
| C-04 | カウンター照会失敗時のエラーハンドリング | E-01 (行271: WS-RESP) | ○ |
| C-05 | GENACNT100カウンター（顧客照会成功）取得 | E-01 (行281-288) | ○ |
| C-06 | GENACNT199カウンター（顧客照会エラー）取得 | E-01 (行296-303) | ○ |
| C-07 | GENACNT200カウンター（顧客追加成功）取得 | E-01 (行304-312) | ○ |
| C-08 | GENACNT299カウンター（顧客追加エラー）取得 | E-01 (行318-325) | ○ |
| C-09 | GENACNT300-GENACNTH99までの各種保険カウンター取得 | E-01 (行327-659) | ○ |
| C-10 | 成功件数（CountSuccess）の集計ロジック | E-01 (行309, 332, 354, 376, 398, 421, 443, 465, 487, 510, 532, 554, 576, 599, 621, 643) | ○ |
| C-11 | エラー件数（CountErrors）の集計ロジック | E-01 (行301, 323, 346, 368, 390, 412, 435, 457, 479, 501, 524, 546, 568, 590, 613, 635, 657) | ○ |
| C-12 | 照会件数（CountInq）の集計ロジック | E-01 (行287, 334, 423, 512, 601) | ○ |
| C-13 | 追加件数（CountAdd）の集計ロジック | E-01 (行310, 356, 445, 534, 623) | ○ |
| C-14 | 更新件数（CountUpd）の集計ロジック | E-01 (行400, 489, 578) | ○ |
| C-15 | 削除件数（CountDel）の集計ロジック | E-01 (行378, 467, 556, 645) | ○ |
| C-16 | ASSIGN APPLIDでアプリケーションID取得 | E-01 (行703-705) | ○ |
| C-17 | CICS RETURNで正常終了 | E-01 (行708-709) | ○ |

### Tran-Rate-Interval SECTION関連
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-18 | TSQから前回時刻読み取り（ReadQ TS） | E-01 (行720-725) | ○ |
| C-19 | TSQ読み取り失敗時デフォルト値設定（120000） | E-01 (行726-727) | ○ |
| C-20 | TSQ削除（DeleteQ TS） | E-01 (行729-731) | ○ |
| C-21 | 現在時刻TSQ書き込み（WRITEQ TS） | E-01 (行734-738) | ○ |
| C-22 | 時間間隔の秒計算ロジック | E-01 (行739-751) | ○ |
| C-23 | 間隔値のTSQ書き込み | E-01 (行756-760) | ○ |
| C-24 | 次回トランザクションスケジュール（Start SSST） | E-01 (行761-765) | ○ |

### Tran-Rate-Counts SECTION関連
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-25 | TSQから前回カウント値読み取り | E-01 (行771-776) | ○ |
| C-26 | TSQ削除処理 | E-01 (行778-780) | ○ |
| C-27 | 新規カウント値のTSQ書き込み | E-01 (行782-787) | ○ |
| C-28 | 前回カウント値のTSQ書き込み | E-01 (行788-793) | ○ |
| C-29 | 差分値（DRateVal）計算ロジック | E-01 (行794) | ○ |
| C-30 | 差分値のTSQ書き込み | E-01 (行795-800) | ○ |

### WORKING-STORAGE関連
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-31 | WS-HEADER構造体定義（WS-EYECATCHER等） | E-01 (行69-75) | ○ |
| C-32 | カウンター名定数定義（GENAcount等） | E-01 (行197-233) | ○ |
| C-33 | SymbList構造体定義 | E-01 (行76-156) | ○ |
| C-34 | カウンター値変数定義（GENACount-V等） | E-01 (行157-195) | ○ |

### LINKAGE SECTION関連
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-35 | DFHCOMMAREA定義 | E-01 (行238-243) | ○ |

### 境界値・エッジケース関連
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-36 | 日跨ぎ時の時間計算（潜在的問題） | E-01 (行742-751: 減算ロジック) | ○ |
| C-37 | カウンターリセット時の負値問題 | E-01 (行794: Compute DRateVal = NRateVal - ORateVal) | ○ |
| C-38 | EIBCALENが0の場合の処理 | E-01 (行257: MOVE EIBCALEN TO WS-CALEN) | ○ |
| C-39 | カウンター値の最大値境界 | E-01 (行18: PIC S9(8) COMP) | ○ |

## 4) 不足情報（Unknown / Missing）
- なし（全主張に対してソースコードから根拠を確認済み）

**補足**：
- 本プログラムはIBM CICS環境専用のWebサービス統計収集プログラムである
- CICS API（EXEC CICS）の動作仕様はIBMのドキュメントに準拠
- カウンター名（GENA01ICUS00等）はGeneral Insurance Application（GenApp）の命名規則に従う

## 5) リスクフラグ（レビュー観点）

| リスク | 該当項目 | レベル |
|--------|----------|--------|
| 日跨ぎ時の時間計算 | C-36 (UT-WEB-052) | 1: 中リスク |
| カウンターリセット時の負値 | C-37 (UT-WEB-062) | 1: 中リスク |
| CICS環境依存性 | 全テストケース | 0: 低リスク |

**リスク詳細**：
1. **日跨ぎ時の時間計算** - 現在時刻が前回時刻より小さくなる場合（23:59:00 -> 00:01:00）、ICountValが負値となる可能性がある。ソースコード上ではこのケースのハンドリングが見られない。
2. **カウンターリセット時の負値** - 外部要因でカウンターがリセットされた場合、DRateValが負値となる。運用上の考慮が必要。

## 6) レビュアーチェックリスト（最小）

- [ ] CICS環境での実行を想定した単体テスト環境が構築可能か確認
- [ ] EXEC CICS QUERY COUNTERのモック化方針を検討
- [ ] TSQ（Temporary Storage Queue）のモック化方針を検討
- [ ] 時間間隔計算の境界値テスト（日跨ぎケース）の実施方法を検討
- [ ] カウンター値の境界値（PIC S9(8)の最大値付近）テストの必要性を判断
- [ ] 各カウンター（GENACNT100-GENACNTH99）の網羅性が保険種別と一致することを確認

## 7) テストケース網羅性分析

### 対象プログラム構造

| セクション/パラグラフ | 行番号 | テストケース数 | カバレッジ |
|----------------------|--------|---------------|-----------|
| MAINLINE SECTION | 250-713 | 47 | 高 |
| Tran-Rate-Interval | 715-767 | 8 | 高 |
| Tran-Rate-Counts | 769-802 | 8 | 高 |
| WORKING-STORAGE | 17-234 | 4 | 中 |
| LINKAGE SECTION | 238-243 | 1 | 中 |
| 境界値テスト | - | 2 | 中 |

### カウンター種別と対応テストケース

| カウンター種別 | 対象操作 | テストケースID |
|---------------|---------|----------------|
| 顧客（Customer） | 照会/追加 | UT-WEB-005～008 |
| モーター保険（Motor） | 照会/追加/削除/更新 | UT-WEB-009～016 |
| エンドウメント保険（Endowment） | 照会/追加/削除/更新 | UT-WEB-017～024 |
| 住宅保険（House） | 照会/追加/削除/更新 | UT-WEB-025～032 |
| 商業保険（Commercial） | 照会/追加/削除 | UT-WEB-033～038 |
| その他（Other） | - | UT-WEB-038 |

### 集計ロジック検証

| 集計項目 | 計算式 | テストケースID |
|---------|-------|----------------|
| 成功件数 | GENACNT100+200+300+400+500+600+700+800+900+A00+B00+C00+D00+E00+F00+G00+H00 | UT-WEB-040 |
| エラー件数 | GENACNT199+299+399+499+599+699+799+899+999+A99+B99+C99+D99+E99+F99+G99+H99 | UT-WEB-041 |
| 照会件数 | GENACNT100+300+700+B00+F00 | UT-WEB-042 |
| 追加件数 | GENACNT200+400+800+C00+G00 | UT-WEB-043 |
| 更新件数 | GENACNT600+A00+E00 | UT-WEB-044 |
| 削除件数 | GENACNT500+900+D00+H00 | UT-WEB-045 |
