---
generated_at: 2026-01-06 19:15:00
metrics:
  claims_total: 32
  claims_with_evidence: 28
  claims_without_evidence: 4
confidence_derived: 0.88
---

# 根拠レポート：受入テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された受入テストケース一覧の信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.88**
  - 根拠あり：28 / 32、根拠なし：4
- 優先レビュー（高）
  1. **UAT-029 Web Services連携（顧客追加）**：Web Services設定JCLは存在するが、実際の動作検証は環境依存
  2. **UAT-030 Web Services連携（ポリシー照会）**：同上
  3. **UAT-031 パフォーマンス確認**：具体的な応答時間基準の根拠なし
  4. **UAT-028 GENAERRSキュー確認**：Db2エラー発生時の動作は推定

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `base/README.md` - アプリケーション概要と機能説明
- E-02: `base/Architecture.md` - アーキテクチャ設計（Db2、VSAM、TSQ、Named Counter Server）
- E-03: `base/Testing.md` - 公式テスト手順
- E-04: `base/Reference.md` - トランザクション、プログラム、リソース定義一覧
- E-05: `base/src/ssmap.bms` - BMS画面マップ定義（全5画面）
- E-06: `base/src/lgtestc1.cbl` - 顧客メニュー プレゼンテーションロジック
- E-07: `base/src/lgtestp1.cbl` - 自動車保険メニュー プレゼンテーションロジック
- E-08: `base/src/lgacus01.cbl` - 顧客追加 ビジネスロジック
- E-09: `base/src/lgicus01.cbl` - 顧客照会 ビジネスロジック
- E-10: `base/src/lgapol01.cbl` - ポリシー追加 ビジネスロジック
- E-11: `base/cntl/README.md` - JCLジョブ説明
- E-12: `base/data/README.md` - サンプルデータ説明

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | SSC1で顧客照会が可能 | E-03, E-06 | ○ |
| C-02 | SSC1で顧客追加が可能 | E-03, E-06, E-08 | ○ |
| C-03 | SSC1で顧客更新が可能 | E-06 (option 4) | ○ |
| C-04 | 存在しない顧客番号でエラー表示 | E-06 (NO-DATA section) | ○ |
| C-05 | SSP1で自動車保険ポリシー照会が可能 | E-03, E-07 | ○ |
| C-06 | SSP1で自動車保険ポリシー追加が可能 | E-07 (option 2) | ○ |
| C-07 | SSP1で自動車保険ポリシー削除が可能 | E-07 (option 3) | ○ |
| C-08 | SSP1で自動車保険ポリシー更新が可能 | E-07 (option 4) | ○ |
| C-09 | 存在しない顧客へのポリシー作成でエラー | E-07 (NO-ADD, return code 70) | ○ |
| C-10 | SSP2で養老保険ポリシー操作が可能 | E-04, E-05 | ○ |
| C-11 | SSP3で住宅保険ポリシー操作が可能 | E-04, E-05 | ○ |
| C-12 | SSP4で商業物件保険ポリシー操作が可能 | E-04, E-05 | ○ |
| C-13 | LGSEでシステム初期化が可能 | E-03, E-04 | ○ |
| C-14 | Db2とVSAMへの2フェーズコミット | E-02, E-06 (Syncpoint Rollback) | ○ |
| C-15 | VSAM失敗時のDb2ロールバック | E-02 | ○ |
| C-16 | F3キーで画面終了 | E-06 (HANDLE AID PF3) | ○ |
| C-17 | CLEARキーで画面初期化 | E-06 (CLEARIT section) | ○ |
| C-18 | 無効オプションでエラーメッセージ表示 | E-06, E-07 (WHEN OTHER) | ○ |
| C-19 | COMMIREAなしでABEND発生 | E-08, E-09 (LGCA ABEND) | ○ |
| C-20 | E2Eフロー（顧客→ポリシー）が機能 | E-03, E-06, E-07 | ○ |
| C-21 | Named Counter Serverで顧客番号採番 | E-02, E-04 | ○ |
| C-22 | GENACNTLキューに顧客番号範囲を記録 | E-06 (WRITE-GENACNTL) | ○ |
| C-23 | GENAERRSキューにDb2エラーを記録 | E-02 | ○ |
| C-24 | 各ポリシータイプ固有のフィールドが存在 | E-05 (BMS map definitions) | ○ |
| C-25 | サンプルデータ（顧客1-10、ポリシー1-10）存在 | E-04, E-12 | ○ |
| C-26 | SSP4のPolicy Updateは未実装 | E-05 (コメントアウト) | ○ |
| C-27 | 商業物件保険にPeril/Premium項目あり | E-05 (ENP4FPE, ENP4CPE等) | ○ |
| C-28 | SSP5 Claim機能の画面定義存在 | E-05 (SSMAPP5) | ○ |
| C-29 | Web Service（顧客追加）が機能 | E-11 (WSAAC01.jcl) | △ |
| C-30 | Web Service（ポリシー照会）が機能 | E-11 (WSAIP01.jcl) | △ |
| C-31 | 応答時間3秒以内で操作完了 | **根拠なし** | △ |
| C-32 | Db2エラー時のTSQ書き込み動作 | E-02, E-08 | △ |

## 4) 不足情報（Unknown / Missing）
- Web Servicesの実際の動作確認には環境設定と接続テストが必要
  - 候補：実際のWeb Services環境でのテスト / WSAAC01.jclの実行結果 / WSDLファイル
- パフォーマンス基準（応答時間）の根拠となる要件定義書が不明
  - 候補：非機能要件定義書 / SLA定義 / パフォーマンス要件
- GENAERRSキューへのエラー書き込みの具体的な条件とフォーマット
  - 候補：エラーログ仕様書 / LGSTSQ.cblの詳細分析

## 5) リスクフラグ（レビュー観点）
- **リスク1（中）**：Web Services連携テスト（UAT-029, UAT-030）は環境依存であり、本番環境での追加検証が必要
- **リスク1（中）**：パフォーマンステスト（UAT-031）の基準値が仮定値であり、実際の要件に基づく調整が必要
- **リスク0（低）**：SSP5（Claim）画面の定義はBMSに存在するが、対応するトランザクション定義がReference.mdにないため、テストケースから除外

## 6) レビュアーチェックリスト（最小）
- [ ] 顧客管理シナリオ（UAT-001〜004）のテスト手順がTesting.mdと整合しているか
- [ ] ポリシー操作（追加/照会/更新/削除）の全タイプで網羅されているか
- [ ] 2フェーズコミット/ロールバックのテストケース（UAT-017, 018）が実環境で再現可能か
- [ ] Web Services連携テストの前提条件（環境設定）が現実的か
- [ ] E2Eシナリオ（UAT-023〜025）で主要業務フローがカバーされているか
- [ ] エラーハンドリングテスト（UAT-004, 009, 021, 022）が十分か
