---
generated_at: 2026-01-06 12:00:00
metrics:
  claims_total: 9
  claims_with_evidence: 9
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：帳票一覧.csv

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：9 / 9、根拠なし：0
- 優先レビュー（高）
  1. **該当なし**：全ての主張に根拠あり

### 重要な注意事項
本プロジェクトはIBM CICS GenApp（保険アプリケーション）であり、典型的な帳票（紙出力・PDF等のレポート）生成機能は実装されていません。ここで「帳票」として分類したものは、TSQ/TDQへの出力データであり、厳密には帳票というよりもログ・統計データ・コントロール情報です。

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `base/src/lgwebst5.cbl` - トランザクション統計収集プログラム
- E-02: `base/src/lgstsq.cbl` - TSQ/TDQへのメッセージ書き込みプログラム
- E-03: `base/src/lgsetup.cbl` - カウンター・TSQ初期化プログラム
- E-04: `base/src/lgtestc1.cbl` - 顧客メニュー・プレゼンテーションロジック
- E-05: `base/Reference.md` - アプリケーションプログラム一覧
- E-06: `base/Architecture.md` - アプリケーションアーキテクチャ説明

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | LGWEBST5はトランザクションカウンター値を収集する | E-01 (行268-273: Query Counter, 行281-303: CountVal処理) | ○ |
| C-02 | 統計情報はTSQ(GENASTAT)に出力される | E-01 (行56: StatQ = 'GENASTAT', 行733-796: WRITEQ TS処理) | ○ |
| C-03 | 60秒間隔でリフレッシュされる | E-01 (行761-765: Start Transid('SSST') After Minutes(1)) | ○ |
| C-04 | LGSTSQはエラーメッセージをTDQ(CSMT)に出力する | E-02 (行40: STDQ-NAME = 'CSMT', 行94-99: WRITEQ TD) | ○ |
| C-05 | LGSTSQはエラーメッセージをTSQ(GENAERRS)にも出力する | E-02 (行82: 'GENAERRS', 行105-111: WRITEQ TS) | ○ |
| C-06 | LGSETUPは顧客番号範囲をTSQ(GENACNTL)に記録する | E-03 (行157-172: WRITEQ TS Queue(STSQ-NAME)) | ○ |
| C-07 | LGTESTC1も顧客番号管理情報を更新する | E-04 (行307-336: WRITEQ TS Queue(STSQ-NAME)) | ○ |
| C-08 | GENACNTL TSQはWorkload Simulator自動化用である | E-06 (行62-64: 説明記載) | ○ |
| C-09 | GENAERRSはDB2問題識別用のTSQである | E-06 (行66-70: 説明記載) | ○ |

## 4) 不足情報（Unknown / Missing）
- 本プロジェクトには明示的な帳票出力機能（印刷、PDF生成、ファイル出力等）は存在しない
  - 候補：JCLによるバッチ処理でのレポート生成 / 外部システムとの連携 / 別モジュールでの実装

## 5) リスクフラグ（レビュー観点）
- **リスク0（低リスク）**：根拠のある情報のみを記載
- ただし、「帳票」の定義について確認が必要。本ドキュメントでは、TSQ/TDQへの出力データを広義の帳票として解釈している

## 6) レビュアーチェックリスト（最小）
- [ ] TSQ/TDQ出力を「帳票」として分類することが適切か確認
- [ ] 他の帳票形式の出力（印刷、ファイル、PDF等）がないか確認
- [ ] 業務要件として追加の帳票が必要かどうか確認
