# 帳票設計書 1-トランザクション統計レポート

## 概要

本ドキュメントは、GENAPP保険アプリケーションにおけるトランザクション統計レポートの設計仕様を定義するものである。LGWEBST5プログラムにより、CICS Named Counter Serverからトランザクションカウンター値を収集し、TSQ(Temporary Storage Queue)であるGENASTATに統計情報を出力する。

### 本帳票の処理概要

**業務上の目的・背景**：本帳票は、保険業務システムにおけるトランザクション処理の実行状況をリアルタイムで監視するために必要である。顧客管理および各種保険ポリシー操作（自動車保険、養老保険、住宅保険、商業用不動産保険）の成功件数・エラー件数を収集し、システム運用管理者がシステムの健全性を把握できるようにする。IBM Business Monitorとの連携により、ビジネスプロセスの可視化を実現する。

**帳票の利用シーン**：システム運用監視ダッシュボードでのリアルタイムモニタリング、システム稼働状況の定期レポート作成、障害発生時の原因分析、キャパシティプランニングのための統計データ収集に利用される。

**主要な出力内容**：
1. 顧客番号カウンター値（GENACUSTNUM）
2. 顧客照会（Inquiry Customer）成功/エラー件数
3. 顧客追加（Add Customer）成功/エラー件数
4. 自動車保険操作（照会/追加/削除/更新）の成功/エラー件数
5. 養老保険操作（照会/追加/削除/更新）の成功/エラー件数
6. 住宅保険操作（照会/追加/削除/更新）の成功/エラー件数
7. 商業用不動産保険操作（照会/追加/削除/更新）の成功/エラー件数
8. 総成功件数・総エラー件数のサマリー
9. 時間間隔情報（前回収集からの経過時間）

**帳票の出力タイミング**：60秒間隔で自動的にトランザクションSSSTが起動され、統計データが収集・更新される。Business Monitor向けの周期的リフレッシュ機能として動作する。

**帳票の利用者**：システム運用管理者、インフラ担当者、ビジネスアナリスト、IBM Business Monitorを利用する監視チーム

## 帳票種別

統計レポート / リアルタイム監視データ

## 利用画面

| 画面No | 画面名 | URL/ルーティング | 出力操作 |
|--------|--------|-----------------|---------|
| - | Web統計参照画面 | HTTP経由（SSISTAT1サービス） | 自動リフレッシュ |

## 出力形式

### 基本仕様

| 項目 | 内容 |
|-----|------|
| ファイル形式 | TSQ（CICS Temporary Storage Queue） |
| 用紙サイズ | N/A（電子データ） |
| 向き | N/A |
| ファイル名 | GENASTAT（キュー名） |
| 出力方法 | CICS TSQへの書き込み / Web参照 |
| 文字コード | EBCDIC |

### TSQ固有設定

| 項目 | 内容 |
|-----|------|
| キュー名 | GENASTAT |
| 共有設定 | Coupling Facility経由で共有可能 |
| データ保持 | CICSリージョン稼働中 |

## 帳票レイアウト

### レイアウト概要

TSQ内に複数のアイテムとして統計データを格納する。各カウンター値は個別のキー名で管理される。

```
┌─────────────────────────────────────┐
│       時間間隔情報（GENA000V）        │
├─────────────────────────────────────┤
│       顧客番号カウンター             │
├─────────────────────────────────────┤
│       顧客操作カウンター             │
│  (照会成功/エラー、追加成功/エラー)    │
├─────────────────────────────────────┤
│       自動車保険カウンター            │
│  (照会/追加/削除/更新 × 成功/エラー)   │
├─────────────────────────────────────┤
│       養老保険カウンター             │
│  (照会/追加/削除/更新 × 成功/エラー)   │
├─────────────────────────────────────┤
│       住宅保険カウンター             │
│  (照会/追加/削除/更新 × 成功/エラー)   │
├─────────────────────────────────────┤
│       商業用不動産保険カウンター       │
│  (照会/追加/削除/更新 × 成功/エラー)   │
├─────────────────────────────────────┤
│       サマリー情報                   │
│  (総成功件数、総エラー件数)           │
└─────────────────────────────────────┘
```

### カウンター項目一覧

| No | カウンター名 | 説明 | データ形式 |
|----|-------------|------|-----------|
| 1 | GENACUSTNUM | 顧客番号カウンター | PIC 9(9) |
| 2 | GENA01ICUS00 | 顧客照会成功件数 | PIC 9(9) |
| 3 | GENA01ICUS99 | 顧客照会エラー件数 | PIC 9(9) |
| 4 | GENA01ACUS00 | 顧客追加成功件数 | PIC 9(9) |
| 5 | GENA01ACUS99 | 顧客追加エラー件数 | PIC 9(9) |
| 6 | GENA01IMOT00 | 自動車保険照会成功件数 | PIC 9(9) |
| 7 | GENA01IMOT99 | 自動車保険照会エラー件数 | PIC 9(9) |
| 8 | GENA01AMOT00 | 自動車保険追加成功件数 | PIC 9(9) |
| 9 | GENA01AMOT99 | 自動車保険追加エラー件数 | PIC 9(9) |
| 10 | GENA01DMOT00 | 自動車保険削除成功件数 | PIC 9(9) |
| 11 | GENA01DMOT99 | 自動車保険削除エラー件数 | PIC 9(9) |
| 12 | GENA01UMOT00 | 自動車保険更新成功件数 | PIC 9(9) |
| 13 | GENA01UMOT99 | 自動車保険更新エラー件数 | PIC 9(9) |
| 14 | GENA01IEND00 | 養老保険照会成功件数 | PIC 9(9) |
| 15 | GENA01IEND99 | 養老保険照会エラー件数 | PIC 9(9) |
| 16 | GENA01AEND00 | 養老保険追加成功件数 | PIC 9(9) |
| 17 | GENA01AEND99 | 養老保険追加エラー件数 | PIC 9(9) |
| 18 | GENA01DEND00 | 養老保険削除成功件数 | PIC 9(9) |
| 19 | GENA01DEND99 | 養老保険削除エラー件数 | PIC 9(9) |
| 20 | GENA01UEND00 | 養老保険更新成功件数 | PIC 9(9) |
| 21 | GENA01UEND99 | 養老保険更新エラー件数 | PIC 9(9) |
| 22 | GENA01IHOU00 | 住宅保険照会成功件数 | PIC 9(9) |
| 23 | GENA01IHOU99 | 住宅保険照会エラー件数 | PIC 9(9) |
| 24 | GENA01AHOU00 | 住宅保険追加成功件数 | PIC 9(9) |
| 25 | GENA01AHOU99 | 住宅保険追加エラー件数 | PIC 9(9) |
| 26 | GENA01DHOU00 | 住宅保険削除成功件数 | PIC 9(9) |
| 27 | GENA01DHOU99 | 住宅保険削除エラー件数 | PIC 9(9) |
| 28 | GENA01UHOU00 | 住宅保険更新成功件数 | PIC 9(9) |
| 29 | GENA01UHOU99 | 住宅保険更新エラー件数 | PIC 9(9) |
| 30 | GENA01ICOM00 | 商業用不動産保険照会成功件数 | PIC 9(9) |
| 31 | GENA01ICOM99 | 商業用不動産保険照会エラー件数 | PIC 9(9) |
| 32 | GENA01ACOM00 | 商業用不動産保険追加成功件数 | PIC 9(9) |
| 33 | GENA01ACOM99 | 商業用不動産保険追加エラー件数 | PIC 9(9) |
| 34 | GENA01DCOM00 | 商業用不動産保険削除成功件数 | PIC 9(9) |
| 35 | GENA01DCOM99 | 商業用不動産保険削除エラー件数 | PIC 9(9) |
| 36 | GENAOTHER | その他カウンター | PIC 9(9) |

### サマリー項目

| No | 項目名 | 説明 | データ形式 |
|----|-------|------|-----------|
| 1 | GENAsucces-V | 総成功件数 | PIC 9(9) |
| 2 | GENAerrors-V | 総エラー件数 | PIC 9(9) |
| 3 | CountInq | 照会操作合計 | PIC S9(8) COMP |
| 4 | CountAdd | 追加操作合計 | PIC S9(8) COMP |
| 5 | CountUpd | 更新操作合計 | PIC S9(8) COMP |
| 6 | CountDel | 削除操作合計 | PIC S9(8) COMP |

## 出力条件

### 抽出条件

| 条件名 | 説明 | 必須 |
|-------|------|-----|
| 時間間隔 | 前回収集から60秒経過 | Yes |
| カウンタープール | GENAプールからの取得 | Yes |

### ソート順

| 優先度 | 項目 | 昇順/降順 |
|-------|------|---------|
| N/A | TSQアイテム番号順 | 昇順 |

### 改ページ条件

N/A（TSQ出力のため改ページ概念なし）

## データベース参照仕様

### 参照テーブル一覧

| テーブル名 | 用途 | 結合条件 |
|-----------|------|---------|
| N/A | 本帳票はデータベースを参照しない | - |

### Named Counter Server参照仕様

#### カウンター取得

| 参照項目（カウンター名） | 帳票項目との対応 | 取得方法 | 備考 |
|------------------------|----------------|---------|------|
| GENACUSTNUM | 顧客番号カウンター | EXEC CICS QUERY COUNTER | GENAプール |
| GENA01ICUS00 | 顧客照会成功件数 | EXEC CICS QUERY COUNTER | GENAプール |
| GENA01ICUS99 | 顧客照会エラー件数 | EXEC CICS QUERY COUNTER | GENAプール |
| その他カウンター | 各種操作件数 | EXEC CICS QUERY COUNTER | GENAプール |

## 計算仕様

### 計算項目一覧

| 項目名 | 計算式 | 端数処理 | 備考 |
|-------|-------|---------|------|
| CountSuccess | 全成功カウンターの合計 | N/A | 累積加算 |
| CountErrors | 全エラーカウンターの合計 | N/A | 累積加算 |
| CountInq | ICUS00+IMOT00+IEND00+IHOU00+ICOM00 | N/A | 照会操作合計 |
| CountAdd | ACUS00+AMOT00+AEND00+AHOU00+ACOM00 | N/A | 追加操作合計 |
| CountUpd | UMOT00+UEND00+UHOU00 | N/A | 更新操作合計 |
| CountDel | DMOT00+DEND00+DHOU00+DCOM00 | N/A | 削除操作合計 |
| ICountVal | (HH*3600)+(MM*60)+SS | N/A | 時間間隔（秒） |
| DRateVal | NRateVal - ORateVal | N/A | 差分カウント |

## 処理フロー

### 出力フロー

```mermaid
flowchart TD
    A[SSSトランザクション起動] --> B[時間取得 ASKTIME/FORMATTIME]
    B --> C[時間間隔計算 Tran-Rate-Interval]
    C --> D[Named Counter照会開始]
    D --> E[GENACUSTNUMカウンター取得]
    E --> F[顧客操作カウンター取得]
    F --> G[自動車保険カウンター取得]
    G --> H[養老保険カウンター取得]
    H --> I[住宅保険カウンター取得]
    I --> J[商業用不動産保険カウンター取得]
    J --> K[サマリー計算]
    K --> L[TSQへ統計データ書き込み]
    L --> M[次回実行スケジュール CICS START]
    M --> N[CICS RETURN]
```

### Tran-Rate-Counts処理

```mermaid
flowchart TD
    A[ReadQ TS - 前回値取得] --> B[DeleteQ TS - 既存データ削除]
    B --> C[WriteQ TS - 新規値書き込み]
    C --> D[WriteQ TS - 前回値書き込み]
    D --> E[差分計算 DRateVal]
    E --> F[WriteQ TS - 差分値書き込み]
```

## エラー処理

### エラーケース一覧

| エラー種別 | 発生条件 | 表示メッセージ | 対処方法 |
|----------|---------|--------------|---------|
| カウンター取得失敗 | Named Counter Serverにアクセスできない | WS-RESP に非正常値 | エラーを無視して処理継続 |
| TSQ読み取り失敗 | 初回実行時など前回値が存在しない | DFHRESP(NORMAL)以外 | デフォルト値'120000'を使用 |
| TSQ書き込み失敗 | TSQ領域不足 | WS-RESP に非正常値 | 処理継続（NOSUSPEND指定） |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定データ件数 | 36カウンター項目 |
| 目標出力時間 | 60秒周期内に完了 |
| 同時出力数上限 | 1（シングルトランザクション） |

## セキュリティ考慮事項

- 統計データには個人情報は含まれない
- Named Counter ServerへのアクセスはCICSセキュリティで制御
- TSQはCoupling Facility経由で共有可能だが、同一Sysplexに限定

## 備考

- 本プログラム（LGWEBST5）はIBM Business Monitor向けの統計収集機能として設計されている
- トランザクションID: SSST
- 60秒間隔で自動起動（EXEC CICS START TRANSID('SSST') AFTER MINUTES(1)）
- Web経由での参照機能あり（TCPservice: SSISTAT1）
- テンプレート名: GENAST3TEMP

---

## コードリーディングガイド

本帳票を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

まず、カウンター名と変数の対応関係を理解することが重要である。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | lgwebst5.cbl | `base/src/lgwebst5.cbl` | WORKING-STORAGE SECTION（行16-234）でカウンター名の定義を確認。GENAcount（GENACUSTNUM）、GENACNT100〜GENACNTI99の36種類のカウンター名定義を理解する |

**カウンター名の命名規則**:
- `GENA01xyyy00`: 成功カウンター（xxは操作種別、yyyは保険種別）
- `GENA01xyyy99`: エラーカウンター
- 操作種別: I=照会、A=追加、D=削除、U=更新
- 保険種別: CUS=顧客、MOT=自動車、END=養老、HOU=住宅、COM=商業

**読解のコツ**: COBOLのWORKING-STORAGE SECTIONはグローバル変数の定義領域。PIC S9(8) COMPはバイナリ形式の符号付き8桁整数を表す。

#### Step 2: メイン処理フローを理解する

統計収集の全体的な処理の流れを把握する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | lgwebst5.cbl | `base/src/lgwebst5.cbl` | MAINLINE SECTION（行250）から処理開始。ASKTIME/FORMATTIME（行260-265）で時刻取得、Tran-Rate-Interval（行266）で時間間隔処理を確認 |

**主要処理フロー**:
1. **行260-265**: 現在時刻の取得（ASKTIME/FORMATTIME）
2. **行266**: 時間間隔計算（Tran-Rate-Interval）
3. **行268-272**: GENACUSTNUMカウンター取得（EXEC CICS QUERY COUNTER）
4. **行281-699**: 36種類のカウンターを順次取得しながらサマリー計算
5. **行703-704**: APPLIDの取得
6. **行708-709**: CICS RETURN

#### Step 3: カウンター取得処理を理解する

Named Counter Serverからのカウンター値取得パターンを理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | lgwebst5.cbl | `base/src/lgwebst5.cbl` | 行268-272のカウンター取得パターン。EXEC CICS QUERY COUNTER でGENAプールからカウンター値を取得 |

**カウンター取得パターン**:
```cobol
Exec CICS Query Counter(GENAcount)
             Pool(GENApool)
             Value(CountVal)
             Resp(WS-RESP)
End-Exec.
```

**サマリー計算ロジック**（行286-699）:
- CountSuccess: 全成功カウンターの累積加算
- CountErrors: 全エラーカウンターの累積加算
- CountInq/CountAdd/CountUpd/CountDel: 操作種別ごとの集計

#### Step 4: TSQ書き込み処理を理解する

統計データのTSQ出力ロジックを理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | lgwebst5.cbl | `base/src/lgwebst5.cbl` | Tran-Rate-Interval（行715-766）とTran-Rate-Counts（行769-802）の2つのサブルーチンを確認 |

**Tran-Rate-Interval処理**（行715-766）:
1. **行720-725**: 前回時刻の読み取り（ReadQ TS）
2. **行729-731**: 既存データ削除（DeleteQ TS）
3. **行734-738**: 新規時刻の書き込み（WriteQ TS）
4. **行742-751**: 時間間隔の計算（秒単位）
5. **行761-765**: 次回実行のスケジュール（CICS START TRANSID('SSST') AFTER MINUTES(1)）

**Tran-Rate-Counts処理**（行769-802）:
1. **行771-776**: 前回値の読み取り
2. **行778-780**: 既存データ削除
3. **行782-793**: 新規値・前回値の書き込み
4. **行794-800**: 差分値の計算・書き込み

### プログラム呼び出し階層図

```
LGWEBST5（トランザクション統計収集）
    │
    ├─ EXEC CICS ASKTIME/FORMATTIME ... 時刻取得
    │
    ├─ Tran-Rate-Interval（行715-766）
    │      ├─ EXEC CICS READQ TS ... 前回時刻読み取り
    │      ├─ EXEC CICS DELETEQ TS ... 既存データ削除
    │      ├─ EXEC CICS WRITEQ TS ... 新規時刻書き込み
    │      └─ EXEC CICS START TRANSID('SSST') ... 次回起動スケジュール
    │
    ├─ EXEC CICS QUERY COUNTER ... カウンター値取得（36回繰り返し）
    │      └─ Pool: GENA
    │
    ├─ Tran-Rate-Counts（行769-802）×複数回
    │      ├─ EXEC CICS READQ TS ... 前回値読み取り
    │      ├─ EXEC CICS DELETEQ TS ... 既存データ削除
    │      └─ EXEC CICS WRITEQ TS ... 新規値・差分値書き込み
    │
    └─ EXEC CICS RETURN
```

### データフロー図

```
[入力]                      [処理]                           [出力]

Named Counter Server        LGWEBST5
  │                           │
  │ GENACUSTNUMカウンター ──▶ │
  │ GENA01ICUS00/99 ────────▶ │ ─▶ CountSuccess累積加算
  │ GENA01ACUS00/99 ────────▶ │ ─▶ CountErrors累積加算
  │ GENA01IMOT00/99 ────────▶ │ ─▶ CountInq/Add/Upd/Del集計
  │ ... (36カウンター) ─────▶ │
  │                           │
  │                           │                               TSQ: GENASTAT
  │                           │ ─▶ 時間間隔情報 ─────────────▶ GENA000V
  │                           │ ─▶ カウンター値 ─────────────▶ GENA100V〜
  │                           │ ─▶ 前回値 ──────────────────▶ (Item 2)
  │                           │ ─▶ 差分値 ──────────────────▶ (Item 3)

自動起動: EXEC CICS START TRANSID('SSST') AFTER MINUTES(1)
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| lgwebst5.cbl | `base/src/lgwebst5.cbl` | ソース | トランザクション統計収集プログラム（803行） |
| lgsetup.cbl | `base/src/lgsetup.cbl` | ソース | カウンター初期化プログラム（統計カウンターも初期化） |
