# 帳票設計書 2-システムエラーログ

## 概要

本ドキュメントは、GENAPP保険アプリケーションにおけるシステムエラーログの設計仕様を定義するものである。LGSTSQプログラムにより、DB2エラー等のシステムエラーメッセージをTDQ(Transient Data Queue)であるCSMTおよびTSQ(Temporary Storage Queue)であるGENAERRSの2箇所に同時出力するログ形式の帳票である。

### 本帳票の処理概要

**業務上の目的・背景**：本帳票は、保険業務システムで発生するDB2データベースエラーやその他のシステムエラーを記録するために必要である。エラー発生時に即座にログを記録することで、システム障害の原因究明、運用監視、デバッグ作業を支援する。TDQ(CSMT)への出力により従来のCICSログとの統合が可能であり、TSQ(GENAERRS)への出力によりアプリケーション固有のエラー履歴管理が実現される。

**帳票の利用シーン**：システム障害発生時の原因調査、DB2接続エラーの監視、アプリケーションデバッグ、運用監視コンソールでのエラー通知確認、定期的なエラーログレビューに利用される。

**主要な出力内容**：
1. システムID（SYSID）- エラー発生元のCICSシステム識別子
2. エラーメッセージ本文（最大90バイト）
3. 呼び出し元プログラム情報（LINK経由の場合）

**帳票の出力タイミング**：エラー発生時にリアルタイムで出力される。他プログラムからのLINK呼び出し、またはトランザクション直接実行時にエラーメッセージを受け取り、即座にログ出力を行う。

**帳票の利用者**：システム運用管理者、インフラ担当者、アプリケーション開発者、障害対応チーム

## 帳票種別

エラーログ / システムログ

## 利用画面

| 画面No | 画面名 | URL/ルーティング | 出力操作 |
|--------|--------|-----------------|---------|
| - | なし（バックグラウンド処理） | EXEC CICS LINK / トランザクション実行 | 自動出力 |

## 出力形式

### 基本仕様

| 項目 | 内容 |
|-----|------|
| ファイル形式 | TDQ（Transient Data Queue）+ TSQ（Temporary Storage Queue） |
| 用紙サイズ | N/A（電子データ） |
| 向き | N/A |
| ファイル名 | CSMT（TDQ）、GENAERRS（TSQ） |
| 出力方法 | CICS TDQ/TSQへの書き込み |
| 文字コード | EBCDIC |

### TDQ固有設定

| 項目 | 内容 |
|-----|------|
| キュー名 | CSMT |
| キュータイプ | Transient Data Queue（一時データキュー） |
| 用途 | CICSシステムメッセージログ |

### TSQ固有設定

| 項目 | 内容 |
|-----|------|
| キュー名 | GENAERRS（デフォルト）またはGENA+4文字（Q=nnnn指定時） |
| 共有設定 | Coupling Facility経由で共有可能 |
| NOSUSPEND | 有効（領域不足時に待機しない） |

## 帳票レイアウト

### レイアウト概要

エラーメッセージは固定長フォーマットで出力される。

```
┌─────────────────────────────────────────────────────────────────┐
│  SYSID  │ 空白 │         エラーメッセージ本文（90バイト）        │
│ (4バイト)│(1バイト)│                                            │
└─────────────────────────────────────────────────────────────────┘
```

### 出力項目詳細

| No | 項目名 | 開始位置 | 長さ | 説明 | データ形式 |
|----|-------|---------|------|------|-----------|
| 1 | WRITE-MSG-SYSID | 1 | 4 | CICSシステムID | PIC X(4) |
| 2 | FILLER-X | 5 | 1 | 区切り空白 | PIC X |
| 3 | WRITE-MSG-MSG | 6 | 90 | エラーメッセージ本文 | PIC X(90) |

### 入力パラメータ形式

#### LINK呼び出し時（COMMAREA経由）

| No | 項目名 | 長さ | 説明 |
|----|-------|------|------|
| 1 | COMMA-DATA | 90 | エラーメッセージ本文 |

#### トランザクション直接実行時（RECEIVE経由）

| No | 項目名 | 長さ | 説明 |
|----|-------|------|------|
| 1 | WS-RECV-TRANID | 5 | トランザクションID |
| 2 | WS-RECV-DATA | 74 | エラーメッセージ本文 |

### キュー名カスタマイズ機能

メッセージ先頭が「Q=nnnn」で始まる場合、TSQキュー名をGENAnnnnに変更可能。

| パターン | TSQキュー名 | 備考 |
|---------|------------|------|
| Q=nnnnメッセージ本文 | GENAnnnn | nnnnは4文字の任意の識別子 |
| 通常メッセージ | GENAERRS | デフォルトキュー名 |

## 出力条件

### 抽出条件

| 条件名 | 説明 | 必須 |
|-------|------|-----|
| エラーメッセージ | 空でないメッセージが渡されること | Yes |

### ソート順

| 優先度 | 項目 | 昇順/降順 |
|-------|------|---------|
| N/A | 到着順（時系列） | - |

### 改ページ条件

N/A（ログ出力のため改ページ概念なし）

## データベース参照仕様

### 参照テーブル一覧

| テーブル名 | 用途 | 結合条件 |
|-----------|------|---------|
| N/A | 本帳票はデータベースを参照しない | - |

## 計算仕様

### 計算項目一覧

| 項目名 | 計算式 | 端数処理 | 備考 |
|-------|-------|---------|------|
| WS-RECV-LEN（調整） | EIBCALEN（LINK時）または受信長-5（トランザクション時） | N/A | メッセージ長調整 |
| Q=指定時の長さ調整 | WS-RECV-LEN - 7 | N/A | Q=nnnn部分を除外 |

## 処理フロー

### 出力フロー

```mermaid
flowchart TD
    A[プログラム開始] --> B[変数初期化]
    B --> C[SYSID取得 CICS ASSIGN]
    C --> D[呼び出し元プログラム取得]
    D --> E{LINK呼び出し?}
    E -->|Yes| F[COMMAREA からメッセージ取得]
    E -->|No| G[RECEIVE でメッセージ取得]
    F --> H[WS-FLAG = 'C']
    G --> I[WS-FLAG = 'R']
    H --> J[メッセージ長設定]
    I --> J
    J --> K{Q=nnnn指定?}
    K -->|Yes| L[TSQキュー名変更]
    K -->|No| M[GENAERRS使用]
    L --> N[メッセージ長調整]
    N --> O[TDQ CSMTへ書き込み]
    M --> O
    O --> P[TSQへ書き込み NOSUSPEND]
    P --> Q{WS-FLAG = 'R'?}
    Q -->|Yes| R[画面クリア SEND TEXT]
    Q -->|No| S[CICS RETURN]
    R --> S
```

## エラー処理

### エラーケース一覧

| エラー種別 | 発生条件 | 表示メッセージ | 対処方法 |
|----------|---------|--------------|---------|
| TDQ書き込み失敗 | CSMTキューが利用不可 | WS-RESP に非正常値 | 処理継続（エラーは無視） |
| TSQ書き込み失敗 | TSQ領域不足 | WS-RESP に非正常値 | 処理継続（NOSUSPEND指定により待機しない） |
| SYSID取得失敗 | CICS ASSIGN 失敗 | WS-RESP に非正常値 | 処理継続 |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定データ件数 | エラー発生頻度に依存 |
| 目標出力時間 | 即時（同期処理） |
| 同時出力数上限 | 制限なし（マルチスレッド対応） |

## セキュリティ考慮事項

- エラーログには機密情報が含まれる可能性があるため、TSQ/TDQへのアクセス権限はシステム管理者に限定することを推奨
- CSMTはCICS標準のシステムログキューであり、CICS標準のセキュリティ設定が適用される
- GENAERRSへのアクセスはアプリケーション固有の権限設定が必要

## 備考

- 本プログラム（LGSTSQ）は運用監視・デバッグ目的で設計されている
- CSMT（TDQ）とGENAERRS（TSQ）の2箇所に同時出力することで、CICS標準ログとアプリケーション固有ログの両方を記録
- Q=nnnnパラメータによりキュー名のカスタマイズが可能（テスト用途等）
- LINK呼び出しとトランザクション直接実行の両方に対応
- トランザクション直接実行時は画面クリア処理（SEND TEXT）を実行

---

## コードリーディングガイド

本帳票を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

まず、メッセージ構造と入力パラメータの定義を理解することが重要である。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | lgstsq.cbl | `base/src/lgstsq.cbl` | WORKING-STORAGE SECTION（行15-40）でメッセージ構造とキュー名を確認 |

**主要データ構造**:
- **WRITE-MSG（行25-28）**: 出力メッセージ構造
  - WRITE-MSG-SYSID: CICSシステムID（4バイト）
  - FILLER-X: 区切り空白（1バイト）
  - WRITE-MSG-MSG: エラーメッセージ本文（90バイト）
- **WS-RECV（行20-22）**: トランザクション直接実行時の入力
  - WS-RECV-TRANID: トランザクションID（5バイト）
  - WS-RECV-DATA: メッセージ本文（74バイト）
- **STSQ（行33-37）**: TSQキュー名（デフォルト: GENAERRS）
- **STDQ-NAME（行40）**: TDQキュー名（固定: CSMT）

**読解のコツ**: REDEFINESは同一メモリ領域を別の構造で参照する機能。行29-32でWRITE-MSGを再定義してQ=nnnn部分を除外した構造を定義している。

#### Step 2: 呼び出し元判定処理を理解する

LINK呼び出しとトランザクション直接実行の判定ロジックを理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | lgstsq.cbl | `base/src/lgstsq.cbl` | MAINLINE SECTION（行55）から処理開始。ASSIGN INVOKINGPROG（行64-66）で呼び出し元プログラムを取得し、WS-FLAGで判定を行う |

**主要処理フロー**:
1. **行57-58**: 変数初期化
2. **行60-62**: SYSID取得（EXEC CICS ASSIGN SYSID）
3. **行64-66**: 呼び出し元プログラム取得（EXEC CICS ASSIGN INVOKINGPROG）
4. **行68-80**: 呼び出し元判定
   - WS-INVOKEPROG ≠ Spaces: LINK呼び出し（WS-FLAG='C'）→ COMMエリアからメッセージ取得
   - WS-INVOKEPROG = Spaces: 直接実行（WS-FLAG='R'）→ RECEIVE経由でメッセージ取得

#### Step 3: キュー名カスタマイズ処理を理解する

Q=nnnnパラメータによるTSQキュー名の動的変更を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | lgstsq.cbl | `base/src/lgstsq.cbl` | 行82-88のQ=nnnn判定処理を確認 |

**キュー名変更ロジック**:
```cobol
IF WRITE-MSG-MSG(1:2) = 'Q=' THEN
   MOVE WRITE-MSG-MSG(3:4) TO STSQ-EXT  ... キュー名末尾4文字を設定
   MOVE WRITE-MSG-REST TO TEMPO         ... Q=nnnn部分を除外
   MOVE TEMPO TO WRITE-MSG-MSG          ... メッセージ本文を再設定
   SUBTRACT 7 FROM WS-RECV-LEN          ... 長さ調整
END-IF.
```

**結果**:
- 入力「Q=TESTエラーメッセージ」→ TSQキュー名「GENATEST」、メッセージ「エラーメッセージ」

#### Step 4: TDQ/TSQ書き込み処理を理解する

二重出力（TDQ CSMT + TSQ GENAERRS）のロジックを理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | lgstsq.cbl | `base/src/lgstsq.cbl` | 行92-111のTDQ/TSQ書き込み処理を確認 |

**書き込み処理**:
1. **行94-99**: TDQ書き込み（EXEC CICS WRITEQ TD QUEUE('CSMT')）
   - CICSシステムメッセージログへの出力
2. **行105-111**: TSQ書き込み（EXEC CICS WRITEQ TS QUEUE(STSQ-NAME) NOSUSPEND）
   - アプリケーション固有エラーログへの出力
   - NOSUSPEND: 領域不足時に待機しない

**後処理**（行113-122）:
- WS-FLAG='R'（直接実行時）: 画面クリア（SEND TEXT）
- CICS RETURN

### プログラム呼び出し階層図

```
LGSTSQ（システムエラーログ出力）
    │
    ├─ EXEC CICS ASSIGN SYSID ... システムID取得
    │
    ├─ EXEC CICS ASSIGN INVOKINGPROG ... 呼び出し元判定
    │
    ├─ [LINK呼び出し時]
    │      └─ COMMエリアからメッセージ取得
    │
    ├─ [直接実行時]
    │      └─ EXEC CICS RECEIVE ... メッセージ取得
    │
    ├─ [Q=nnnn判定]
    │      └─ TSQキュー名を動的変更
    │
    ├─ EXEC CICS WRITEQ TD QUEUE('CSMT') ... TDQ出力
    │
    ├─ EXEC CICS WRITEQ TS QUEUE(STSQ-NAME) NOSUSPEND ... TSQ出力
    │
    └─ EXEC CICS RETURN
```

### データフロー図

```
[入力]                      [処理]                           [出力]

他プログラム（LINK）        LGSTSQ
  │                           │
  │ COMMAREA(90バイト) ─────▶ │
  │                           │ ─▶ SYSID付加
  │                           │ ─▶ Q=nnnn判定・キュー名変更
  │                           │                               TDQ: CSMT
トランザクション直接実行      │ ────────────────────────────▶ (CICSログ)
  │                           │                               TSQ: GENAERRS
  │ RECEIVE(74バイト) ───────▶ │ ────────────────────────────▶ (アプリログ)
  │                           │
  │                           │ [直接実行時のみ]
  │ ◀─────────────────────── │ 画面クリア（SEND TEXT）

メッセージ形式:
┌──────────┬─────┬────────────────────────────────┐
│ SYSID(4) │ ' ' │ エラーメッセージ本文(90)        │
└──────────┴─────┴────────────────────────────────┘
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| lgstsq.cbl | `base/src/lgstsq.cbl` | ソース | システムエラーログ出力プログラム（127行） |
