# 帳票設計書 3-顧客番号管理レポート

## 概要

本ドキュメントは、GENAPP保険アプリケーションにおける顧客番号管理レポートの設計仕様を定義するものである。LGSETUPおよびLGTESTC1プログラムにより、顧客番号の割当範囲（LOW CUSTOMER/HIGH CUSTOMER）をTSQ(Temporary Storage Queue)であるGENACNTLに記録する管理情報帳票である。

### 本帳票の処理概要

**業務上の目的・背景**：本帳票は、保険業務システムで使用される顧客番号の割当範囲を管理するために必要である。Named Counter Serverと連携して顧客番号を一意に採番する際、現在の割当範囲（最小顧客番号・最大顧客番号）を記録することで、DB2データベースの復元時やシステム初期化時に顧客番号の整合性を維持する。また、Workload Simulator自動化テストにおける顧客番号範囲の把握にも利用される。

**帳票の利用シーン**：システム初期化時の顧客番号範囲設定、DB2データベース復元後の番号同期、新規顧客追加時の番号範囲更新、Workload Simulatorによる自動化テスト、システム状態の監査・確認に利用される。

**主要な出力内容**：
1. コントロール情報ヘッダー（「**** GENAPP CNTL」）
2. 最小顧客番号（LOW CUSTOMER=nnnnnnnnnn）
3. 最大顧客番号（HIGH CUSTOMER=nnnnnnnnnn）

**帳票の出力タイミング**：LGSETUPプログラムによるシステム初期化時、およびLGTESTC1プログラムによる新規顧客追加時に出力・更新される。

**帳票の利用者**：システム運用管理者、データベース管理者、テスト自動化チーム、アプリケーション開発者

## 帳票種別

コントロール情報 / 管理レポート

## 利用画面

| 画面No | 画面名 | URL/ルーティング | 出力操作 |
|--------|--------|-----------------|---------|
| 1 | 顧客メニュー画面 | トランザクションSSC1 | 顧客追加（オプション2）実行時に自動更新 |
| - | システム初期化 | トランザクション（LGSETUP直接） | 初期化実行時 |

## 出力形式

### 基本仕様

| 項目 | 内容 |
|-----|------|
| ファイル形式 | TSQ（CICS Temporary Storage Queue） |
| 用紙サイズ | N/A（電子データ） |
| 向き | N/A |
| ファイル名 | GENACNTL（キュー名） |
| 出力方法 | CICS TSQへの書き込み |
| 文字コード | EBCDIC |

### TSQ固有設定

| 項目 | 内容 |
|-----|------|
| キュー名 | GENACNTL |
| 共有設定 | Coupling Facility経由で共有可能 |
| 排他制御 | ENQ/DEQによるリソースロック |
| データ保持 | CICSリージョン稼働中 |

## 帳票レイアウト

### レイアウト概要

TSQ内に3つのアイテムとして管理情報を格納する。

```
┌─────────────────────────────────────┐
│  Item 1: ヘッダー情報               │
│  「**** GENAPP CNTL」（20バイト）   │
├─────────────────────────────────────┤
│  Item 2: 最小顧客番号               │
│  「LOW CUSTOMER=nnnnnnnnnn」（23バイト） │
├─────────────────────────────────────┤
│  Item 3: 最大顧客番号               │
│  「HIGH CUSTOMER=nnnnnnnnnn」（24バイト）│
└─────────────────────────────────────┘
```

### 出力項目詳細

#### Item 1: ヘッダー情報

| No | 項目名 | 長さ | 説明 | データ形式 |
|----|-------|------|------|-----------|
| 1 | WRITE-MSG-E | 20 | ヘッダー「**** GENAPP CNTL」 | PIC X(20) |

#### Item 2: 最小顧客番号

| No | 項目名 | 長さ | 説明 | データ形式 |
|----|-------|------|------|-----------|
| 1 | WRITE-MSG-L | 13 | ラベル「LOW CUSTOMER=」 | PIC X(13) |
| 2 | WRITE-MSG-LOW | 10 | 最小顧客番号 | PIC 9(10) |

#### Item 3: 最大顧客番号

| No | 項目名 | 長さ | 説明 | データ形式 |
|----|-------|------|------|-----------|
| 1 | WRITE-MSG-H | 14 | ラベル「HIGH CUSTOMER=」 | PIC X(14) |
| 2 | WRITE-MSG-HIGH | 10 | 最大顧客番号 | PIC 9(10) |

## 出力条件

### 抽出条件

| 条件名 | 説明 | 必須 |
|-------|------|-----|
| 初期化実行（LGSETUP） | システム初期化時 | Yes（初期化時） |
| 顧客追加成功（LGTESTC1） | 新規顧客追加成功時 | Yes（追加時） |

### ソート順

| 優先度 | 項目 | 昇順/降順 |
|-------|------|---------|
| N/A | TSQアイテム番号順（固定） | - |

### 改ページ条件

N/A（TSQ出力のため改ページ概念なし）

## データベース参照仕様

### 参照テーブル一覧

| テーブル名 | 用途 | 結合条件 |
|-----------|------|---------|
| N/A | 本帳票はデータベースを直接参照しない | - |

### Named Counter Server連携仕様

#### LGSETUP プログラム

| 操作 | カウンター名 | プール名 | 説明 |
|-----|-------------|---------|------|
| DELETE | GENACUSTNUM | GENA | 既存カウンター削除 |
| DEFINE | GENACUSTNUM | GENA | 新規カウンター定義（初期値=LastCustNum） |

#### 統計カウンターの初期化（LGSETUP）

LGSETUPでは顧客番号カウンターに加え、全統計カウンター（36種類）も初期化される。

## 計算仕様

### 計算項目一覧

| 項目名 | 計算式 | 端数処理 | 備考 |
|-------|-------|---------|------|
| FrstCustNum | 固定値 0000001 | N/A | 最小顧客番号初期値 |
| LastCustNum | 入力パラメータまたはデフォルト 0000011 | N/A | 最大顧客番号初期値 |

## 処理フロー

### LGSETUP 初期化フロー

```mermaid
flowchart TD
    A[トランザクション開始] --> B[パラメータ受信 CICS RECEIVE]
    B --> C{パラメータあり?}
    C -->|Yes| D[LastCustNumを設定]
    C -->|No| E[デフォルト値使用 0000011]
    D --> F[TSQ削除処理]
    E --> F
    F --> G[GENAERRS削除]
    G --> H[GENASTRT削除]
    H --> I[GENASTAT削除]
    I --> J[GENACNTL削除]
    J --> K[TSQ書き込み - ヘッダー]
    K --> L[TSQ書き込み - LOW CUSTOMER]
    L --> M[TSQ書き込み - HIGH CUSTOMER]
    M --> N[Named Counter初期化]
    N --> O[GENACUSTNUMカウンター再定義]
    O --> P[統計カウンター初期化（36種類）]
    P --> Q[画面表示 SEND TEXT]
    Q --> R[CICS RETURN]
```

### LGTESTC1 顧客追加時更新フロー

```mermaid
flowchart TD
    A[顧客追加成功] --> B[WRITE-GENACNTL呼び出し]
    B --> C[ENQ リソースロック取得]
    C --> D[TSQ読み取り Item 1]
    D --> E{正常読み取り?}
    E -->|Yes| F[HIGH CUSTOMER検索ループ]
    E -->|No| G[新規TSQ作成]
    F --> H{HIGH CUSTOMER発見?}
    H -->|Yes| I[REWRITE - 番号更新]
    H -->|No| J[ループ継続/終了]
    I --> K[DEQ リソースロック解放]
    G --> L[WriteQ - ヘッダー]
    L --> M[WriteQ - LOW CUSTOMER]
    M --> N[WriteQ - HIGH CUSTOMER]
    N --> K
    J --> K
```

## エラー処理

### エラーケース一覧

| エラー種別 | 発生条件 | 表示メッセージ | 対処方法 |
|----------|---------|--------------|---------|
| TSQ読み取り失敗 | 初回実行時などTSQが存在しない | WS-RESP に非正常値 | 新規TSQ作成処理へ分岐 |
| TSQ書き込み失敗 | TSQ領域不足 | WS-RESP に非正常値 | 処理継続（NOSUSPEND指定） |
| Named Counter操作失敗 | カウンターサーバー接続エラー | WS-RESP に非正常値 | 処理継続 |
| ENQ/DEQ失敗 | リソースロック取得失敗 | N/A | 処理継続 |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定データ件数 | 3アイテム（固定） |
| 目標出力時間 | 即時 |
| 同時出力数上限 | 1（ENQ/DEQによる排他制御） |

## セキュリティ考慮事項

- 顧客番号範囲情報は機密性が低いが、不正な変更を防ぐためアクセス権限を制限することを推奨
- ENQ/DEQによる排他制御により、同時更新による不整合を防止
- TSQはCoupling Facility経由で共有可能だが、同一Sysplexに限定

## 備考

- 本帳票はNamed Counter Serverと連携して顧客番号の一意性を保証するための管理情報
- Workload Simulator自動化テスト用途として設計されている
- LGSETUPはシステム初期化プログラムとして、全TSQ（GENAERRS, GENASTRT, GENASTAT, GENACNTL）と全統計カウンターを初期化する
- LGTESTC1は顧客メニュー画面のプログラムで、顧客追加成功時にGENACNTLを更新する
- TSQ操作時はENQ/DEQによるリソースロックで排他制御を行う
- 通常はNamed Counter ServerまたはDB2の機能で顧客番号を採番するが、本TSQはWorkload Simulatorとの連携用に提供されている

---

## コードリーディングガイド

本帳票を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。本帳票はLGSETUPプログラム（初期化時）とLGTESTC1プログラム（顧客追加時）の2つから出力される。

### 推奨読解順序

#### Step 1: データ構造を理解する

まず、TSQに出力されるデータ構造を理解することが重要である。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | lgsetup.cbl | `base/src/lgsetup.cbl` | WORKING-STORAGE SECTION（行18-109）でWRITE-MSG構造体とカウンター名を確認 |

**主要データ構造**（lgsetup.cbl 行43-50）:
```cobol
01  WRITE-MSG.
  03 WRITE-MSG-E            PIC X(20) Value '**** GENAPP CNTL'.
  03 WRITE-MSG-L            PIC X(13) Value 'LOW CUSTOMER='.
  03 WRITE-MSG-LOW          PIC 9(10).
  03 FILLER                 PIC X.
  03 WRITE-MSG-H            PIC X(14) Value 'HIGH CUSTOMER='.
  03 WRITE-MSG-High         PIC 9(10).
```

**TSQ出力構造**:
- Item 1: ヘッダー「**** GENAPP CNTL」（20バイト）
- Item 2: 「LOW CUSTOMER=nnnnnnnnnn」（23バイト）
- Item 3: 「HIGH CUSTOMER=nnnnnnnnnn」（24バイト）

**読解のコツ**: PIC 9(10)は10桁の数値型を表す。FILLERは名前のない予備領域で、構造体のパディングに使用される。

#### Step 2: LGSETUP初期化処理を理解する

システム初期化時のTSQ作成とNamed Counter初期化を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | lgsetup.cbl | `base/src/lgsetup.cbl` | MAINLINE SECTION（行126）から処理開始。パラメータ受信、TSQ削除・作成、Named Counter初期化の流れを確認 |

**主要処理フロー**:
1. **行128-135**: パラメータ受信（EXEC CICS RECEIVE）、LastCustNum設定
2. **行138-152**: 既存TSQ削除
   - GENAERRS（エラーログ）
   - GENASTRT（開始情報）
   - GENASTAT（統計情報）
   - GENACNTL（顧客番号管理）
3. **行154-176**: GENACNTL TSQへの書き込み
   - Item 1: ヘッダー（行157-162）
   - Item 2: LOW CUSTOMER（行164-169）
   - Item 3: HIGH CUSTOMER（行171-176）
4. **行179-187**: GENACUSTNUMカウンター初期化
   - DELETE COUNTER（行179-182）
   - DEFINE COUNTER（行183-187）
5. **行189-516**: 統計カウンター（36種類）の初期化

#### Step 3: LGTESTC1顧客追加時更新処理を理解する

顧客追加成功時のGENACNTL更新処理を理解する（LGTESTC1内のWRITE-GENACNTLセクション）。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | lgtestc1.cbl | `base/src/lgtestc1.cbl` | WRITE-GENACNTLセクションを確認。ENQ/DEQによる排他制御とREWRITEによる更新を理解する |

**WRITE-GENACNTL処理パターン**:
1. **ENQ**: リソースロック取得（EXEC CICS ENQ RESOURCE(STSQ-NAME)）
2. **ReadQ TS**: 既存TSQの読み取り（Item 1から順次）
3. **ループ処理**: 「HIGH CUSTOMER=」を含むItemを検索
4. **REWRITE**: HIGH CUSTOMERの値を更新
5. **DEQ**: リソースロック解放

**新規TSQ作成時**（TSQが存在しない場合）:
- Item 1〜3を新規に書き込み

#### Step 4: Named Counter連携を理解する

GENACUSTNUMカウンターの操作を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | lgsetup.cbl | `base/src/lgsetup.cbl` | 行179-187のNamed Counter操作を確認 |

**Named Counter操作パターン**:
```cobol
* 既存カウンター削除
Exec CICS Delete Counter(GENAcount)
             Pool(GENApool)
             Resp(WS-RESP)
End-Exec.
* 新規カウンター定義
Exec CICS Define Counter(GENAcount)
             Pool(GENApool)
             Value(LastCustNum)
             Resp(WS-RESP)
End-Exec.
```

### プログラム呼び出し階層図

```
[初期化時: LGSETUP]
    │
    ├─ EXEC CICS RECEIVE ... パラメータ取得
    │
    ├─ EXEC CICS DELETEQ TS ... TSQ削除（4種類）
    │      ├─ GENAERRS
    │      ├─ GENASTRT
    │      ├─ GENASTAT
    │      └─ GENACNTL
    │
    ├─ EXEC CICS WRITEQ TS QUEUE('GENACNTL') ... TSQ書き込み
    │      ├─ Item 1: ヘッダー
    │      ├─ Item 2: LOW CUSTOMER
    │      └─ Item 3: HIGH CUSTOMER
    │
    ├─ EXEC CICS DELETE/DEFINE COUNTER ... GENACUSTNUMカウンター初期化
    │
    ├─ 統計カウンター初期化（36種類）
    │
    └─ EXEC CICS RETURN

[顧客追加時: LGTESTC1 → WRITE-GENACNTL]
    │
    ├─ EXEC CICS ENQ ... リソースロック取得
    │
    ├─ EXEC CICS READQ TS ... 既存TSQ読み取り
    │
    ├─ HIGH CUSTOMER検索ループ
    │
    ├─ EXEC CICS REWRITE ... HIGH CUSTOMER更新
    │      または
    │      EXEC CICS WRITEQ TS ... 新規TSQ作成
    │
    └─ EXEC CICS DEQ ... リソースロック解放
```

### データフロー図

```
[初期化時: LGSETUP]

[入力]                      [処理]                           [出力]

パラメータ（顧客番号上限）   LGSETUP
  │                           │
  │ LastCustNum ─────────────▶ │
  │                           │                               TSQ: GENACNTL
  │                           │ ─▶ 既存TSQ削除               Item 1: ヘッダー
  │                           │ ─▶ TSQ新規作成 ─────────────▶ Item 2: LOW CUSTOMER
  │                           │                               Item 3: HIGH CUSTOMER
  │                           │
  │                           │                               Named Counter Server
  │                           │ ─▶ GENACUSTNUM再定義 ───────▶ Pool: GENA

[顧客追加時: LGTESTC1]

顧客追加成功                 LGTESTC1
  │                           │
  │ 新顧客番号 ──────────────▶ │ WRITE-GENACNTL呼び出し
  │                           │
  │                           │                               TSQ: GENACNTL
  │                           │ ─▶ ENQ(排他ロック)
  │                           │ ─▶ ReadQ/検索
  │                           │ ─▶ REWRITE ────────────────▶ Item 3: HIGH CUSTOMER更新
  │                           │ ─▶ DEQ(ロック解放)
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| lgsetup.cbl | `base/src/lgsetup.cbl` | ソース | システム初期化プログラム（534行） |
| lgtestc1.cbl | `base/src/lgtestc1.cbl` | ソース | 顧客メニュープログラム（WRITE-GENACNTLセクション含む） |
