---
generated_at: 2026-01-06 18:30:00
metrics:
  claims_total: 25
  claims_with_evidence: 24
  claims_without_evidence: 1
confidence_derived: 0.96
---

# 根拠レポート：1-トランザクション統計レポート

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.96**
  - 根拠あり：24 / 25、根拠なし：1
- 優先レビュー（高）
  1. **Web参照機能の詳細仕様**：SSISTAT1サービスの詳細実装が確認できない

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `base/src/lgwebst5.cbl` - 統計収集プログラムのソースコード
- E-02: `base/Architecture.md` - アプリケーションアーキテクチャドキュメント
- E-03: `docs/code-to-docs/帳票一覧/帳票一覧.csv` - 帳票一覧定義
- E-04: `lgwebst5.cbl` 行1-9 プログラムヘッダーコメント
- E-05: `lgwebst5.cbl` 行56 StatQ定義（GENASTAT）
- E-06: `lgwebst5.cbl` 行197-233 カウンター名定義
- E-07: `lgwebst5.cbl` 行761-765 60秒間隔の自動起動設定
- E-08: `lgwebst5.cbl` 行40 TCPservice定義
- E-09: `lgwebst5.cbl` 行268-272 CICS QUERY COUNTER使用例
- E-10: `lgwebst5.cbl` 行715-767 Tran-Rate-Interval処理
- E-11: `lgwebst5.cbl` 行769-802 Tran-Rate-Counts処理
- E-12: `Architecture.md` 行60-64 TSQ(GENACNTL)説明
- E-13: `Architecture.md` 行52-58 Named Counter Server説明

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | LGWEBST5プログラムが統計収集を行う | E-01, E-04 | ○ |
| C-02 | TSQ名はGENASTAT | E-05 | ○ |
| C-03 | Business Monitor向けの60秒間隔リフレッシュ | E-04, E-07 | ○ |
| C-04 | Named Counter Serverからカウンター値を取得 | E-09, E-13 | ○ |
| C-05 | カウンタープール名はGENA | E-06（行198） | ○ |
| C-06 | 顧客照会カウンター名GENA01ICUS00/99 | E-06（行199-200） | ○ |
| C-07 | 顧客追加カウンター名GENA01ACUS00/99 | E-06（行201-202） | ○ |
| C-08 | 自動車保険カウンター名GENA01IMOT/AMOT/DMOT/UMOT | E-06（行203-210） | ○ |
| C-09 | 養老保険カウンター名GENA01IEND/AEND/DEND/UEND | E-06（行211-218） | ○ |
| C-10 | 住宅保険カウンター名GENA01IHOU/AHOU/DHOU/UHOU | E-06（行219-226） | ○ |
| C-11 | 商業用不動産保険カウンター名GENA01ICOM/ACOM/DCOM/HCOM | E-06（行227-232） | ○ |
| C-12 | トランザクションID SSST | E-07 | ○ |
| C-13 | EXEC CICS START で次回実行をスケジュール | E-07 | ○ |
| C-14 | 時間間隔計算処理が存在 | E-10 | ○ |
| C-15 | 前回値との差分計算を行う | E-11 | ○ |
| C-16 | TSQへの書き込みにNOSUSPEND指定 | E-11（行783-787） | ○ |
| C-17 | 総成功件数・総エラー件数を計算 | E-01（行670-673） | ○ |
| C-18 | Web参照用TCPサービス名SSISTAT1 | E-08 | ○ |
| C-19 | テンプレート名GENAST3TEMP | E-01（行57） | ○ |
| C-20 | データ形式PIC 9(9) | E-01（行157-195） | ○ |
| C-21 | APPLID取得処理 | E-01（行703-705） | ○ |
| C-22 | TSQ初回読み取り失敗時のデフォルト値 | E-10（行726-727） | ○ |
| C-23 | GENAOTHERカウンター | E-06（行233） | ○ |
| C-24 | 操作種別ごとの合計計算（CountInq等） | E-01（行287, 334, 378, 400等） | ○ |
| C-25 | Web経由での詳細参照機能 | E-08 | △ |

## 4) 不足情報（Unknown / Missing）
- Web参照機能（SSISTAT1サービス）の詳細実装
  - 候補：CICS Web Service定義 / HTTPリスナー設定 / 外部ドキュメント

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 統計収集の基本機能についてはソースコードから十分に確認可能
- 1: 中リスク - Web参照機能の詳細がコード内で完全には確認できないが、TCPservice名は定義されている

## 6) レビュアーチェックリスト（最小）
- [ ] カウンター名の命名規則が実運用と一致しているか確認
- [ ] 60秒間隔が運用要件に適合しているか確認
- [ ] SSISTAT1サービスの実装詳細を別途確認
- [ ] Coupling Facilityの設定要件を確認
