---
generated_at: 2026-01-06 18:35:00
metrics:
  claims_total: 22
  claims_with_evidence: 22
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：2-システムエラーログ

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：22 / 22、根拠なし：0
- 優先レビュー（高）
  1. 該当なし - 全ての主張に根拠が確認できました

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `base/src/lgstsq.cbl` - エラーログ出力プログラムのソースコード
- E-02: `base/Architecture.md` - アプリケーションアーキテクチャドキュメント
- E-03: `docs/code-to-docs/帳票一覧/帳票一覧.csv` - 帳票一覧定義
- E-04: `lgstsq.cbl` 行1-8 プログラムヘッダーコメント
- E-05: `lgstsq.cbl` 行33-38 STSQ-NAME定義（GENAERRS）
- E-06: `lgstsq.cbl` 行40 STDQ-NAME定義（CSMT）
- E-07: `lgstsq.cbl` 行25-32 WRITE-MSG構造体定義
- E-08: `lgstsq.cbl` 行60-66 SYSID/INVOKINGPROG取得
- E-09: `lgstsq.cbl` 行68-80 LINK/RECEIVE判定処理
- E-10: `lgstsq.cbl` 行82-88 Q=nnnnパラメータ処理
- E-11: `lgstsq.cbl` 行94-99 TDQ CSMT書き込み
- E-12: `lgstsq.cbl` 行105-111 TSQ書き込み（NOSUSPEND）
- E-13: `lgstsq.cbl` 行113-119 画面クリア処理
- E-14: `Architecture.md` 行66-69 TSQ(GENAERRS)説明

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | LGSTSQプログラムがエラーログ出力を行う | E-01, E-04 | ○ |
| C-02 | デフォルトTSQキュー名はGENAERRS | E-05 | ○ |
| C-03 | TDQキュー名はCSMT | E-06 | ○ |
| C-04 | Q=nnnnパラメータでキュー名変更可能 | E-04, E-10 | ○ |
| C-05 | WRITE-MSG構造体は95バイト（SYSID 4 + FILLER 1 + MSG 90） | E-07 | ○ |
| C-06 | CICS ASSIGN SYSIDでシステムID取得 | E-08（行60-62） | ○ |
| C-07 | CICS ASSIGN INVOKINGPROGで呼び出し元取得 | E-08（行64-66） | ○ |
| C-08 | LINK呼び出し時はCOMMAREAからメッセージ取得 | E-09（行68-71） | ○ |
| C-09 | トランザクション実行時はRECEIVEでメッセージ取得 | E-09（行73-79） | ○ |
| C-10 | WS-FLAGで呼び出し方式を識別（C/R） | E-09 | ○ |
| C-11 | Q=指定時にキュー名の後半4文字を変更 | E-10（行83-88） | ○ |
| C-12 | WRITEQ TD でCSMTに書き込み | E-11 | ○ |
| C-13 | WRITEQ TS でGENAERRSに書き込み | E-12 | ○ |
| C-14 | TSQ書き込みにNOSUSPEND指定 | E-12（行108） | ○ |
| C-15 | トランザクション実行時は画面クリア（SEND TEXT）を実行 | E-13 | ○ |
| C-16 | COMMAREA定義は90バイト | E-01（行47-48） | ○ |
| C-17 | WS-RECV定義は80バイト（TRANID 5 + DATA 74 + 予備1） | E-01（行20-23） | ○ |
| C-18 | Q=指定時にメッセージ長を7減算 | E-10（行87） | ○ |
| C-19 | DB2エラー等のシステムエラーを記録 | E-03, E-14 | ○ |
| C-20 | 運用監視・デバッグ目的 | E-03, E-14 | ○ |
| C-21 | CSMTとGENAERRSの2箇所に同時出力 | E-03, E-11, E-12 | ○ |
| C-22 | Using a temporary storage queue（エラー用）は best practiceではない | E-14 | ○ |

## 4) 不足情報（Unknown / Missing）
- 特になし。ソースコードから全ての仕様が確認できました。

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全ての主張がソースコードおよびアーキテクチャドキュメントから確認可能

## 6) レビュアーチェックリスト（最小）
- [ ] CSMTキューがCICSシステムで適切に定義されているか確認
- [ ] GENAERRSキューのサイズ・保持期間が運用要件に適合しているか確認
- [ ] エラーログに機密情報が含まれないことを確認
- [ ] Q=パラメータの使用ケースを運用チームと確認
