---
generated_at: 2026-01-06 18:40:00
metrics:
  claims_total: 28
  claims_with_evidence: 28
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：3-顧客番号管理レポート

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：28 / 28、根拠なし：0
- 優先レビュー（高）
  1. 該当なし - 全ての主張に根拠が確認できました

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `base/src/lgsetup.cbl` - システム初期化プログラムのソースコード
- E-02: `base/src/lgtestc1.cbl` - 顧客メニュープログラムのソースコード
- E-03: `base/Architecture.md` - アプリケーションアーキテクチャドキュメント
- E-04: `docs/code-to-docs/帳票一覧/帳票一覧.csv` - 帳票一覧定義
- E-05: `lgsetup.cbl` 行1-11 プログラムヘッダーコメント
- E-06: `lgsetup.cbl` 行96 STSQ-NAME定義（GENACNTL）
- E-07: `lgsetup.cbl` 行43-50 WRITE-MSG構造体定義
- E-08: `lgsetup.cbl` 行52-55 FrstCustNum/LastCustNum定義
- E-09: `lgsetup.cbl` 行137-152 TSQ削除処理
- E-10: `lgsetup.cbl` 行157-176 TSQ書き込み処理
- E-11: `lgsetup.cbl` 行179-187 Named Counter初期化
- E-12: `lgsetup.cbl` 行189-516 統計カウンター初期化
- E-13: `lgtestc1.cbl` 行37-38 STSQ-NAME定義
- E-14: `lgtestc1.cbl` 行137 WRITE-GENACNTL呼び出し
- E-15: `lgtestc1.cbl` 行283-346 WRITE-GENACNTL処理
- E-16: `lgtestc1.cbl` 行285-287 ENQリソースロック
- E-17: `lgtestc1.cbl` 行343-345 DEQリソースロック解放
- E-18: `Architecture.md` 行60-64 TSQ(GENACNTL)説明

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | LGSETUPプログラムが初期化を行う | E-01, E-05 | ○ |
| C-02 | LGTESTC1プログラムが顧客追加時に更新を行う | E-02, E-14 | ○ |
| C-03 | TSQキュー名はGENACNTL | E-06, E-13 | ○ |
| C-04 | ヘッダー情報「**** GENAPP CNTL」20バイト | E-07（行44） | ○ |
| C-05 | LOW CUSTOMER ラベル13バイト | E-07（行45） | ○ |
| C-06 | HIGH CUSTOMER ラベル14バイト | E-07（行48） | ○ |
| C-07 | 顧客番号は10桁 PIC 9(10) | E-07（行46, 49） | ○ |
| C-08 | FrstCustNum初期値0000001 | E-08（行52） | ○ |
| C-09 | LastCustNum初期値0000011 | E-08（行53） | ○ |
| C-10 | パラメータでLastCustNum設定可能 | E-01（行132-135） | ○ |
| C-11 | GENAERRS TSQ削除 | E-09（行138-140） | ○ |
| C-12 | GENASTRT TSQ削除 | E-09（行142-144） | ○ |
| C-13 | GENASTAT TSQ削除 | E-09（行146-148） | ○ |
| C-14 | GENACNTL TSQ削除 | E-09（行150-152） | ○ |
| C-15 | TSQ書き込み - ヘッダー20バイト | E-10（行157-162） | ○ |
| C-16 | TSQ書き込み - LOW CUSTOMER 23バイト | E-10（行164-169） | ○ |
| C-17 | TSQ書き込み - HIGH CUSTOMER 24バイト | E-10（行171-176） | ○ |
| C-18 | NOSUSPEND指定あり | E-10（行160, 167, 174） | ○ |
| C-19 | GENACUSTNUM カウンター削除・再定義 | E-11 | ○ |
| C-20 | GENAプール使用 | E-11（行180, 184） | ○ |
| C-21 | 統計カウンター36種類の初期化 | E-12 | ○ |
| C-22 | LGTESTC1でENQリソースロック | E-16 | ○ |
| C-23 | LGTESTC1でDEQリソースロック解放 | E-17 | ○ |
| C-24 | HIGH CUSTOMER検索ループ | E-15（行296-316） | ○ |
| C-25 | REWRITE で番号更新 | E-15（行307-313） | ○ |
| C-26 | TSQが存在しない場合は新規作成 | E-15（行320-341） | ○ |
| C-27 | Workload Simulator自動化用 | E-04, E-18 | ○ |
| C-28 | Named Counter Serverと連携 | E-04, E-11, E-03 | ○ |

## 4) 不足情報（Unknown / Missing）
- 特になし。ソースコードおよびアーキテクチャドキュメントから全ての仕様が確認できました。

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全ての主張がソースコードおよびアーキテクチャドキュメントから確認可能

## 6) レビュアーチェックリスト（最小）
- [ ] GENACNTL TSQのサイズ・保持期間が運用要件に適合しているか確認
- [ ] Named Counter Serverの設定がアプリケーション要件と一致しているか確認
- [ ] 初期値（FrstCustNum/LastCustNum）がDB2データベースと整合しているか確認
- [ ] ENQ/DEQのタイムアウト設定が適切か確認
- [ ] 複数リージョン構成時のCoupling Facility設定を確認
