# 業務要件一覧 根拠レポート

## 1. 概要

本レポートは、CICS GenApp（General Insurance Application）プロジェクトから抽出した業務要件一覧の根拠を提供するものです。

### 1.1 対象システム
- **システム名**: General Insurance Application (GenApp)
- **プラットフォーム**: IBM CICS Transaction Server for z/OS
- **開発言語**: COBOL
- **データベース**: IBM Db2, VSAM

### 1.2 分析対象ファイル

| カテゴリ | ファイル数 | 主要ファイル |
|---------|-----------|-------------|
| COBOLソースコード | 31 | lgacus01.cbl, lgicus01.cbl, lgapol01.cbl 等 |
| コピーブック | 13 | lgcmarea.cpy, lgpolicy.cpy 等 |
| JCLジョブ | 26 | db2cre.jcl, cobol.jcl 等 |
| ドキュメント | 6 | Architecture.md, Reference.md 等 |

## 2. 要件抽出の根拠

### 2.1 顧客管理機能 (BR-001 - BR-003, BR-025, BR-028)

#### 根拠ソース

**プレゼンテーション層**
- `base/src/lgtestc1.cbl` (顧客メニュープログラム)
  - 行84-111: オプション '1' で顧客情報照会 (LGICUS01 呼び出し)
  - 行113-146: オプション '2' で顧客情報登録 (LGACUS01 呼び出し)
  - 行148-207: オプション '4' で顧客情報更新 (LGUCUS01 呼び出し)

**ビジネスロジック層**
- `base/src/lgacus01.cbl`: 顧客追加ビジネスロジック
  - 行1-9のコメント: "Business logic for adding a new customer"
  - 行119: INSERT-CUSTOMER 処理の呼び出し

- `base/src/lgicus01.cbl`: 顧客照会ビジネスロジック
  - 行1-11のコメント: "To obtain Customer's details from database"
  - 行109: GET-CUSTOMER-INFO 処理の呼び出し

- `base/src/lgucus01.cbl`: 顧客更新ビジネスロジック
  - 行1-8のコメント: "UPDATE customer details"

**データアクセス層**
- `base/src/lgacdb01.cbl`: DB2への顧客登録
  - 行199-211: Named Counter Server からの顧客番号取得
  - 行215-287: CUSTOMERテーブルへのINSERT

**データ構造**
- `base/src/lgcmarea.cpy` 行14-26: 顧客データ構造定義
  - CA-FIRST-NAME, CA-LAST-NAME, CA-DOB, CA-HOUSE-NAME 等

**ドキュメント**
- `base/Architecture.md` 行19: "Run SSC1 to inquire on existing customer records and add customer records"

### 2.2 自動車保険機能 (BR-004 - BR-007)

#### 根拠ソース

**プレゼンテーション層**
- `base/src/lgtestp1.cbl` (自動車保険メニュープログラム)
  - 行1-9のコメント: "Menu for Motor Policy Transactions"
  - 行68-95: オプション '1' で保険照会 (リクエストID: '01IMOT')
  - 行97-133: オプション '2' で保険登録 (リクエストID: '01AMOT')
  - 行135-167: オプション '3' で保険削除 (リクエストID: '01DMOT')
  - 行169-234: オプション '4' で保険更新 (リクエストID: '01UMOT')

**ビジネスロジック層**
- `base/src/lgapol01.cbl`: 保険追加ビジネスロジック
  - 行1-11のコメント: "Add Policy business logic - To add full details of an individual policy: Endowment, House, Motor, Commercial"

- `base/src/lgipol01.cbl`: 保険照会ビジネスロジック
  - 行1-10のコメント: "Business logic for policy inquire - To obtain full details of an individual policy"

- `base/src/lgdpol01.cbl`: 保険削除ビジネスロジック
  - 行119-130: リクエストID検証 ('01DEND', '01DMOT', '01DHOU', '01DCOM')

- `base/src/lgupol01.cbl`: 保険更新ビジネスロジック
  - 行113-141: リクエストID別の処理分岐 ('01UEND', '01UHOU', '01UMOT')

**データ構造**
- `base/src/lgcmarea.cpy` 行64-75: 自動車保険データ構造
  - CA-M-MAKE, CA-M-MODEL, CA-M-VALUE, CA-M-REGNUMBER 等

**ドキュメント**
- `base/Architecture.md` 行21: "Run SSP1 to create a motor insurance policy"
- `base/Reference.md` 行46-56: トランザクション一覧

### 2.3 養老保険機能 (BR-008 - BR-011)

#### 根拠ソース

**プレゼンテーション層**
- `base/src/lgtestp2.cbl` (養老保険メニュープログラム)
  - 行1-8のコメント: "Menu for Endowment Policy Transactions"
  - 行63-88: オプション '1' で保険照会 (リクエストID: '01IEND')
  - 行90-123: オプション '2' で保険登録 (リクエストID: '01AEND')
  - 行125-153: オプション '3' で保険削除 (リクエストID: '01DEND')
  - 行155-216: オプション '4' で保険更新 (リクエストID: '01UEND')

**データ構造**
- `base/src/lgcmarea.cpy` 行46-54: 養老保険データ構造
  - CA-E-WITH-PROFITS, CA-E-EQUITIES, CA-E-MANAGED-FUND, CA-E-FUND-NAME 等

**ドキュメント**
- `base/Architecture.md` 行22: "Run SSP2 to create an endowment insurance policy"

### 2.4 住宅保険機能 (BR-012 - BR-015)

#### 根拠ソース

**プレゼンテーション層**
- `base/src/lgtestp3.cbl` (住宅保険メニュープログラム)
  - 行1-8のコメント: "Menu for House Policy Transactions"
  - 行66-90: オプション '1' で保険照会 (リクエストID: '01IHOU')
  - 行92-123: オプション '2' で保険登録 (リクエストID: '01AHOU')
  - 行125-153: オプション '3' で保険削除 (リクエストID: '01DHOU')
  - 行155-214: オプション '4' で保険更新 (リクエストID: '01UHOU')

**データ構造**
- `base/src/lgcmarea.cpy` 行56-63: 住宅保険データ構造
  - CA-H-PROPERTY-TYPE, CA-H-BEDROOMS, CA-H-VALUE 等

**ドキュメント**
- `base/Architecture.md` 行23: "Run SSP3 to create a house insurance policy"

### 2.5 商業用不動産保険機能 (BR-016 - BR-018)

#### 根拠ソース

**プレゼンテーション層**
- `base/src/lgtestp4.cbl` (商業用不動産保険メニュープログラム)
  - 行1-8のコメント: "Menu for Commercial Policy Transactions"
  - 行73-154: オプション '1' で保険照会（複数の検索条件対応）
    - 行87-89: 顧客番号+保険証券番号検索 (リクエストID: '01ICOM')
    - 行97-98: 保険証券番号のみ検索 (リクエストID: '02ICOM')
    - 行106-107: 顧客番号のみ検索 (リクエストID: '03ICOM')
    - 行115-116: 郵便番号検索 (リクエストID: '05ICOM')
  - 行156-195: オプション '2' で保険登録 (リクエストID: '01ACOM')
  - 行197-234: オプション '3' で保険削除 (リクエストID: '01DCOM')

**データ構造**
- `base/src/lgcmarea.cpy` 行77-94: 商業用不動産保険データ構造
  - CA-B-Address, CA-B-Latitude, CA-B-Longitude
  - CA-B-FirePeril, CA-B-FirePremium
  - CA-B-CrimePeril, CA-B-CrimePremium
  - CA-B-FloodPeril, CA-B-FloodPremium
  - CA-B-WeatherPeril, CA-B-WeatherPremium

**ドキュメント**
- `base/Architecture.md` 行24: "Run SSP4 to create a commercial property insurance policy"

### 2.6 システム管理機能 (BR-019 - BR-023)

#### 根拠ソース

**ドキュメント**
- `base/Reference.md` 行48-52: システムトランザクション定義
  - LGSE: "Initialize counters and temporary storage queues"
  - LGCF: "Retrieve random customer number from VSAM file"
  - LGPF: "Retrieve policy and customer number from VSAM file"
  - LGST: "Event adapter trigger to update counters"

**アーキテクチャ**
- `base/Architecture.md` 行52-58: Named Counter Server の説明
- `base/Architecture.md` 行60-64: Temporary storage queue (control) の説明
- `base/Architecture.md` 行66-70: Temporary storage queue (errors) の説明

### 2.7 データ整合性・採番機能 (BR-024 - BR-027)

#### 根拠ソース

**二相コミット**
- `base/Architecture.md` 行48-50: "The application uses a two-phase commit to store customer and policy data in Db2 and, if successful, it updates VSAM."
- `base/src/lgtestp1.cbl` 行120, 144: `Exec CICS Syncpoint Rollback End-Exec`

**顧客番号採番**
- `base/src/lgacdb01.cbl` 行199-211: Named Counter Server からの取得
- `base/cntl/db2cre.jcl` 行103-104: DB2 IDENTITY定義 (START WITH 1000001, INCREMENT BY 1)

**保険証券番号採番**
- `base/cntl/db2cre.jcl` 行154-155: POLICY テーブルの IDENTITY定義

**参照整合性**
- `base/cntl/db2cre.jcl` 行166-168: 外部キー制約 (ON DELETE CASCADE)
- `base/Architecture.md` 行109-110: "These tables are related for referential integrity"

## 3. データベース構造

### 3.1 テーブル一覧

`base/cntl/db2cre.jcl` より抽出:

| テーブル名 | 説明 | 主キー |
|-----------|------|-------|
| CUSTOMER | 顧客情報 | customerNumber |
| CUSTOMER_SECURE | 顧客セキュリティ情報 | customerNumber |
| POLICY | 保険契約基本情報 | policyNumber |
| ENDOWMENT | 養老保険詳細 | policyNumber |
| HOUSE | 住宅保険詳細 | policyNumber |
| MOTOR | 自動車保険詳細 | policyNumber |
| COMMERCIAL | 商業用不動産保険詳細 | policyNumber |
| CLAIM | 保険金請求 | claimNumber |

### 3.2 VSAMファイル

- `base/Architecture.md` 行85-98: VSAMファイルの説明
- `base/Reference.md` 行105-106: FILE リソース定義

| ファイル名 | 説明 | キー構造 |
|-----------|------|---------|
| KSDSCUST | 顧客レコード | 先頭10文字（顧客番号） |
| KSDSPOLY | 保険レコード | 先頭21文字（種別1文字+顧客ID10文字+保険番号10文字） |

## 4. 信頼度評価

### 4.1 評価基準

| 評価 | 説明 |
|-----|------|
| 高 | 複数のソースから一貫した情報が得られた |
| 中 | 主にコードから抽出、ドキュメントで部分的に確認 |
| 低 | コードからの推測、ドキュメント未確認 |

### 4.2 要件別信頼度

| 要件ID | 信頼度 | 根拠 |
|-------|-------|------|
| BR-001 - BR-003 | 高 | Architecture.md、Reference.md、COBOLソースコードで一貫 |
| BR-004 - BR-007 | 高 | Architecture.md、Reference.md、COBOLソースコードで一貫 |
| BR-008 - BR-011 | 高 | Architecture.md、Reference.md、COBOLソースコードで一貫 |
| BR-012 - BR-015 | 高 | Architecture.md、Reference.md、COBOLソースコードで一貫 |
| BR-016 - BR-018 | 高 | Architecture.md、Reference.md、COBOLソースコードで一貫 |
| BR-019 - BR-022 | 中 | Reference.mdに記載、コードは部分的に確認 |
| BR-023 | 中 | コード内のエラー処理から抽出 |
| BR-024 | 高 | Architecture.mdで明確に記載 |
| BR-025 - BR-026 | 高 | COBOLソースコード、JCLで確認 |
| BR-027 | 高 | JCL内のCREATE TABLE文で確認 |
| BR-028 | 中 | COBOLソースコードから抽出 |

## 5. 制限事項と注意点

### 5.1 分析の制限

1. **実行環境の制約**: 実際のCICS環境での動作確認は行っていません
2. **Web Services**: WSA*プログラムは詳細分析の対象外としました
3. **CICSPlex SM連携**: トポロジ管理機能は対象外としました

### 5.2 追加調査推奨項目

1. CLAIM（保険金請求）機能の詳細仕様
2. Web Services経由のアクセス要件
3. セキュリティ要件（CUSTOMER_SECUREテーブルの使用方法）

## 6. 参照ドキュメント

| ファイル | 説明 |
|---------|------|
| `/base/Architecture.md` | アプリケーションアーキテクチャ |
| `/base/Reference.md` | リファレンスガイド |
| `/base/README.md` | 基本説明 |
| `/README.md` | プロジェクト概要 |

---

*本レポートは2026年1月6日に生成されました。*
