# 機能設計書 F001-顧客登録

## 概要

本ドキュメントは、CICS-GENAPPシステムにおける顧客登録機能の詳細設計を定義する。新規顧客情報をDb2データベースおよびVSAMファイルに登録する機能である。

### 本機能の処理概要

本機能は、保険業務システムにおいて新規顧客を登録するための基幹機能を提供する。

**業務上の目的・背景**：保険契約を締結するためには、まず顧客情報の登録が必要である。本機能は、顧客の基本情報（氏名、住所、連絡先等）をシステムに登録し、一意の顧客番号を発行することで、以後の保険ポリシー管理の基盤を構築する。顧客情報を適切に管理することは、保険業務における顧客サービス向上と契約管理の効率化に不可欠である。

**機能の利用シーン**：新規顧客が保険契約を希望する際、オペレーターが顧客メニュー画面からオプション2を選択し、顧客の基本情報を入力して登録を実行する。また、WebサービスやAPIを通じた自動登録にも対応する。

**主要な処理内容**：
1. 名前付きカウンタ（GENACUSTNUM）から一意の顧客番号を取得
2. Db2のCUSTOMERテーブルに顧客基本情報をINSERT
3. CUSTOMER_SECUREテーブルに初期パスワードとセキュリティ情報を登録
4. VSAMファイル（KSDSCUST）に顧客レコードを書き込み
5. 登録完了後、発行された顧客番号を呼び出し元に返却

**関連システム・外部連携**：CICSの名前付きカウンタサーバー（Named Counter Server）と連携し、一意の顧客番号を取得する。

**権限による制御**：本機能は顧客登録権限を持つオペレーターのみが実行可能である。

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 1 | 顧客メニュー画面 | 主画面 | オプション2選択時にLGACUS01プログラムをCICS LINKで呼び出し、新規顧客をDb2/VSAMに登録する |

## 機能種別

CRUD操作（Create）/ データ登録処理

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| CA-REQUEST-ID | X(6) | Yes | リクエストID | '02ACUS'固定 |
| CA-FIRST-NAME | X(10) | Yes | 名 | 空白不可 |
| CA-LAST-NAME | X(20) | Yes | 姓 | 空白不可 |
| CA-DOB | X(10) | Yes | 生年月日 | 日付形式（YYYY-MM-DD） |
| CA-HOUSE-NAME | X(20) | No | 建物名 | - |
| CA-HOUSE-NUM | X(4) | No | 建物番号 | - |
| CA-POSTCODE | X(8) | Yes | 郵便番号 | - |
| CA-PHONE-MOBILE | X(20) | No | 携帯電話番号 | - |
| CA-PHONE-HOME | X(20) | No | 自宅電話番号 | - |
| CA-EMAIL-ADDRESS | X(100) | No | メールアドレス | - |

### 入力データソース

- 画面入力（顧客メニュー画面 SSMAPC1）
- CICS通信領域（COMMAREA）を介したデータ連携

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| CA-RETURN-CODE | 9(2) | 処理結果コード（00:正常、その他:エラー） |
| CA-CUSTOMER-NUM | 9(10) | 発行された顧客番号 |

### 出力先

- CICS通信領域（COMMAREA）
- Db2 CUSTOMERテーブル
- Db2 CUSTOMER_SECUREテーブル
- VSAMファイル（KSDSCUST）

## 処理フロー

### 処理シーケンス

```
1. COMMAREAの受信と検証
   └─ COMMAREAが存在しない場合はABEND('LGCA')
2. COMMAREAの長さチェック
   └─ 必要な長さ（ヘッダー18バイト + 顧客データ72バイト）を確認
3. 顧客番号の取得（LGACDB01）
   └─ 名前付きカウンタ(GENACUSTNUM)から一意の番号を取得
4. CUSTOMERテーブルへのINSERT（LGACDB01）
   └─ 顧客基本情報をDb2に登録
5. VSAMファイルへの書き込み（LGACVS01）
   └─ KSDSCUSTファイルに顧客レコードを登録
6. CUSTOMER_SECUREテーブルへのINSERT（LGACDB02）
   └─ 初期パスワードとセキュリティ情報を登録
7. 結果の返却
   └─ 顧客番号とリターンコードをCOMMAREAに設定
```

### フローチャート

```mermaid
flowchart TD
    A[開始] --> B{COMMAREAあり?}
    B -->|No| C[ABEND LGCA]
    B -->|Yes| D{長さチェック}
    D -->|NG| E[RC=98で終了]
    D -->|OK| F[LGACDB01呼出]
    F --> G[名前付きカウンタから顧客番号取得]
    G --> H[CUSTOMERテーブルINSERT]
    H --> I{SQLCODE=0?}
    I -->|No| J[RC=90でエラー終了]
    I -->|Yes| K[LGACVS01呼出]
    K --> L[VSAMファイル書込]
    L --> M{成功?}
    M -->|No| N[RC=80でABEND]
    M -->|Yes| O[LGACDB02呼出]
    O --> P[CUSTOMER_SECUREテーブルINSERT]
    P --> Q[RC=00で正常終了]
    E --> R[終了]
    J --> R
    N --> R
    Q --> R
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-001 | 顧客番号自動採番 | 名前付きカウンタから一意の顧客番号を自動発行する | 常時 |
| BR-002 | 初期パスワード設定 | 新規顧客には固定のMD5ハッシュ値をパスワードとして設定する | 新規登録時 |
| BR-003 | セキュリティ状態初期化 | 新規顧客のセキュリティ状態は'N'（新規）で初期化する | 新規登録時 |
| BR-004 | 二重登録防止 | 同一顧客番号での重複登録はDb2の主キー制約により防止される | 常時 |

### 計算ロジック

- 顧客番号: CICS名前付きカウンタ(GENACUSTNUM, Pool:GENA)から順次取得
- 初期パスワード: '5732fec825535eeafb8fac50fee3a8aa'（固定MD5ハッシュ）

## データベース操作仕様

### 操作別データベース影響一覧

| 操作 | 対象テーブル | 操作種別 | 概要 |
|-----|-------------|---------|------|
| 顧客情報登録 | CUSTOMER | INSERT | 顧客基本情報の登録 |
| セキュリティ情報登録 | CUSTOMER_SECURE | INSERT | パスワード・状態情報の登録 |

### テーブル別操作詳細

#### CUSTOMER

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| INSERT | CUSTOMERNUMBER | 名前付きカウンタ値 or DEFAULT | カウンタ取得失敗時はIDENTITY使用 |
| INSERT | FIRSTNAME | :CA-FIRST-NAME | |
| INSERT | LASTNAME | :CA-LAST-NAME | |
| INSERT | DATEOFBIRTH | :CA-DOB | |
| INSERT | HOUSENAME | :CA-HOUSE-NAME | |
| INSERT | HOUSENUMBER | :CA-HOUSE-NUM | |
| INSERT | POSTCODE | :CA-POSTCODE | |
| INSERT | PHONEMOBILE | :CA-PHONE-MOBILE | |
| INSERT | PHONEHOME | :CA-PHONE-HOME | |
| INSERT | EMAILADDRESS | :CA-EMAIL-ADDRESS | |

#### CUSTOMER_SECURE

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| INSERT | customerNumber | :DB2-CUSTOMERNUM-INT | |
| INSERT | customerPass | :D2-CUSTSECR-PASS | MD5ハッシュ固定値 |
| INSERT | state_indicator | :D2-CUSTSECR-STATE | 'N'固定 |
| INSERT | pass_changes | :DB2-CUSTOMERCNT-INT | 0固定 |

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| 98 | 入力エラー | COMMAREAの長さ不足 | 正しい長さのCOMMAREAで再実行 |
| 90 | DB2エラー | CUSTOMERテーブルINSERT失敗 | エラーログ確認、Db2状態確認 |
| 80 | VSAMエラー | KSDSCUSTファイル書込失敗 | VSAMファイル状態確認 |
| LGCA | システムエラー | COMMAREAなし | プログラム呼出方法確認 |
| LGV0 | VSAMエラー | VSAMファイル書込異常 | VSAMファイル定義確認 |

### リトライ仕様

- 名前付きカウンタ取得失敗時は、Db2のIDENTITY_VAL_LOCAL()を使用したフォールバック処理を実行
- VSAMエラー時はリトライなし（ABENDで終了）

## トランザクション仕様

- トランザクションID: SSC1
- コミット: 正常終了時にCICS RETURNで暗黙コミット
- ロールバック: ABEND発生時にCICSにより自動ロールバック
- 注意: Db2とVSAMの両方に登録するため、整合性維持のためABEND処理を使用

## パフォーマンス要件

- レスポンス時間: 1秒以内
- 名前付きカウンタへのアクセスはCICS内部処理のため高速

## セキュリティ考慮事項

- 初期パスワードは固定のMD5ハッシュ値で設定（'5732fec825535eeafb8fac50fee3a8aa'）
- 顧客は初回ログイン時にパスワード変更を推奨
- エラー発生時はLGSTSQプログラムを通じてエラーキュー（GENAERRRS）にログを記録
- 顧客情報は個人情報として適切に保護する必要がある

## 備考

- LGACUS01: ビジネスロジック層（LGACDB01を呼び出し）
- LGACDB01: Db2データアクセス層（CUSTOMER登録、LGACVS01/LGACDB02呼び出し）
- LGACVS01: VSAMデータアクセス層（KSDSCUSTファイル書込）
- LGACDB02: Db2セキュリティデータアクセス層（CUSTOMER_SECURE登録）

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

まず、プログラム間で受け渡されるデータ構造を理解することが重要である。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | lgcmarea.cpy | `base/src/lgcmarea.cpy` | COMMAREA構造の理解。`CA-REQUEST-ID`、`CA-RETURN-CODE`、`CA-CUSTOMER-NUM`、および`CA-CUSTOMER-REQUEST`内の顧客情報フィールド（氏名、住所等）の定義を確認 |
| 1-2 | lgpolicy.cpy | `base/src/lgpolicy.cpy` | `WS-CUSTOMER-LEN`（72バイト）の定義を確認。COMMAREAの長さチェックに使用される |

**読解のコツ**: COBOLの`REDEFINES`句により、同一領域が複数の用途で再定義されている。顧客登録では`CA-CUSTOMER-REQUEST`の定義（10-26行目）に注目する。

#### Step 2: 画面レイアウトを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | ssmap.bms | `base/src/ssmap.bms` | `SSMAPC1`マップ（13-106行目）が顧客メニュー画面。入力フィールド（`ENT1CNO`、`ENT1FNA`等）と画面レイアウトを確認。オプション2が「Cust Add」 |

**読解のコツ**: BMSマップの`POS=(行,列)`で画面上の位置、`LENGTH`で入力可能文字数、`ATTRB`で属性（入力可/不可等）を定義している。

#### Step 3: エントリーポイント（ビジネスロジック層）

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | lgacus01.cbl | `base/src/lgacus01.cbl` | **MAINLINE SECTION**（78-126行目）: COMMAREAの検証とLGACDB01呼び出し |

**主要処理フロー**:
1. **94-99行目**: COMMAREAなしの場合はABEND('LGCA')
2. **107-115行目**: COMMAREAの長さチェック（ヘッダー18バイト + 顧客データ72バイト）
3. **119行目**: `PERFORM INSERT-CUSTOMER` → LGACDB01をCICS LINKで呼び出し（132-140行目）
4. **147-178行目**: エラー時はLGSTSQを呼び出してエラーログ出力

#### Step 4: 中核処理（Db2データアクセス層）

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | lgacdb01.cbl | `base/src/lgacdb01.cbl` | **最も重要なファイル**。顧客番号取得、Db2登録、VSAM登録、セキュリティ登録のオーケストレーション |

**主要処理フロー**:
1. **171行目**: `PERFORM Obtain-CUSTOMER-Number` - 名前付きカウンタから顧客番号取得
2. **172行目**: `PERFORM INSERT-CUSTOMER` - CUSTOMERテーブルへINSERT
3. **174-177行目**: LGACVS01をCICS LINKで呼び出し（VSAMファイル書込）
4. **179-189行目**: CDB2AREAを設定してLGACDB02を呼び出し（セキュリティ情報登録）

**注目すべき詳細**:
- **199-211行目** `Obtain-CUSTOMER-Number`: CICS名前付きカウンタ（GENACUSTNUM）から顧客番号取得。失敗時は`LGAC-NCS='NO'`に設定
- **215-287行目** `INSERT-CUSTOMER`: カウンタ取得成功時（LGAC-NCS='ON'）とフォールバック時で異なるSQL（DEFAULTでIDENTITY使用）
- **181-184行目**: 初期パスワード（MD5ハッシュ固定値）とセキュリティ状態（'N'）の設定

#### Step 5: VSAM処理層

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 5-1 | lgacvs01.cbl | `base/src/lgacvs01.cbl` | KSDSCUSTファイルへの顧客レコード書込処理 |

**主要処理フロー**:
- **68-81行目**: CICS WRITE FILEコマンドでVSAMに書込。キーは`CA-Customer-Num`（10桁）
- **75-80行目**: 書込失敗時はエラーコード'80'を設定しABEND('LGV0')

#### Step 6: セキュリティ処理層

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 6-1 | lgacdb02.cbl | `base/src/lgacdb02.cbl` | CUSTOMER_SECUREテーブルへの初期パスワード登録 |

**主要処理フロー**:
- **143-152行目**: REQUEST-IDが'02ACUS'の場合にINSERT実行
- **161-184行目** `INSERT-CUSTOMER-PASSWORD`: customerNumber、customerPass、state_indicator、pass_changesをINSERT

#### Step 7: 補助機能（エラーログ）

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 7-1 | lgstsq.cbl | `base/src/lgstsq.cbl` | エラーメッセージをTDQ（CSMT）およびTSQ（GENAERRS）に書き込む共通ログ機能 |

**主要処理フロー**:
- **94-99行目**: TDQ（CSMT）への書き込み
- **105-111行目**: TSQ（GENAERRS）への書き込み

### プログラム呼び出し階層図

```
画面操作（オプション2選択）
    │
    ▼
LGACUS01 (lgacus01.cbl)  ─────────────────┐
    │ CICS LINK                           │ エラー時
    ▼                                     ▼
LGACDB01 (lgacdb01.cbl)              LGSTSQ (lgstsq.cbl)
    │                                     │
    ├─ CICS GET COUNTER (GENACUSTNUM)     └─ TDQ/TSQ書込
    │
    ├─ SQL INSERT (CUSTOMER)
    │
    ├─ CICS LINK ──▶ LGACVS01 (lgacvs01.cbl)
    │                    │
    │                    └─ CICS WRITE FILE (KSDSCUST)
    │
    └─ CICS LINK ──▶ LGACDB02 (lgacdb02.cbl)
                         │
                         └─ SQL INSERT (CUSTOMER_SECURE)
```

### データフロー図

```
[入力]                    [処理]                         [出力]

COMMAREA ─────────▶ LGACUS01 ─────▶ LGACDB01 ─────────▶ CUSTOMER (Db2)
 ├─ CA-FIRST-NAME       │              │
 ├─ CA-LAST-NAME        │              ├─▶ KSDSCUST (VSAM)
 ├─ CA-DOB              │              │
 ├─ CA-HOUSE-NAME       │              └─▶ CUSTOMER_SECURE (Db2)
 ├─ CA-HOUSE-NUM        │
 ├─ CA-POSTCODE         │
 ├─ CA-PHONE-MOBILE     │
 ├─ CA-PHONE-HOME       │
 └─ CA-EMAIL-ADDRESS    │
                        │
名前付きカウンタ ◀──────┘
(GENACUSTNUM)
       │
       └───────────────────────────────────────────────▶ CA-CUSTOMER-NUM
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| lgacus01.cbl | `base/src/lgacus01.cbl` | COBOLプログラム | ビジネスロジック層（エントリーポイント） |
| lgacdb01.cbl | `base/src/lgacdb01.cbl` | COBOLプログラム | Db2データアクセス層（中核処理） |
| lgacvs01.cbl | `base/src/lgacvs01.cbl` | COBOLプログラム | VSAMデータアクセス層 |
| lgacdb02.cbl | `base/src/lgacdb02.cbl` | COBOLプログラム | セキュリティデータアクセス層 |
| lgcmarea.cpy | `base/src/lgcmarea.cpy` | コピーブック | COMMAREA構造定義 |
| lgpolicy.cpy | `base/src/lgpolicy.cpy` | コピーブック | ポリシー/顧客データ長定義 |
| ssmap.bms | `base/src/ssmap.bms` | BMSマップ | 画面定義（SSMAPC1が顧客メニュー） |
| lgstsq.cbl | `base/src/lgstsq.cbl` | COBOLプログラム | エラーログ共通機能 |
