# 機能設計書 F010-養老保険更新

## 概要

本ドキュメントは、CICS-GENAPPシステムにおける養老保険更新機能の詳細設計を定義する。既存の養老保険ポリシーの情報をDb2データベースおよびVSAMファイルで更新する機能である。

### 本機能の処理概要

本機能は、既に登録されている養老保険ポリシーの内容を変更・更新するための基幹機能を提供する。

**業務上の目的・背景**：養老保険の契約期間中に、被保険者情報の変更、運用オプションの変更、保険金額の見直しなど、様々な更新が発生する。本機能は、これらの変更を迅速かつ正確にシステムに反映し、契約内容の正確性を維持する。楽観的ロック（タイムスタンプ比較）により、同時更新の競合を防止する。

**機能の利用シーン**：顧客から契約内容の変更申し出があった際、オペレーターが養老保険詳細画面でPF4キーを押下し、変更内容を入力して更新を実行する。更新前に必ず照会（F009）で現在の情報を取得してから更新を行う。

**主要な処理内容**：
1. リクエストID('01UEND')とCOMMAREAの検証
2. LGUPOL01プログラムを呼び出しビジネスロジックを実行
3. LGUPDB01プログラムでPOLICYテーブルをSELECT FOR UPDATEでロック取得
4. タイムスタンプ比較による楽観的ロック検証
5. ENDOWMENTテーブルとPOLICYテーブルをUPDATE
6. LGUPVS01プログラムでVSAMファイル（KSDSPOLY）を更新
7. 処理結果と新タイムスタンプを呼び出し元に返却

**関連システム・外部連携**：Db2データベース、VSAMファイルとの連携。

**権限による制御**：本機能は保険ポリシー更新権限を持つオペレーターのみが実行可能である。

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 4 | 養老保険詳細画面 | 主画面 | PF4キー押下時にLGUPOL01プログラムをCICS LINKで呼び出し、養老保険情報を更新する |

## 機能種別

CRUD操作（Update）/ データ更新処理

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| CA-REQUEST-ID | X(6) | Yes | リクエストID | '01UEND'固定 |
| CA-CUSTOMER-NUM | 9(10) | Yes | 顧客番号 | 存在する顧客番号 |
| CA-POLICY-NUM | 9(10) | Yes | ポリシー番号 | 存在するポリシー番号 |
| CA-LASTCHANGED | X(26) | Yes | 最終更新タイムスタンプ | 照会時取得値と一致 |
| CA-ISSUE-DATE | X(10) | Yes | 発効日 | 日付形式 |
| CA-EXPIRY-DATE | X(10) | Yes | 満期日 | 日付形式 |
| CA-BROKERID | 9(10) | No | ブローカーID | - |
| CA-BROKERSREF | X(10) | No | ブローカー参照番号 | - |
| CA-E-WITH-PROFITS | X(1) | Yes | 利益付きフラグ | Y/N |
| CA-E-EQUITIES | X(1) | Yes | 株式オプション | Y/N |
| CA-E-MANAGED-FUND | X(1) | Yes | 管理基金オプション | Y/N |
| CA-E-FUND-NAME | X(10) | No | ファンド名 | - |
| CA-E-TERM | 9(2) | Yes | 保険期間（年） | - |
| CA-E-SUM-ASSURED | 9(6) | Yes | 保険金額 | - |
| CA-E-LIFE-ASSURED | X(31) | Yes | 被保険者名 | - |

### 入力データソース

- 画面入力（養老保険詳細画面 SSMAPM1）
- CICS通信領域（COMMAREA）を介したデータ連携

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| CA-RETURN-CODE | 9(2) | 処理結果コード |
| CA-LASTCHANGED | X(26) | 新しい最終更新タイムスタンプ |

### 出力先

- CICS通信領域（COMMAREA）
- Db2 POLICYテーブル（更新）
- Db2 ENDOWMENTテーブル（更新）
- VSAMファイル（KSDSPOLY）（更新）

## 処理フロー

### 処理シーケンス

```
1. COMMAREAの受信と検証
   └─ COMMAREAが存在しない場合はABEND('LGCA')
2. COMMAREAの長さチェック
   └─ ヘッダー28バイト + 養老保険データ124バイトを確認
3. LGUPDB01プログラム呼び出し
   └─ CICS LINKでDb2アクセス層を呼び出し
4. POLICYテーブルのOPEN CURSOR（FOR UPDATE）
   └─ SELECT FOR UPDATEで排他ロック取得
5. タイムスタンプ比較（楽観的ロック）
   └─ COMMAREAのCA-LASTCHANGEDとDb2のDB2-LASTCHANGEDを比較
6. ENDOWMENTテーブルのUPDATE
   └─ 養老保険固有情報を更新
7. POLICYテーブルのUPDATE
   └─ 共通情報を更新、新タイムスタンプを設定
8. LGUPVS01プログラム呼び出し
   └─ VSAMファイルを更新
9. CURSORのCLOSE
10. 結果の返却
    └─ 新タイムスタンプとリターンコードをCOMMAREAに設定
```

### フローチャート

```mermaid
flowchart TD
    A[開始] --> B{COMMAREAあり?}
    B -->|No| C[ABEND LGCA]
    B -->|Yes| D{長さチェック}
    D -->|NG| E[RC=98で終了]
    D -->|OK| F[LGUPDB01呼出]
    F --> G[OPEN POLICY_CURSOR]
    G --> H{SQLCODE判定}
    H -->|-913| I[RC=90 ロック競合]
    H -->|0| J[FETCH POLICY_CURSOR]
    J --> K{FETCH成功?}
    K -->|SQLCODE=100| L[RC=01 データなし]
    K -->|Yes| M{タイムスタンプ一致?}
    M -->|No| N[RC=02 競合検出]
    M -->|Yes| O[UPDATE ENDOWMENT]
    O --> P{SQLCODE=0?}
    P -->|No| Q[RC=90/01 エラー]
    P -->|Yes| R[UPDATE POLICY]
    R --> S[SELECT新タイムスタンプ]
    S --> T{SQLCODE=0?}
    T -->|No| U[SYNCPOINT ROLLBACK]
    T -->|Yes| V[LGUPVS01呼出]
    V --> W[VSAMファイル更新]
    W --> X[CLOSE CURSOR]
    X --> Y[RC=00で正常終了]
    E --> Z[終了]
    I --> Z
    L --> Z
    N --> Z
    Q --> Z
    U --> Z
    Y --> Z
    C --> Z
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-001 | 楽観的ロック | タイムスタンプが一致しない場合は更新を拒否（'02'エラー） | 常時 |
| BR-002 | 排他ロック | SELECT FOR UPDATEで対象行をロック | 更新時 |
| BR-003 | タイムスタンプ更新 | CURRENT TIMESTAMPで新しいタイムスタンプを自動設定 | 更新成功時 |
| BR-004 | トランザクション整合性 | 全ての更新が成功しないとロールバック | 常時 |
| BR-005 | VARCHARデータ保持 | 更新時、既存のPADDINGDATAは変更しない | 常時 |

### 計算ロジック

- 新タイムスタンプ: CURRENT TIMESTAMP（Db2現在タイムスタンプ）

## データベース操作仕様

### 操作別データベース影響一覧

| 操作 | 対象テーブル | 操作種別 | 概要 |
|-----|-------------|---------|------|
| ロック取得 | POLICY | SELECT FOR UPDATE | 排他ロック取得 |
| ポリシー情報更新 | POLICY | UPDATE | 保険ポリシー共通情報の更新 |
| 養老保険情報更新 | ENDOWMENT | UPDATE | 養老保険固有情報の更新 |

### テーブル別操作詳細

#### POLICY

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| SELECT FOR UPDATE | ISSUEDATE, EXPIRYDATE, LASTCHANGED, BROKERID, BROKERSREFERENCE | WHERE CUSTOMERNUMBER = :DB2-CUSTOMERNUM-INT AND POLICYNUMBER = :DB2-POLICYNUM-INT | ロック取得用 |
| UPDATE | ISSUEDATE | :CA-ISSUE-DATE | WHERE CURRENT OF POLICY_CURSOR |
| UPDATE | EXPIRYDATE | :CA-EXPIRY-DATE | 同上 |
| UPDATE | LASTCHANGED | CURRENT TIMESTAMP | 同上 |
| UPDATE | BROKERID | :DB2-BROKERID-INT | 同上 |
| UPDATE | BROKERSREFERENCE | :CA-BROKERSREF | 同上 |

#### ENDOWMENT

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| UPDATE | WITHPROFITS | :CA-E-WITH-PROFITS | WHERE POLICYNUMBER = :DB2-POLICYNUM-INT |
| UPDATE | EQUITIES | :CA-E-EQUITIES | 同上 |
| UPDATE | MANAGEDFUND | :CA-E-MANAGED-FUND | 同上 |
| UPDATE | FUNDNAME | :CA-E-FUND-NAME | 同上 |
| UPDATE | TERM | :DB2-E-TERM-SINT | 同上 |
| UPDATE | SUMASSURED | :DB2-E-SUMASSURED-INT | 同上 |
| UPDATE | LIFEASSURED | :CA-E-LIFE-ASSURED | 同上 |

**注**: PADDINGDATAは更新対象外

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| 98 | 入力エラー | COMMAREAの長さ不足 | 正しい長さのCOMMAREAで再実行 |
| 99 | 入力エラー | リクエストIDが不正 | 正しいリクエストIDを設定 |
| 01 | 業務エラー | データが存在しない（SQLCODE=100） | 正しい顧客番号/ポリシー番号を指定 |
| 02 | 業務エラー | タイムスタンプ不一致（楽観的ロック競合） | 再照会して最新データで更新 |
| 90 | DB2エラー | ロック競合/その他SQLエラー | エラーログ確認、時間を置いて再実行 |
| LGCA | システムエラー | COMMAREAなし | プログラム呼出方法確認 |

### リトライ仕様

- タイムスタンプ不一致（'02'エラー）: 再照会後に更新を再試行
- ロック競合（SQLCODE=-913）: 時間を置いて再試行

## トランザクション仕様

- トランザクションID: SSC1
- コミット: 正常終了時にCICS RETURNで暗黙コミット
- ロールバック: SYNCPOINT ROLLBACKで明示的ロールバック（UPDATE失敗時）
- カーソル: WITH HOLDオプションでSYNCPOINT後もカーソルを保持

## パフォーマンス要件

- レスポンス時間: 1秒以内
- SELECT FOR UPDATEにより排他ロックを取得するため、長時間のトランザクションは避ける

## セキュリティ考慮事項

- 保険ポリシー更新には適切な権限管理が必要
- 楽観的ロックにより同時更新の競合を防止
- エラー発生時はLGSTSQプログラムを通じてエラーキューにログを記録
- 更新前の照会（F009）実行が必須

## 備考

- LGUPOL01: ビジネスロジック層（LGUPDB01を呼び出し）
- LGUPDB01: Db2データアクセス層（POLICY/ENDOWMENTテーブルUPDATE、LGUPVS01呼び出し）
- LGUPVS01: VSAMデータアクセス層（KSDSPOLYファイル更新）
- 養老保険完全データ長: WS-FULL-ENDOW-LEN = 124バイト
- カーソル名: POLICY_CURSOR（WITH HOLD FOR UPDATE）
- 注意: PADDINGDATAは更新対象外（既存データを保持）

## コードリーディングガイド

本機能を理解するための推奨コードリーディング順序を示す。

### 推奨リーディング順序

| Step | ファイル | パス | 読むべきポイント |
|------|---------|------|-----------------|
| 1 | lgcmarea.cpy | base/src/lgcmarea.cpy | CA-REQUEST-ID、CA-LASTCHANGED、CA-E-*（養老保険フィールド）のデータ構造を把握 |
| 2 | lgpolicy.cpy | base/src/lgpolicy.cpy | WS-FULL-ENDOW-LEN（124バイト）、DB2ホスト変数の定義を確認 |
| 3 | lgupol01.cbl | base/src/lgupol01.cbl | ビジネスロジック層のエントリポイント、リクエストID評価 |
| 4 | lgupdb01.cbl | base/src/lgupdb01.cbl | Db2アクセス層、カーソル操作、楽観的ロック、UPDATE処理 |
| 5 | lgupvs01.cbl | base/src/lgupvs01.cbl | VSAMアクセス層、KSDSPOLYファイル更新 |
| 6 | lgstsq.cbl | base/src/lgstsq.cbl | エラーログ出力処理 |

### Step別詳細ガイド

#### Step 1: データ構造の理解（lgcmarea.cpy）
**読むべき箇所**: ファイル全体

養老保険更新で使用する主要フィールド:
- `CA-REQUEST-ID`: '01UEND'（養老保険更新を示す識別子）
- `CA-CUSTOMER-NUM`: 更新対象の顧客番号
- `CA-POLICY-NUM`: 更新対象のポリシー番号
- `CA-LASTCHANGED`: 楽観的ロック用タイムスタンプ（入力/出力両方）
- `CA-E-WITH-PROFITS`, `CA-E-EQUITIES`, `CA-E-MANAGED-FUND`: 運用オプション
- `CA-E-TERM`: 保険期間
- `CA-E-SUM-ASSURED`: 保険金額
- `CA-E-LIFE-ASSURED`: 被保険者名

#### Step 2: エントリポイントの理解（lgupol01.cbl）
**読むべき箇所**: 99-147行目

```
99-103行目: COMMAREA存在チェック
  - COMMAREAがない場合はABEND('LGCA')

113-141行目: リクエストID評価と長さチェック
  - '01UEND': WS-FULL-ENDOW-LEN（124バイト）を加算
  - 長さ不足時はRC='98'で終了

157-160行目: LGUPDB01呼び出し
  - CICS LINKでDb2アクセス層を呼び出し
```

#### Step 3: Db2アクセス層の理解（lgupdb01.cbl）
**読むべき箇所**: 128-418行目

```
128-143行目: POLICY_CURSORの宣言（重要）
  - DECLARE CURSOR WITH HOLD FOR ... FOR UPDATE
  - SELECT FOR UPDATEで排他ロックを取得
  - WITH HOLDでSYNCPOINT後もカーソル保持

183-187行目: COMMAREA存在チェック

194-199行目: データ変換
  - CA-CUSTOMER-NUM → DB2-CUSTOMERNUM-INT
  - CA-POLICY-NUM → DB2-POLICYNUM-INT

207行目: UPDATE-POLICY-DB2-INFO呼び出し

209-212行目: LGUPVS01呼び出し
  - VSAM更新層を呼び出し

251-361行目: UPDATE-POLICY-DB2-INFO手続き（更新の核心）
  - 255-270行目: OPEN POLICY_CURSOR
    - SQLCODE = 0: 成功
    - SQLCODE = -913: ロック競合（RC='90'）

  - 273行目: FETCH-DB2-POLICY-ROW実行

  - 278行目: タイムスタンプ比較（楽観的ロック）
    - CA-LASTCHANGED = DB2-LASTCHANGED なら更新続行
    - 不一致時はRC='02'で終了（346行目）

  - 283-300行目: リクエストID評価
    - '01UEND'の場合: UPDATE-ENDOW-DB2-INFO（288行目）

  - 318-326行目: UPDATE POLICY
    - LASTCHANGED = CURRENT TIMESTAMP
    - WHERE CURRENT OF POLICY_CURSOR

  - 329-334行目: 新タイムスタンプ取得
    - SELECT LASTCHANGED INTO :CA-LASTCHANGED

  - 336-342行目: エラー時ロールバック
    - EXEC CICS SYNCPOINT ROLLBACK END-EXEC

387-418行目: UPDATE-ENDOW-DB2-INFO手続き（養老保険固有）
  - 390-391行目: 数値変換
  - 394-406行目: UPDATE ENDOWMENT
    - PADDINGDATAは更新対象外（既存値を保持）
```

#### Step 4: VSAMアクセス層の理解（lgupvs01.cbl）
**読むべき箇所**: 99-166行目

```
102-104行目: キー設定
  - WF-Request-ID: リクエストIDの4文字目（'E'）
  - WF-Customer-Num, WF-Policy-Num

106-135行目: ポリシータイプ別データ設定
  - 113-118行目: 'E'（Endowment）の場合
    - WF-E-WITH-PROFITS, WF-E-EQUITIES等を設定

139-146行目: READ FOR UPDATE
  - EXEC CICS READ FILE('KSDSPOLY') ... Update
  - エラー時はRC='81'

155-166行目: REWRITE
  - EXEC CICS REWRITE FILE('KSDSPOLY')
  - エラー時はRC='82'、ABEND('LGV4')
```

#### Step 5: エラーログの理解（lgstsq.cbl）
**読むべき箇所**: 各プログラムのWRITE-ERROR-MESSAGE段落

各プログラムでエラー発生時にLGSTSQを呼び出してログを記録:
- lgupol01.cbl: 169-201行目
- lgupdb01.cbl: 502-535行目
- lgupvs01.cbl: 174-206行目

### プログラム呼出し階層

```
SSMAPM1（養老保険詳細画面）
  ↓ PF4キー押下
LGUPOL01（ビジネスロジック層）
  ├── リクエストID評価（'01UEND'）
  ├── COMMAREA長チェック
  └── CICS LINK
        ↓
      LGUPDB01（Db2アクセス層）
        ├── OPEN POLICY_CURSOR（SELECT FOR UPDATE）
        ├── FETCH → タイムスタンプ比較（楽観的ロック）
        ├── UPDATE ENDOWMENT
        ├── UPDATE POLICY（CURRENT TIMESTAMP設定）
        └── CICS LINK
              ↓
            LGUPVS01（VSAMアクセス層）
              ├── READ FILE('KSDSPOLY') UPDATE
              └── REWRITE FILE('KSDSPOLY')
```

### データフロー図

```
[COMMAREA入力]
  CA-REQUEST-ID='01UEND'
  CA-CUSTOMER-NUM=顧客番号
  CA-POLICY-NUM=ポリシー番号
  CA-LASTCHANGED=前回取得タイムスタンプ（楽観的ロック用）
  CA-E-*=更新データ
        ↓
[LGUPOL01] リクエストID評価・長さチェック
        ↓
[LGUPDB01]
  ├── SELECT FOR UPDATE → ロック取得
  ├── タイムスタンプ比較
  │     ├── 一致 → 更新続行
  │     └── 不一致 → RC='02'で終了
  ├── UPDATE ENDOWMENT
  └── UPDATE POLICY SET LASTCHANGED = CURRENT TIMESTAMP
        ↓
[LGUPVS01] READ UPDATE → REWRITE
        ↓
[COMMAREA出力]
  CA-LASTCHANGED=新タイムスタンプ
  CA-RETURN-CODE='00'（成功）/'02'（競合）
```

### 関連ファイル一覧

| 種別 | ファイル名 | 説明 |
|------|-----------|------|
| COBOL | lgupol01.cbl | ビジネスロジック層 |
| COBOL | lgupdb01.cbl | Db2アクセス層（カーソル操作含む） |
| COBOL | lgupvs01.cbl | VSAMアクセス層 |
| COBOL | lgstsq.cbl | エラーログ出力 |
| COPYBOOK | lgcmarea.cpy | COMMAREA定義 |
| COPYBOOK | lgpolicy.cpy | ポリシー関連定義 |
| BMS | ssmap.bms | 画面定義（SSMAPM1） |
