# 機能設計書 F012-住宅保険登録

## 概要

本ドキュメントは、保険契約管理システムにおける住宅保険（House）ポリシーの新規登録機能について、その設計と仕様を詳細に記述したものである。

### 本機能の処理概要

住宅保険登録機能は、新規の住宅保険ポリシーをDb2データベースおよびVSAMファイルに登録する機能である。顧客番号と物件情報（物件種別、寝室数、評価額、住所情報など）を入力として受け取り、POLICYテーブルとHOUSEテーブルに新規レコードを作成し、同時にVSAMファイルにも同期登録を行う。

**業務上の目的・背景**：顧客が住宅保険に加入する際、物件情報と保険条件を登録して契約を成立させる必要がある。住宅保険は火災、盗難、自然災害などのリスクから住宅資産を保護するための商品であり、物件の評価額や種別によって保険料が決定される。本機能は、保険契約の迅速な締結と正確なデータ管理を実現する。

**機能の利用シーン**：オペレーターが住宅保険ポリシーメニュー画面（SSP3）からオプション2を選択し、顧客番号と物件情報を入力して登録を実行する。登録成功時は新規に採番されたポリシー番号が画面に表示される。

**主要な処理内容**：
1. コミュニケーションエリア（COMMAREA）から顧客番号・物件情報を受け取る
2. リクエストIDが'01AHOU'であることを検証する
3. LGAPDB01プログラムを呼び出してDb2のPOLICYテーブルに基本情報を登録
4. ポリシー番号を自動採番（IDENTITY_VAL_LOCAL）で取得
5. HOUSEテーブルに物件詳細情報を登録
6. LGAPVS01プログラムを呼び出してVSAMファイルにレコードを書き込む
7. 採番されたポリシー番号をCOMMAREAに設定して返却

**関連システム・外部連携**：Db2データベース（POLICYテーブル、HOUSEテーブル）およびVSAM KSDS ファイル（KSDSPOLY）と連携する。

**権限による制御**：本機能に対する特別な権限制御は実装されていない。CICSトランザクション実行権限により制御される。

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 4 | 住宅保険ポリシーメニュー画面 | 主機能 | オプション2選択時にLGAPOL01プログラムをCICS LINKで呼び出し、住宅保険ポリシーを新規作成する |

## 機能種別

CRUD操作（Create）

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| CA-REQUEST-ID | X(6) | Yes | リクエスト識別子（'01AHOU'） | '01AHOU'であること |
| CA-CUSTOMER-NUM | 9(10) | Yes | 顧客番号 | 数値10桁、既存顧客であること |
| CA-ISSUE-DATE | X(10) | Yes | 発効日 | 日付形式 |
| CA-EXPIRY-DATE | X(10) | Yes | 満期日 | 日付形式 |
| CA-BROKERID | 9(10) | No | ブローカーID | 数値10桁 |
| CA-BROKERSREF | X(10) | No | ブローカー参照番号 | - |
| CA-PAYMENT | 9(6) | No | 支払額 | 数値6桁 |
| CA-H-PROPERTY-TYPE | X(15) | Yes | 物件種別 | - |
| CA-H-BEDROOMS | 9(3) | Yes | 寝室数 | 数値3桁 |
| CA-H-VALUE | 9(8) | Yes | 物件評価額 | 数値8桁 |
| CA-H-HOUSE-NAME | X(20) | No | 物件名称 | - |
| CA-H-HOUSE-NUMBER | X(4) | No | 住居番号 | - |
| CA-H-POSTCODE | X(8) | Yes | 郵便番号 | - |

### 入力データソース

画面入力（住宅保険ポリシーメニュー画面 SSMAPP3）からCOMMARED経由でデータを受け取る。

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| CA-RETURN-CODE | 9(2) | 処理結果コード（00:正常、70:顧客不在、80:VSAMエラー、90:DB2エラー、98:長さ不足、99:リクエスト不正） |
| CA-POLICY-NUM | 9(10) | 新規採番されたポリシー番号 |
| CA-LASTCHANGED | X(26) | 最終更新タイムスタンプ |

### 出力先

- Db2 POLICYテーブル（レコード挿入）
- Db2 HOUSEテーブル（レコード挿入）
- VSAM KSDSファイル（KSDSPOLY）（レコード書き込み）
- エラー時：一時ストレージキュー（GENAERRS）へエラーメッセージ出力

## 処理フロー

### 処理シーケンス

```
1. LGAPOL01: メイン処理開始
   └─ COMMARCAの検証（長さ、リクエストID）
2. LGAPOL01: LGAPDB01プログラム呼び出し
   └─ CICS LINKでDb2登録処理を実行
3. LGAPDB01: リクエストIDの検証
   └─ '01AHOU'であることを確認、ポリシータイプ='H'を設定
4. LGAPDB01: POLICYテーブルへINSERT
   └─ ポリシー番号は自動採番（DEFAULT）
5. LGAPDB01: 採番されたポリシー番号取得
   └─ IDENTITY_VAL_LOCAL()で取得
6. LGAPDB01: HOUSEテーブルへINSERT
   └─ 物件詳細情報を登録
7. LGAPDB01: LGAPVS01プログラム呼び出し
   └─ CICS LINKでVSAM登録処理を実行
8. LGAPVS01: VSAMファイルへレコード書き込み
   └─ CICS WRITE FILEコマンド実行
9. 呼び出し元へリターン
   └─ ポリシー番号とリターンコードを返却
```

### フローチャート

```mermaid
flowchart TD
    A[開始] --> B{COMMARCAを受信?}
    B -->|No| C[ABEND 'LGCA']
    B -->|Yes| D{REQUEST-ID = '01AHOU'?}
    D -->|No| E[RC='99' で終了]
    D -->|Yes| F{COMMARCA長さ十分?}
    F -->|No| G[RC='98' で終了]
    F -->|Yes| H[POLICYテーブルINSERT]
    H --> I{SQLCODE = 0?}
    I -->|SQLCODE=-530| J[RC='70' 顧客不在]
    I -->|Other Error| K[RC='90' エラー記録]
    I -->|Yes| L[ポリシー番号取得]
    L --> M[HOUSEテーブルINSERT]
    M --> N{SQLCODE = 0?}
    N -->|No| O[ABEND 'LGSQ' ロールバック]
    N -->|Yes| P[LGAPVS01呼び出し]
    P --> Q[VSAM WRITE]
    Q --> R{RESP = NORMAL?}
    R -->|No| S[RC='80' エラー記録]
    R -->|Yes| T[RC='00']
    J --> U[終了]
    K --> U
    O --> U
    S --> U
    T --> U
    E --> U
    G --> U
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-012-1 | 顧客存在確認 | 登録する顧客が既存であること | 常時（外部キー制約） |
| BR-012-2 | ポリシー自動採番 | ポリシー番号はシステムで自動採番 | 常時 |
| BR-012-3 | タイムスタンプ自動設定 | LASTCHANGED列は現在時刻で自動設定 | 常時 |
| BR-012-4 | ポリシータイプ設定 | 住宅保険は'H'タイプで登録 | 常時 |

### 計算ロジック

特別な計算ロジックは存在しない。入力値はそのまま登録される。

## データベース操作仕様

### 操作別データベース影響一覧

| 操作 | 対象テーブル | 操作種別 | 概要 |
|-----|-------------|---------|------|
| 登録 | POLICY | INSERT | ポリシー基本情報を登録 |
| 登録 | HOUSE | INSERT | 物件詳細情報を登録 |
| 書込 | KSDSPOLY | WRITE | VSAMファイルにレコード登録 |

### テーブル別操作詳細

#### POLICY

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| INSERT | POLICYNUMBER | DEFAULT（自動採番） | IDENTITY列 |
| INSERT | CUSTOMERNUMBER | :CA-CUSTOMER-NUM | 顧客番号 |
| INSERT | ISSUEDATE | :CA-ISSUE-DATE | 発効日 |
| INSERT | EXPIRYDATE | :CA-EXPIRY-DATE | 満期日 |
| INSERT | POLICYTYPE | 'H' | 住宅保険 |
| INSERT | LASTCHANGED | CURRENT TIMESTAMP | 自動設定 |
| INSERT | BROKERID | :CA-BROKERID | ブローカーID |
| INSERT | BROKERSREFERENCE | :CA-BROKERSREF | ブローカー参照 |
| INSERT | PAYMENT | :CA-PAYMENT | 支払額 |

#### HOUSE

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| INSERT | POLICYNUMBER | :採番されたポリシー番号 | 外部キー |
| INSERT | PROPERTYTYPE | :CA-H-PROPERTY-TYPE | 物件種別 |
| INSERT | BEDROOMS | :CA-H-BEDROOMS | 寝室数 |
| INSERT | VALUE | :CA-H-VALUE | 評価額 |
| INSERT | HOUSENAME | :CA-H-HOUSE-NAME | 物件名称 |
| INSERT | HOUSENUMBER | :CA-H-HOUSE-NUMBER | 住居番号 |
| INSERT | POSTCODE | :CA-H-POSTCODE | 郵便番号 |

#### KSDSPOLY（VSAMファイル）

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| WRITE | キー | 'H' + 顧客番号 + ポリシー番号 | キー長21バイト |
| WRITE | データ | 物件種別、寝室数、評価額、郵便番号、物件名称 | 43バイト |

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| 70 | 顧客不在 | SQLCODE=-530（外部キー違反） | 顧客登録を先に実施 |
| 80 | VSAM書込エラー | CICS WRITE FILEでRESP≠NORMAL | エラーログ記録 |
| 90 | DB2登録エラー | SQLCODE≠0 | エラーログ記録、ABEND発行 |
| 98 | COMMAREA長不足 | EIBCALEN < 必要長 | 呼び出し元で対処 |
| 99 | リクエスト不正 | CA-REQUEST-IDが無効 | 呼び出し元で対処 |
| LGCA | ABEND | COMMARCAなし | システム異常 |
| LGSQ | ABEND | HOUSEテーブルINSERT失敗 | POLICYテーブル更新をロールバック |

### リトライ仕様

リトライ処理は実装されていない。エラー発生時はABENDまたはエラーコードを返却する。

## トランザクション仕様

- トランザクション境界：LGAPDB01内でPOLICYとHOUSEのINSERTを同一トランザクションで実行
- コミット：呼び出し元で正常終了時に暗黙的コミット
- ロールバック：HOUSE INSERT失敗時はABEND('LGSQ')でロールバック
- 呼び出し元（LGTESTP3）でもCA-RETURN-CODE > 0の場合にSYNCPOINT ROLLBACK実行

## パフォーマンス要件

- レスポンス時間：通常1秒以内
- POLICYテーブルへのINSERTとポリシー番号採番が連続して実行される
- VSAM WRITEはキーによる直接アクセス

## セキュリティ考慮事項

- CICSトランザクションセキュリティによるアクセス制御
- エラー発生時のログ記録（GENAERRS一時ストレージキュー）
- 顧客情報は外部キー制約により整合性を確保

## 備考

- 住宅保険（House Insurance）は、住宅とその内容物を火災、盗難、自然災害などから保護する保険商品
- ポリシー番号はDb2のIDENTITY列機能を使用して自動採番される
- POLICYとHOUSEテーブルは外部キー関係にあり、データ整合性が保証される
- VSAMファイルはDb2と同期して登録されるが、VSAM書込失敗時のロールバック処理は実装されていない

## コードリーディングガイド

本機能を理解するための推奨コードリーディング順序を示す。

### 推奨リーディング順序

| Step | ファイル | パス | 読むべきポイント |
|------|---------|------|-----------------|
| 1 | lgcmarea.cpy | base/src/lgcmarea.cpy | CA-REQUEST-ID、CA-CUSTOMER-NUM、CA-H-*（住宅保険固有フィールド）のデータ構造を把握 |
| 2 | lgpolicy.cpy | base/src/lgpolicy.cpy | WS-FULL-HOUSE-LEN（102バイト）、DB2ホスト変数の定義を確認 |
| 3 | lgapol01.cbl | base/src/lgapol01.cbl | ビジネスロジック層のエントリポイント、COMMAREA検証 |
| 4 | lgapdb01.cbl | base/src/lgapdb01.cbl | Db2アクセス層、POLICY/HOUSEテーブルINSERT |
| 5 | lgapvs01.cbl | base/src/lgapvs01.cbl | VSAMアクセス層、KSDSPOLYファイルへの書き込み |
| 6 | lgstsq.cbl | base/src/lgstsq.cbl | エラーログ出力処理 |

### Step別詳細ガイド

#### Step 1: データ構造の理解（lgcmarea.cpy）
**読むべき箇所**: ファイル全体

住宅保険登録で使用する主要フィールド:
- `CA-REQUEST-ID`: '01AHOU'（住宅保険登録を示す識別子）
- `CA-CUSTOMER-NUM`: 登録対象の顧客番号
- `CA-H-PROPERTY-TYPE`: 物件種別
- `CA-H-BEDROOMS`: 寝室数
- `CA-H-VALUE`: 物件評価額
- `CA-H-HOUSE-NAME`: 物件名称
- `CA-H-HOUSE-NUMBER`: 住居番号
- `CA-H-POSTCODE`: 郵便番号

#### Step 2: エントリポイントの理解（lgapol01.cbl）
**読むべき箇所**: 98-124行目

```
98-102行目: COMMAREA存在チェック
  - COMMAREAがない場合はABEND('LGCA')

109行目: 必要COMMAREA長の計算開始
  - WS-CA-HEADER-LEN（28バイト）を加算

113-116行目: 長さチェック
  - 不足時はRC='98'で終了

121-124行目: LGAPDB01呼び出し
  - CICS LINKでDb2アクセス層を呼び出し
```

#### Step 3: Db2アクセス層の理解（lgapdb01.cbl）
**読むべき箇所**: 184-260行目、398-467行目

```
184-207行目: リクエストID評価と長さ計算
  - '01AHOU'の場合: WS-FULL-HOUSE-LEN（102バイト）を加算
  - DB2-POLICYTYPE = 'H'（House）を設定

210-213行目: COMMAREA長チェック
  - 不足時はRC='98'で終了

219行目: INSERT-POLICY実行

223-241行目: ポリシータイプ別処理
  - '01AHOU'の場合、INSERT-HOUSE（232行目）を実行

243-246行目: LGAPVS01呼び出し
  - VSAM書き込み層を呼び出し

261-322行目: INSERT-POLICY手続き
  - 268-288行目: POLICYテーブルINSERT（IDENTITY列で自動採番）
  - 290-305行目: SQLCODE判定（-530=FK違反→RC='70'）
  - 308-311行目: IDENTITY_VAL_LOCAL()でポリシー番号取得
  - 316-321行目: LASTCHANGED取得

398-467行目: INSERT-HOUSE手続き（住宅保険固有）
  - 400-401行目: 数値フィールドの整数変換
    - CA-H-BEDROOMS → DB2-H-BEDROOMS-SINT
    - CA-H-VALUE → DB2-H-VALUE-INT
  - 404-418行目: INSERT INTO HOUSE
    - PROPERTYTYPE, BEDROOMS, VALUE, HOUSENAME, HOUSENUMBER, POSTCODE
  - 420-426行目: エラー時ABEND('LGSQ')でロールバック
```

#### Step 4: VSAMアクセス層の理解（lgapvs01.cbl）
**読むべき箇所**: 99-147行目

```
99-101行目: キー設定
  - WF-Request-ID: リクエストIDの4文字目（'H'）
  - WF-Customer-Num: 顧客番号
  - WF-Policy-Num: ポリシー番号

103-132行目: ポリシータイプ別データ設定
  - 117-122行目: 'H'（House）の場合
    - WF-H-PROPERTY-TYPE, WF-H-BEDROOMS等を設定

135-147行目: VSAM書き込み
  - EXEC CICS WRITE FILE('KSDSPOLY')
  - 64バイト固定長でレコード書き込み
  - エラー時はRC='80'を設定
```

#### Step 5: エラーログの理解（lgstsq.cbl）
**読むべき箇所**: 各プログラムのWRITE-ERROR-MESSAGE段落

各プログラムでエラー発生時にLGSTSQを呼び出してログを記録:
- lgapol01.cbl: 137-169行目
- lgapdb01.cbl: 562-595行目
- lgapvs01.cbl: 155-188行目

### プログラム呼出し階層

```
SSMAPP3（住宅保険ポリシーメニュー画面）
  ↓ オプション2選択
LGAPOL01（ビジネスロジック層）
  ├── COMMAREA検証
  └── CICS LINK
        ↓
      LGAPDB01（Db2アクセス層）
        ├── INSERT-POLICY（POLICYテーブル）
        │     └── IDENTITY_VAL_LOCAL()でポリシー番号取得
        ├── INSERT-HOUSE（HOUSEテーブル）
        └── CICS LINK
              ↓
            LGAPVS01（VSAMアクセス層）
              └── CICS WRITE FILE('KSDSPOLY')
```

### データフロー図

```
[COMMAREA入力]
  CA-REQUEST-ID='01AHOU'
  CA-CUSTOMER-NUM=顧客番号
  CA-H-PROPERTY-TYPE, CA-H-BEDROOMS, CA-H-VALUE等
        ↓
[LGAPOL01] COMMAREA検証
        ↓
[LGAPDB01]
  ├── INSERT INTO POLICY → ポリシー番号自動採番
  └── INSERT INTO HOUSE
        ↓
[LGAPVS01] WRITE FILE('KSDSPOLY')
        ↓
[COMMAREA出力]
  CA-POLICY-NUM=採番されたポリシー番号
  CA-LASTCHANGED=タイムスタンプ
  CA-RETURN-CODE='00'（成功）
```

### 関連ファイル一覧

| 種別 | ファイル名 | 説明 |
|------|-----------|------|
| COBOL | lgapol01.cbl | ビジネスロジック層 |
| COBOL | lgapdb01.cbl | Db2アクセス層 |
| COBOL | lgapvs01.cbl | VSAMアクセス層 |
| COBOL | lgstsq.cbl | エラーログ出力 |
| COPYBOOK | lgcmarea.cpy | COMMAREA定義 |
| COPYBOOK | lgpolicy.cpy | ポリシー関連定義（長さ定数含む） |
| BMS | ssmap.bms | 画面定義（SSMAPP3） |
