# 機能設計書 F013-住宅保険照会

## 概要

本ドキュメントは、保険契約管理システムにおける住宅保険（House）ポリシーの照会機能について、その設計と仕様を詳細に記述したものである。

### 本機能の処理概要

住宅保険照会機能は、既存の住宅保険ポリシー情報をDb2データベースから取得し、画面に表示する機能である。顧客番号とポリシー番号を指定することで、該当するポリシーの基本情報と物件詳細情報を取得し、COMMARCAを通じて呼び出し元に返却する。

**業務上の目的・背景**：保険契約の内容確認、更新作業の事前確認、顧客問い合わせ対応など、日常的な業務において契約内容の参照は必須である。本機能は、保険契約の詳細情報を迅速に取得し、業務効率の向上と顧客サービスの質的向上を実現する。

**機能の利用シーン**：オペレーターが住宅保険ポリシーメニュー画面（SSP3）からオプション1を選択し、顧客番号とポリシー番号を指定して照会を実行する。また、オプション4（更新）の前処理としても内部的に呼び出される。

**主要な処理内容**：
1. コミュニケーションエリア（COMMAREA）から顧客番号・ポリシー番号を受け取る
2. リクエストIDが'01IHOU'であることを検証する
3. LGIPDB01プログラムを呼び出してDb2から情報を取得
4. POLICYテーブルとHOUSEテーブルをJOINしてデータを取得
5. 取得したデータをCOMMAREAにセットして返却

**関連システム・外部連携**：Db2データベース（POLICYテーブル、HOUSEテーブル）と連携する。

**権限による制御**：本機能に対する特別な権限制御は実装されていない。CICSトランザクション実行権限により制御される。

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 4 | 住宅保険ポリシーメニュー画面 | 主機能 | オプション1選択時にLGIPOL01プログラムをCICS LINKで呼び出し、ポリシー詳細を照会・表示する |

## 機能種別

CRUD操作（Read）

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| CA-REQUEST-ID | X(6) | Yes | リクエスト識別子（'01IHOU'） | '01IHOU'であること |
| CA-CUSTOMER-NUM | 9(10) | Yes | 顧客番号 | 数値10桁 |
| CA-POLICY-NUM | 9(10) | Yes | ポリシー番号 | 数値10桁 |

### 入力データソース

画面入力（住宅保険ポリシーメニュー画面 SSMAPP3）からCOMMARED経由でデータを受け取る。

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| CA-RETURN-CODE | 9(2) | 処理結果コード（00:正常、01:データなし、90:DB2エラー、98:長さ不足、99:リクエスト不正） |
| CA-ISSUE-DATE | X(10) | 発効日 |
| CA-EXPIRY-DATE | X(10) | 満期日 |
| CA-LASTCHANGED | X(26) | 最終更新タイムスタンプ |
| CA-BROKERID | 9(10) | ブローカーID |
| CA-BROKERSREF | X(10) | ブローカー参照番号 |
| CA-PAYMENT | 9(6) | 支払額 |
| CA-H-PROPERTY-TYPE | X(15) | 物件種別 |
| CA-H-BEDROOMS | 9(3) | 寝室数 |
| CA-H-VALUE | 9(8) | 物件評価額 |
| CA-H-HOUSE-NAME | X(20) | 物件名称 |
| CA-H-HOUSE-NUMBER | X(4) | 住居番号 |
| CA-H-POSTCODE | X(8) | 郵便番号 |

### 出力先

- COMMARCA（呼び出し元プログラムへデータ返却）
- エラー時：一時ストレージキュー（GENAERRS）へエラーメッセージ出力

## 処理フロー

### 処理シーケンス

```
1. LGIPOL01: メイン処理開始
   └─ COMMARCAの検証（存在確認）
2. LGIPOL01: LGIPDB01プログラム呼び出し
   └─ CICS LINKでDb2照会処理を実行
3. LGIPDB01: リクエストIDの検証
   └─ '01IHOU'であることを確認
4. LGIPDB01: POLICYとHOUSEテーブルをJOINしてSELECT
   └─ 顧客番号とポリシー番号を条件に検索
5. LGIPDB01: 取得データをCOMMAREAに設定
   └─ 数値型の変換処理を含む
6. LGIPDB01: 終了マーカー設定
   └─ 'FINAL'を設定
7. 呼び出し元へリターン
   └─ リターンコードと取得データを返却
```

### フローチャート

```mermaid
flowchart TD
    A[開始] --> B{COMMARCAを受信?}
    B -->|No| C[ABEND 'LGCA']
    B -->|Yes| D[LGIPDB01呼び出し]
    D --> E{REQUEST-ID = '01IHOU'?}
    E -->|No| F[RC='99' で終了]
    E -->|Yes| G[POLICY/HOUSE JOIN SELECT]
    G --> H{SQLCODE = 0?}
    H -->|SQLCODE=100| I[RC='01' データなし]
    H -->|Other Error| J[RC='90' エラー記録]
    H -->|Yes| K{COMMARCA長さ十分?}
    K -->|No| L[RC='98' で終了]
    K -->|Yes| M[データをCOMMAREAに設定]
    M --> N['FINAL'マーカー設定]
    N --> O[RC='00']
    I --> P[終了]
    J --> P
    L --> P
    O --> P
    F --> P
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-013-1 | ポリシー存在確認 | 指定されたポリシーが存在すること | SQLCODE≠100 |
| BR-013-2 | NULL値処理 | BROKERID、BROKERSREF、PAYMENTはNULL許容 | インジケータ変数で判定 |
| BR-013-3 | 終了マーカー | データ末尾に'FINAL'を設定 | 正常取得時 |

### 計算ロジック

計算ロジックは存在しない。Db2から取得した値をそのままCOMMAREAに設定する。

## データベース操作仕様

### 操作別データベース影響一覧

| 操作 | 対象テーブル | 操作種別 | 概要 |
|-----|-------------|---------|------|
| 照会 | POLICY | SELECT | ポリシー基本情報を取得 |
| 照会 | HOUSE | SELECT | 物件詳細情報を取得（JOIN） |

### テーブル別操作詳細

#### POLICY（JOIN）

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| SELECT | ISSUEDATE | 取得 | 発効日 |
| SELECT | EXPIRYDATE | 取得 | 満期日 |
| SELECT | LASTCHANGED | 取得 | 最終更新日時 |
| SELECT | BROKERID | 取得（NULL可） | ブローカーID |
| SELECT | BROKERSREFERENCE | 取得（NULL可） | ブローカー参照 |
| SELECT | PAYMENT | 取得（NULL可） | 支払額 |

#### HOUSE（JOIN）

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| SELECT | PROPERTYTYPE | 取得 | 物件種別 |
| SELECT | BEDROOMS | 取得 | 寝室数 |
| SELECT | VALUE | 取得 | 評価額 |
| SELECT | HOUSENAME | 取得 | 物件名称 |
| SELECT | HOUSENUMBER | 取得 | 住居番号 |
| SELECT | POSTCODE | 取得 | 郵便番号 |

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| 01 | データなし | SQLCODE=100 | 顧客番号・ポリシー番号を確認 |
| 90 | DB2照会エラー | SQLCODE≠0かつ≠100 | エラーログ記録 |
| 98 | COMMAREA長不足 | EIBCALEN < 必要長 | 呼び出し元で対処 |
| 99 | リクエスト不正 | CA-REQUEST-IDが無効 | 呼び出し元で対処 |
| LGCA | ABEND | COMMARCAなし | システム異常 |

### リトライ仕様

リトライ処理は実装されていない。エラー発生時は即座にエラーコードを返却する。

## トランザクション仕様

- 照会のみのため、トランザクション管理は不要
- 読み取り専用アクセス

## パフォーマンス要件

- レスポンス時間：通常1秒以内
- POLICY.POLICYNUMBER、HOUSE.POLICYNUMBERインデックスを使用
- 単一レコード取得のため、パフォーマンス問題は発生しにくい

## セキュリティ考慮事項

- CICSトランザクションセキュリティによるアクセス制御
- 顧客情報の参照履歴は記録されない
- 読み取り専用のため、データ改ざんリスクなし

## 備考

- POLICYテーブルとHOUSEテーブルはPOLICYNUMBERでJOIN
- NULL値が含まれる可能性のある項目はインジケータ変数で判定
- データ取得後、数値型からCOBOL数値型への変換処理が行われる

## コードリーディングガイド

本機能を理解するための推奨コードリーディング順序を示す。

### 推奨リーディング順序

| Step | ファイル | パス | 読むべきポイント |
|------|---------|------|-----------------|
| 1 | lgcmarea.cpy | base/src/lgcmarea.cpy | CA-REQUEST-ID、CA-CUSTOMER-NUM、CA-POLICY-NUM、CA-H-*（住宅保険フィールド）のデータ構造を把握 |
| 2 | lgpolicy.cpy | base/src/lgpolicy.cpy | DB2-HOUSE構造体、WS-FULL-HOUSE-LEN定義を確認 |
| 3 | lgipol01.cbl | base/src/lgipol01.cbl | ビジネスロジック層のエントリポイント |
| 4 | lgipdb01.cbl | base/src/lgipdb01.cbl | Db2アクセス層、POLICY/HOUSE JOIN SELECT、NULL処理 |
| 5 | lgstsq.cbl | base/src/lgstsq.cbl | エラーログ出力処理 |

### Step別詳細ガイド

#### Step 1: データ構造の理解（lgcmarea.cpy）
**読むべき箇所**: ファイル全体

住宅保険照会で使用する主要フィールド:
- `CA-REQUEST-ID`: '01IHOU'（住宅保険照会を示す識別子）
- `CA-CUSTOMER-NUM`: 照会対象の顧客番号
- `CA-POLICY-NUM`: 照会対象のポリシー番号
- `CA-H-PROPERTY-TYPE`: 物件種別（出力）
- `CA-H-BEDROOMS`: 寝室数（出力）
- `CA-H-VALUE`: 物件評価額（出力）
- `CA-H-HOUSE-NAME`: 物件名称（出力）
- `CA-H-HOUSE-NUMBER`: 住居番号（出力）
- `CA-H-POSTCODE`: 郵便番号（出力）

#### Step 2: エントリポイントの理解（lgipol01.cbl）
**読むべき箇所**: 79-96行目

```
79-83行目: COMMAREA存在チェック
  - COMMAREAがない場合はABEND('LGCA')

86-88行目: 初期化
  - CA-RETURN-CODE = '00'

91-94行目: LGIPDB01呼び出し
  - CICS LINKでDb2アクセス層を呼び出し（32500バイトCOMMAREA）
```

#### Step 3: Db2アクセス層の理解（lgipdb01.cbl）
**読むべき箇所**: 251-310行目、441-523行目

```
251-255行目: COMMAREA存在チェック
  - COMMAREAがない場合はABEND('LGCA')

263-267行目: データ変換
  - CA-CUSTOMER-NUM → DB2-CUSTOMERNUM-INT
  - CA-POLICY-NUM → DB2-POLICYNUM-INT

275行目: リクエストIDの大文字変換
  - FUNCTION UPPER-CASE(CA-REQUEST-ID)

277-310行目: リクエストID評価
  - '01IHOU'の場合: GET-HOUSE-DB2-INFO実行（285行目）

441-523行目: GET-HOUSE-DB2-INFO手続き（住宅保険照会の核心）
  - 444-476行目: POLICY/HOUSE JOIN SELECT
    - ISSUEDATE, EXPIRYDATE, LASTCHANGED（POLICYから）
    - BROKERID, BROKERSREF, PAYMENT（NULL許容、インジケータ使用）
    - PROPERTYTYPE, BEDROOMS, VALUE, HOUSENAME, HOUSENUMBER, POSTCODE（HOUSEから）

  - 478行目: SQLCODE判定
    - 0: 成功
    - 100: データなし（RC='01'）
    - その他: エラー（RC='90'）

  - 482-483行目: 必要COMMAREA長の計算
    - WS-CA-HEADERTRAILER-LEN + WS-FULL-HOUSE-LEN

  - 487-489行目: COMMAREA長チェック
    - 不足時はRC='98'で終了

  - 494-501行目: データ移動
    - NULLチェック（インジケータ変数 ≠ -1）
    - 数値型変換（BEDROOMS, VALUE）
    - DB2-POLICY-COMMON → CA-POLICY-COMMON
    - DB2-HOUSE → CA-HOUSE

  - 508行目: データ終端マーク
    - 'FINAL'をCA-H-FILLER(1:5)に設定
```

#### Step 4: インジケータ変数の理解（lgipdb01.cbl）
**読むべき箇所**: 203-205行目

```
203-205行目: インジケータ変数定義
  - IND-BROKERID: BROKERID列のNULL判定
  - IND-BROKERSREF: BROKERSREFERENCE列のNULL判定
  - IND-PAYMENT: PAYMENT列のNULL判定

使用方法:
  - インジケータ = -1: 値はNULL
  - インジケータ ≠ -1: 値は有効
```

#### Step 5: エラーログの理解（lgstsq.cbl）
**読むべき箇所**: 各プログラムのWRITE-ERROR-MESSAGE段落

各プログラムでエラー発生時にLGSTSQを呼び出してログを記録:
- lgipol01.cbl: 107-139行目
- lgipdb01.cbl: 997-1030行目

### プログラム呼出し階層

```
SSMAPP3（住宅保険ポリシーメニュー画面）
  ↓ オプション1選択
LGIPOL01（ビジネスロジック層）
  ├── COMMAREA検証
  └── CICS LINK
        ↓
      LGIPDB01（Db2アクセス層）
        ├── リクエストID大文字変換
        ├── リクエストID評価（'01IHOU'）
        └── GET-HOUSE-DB2-INFO
              ├── SELECT POLICY JOIN HOUSE
              ├── NULLインジケータ処理
              ├── 数値型変換
              └── 'FINAL'マーク設定
```

### データフロー図

```
[COMMAREA入力]
  CA-REQUEST-ID='01IHOU'
  CA-CUSTOMER-NUM=顧客番号
  CA-POLICY-NUM=ポリシー番号
        ↓
[LGIPOL01] COMMAREA検証
        ↓
[LGIPDB01]
  ├── リクエストID大文字変換
  └── SELECT FROM POLICY, HOUSE
        WHERE POLICY.POLICYNUMBER = HOUSE.POLICYNUMBER
          AND CUSTOMERNUMBER = ? AND POLICYNUMBER = ?
        ↓
[COMMAREA出力]
  CA-ISSUE-DATE, CA-EXPIRY-DATE（発効日、満期日）
  CA-LASTCHANGED（タイムスタンプ）
  CA-BROKERID, CA-BROKERSREF, CA-PAYMENT（NULL許容）
  CA-H-PROPERTY-TYPE, CA-H-BEDROOMS, CA-H-VALUE（物件情報）
  CA-H-HOUSE-NAME, CA-H-HOUSE-NUMBER, CA-H-POSTCODE
  + 'FINAL'マーク
  CA-RETURN-CODE='00'（成功）
```

### 関連ファイル一覧

| 種別 | ファイル名 | 説明 |
|------|-----------|------|
| COBOL | lgipol01.cbl | ビジネスロジック層 |
| COBOL | lgipdb01.cbl | Db2アクセス層 |
| COBOL | lgstsq.cbl | エラーログ出力 |
| COPYBOOK | lgcmarea.cpy | COMMAREA定義 |
| COPYBOOK | lgpolicy.cpy | ポリシー関連定義（DB2-HOUSE含む） |
| BMS | ssmap.bms | 画面定義（SSMAPP3） |
