# 機能設計書 F014-住宅保険更新

## 概要

本ドキュメントは、保険契約管理システムにおける住宅保険（House）ポリシーの更新機能について、その設計と仕様を詳細に記述したものである。

### 本機能の処理概要

住宅保険更新機能は、既存の住宅保険ポリシー情報をDb2データベースおよびVSAMファイルで更新する機能である。顧客番号とポリシー番号を指定し、物件情報（物件種別、寝室数、評価額、住所情報など）の変更内容を反映する。楽観的ロック機構により同時更新の整合性を確保する。

**業務上の目的・背景**：保険契約期間中に物件の改築、評価額の見直し、住所変更などが発生した場合、契約内容を更新する必要がある。本機能は、既存契約の変更を効率的に処理し、最新の情報をデータベースに反映させることで、正確な契約管理を実現する。

**機能の利用シーン**：オペレーターが住宅保険ポリシーメニュー画面（SSP3）からオプション4を選択すると、まず現在のポリシー情報が照会・表示される。その後、オペレーターが内容を編集し、再度画面を送信すると更新処理が実行される。

**主要な処理内容**：
1. コミュニケーションエリア（COMMAREA）から顧客番号・ポリシー番号・更新情報を受け取る
2. リクエストIDが'01UHOU'であることを検証する
3. LGUPDB01プログラムを呼び出してDb2の更新処理を実行
4. SELECT FOR UPDATEでPOLICYテーブルのレコードをロック
5. タイムスタンプ検証で楽観的ロックを実施
6. HOUSEテーブルの物件情報を更新
7. POLICYテーブルの基本情報を更新（新しいタイムスタンプを設定）
8. LGUPVS01プログラムを呼び出してVSAMファイルを更新

**関連システム・外部連携**：Db2データベース（POLICYテーブル、HOUSEテーブル）およびVSAM KSDS ファイル（KSDSPOLY）と連携する。

**権限による制御**：本機能に対する特別な権限制御は実装されていない。CICSトランザクション実行権限により制御される。

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 4 | 住宅保険ポリシーメニュー画面 | 主機能 | オプション4選択時にまずLGIPOL01で照会後、LGUPOL01プログラムをCICS LINKで呼び出し、ポリシーを更新する |

## 機能種別

CRUD操作（Update）

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| CA-REQUEST-ID | X(6) | Yes | リクエスト識別子（'01UHOU'） | '01UHOU'であること |
| CA-CUSTOMER-NUM | 9(10) | Yes | 顧客番号 | 数値10桁 |
| CA-POLICY-NUM | 9(10) | Yes | ポリシー番号 | 数値10桁 |
| CA-LASTCHANGED | X(26) | Yes | 最終更新タイムスタンプ（楽観的ロック用） | 照会時の値と一致 |
| CA-ISSUE-DATE | X(10) | Yes | 発効日 | 日付形式 |
| CA-EXPIRY-DATE | X(10) | Yes | 満期日 | 日付形式 |
| CA-BROKERID | 9(10) | No | ブローカーID | 数値10桁 |
| CA-BROKERSREF | X(10) | No | ブローカー参照番号 | - |
| CA-PAYMENT | 9(6) | No | 支払額 | 数値6桁 |
| CA-H-PROPERTY-TYPE | X(15) | Yes | 物件種別 | - |
| CA-H-BEDROOMS | 9(3) | Yes | 寝室数 | 数値3桁 |
| CA-H-VALUE | 9(8) | Yes | 物件評価額 | 数値8桁 |
| CA-H-HOUSE-NAME | X(20) | No | 物件名称 | - |
| CA-H-HOUSE-NUMBER | X(4) | No | 住居番号 | - |
| CA-H-POSTCODE | X(8) | Yes | 郵便番号 | - |

### 入力データソース

画面入力（住宅保険ポリシーメニュー画面 SSMAPP3）からCOMMARED経由でデータを受け取る。

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| CA-RETURN-CODE | 9(2) | 処理結果コード（00:正常、01:データなし、02:タイムスタンプ不一致、90:DB2エラー、98:長さ不足、99:リクエスト不正） |
| CA-LASTCHANGED | X(26) | 更新後の最終更新タイムスタンプ |

### 出力先

- Db2 POLICYテーブル（レコード更新）
- Db2 HOUSEテーブル（レコード更新）
- VSAM KSDSファイル（KSDSPOLY）（レコード更新）
- エラー時：一時ストレージキュー（GENAERRS）へエラーメッセージ出力

## 処理フロー

### 処理シーケンス

```
1. LGUPOL01: メイン処理開始
   └─ COMMARCAの検証（長さ、リクエストID）
2. LGUPOL01: LGUPDB01プログラム呼び出し
   └─ CICS LINKでDb2更新処理を実行
3. LGUPDB01: POLICY_CURSOR OPEN
   └─ SELECT FOR UPDATEでレコードをロック
4. LGUPDB01: レコードFETCH
   └─ 現在のデータを取得
5. LGUPDB01: タイムスタンプ比較
   └─ CA-LASTCHANGED = DB2-LASTCHANGED を確認
6. LGUPDB01: HOUSEテーブルUPDATE
   └─ 物件情報を更新
7. LGUPDB01: POLICYテーブルUPDATE
   └─ 基本情報を更新、LASTCHANGED = CURRENT TIMESTAMP
8. LGUPDB01: 新しいタイムスタンプ取得
   └─ 更新後のLASTCHANGEDをSELECT
9. LGUPDB01: POLICY_CURSOR CLOSE
10. LGUPDB01: LGUPVS01プログラム呼び出し
    └─ CICS LINKでVSAM更新処理を実行
11. 呼び出し元へリターン
    └─ リターンコードと新タイムスタンプを返却
```

### フローチャート

```mermaid
flowchart TD
    A[開始] --> B{COMMARCAを受信?}
    B -->|No| C[ABEND 'LGCA']
    B -->|Yes| D{REQUEST-ID = '01UHOU'?}
    D -->|No| E[RC='99' で終了]
    D -->|Yes| F{COMMARCA長さ十分?}
    F -->|No| G[RC='98' で終了]
    F -->|Yes| H[POLICY_CURSOR OPEN]
    H --> I{OPEN成功?}
    I -->|SQLCODE=-913| J[RC='90' ロック競合]
    I -->|No| K[RC='90' エラー]
    I -->|Yes| L[POLICY_CURSOR FETCH]
    L --> M{FETCH成功?}
    M -->|SQLCODE=100| N[RC='01' データなし]
    M -->|No| O[RC='90' エラー]
    M -->|Yes| P{タイムスタンプ一致?}
    P -->|No| Q[RC='02' 競合検出]
    P -->|Yes| R[HOUSEテーブルUPDATE]
    R --> S{UPDATE成功?}
    S -->|No| T[RC='90' エラー]
    S -->|Yes| U[POLICYテーブルUPDATE]
    U --> V{UPDATE成功?}
    V -->|No| W[SYNCPOINT ROLLBACK]
    V -->|Yes| X[新タイムスタンプ取得]
    X --> Y[POLICY_CURSOR CLOSE]
    Y --> Z[LGUPVS01呼び出し]
    Z --> AA[RC='00']
    J --> BB[終了]
    K --> BB
    N --> BB
    O --> BB
    Q --> BB
    T --> BB
    W --> BB
    AA --> BB
    E --> BB
    G --> BB
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-014-1 | 楽観的ロック | 照会時のタイムスタンプと更新時のタイムスタンプが一致すること | 常時 |
| BR-014-2 | 排他ロック | SELECT FOR UPDATEでレコードをロック | 更新処理中 |
| BR-014-3 | タイムスタンプ自動更新 | 更新時にLASTCHANGEDが自動的に現在時刻に更新される | 常時 |
| BR-014-4 | ポリシー存在確認 | 更新対象のポリシーが存在すること | 常時 |

### 計算ロジック

特別な計算ロジックは存在しない。入力値で既存データを上書きする。

## データベース操作仕様

### 操作別データベース影響一覧

| 操作 | 対象テーブル | 操作種別 | 概要 |
|-----|-------------|---------|------|
| ロック | POLICY | SELECT FOR UPDATE | 排他ロックを取得 |
| 更新 | POLICY | UPDATE | ポリシー基本情報を更新 |
| 更新 | HOUSE | UPDATE | 物件詳細情報を更新 |
| 更新 | KSDSPOLY | REWRITE | VSAMファイルのレコード更新 |

### テーブル別操作詳細

#### POLICY

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| SELECT | ISSUEDATE, EXPIRYDATE, LASTCHANGED, BROKERID, BROKERSREFERENCE | ロック取得用 | FOR UPDATE |
| UPDATE | ISSUEDATE | :CA-ISSUE-DATE | 発効日 |
| UPDATE | EXPIRYDATE | :CA-EXPIRY-DATE | 満期日 |
| UPDATE | LASTCHANGED | CURRENT TIMESTAMP | 自動更新 |
| UPDATE | BROKERID | :CA-BROKERID | ブローカーID |
| UPDATE | BROKERSREFERENCE | :CA-BROKERSREF | ブローカー参照 |

#### HOUSE

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| UPDATE | PROPERTYTYPE | :CA-H-PROPERTY-TYPE | 物件種別 |
| UPDATE | BEDROOMS | :CA-H-BEDROOMS | 寝室数 |
| UPDATE | VALUE | :CA-H-VALUE | 評価額 |
| UPDATE | HOUSENAME | :CA-H-HOUSE-NAME | 物件名称 |
| UPDATE | HOUSENUMBER | :CA-H-HOUSE-NUMBER | 住居番号 |
| UPDATE | POSTCODE | :CA-H-POSTCODE | 郵便番号 |

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| 01 | データなし | SQLCODE=100 | 顧客番号・ポリシー番号を確認 |
| 02 | タイムスタンプ不一致 | CA-LASTCHANGED ≠ DB2-LASTCHANGED | 再照会して再更新 |
| 90 | DB2更新エラー | SQLCODE≠0 | エラーログ記録、ロールバック |
| 98 | COMMAREA長不足 | EIBCALEN < 必要長 | 呼び出し元で対処 |
| 99 | リクエスト不正 | CA-REQUEST-IDが無効 | 呼び出し元で対処 |
| LGCA | ABEND | COMMARCAなし | システム異常 |

### リトライ仕様

リトライ処理は実装されていない。タイムスタンプ不一致時は再照会・再更新が必要。

## トランザクション仕様

- トランザクション境界：SELECT FOR UPDATE からカーソルCLOSEまで
- コミット：呼び出し元で正常終了時に暗黙的コミット
- ロールバック：POLICY UPDATE失敗時にSYNCPOINT ROLLBACK
- カーソルはWITH HOLDで定義されているため、SYNCPOINT後もオープン状態

## パフォーマンス要件

- レスポンス時間：通常1秒以内
- SELECT FOR UPDATEによるロック待ち発生の可能性あり
- SQLCODE=-913（タイムアウト）の場合はRC='90'で返却

## セキュリティ考慮事項

- CICSトランザクションセキュリティによるアクセス制御
- 楽観的ロックにより同時更新の整合性を確保
- エラー発生時のログ記録（GENAERRS一時ストレージキュー）

## 備考

- 更新処理は2段階で実行される：まず照会（オプション1相当）、次に更新
- タイムスタンプ検証により、他ユーザーによる更新との競合を検出
- カーソル使用によりレコードレベルの排他制御を実現
- VSAM更新はDb2更新成功後に実行される

## コードリーディングガイド

本機能を理解するための推奨コードリーディング順序を示す。

### 推奨リーディング順序

| Step | ファイル | パス | 読むべきポイント |
|------|---------|------|-----------------|
| 1 | lgcmarea.cpy | base/src/lgcmarea.cpy | CA-REQUEST-ID、CA-LASTCHANGED、CA-H-*（住宅保険フィールド）のデータ構造を把握 |
| 2 | lgpolicy.cpy | base/src/lgpolicy.cpy | WS-FULL-HOUSE-LEN（102バイト）、DB2ホスト変数の定義を確認 |
| 3 | lgupol01.cbl | base/src/lgupol01.cbl | ビジネスロジック層のエントリポイント、リクエストID評価 |
| 4 | lgupdb01.cbl | base/src/lgupdb01.cbl | Db2アクセス層、カーソル操作、楽観的ロック、UPDATE処理 |
| 5 | lgupvs01.cbl | base/src/lgupvs01.cbl | VSAMアクセス層、KSDSPOLYファイル更新 |
| 6 | lgstsq.cbl | base/src/lgstsq.cbl | エラーログ出力処理 |

### Step別詳細ガイド

#### Step 1: データ構造の理解（lgcmarea.cpy）
**読むべき箇所**: ファイル全体

住宅保険更新で使用する主要フィールド:
- `CA-REQUEST-ID`: '01UHOU'（住宅保険更新を示す識別子）
- `CA-CUSTOMER-NUM`: 更新対象の顧客番号
- `CA-POLICY-NUM`: 更新対象のポリシー番号
- `CA-LASTCHANGED`: 楽観的ロック用タイムスタンプ（入力/出力両方）
- `CA-H-PROPERTY-TYPE`: 物件種別
- `CA-H-BEDROOMS`: 寝室数
- `CA-H-VALUE`: 物件評価額
- `CA-H-HOUSE-NAME`, `CA-H-HOUSE-NUMBER`, `CA-H-POSTCODE`

#### Step 2: エントリポイントの理解（lgupol01.cbl）
**読むべき箇所**: 99-147行目

```
99-103行目: COMMAREA存在チェック
  - COMMAREAがない場合はABEND('LGCA')

123-129行目: リクエストID評価と長さチェック
  - '01UHOU': WS-FULL-HOUSE-LEN（102バイト）を加算
  - 長さ不足時はRC='98'で終了

157-160行目: LGUPDB01呼び出し
  - CICS LINKでDb2アクセス層を呼び出し
```

#### Step 3: Db2アクセス層の理解（lgupdb01.cbl）
**読むべき箇所**: 128-143行目、251-381行目、424-454行目

```
128-143行目: POLICY_CURSORの宣言
  - DECLARE CURSOR WITH HOLD FOR ... FOR UPDATE

251-361行目: UPDATE-POLICY-DB2-INFO手続き
  - 255-270行目: OPEN POLICY_CURSOR
  - 273行目: FETCH-DB2-POLICY-ROW
  - 278行目: タイムスタンプ比較（楽観的ロック）
  - 283-300行目: リクエストID評価
    - '01UHOU'の場合: UPDATE-HOUSE-DB2-INFO（293行目）
  - 318-326行目: UPDATE POLICY
  - 329-334行目: 新タイムスタンプ取得

424-454行目: UPDATE-HOUSE-DB2-INFO手続き（住宅保険固有）
  - 427-428行目: 数値変換
    - CA-H-BEDROOMS → DB2-H-BEDROOMS-SINT
    - CA-H-VALUE → DB2-H-VALUE-INT
  - 431-442行目: UPDATE HOUSE
    - PROPERTYTYPE, BEDROOMS, VALUE, HOUSENAME, HOUSENUMBER, POSTCODE
```

#### Step 4: VSAMアクセス層の理解（lgupvs01.cbl）
**読むべき箇所**: 99-166行目

```
102-104行目: キー設定
  - WF-Request-ID: リクエストIDの4文字目（'H'）

106-135行目: ポリシータイプ別データ設定
  - 120-125行目: 'H'（House）の場合
    - WF-H-PROPERTY-TYPE, WF-H-BEDROOMS等を設定

139-166行目: READ UPDATE → REWRITE
```

#### Step 5: エラーログの理解（lgstsq.cbl）
**読むべき箇所**: 各プログラムのWRITE-ERROR-MESSAGE段落

### プログラム呼出し階層

```
SSMAPP3（住宅保険ポリシーメニュー画面）
  ↓ オプション4選択（編集後）
LGUPOL01（ビジネスロジック層）
  ├── リクエストID評価（'01UHOU'）
  └── CICS LINK
        ↓
      LGUPDB01（Db2アクセス層）
        ├── OPEN POLICY_CURSOR（SELECT FOR UPDATE）
        ├── FETCH → タイムスタンプ比較
        ├── UPDATE HOUSE
        ├── UPDATE POLICY（CURRENT TIMESTAMP）
        └── CICS LINK
              ↓
            LGUPVS01（VSAMアクセス層）
              ├── READ FILE UPDATE
              └── REWRITE FILE
```

### データフロー図

```
[COMMAREA入力]
  CA-REQUEST-ID='01UHOU'
  CA-CUSTOMER-NUM, CA-POLICY-NUM
  CA-LASTCHANGED（楽観的ロック用）
  CA-H-*（更新データ）
        ↓
[LGUPOL01] リクエストID評価
        ↓
[LGUPDB01]
  ├── SELECT FOR UPDATE → ロック取得
  ├── タイムスタンプ比較
  ├── UPDATE HOUSE
  └── UPDATE POLICY SET LASTCHANGED = CURRENT TIMESTAMP
        ↓
[LGUPVS01] READ UPDATE → REWRITE
        ↓
[COMMAREA出力]
  CA-LASTCHANGED=新タイムスタンプ
  CA-RETURN-CODE='00'/'02'（競合）
```

### 関連ファイル一覧

| 種別 | ファイル名 | 説明 |
|------|-----------|------|
| COBOL | lgupol01.cbl | ビジネスロジック層 |
| COBOL | lgupdb01.cbl | Db2アクセス層 |
| COBOL | lgupvs01.cbl | VSAMアクセス層 |
| COBOL | lgstsq.cbl | エラーログ出力 |
| COPYBOOK | lgcmarea.cpy | COMMAREA定義 |
| COPYBOOK | lgpolicy.cpy | ポリシー関連定義 |
| BMS | ssmap.bms | 画面定義（SSMAPP3） |
