# 機能設計書 F015-住宅保険削除

## 概要

本ドキュメントは、保険契約管理システムにおける住宅保険（House）ポリシーの削除機能について、その設計と仕様を詳細に記述したものである。

### 本機能の処理概要

住宅保険削除機能は、既存の住宅保険ポリシーレコードをDb2データベースおよびVSAMファイルから完全に削除する機能である。顧客番号とポリシー番号を指定することで、該当するポリシー情報を論理的・物理的に削除し、データの整合性を保ちながら契約終了処理を実行する。

**業務上の目的・背景**：保険契約が満期を迎えた場合、解約が行われた場合、または誤って登録されたポリシーを削除する必要がある場合に、本機能が使用される。ポリシー削除は契約管理業務において重要な機能であり、データベースの整合性を維持しながら不要なレコードを適切に処理することで、システムリソースの効率的な利用とデータ品質の維持を実現する。

**機能の利用シーン**：オペレーターが住宅保険ポリシーメニュー画面（SSP3）からオプション3を選択し、顧客番号とポリシー番号を指定して削除を実行する。削除前に対象ポリシーの存在確認が行われ、正常に削除された場合は画面にメッセージが表示される。

**主要な処理内容**：
1. コミュニケーションエリア（COMMAREA）から顧客番号・ポリシー番号を受け取る
2. リクエストIDが'01DHOU'であることを検証する
3. LGDPDB01プログラムを呼び出してDb2のPOLICYテーブルからレコードを削除する
4. 外部キー制約によりHOUSEテーブルからも自動的に削除される
5. LGDPVS01プログラムを呼び出してVSAMファイル（KSDSPOLY）からレコードを削除する
6. 処理結果をリターンコードとして返却する

**関連システム・外部連携**：Db2データベース（POLICYテーブル、HOUSEテーブル）およびVSAM KSDS ファイル（KSDSPOLY）と連携する。

**権限による制御**：本機能に対する特別な権限制御は実装されていない。CICSトランザクション実行権限により制御される。

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 4 | 住宅保険ポリシーメニュー画面 | 主機能 | オプション3選択時にLGDPOL01プログラムをCICS LINKで呼び出し、ポリシーを削除する |

## 機能種別

CRUD操作（Delete）

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| CA-REQUEST-ID | X(6) | Yes | リクエスト識別子（'01DHOU'） | '01DHOU'であること |
| CA-CUSTOMER-NUM | 9(10) | Yes | 顧客番号 | 数値10桁 |
| CA-POLICY-NUM | 9(10) | Yes | ポリシー番号 | 数値10桁 |

### 入力データソース

画面入力（住宅保険ポリシーメニュー画面 SSMAPP3）からCOMMARED経由でデータを受け取る。

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| CA-RETURN-CODE | 9(2) | 処理結果コード（00:正常、81:VSAMエラー、90:DB2エラー、99:リクエスト不正） |

### 出力先

- Db2 POLICYテーブル（レコード削除）
- Db2 HOUSEテーブル（外部キー制約による連鎖削除）
- VSAM KSDSファイル（KSDSPOLY）（レコード削除）
- エラー時：一時ストレージキュー（GENAERRS）へエラーメッセージ出力

## 処理フロー

### 処理シーケンス

```
1. LGDPOL01: メイン処理開始
   └─ COMMARCAの検証（長さ、リクエストID）
2. LGDPOL01: リクエストIDの検証
   └─ '01DHOU'であることを確認
3. LGDPOL01: LGDPDB01プログラム呼び出し
   └─ CICS LINKでDb2削除処理を実行
4. LGDPDB01: Db2 POLICYテーブルから削除
   └─ DELETE文実行、外部キーによりHOUSEも削除
5. LGDPDB01: LGDPVS01プログラム呼び出し
   └─ CICS LINKでVSAM削除処理を実行
6. LGDPVS01: VSAMファイルからレコード削除
   └─ CICS DELETE FILEコマンド実行
7. 呼び出し元へリターン
   └─ リターンコードを設定して終了
```

### フローチャート

```mermaid
flowchart TD
    A[開始] --> B{COMMARCAを受信?}
    B -->|No| C[ABEND 'LGCA']
    B -->|Yes| D{COMMARCA長さ >= 28?}
    D -->|No| E[RC='98' で終了]
    D -->|Yes| F{REQUEST-ID = '01DHOU'?}
    F -->|No| G[RC='99' で終了]
    F -->|Yes| H[LGDPDB01呼び出し]
    H --> I[DB2 POLICYテーブル DELETE]
    I --> J{SQLCODE = 0?}
    J -->|No| K[RC='90' エラー記録]
    J -->|Yes| L[LGDPVS01呼び出し]
    L --> M[VSAM KSDSPOLY DELETE]
    M --> N{RESP = NORMAL?}
    N -->|No| O[RC='81' エラー記録]
    N -->|Yes| P[RC='00']
    K --> Q[終了]
    O --> Q
    P --> Q
    E --> Q
    G --> Q
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-015-1 | ポリシー存在確認 | 削除対象のポリシーが存在すること | 常時 |
| BR-015-2 | 外部キー連鎖削除 | POLICYテーブル削除時にHOUSEも自動削除 | Db2外部キー制約による |
| BR-015-3 | 二重削除許容 | SQLCODE=100（レコード不在）も正常終了扱い | Db2削除時 |

### 計算ロジック

削除機能のため、計算ロジックは存在しない。

## データベース操作仕様

### 操作別データベース影響一覧

| 操作 | 対象テーブル | 操作種別 | 概要 |
|-----|-------------|---------|------|
| 削除 | POLICY | DELETE | 顧客番号・ポリシー番号を条件にレコード削除 |
| 削除 | HOUSE | DELETE | 外部キー制約による連鎖削除 |
| 削除 | KSDSPOLY | DELETE | VSAMファイルからレコード削除 |

### テーブル別操作詳細

#### POLICY

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| DELETE | - | CUSTOMERNUMBER = :顧客番号 AND POLICYNUMBER = :ポリシー番号 | 削除条件 |

#### HOUSE

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| DELETE | - | POLICYNUMBER（外部キー） | POLICYテーブル削除に連動 |

#### KSDSPOLY（VSAMファイル）

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| DELETE | - | キー: リクエストID(1) + 顧客番号(10) + ポリシー番号(10) | キー長21バイト |

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| 81 | VSAM削除エラー | CICS DELETE FILEでRESP≠NORMAL | エラーログ記録、ロールバック検討 |
| 90 | DB2削除エラー | SQLCODE≠0かつ≠100 | エラーログ記録、処理中止 |
| 98 | COMMAREA長不足 | EIBCALEN < 28 | 呼び出し元で対処 |
| 99 | リクエスト不正 | CA-REQUEST-IDが無効 | 呼び出し元で対処 |
| LGCA | ABEND | COMMARCAなし | システム異常 |

### リトライ仕様

リトライ処理は実装されていない。エラー発生時は即座にエラーコードを返却する。

## トランザクション仕様

- トランザクション境界：呼び出し元プログラム（LGTESTP3）で制御
- コミット：呼び出し元で正常終了時に暗黙的コミット
- ロールバック：呼び出し元でCA-RETURN-CODE > 0の場合にSYNCPOINT ROLLBACK実行
- Db2とVSAMの両方を更新するため、一貫性確保が重要

## パフォーマンス要件

- レスポンス時間：通常1秒以内
- Db2 DELETEはPOLICYNUMBERインデックスを使用
- VSAM DELETEはキーによる直接アクセス

## セキュリティ考慮事項

- CICSトランザクションセキュリティによるアクセス制御
- エラー発生時のログ記録（GENAERRS一時ストレージキュー）
- 物理削除のため、削除後のデータ復旧は不可

## 備考

- 住宅保険（House Insurance）は住宅資産を保護するための保険商品
- Db2の外部キー制約を活用した連鎖削除により、データ整合性を自動的に確保
- VSAMファイルはDb2と同期して削除されるが、Db2削除が失敗してもVSAM削除は試行されない設計

## コードリーディングガイド

本機能を理解するための推奨コードリーディング順序を示す。

### 推奨リーディング順序

| Step | ファイル | パス | 読むべきポイント |
|------|---------|------|-----------------|
| 1 | lgcmarea.cpy | base/src/lgcmarea.cpy | CA-REQUEST-ID、CA-CUSTOMER-NUM、CA-POLICY-NUM、CA-RETURN-CODEのデータ構造を把握 |
| 2 | lgpolicy.cpy | base/src/lgpolicy.cpy | DB2-CUSTOMERNUM-INT、DB2-POLICYNUM-INTの定義を確認 |
| 3 | lgdpol01.cbl | base/src/lgdpol01.cbl | ビジネスロジック層のエントリポイント、UPPER-CASE変換とリクエストID検証 |
| 4 | lgdpdb01.cbl | base/src/lgdpdb01.cbl | Db2アクセス層、DELETE SQLの実行とLGDPVS01の呼び出し |
| 5 | lgdpvs01.cbl | base/src/lgdpvs01.cbl | VSAMアクセス層、KSDSPOLYファイルからのレコード削除 |
| 6 | lgstsq.cbl | base/src/lgstsq.cbl | エラーログ出力処理 |

### Step別詳細ガイド

#### Step 1: データ構造の理解（lgcmarea.cpy）
**読むべき箇所**: ファイル全体

削除処理で使用する主要フィールド:
- `CA-REQUEST-ID`: '01DHOU'（住宅保険削除を示す識別子）
- `CA-CUSTOMER-NUM`: 削除対象の顧客番号
- `CA-POLICY-NUM`: 削除対象のポリシー番号
- `CA-RETURN-CODE`: 処理結果（'00'=成功, '81'=VSAMエラー, '90'=DBエラー等）

#### Step 2: エントリポイントの理解（lgdpol01.cbl）
**読むべき箇所**: 95-144行目

```
95-99行目: COMMAREA存在チェック
  - COMMAREAがない場合はABEND('LGCA')

117行目: リクエストIDの大文字変換
  - FUNCTION UPPER-CASE(CA-REQUEST-ID)

119-130行目: リクエストID検証
  - '01DHOU'を含む削除リクエストを処理
  - 検証OKならLGDPDB01を呼び出し
```

#### Step 3: Db2アクセス層の理解（lgdpdb01.cbl）
**読むべき箇所**: 148-204行目

```
148-153行目: データ変換
  - CA-CUSTOMER-NUM → DB2-CUSTOMERNUM-INT
  - CA-POLICY-NUM → DB2-POLICYNUM-INT

160-172行目: リクエストID検証とVSAM呼び出し
  - 検証OKならDELETE-POLICY-DB2-INFO実行後、LGDPVS01を呼び出し

186-204行目: DELETE-POLICY-DB2-INFO
  - DELETE FROM POLICY WHERE CUSTOMERNUMBER = ? AND POLICYNUMBER = ?
  - 外部キー制約によりHOUSEテーブルも連動して削除
```

#### Step 4: VSAMアクセス層の理解（lgdpvs01.cbl）
**読むべき箇所**: 77-91行目

```
77-79行目: キー設定
  - WF-Request-ID: リクエストIDの4文字目（'H'）
  - WF-Customer-Num, WF-Policy-Num

81-91行目: VSAM削除
  - EXEC CICS DELETE FILE('KSDSPOLY')
  - Ridfld(WF-Policy-Key): 21バイトキー
```

### プログラム呼出し階層

```
SSMAPP3（住宅保険ポリシーメニュー画面）
  ↓ オプション3選択
LGDPOL01（ビジネスロジック層）
  ├── リクエストID検証（'01DHOU'）
  └── CICS LINK
        ↓
      LGDPDB01（Db2アクセス層）
        ├── DELETE FROM POLICY（FK制約でHOUSEも削除）
        └── CICS LINK
              ↓
            LGDPVS01（VSAMアクセス層）
              └── CICS DELETE FILE('KSDSPOLY')
```

### データフロー図

```
[COMMAREA入力]
  CA-REQUEST-ID='01DHOU'
  CA-CUSTOMER-NUM=顧客番号
  CA-POLICY-NUM=ポリシー番号
        ↓
[LGDPOL01] リクエストID検証・大文字変換
        ↓
[LGDPDB01] DELETE FROM POLICY → FK制約でHOUSEも削除
        ↓
[LGDPVS01] DELETE FILE('KSDSPOLY')
        ↓
[COMMAREA出力]
  CA-RETURN-CODE='00'/'81'/'90'
```

### 関連ファイル一覧

| 種別 | ファイル名 | 説明 |
|------|-----------|------|
| COBOL | lgdpol01.cbl | ビジネスロジック層 |
| COBOL | lgdpdb01.cbl | Db2アクセス層 |
| COBOL | lgdpvs01.cbl | VSAMアクセス層 |
| COBOL | lgstsq.cbl | エラーログ出力 |
| COPYBOOK | lgcmarea.cpy | COMMAREA定義 |
| COPYBOOK | lgpolicy.cpy | ポリシー関連定義 |
| BMS | ssmap.bms | 画面定義（SSMAPP3） |
