# 機能設計書 F016-商業用不動産保険登録

## 概要

本ドキュメントは、保険契約管理システムにおける商業用不動産保険（Commercial）ポリシーの新規登録機能について、その設計と仕様を詳細に記述したものである。

### 本機能の処理概要

商業用不動産保険登録機能は、新規の商業用不動産保険ポリシーをDb2データベースおよびVSAMファイルに登録する機能である。顧客番号と物件情報（住所、郵便番号、緯度経度、物件タイプ）および各種リスク保険料（火災、犯罪、洪水、気象）を入力として受け取り、POLICYテーブルとCOMMERCIALテーブルに新規レコードを作成し、同時にVSAMファイルにも同期登録を行う。

**業務上の目的・背景**：企業や事業者が所有する商業用不動産に対して、火災、犯罪、洪水、気象災害などの複合リスクをカバーする保険を提供する。本機能は、多岐にわたるリスク要素を個別に評価・登録し、包括的な商業保険契約の締結を支援する。

**機能の利用シーン**：オペレーターが商業用不動産保険ポリシーメニュー画面（SSP4）からオプション2を選択し、顧客番号と物件情報・リスク保険料を入力して登録を実行する。登録成功時は新規に採番されたポリシー番号が画面に表示される。

**主要な処理内容**：
1. コミュニケーションエリア（COMMAREA）から顧客番号・物件情報・リスク保険料を受け取る
2. リクエストIDが'01ACOM'であることを検証する
3. LGAPDB01プログラムを呼び出してDb2のPOLICYテーブルに基本情報を登録
4. ポリシー番号を自動採番（IDENTITY_VAL_LOCAL）で取得
5. COMMERCIALテーブルに物件詳細情報とリスク保険料を登録
6. LGAPVS01プログラムを呼び出してVSAMファイルにレコードを書き込む
7. 採番されたポリシー番号をCOMMAREAに設定して返却

**関連システム・外部連携**：Db2データベース（POLICYテーブル、COMMERCIALテーブル）およびVSAM KSDS ファイル（KSDSPOLY）と連携する。

**権限による制御**：本機能に対する特別な権限制御は実装されていない。CICSトランザクション実行権限により制御される。

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 5 | 商業用不動産保険ポリシーメニュー画面 | 主機能 | オプション2選択時にLGAPOL01プログラムをCICS LINKで呼び出し、商業用不動産保険ポリシーを新規作成する |

## 機能種別

CRUD操作（Create）

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| CA-REQUEST-ID | X(6) | Yes | リクエスト識別子（'01ACOM'） | '01ACOM'であること |
| CA-CUSTOMER-NUM | 9(10) | Yes | 顧客番号 | 数値10桁、既存顧客であること |
| CA-ISSUE-DATE | X(10) | Yes | 発効日（StartDate） | 日付形式 |
| CA-EXPIRY-DATE | X(10) | Yes | 満期日（RenewalDate） | 日付形式 |
| CA-B-Address | X(255) | Yes | 物件住所 | - |
| CA-B-Postcode | X(8) | Yes | 郵便番号 | - |
| CA-B-Latitude | X(11) | No | 緯度 | - |
| CA-B-Longitude | X(11) | No | 経度 | - |
| CA-B-Customer | X(255) | No | 顧客名 | - |
| CA-B-PropType | X(255) | No | 物件タイプ | - |
| CA-B-FirePeril | 9(4) | No | 火災リスク | 数値4桁 |
| CA-B-FirePremium | 9(8) | No | 火災保険料 | 数値8桁 |
| CA-B-CrimePeril | 9(4) | No | 犯罪リスク | 数値4桁 |
| CA-B-CrimePremium | 9(8) | No | 犯罪保険料 | 数値8桁 |
| CA-B-FloodPeril | 9(4) | No | 洪水リスク | 数値4桁 |
| CA-B-FloodPremium | 9(8) | No | 洪水保険料 | 数値8桁 |
| CA-B-WeatherPeril | 9(4) | No | 気象リスク | 数値4桁 |
| CA-B-WeatherPremium | 9(8) | No | 気象保険料 | 数値8桁 |
| CA-B-Status | 9(4) | No | ステータス | 数値4桁 |
| CA-B-RejectReason | X(255) | No | 拒否理由 | - |

### 入力データソース

画面入力（商業用不動産保険ポリシーメニュー画面 SSMAPP4）からCOMMARED経由でデータを受け取る。

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| CA-RETURN-CODE | 9(2) | 処理結果コード（00:正常、70:顧客不在、80:VSAMエラー、90:DB2エラー、98:長さ不足、99:リクエスト不正） |
| CA-POLICY-NUM | 9(10) | 新規採番されたポリシー番号 |
| CA-LASTCHANGED | X(26) | 最終更新タイムスタンプ（RequestDate） |

### 出力先

- Db2 POLICYテーブル（レコード挿入）
- Db2 COMMERCIALテーブル（レコード挿入）
- VSAM KSDSファイル（KSDSPOLY）（レコード書き込み）
- エラー時：一時ストレージキュー（GENAERRS）へエラーメッセージ出力

## 処理フロー

### 処理シーケンス

```
1. LGAPOL01: メイン処理開始
   └─ COMMARCAの検証（長さ、リクエストID）
2. LGAPOL01: LGAPDB01プログラム呼び出し
   └─ CICS LINKでDb2登録処理を実行
3. LGAPDB01: リクエストIDの検証
   └─ '01ACOM'であることを確認、ポリシータイプ='C'を設定
4. LGAPDB01: POLICYテーブルへINSERT
   └─ ポリシー番号は自動採番（DEFAULT）
5. LGAPDB01: 採番されたポリシー番号取得
   └─ IDENTITY_VAL_LOCAL()で取得
6. LGAPDB01: COMMERCIALテーブルへINSERT
   └─ 物件詳細情報とリスク保険料を登録
7. LGAPDB01: LGAPVS01プログラム呼び出し
   └─ CICS LINKでVSAM登録処理を実行
8. LGAPVS01: VSAMファイルへレコード書き込み
   └─ CICS WRITE FILEコマンド実行
9. 呼び出し元へリターン
   └─ ポリシー番号とリターンコードを返却
```

### フローチャート

```mermaid
flowchart TD
    A[開始] --> B{COMMARCAを受信?}
    B -->|No| C[ABEND 'LGCA']
    B -->|Yes| D{REQUEST-ID = '01ACOM'?}
    D -->|No| E[RC='99' で終了]
    D -->|Yes| F{COMMARCA長さ十分?}
    F -->|No| G[RC='98' で終了]
    F -->|Yes| H[POLICYテーブルINSERT]
    H --> I{SQLCODE = 0?}
    I -->|SQLCODE=-530| J[RC='70' 顧客不在]
    I -->|Other Error| K[RC='90' エラー記録]
    I -->|Yes| L[ポリシー番号取得]
    L --> M[COMMERCIALテーブルINSERT]
    M --> N{SQLCODE = 0?}
    N -->|No| O[ABEND 'LGSQ' ロールバック]
    N -->|Yes| P[LGAPVS01呼び出し]
    P --> Q[VSAM WRITE]
    Q --> R{RESP = NORMAL?}
    R -->|No| S[RC='80' エラー記録]
    R -->|Yes| T[RC='00']
    J --> U[終了]
    K --> U
    O --> U
    S --> U
    T --> U
    E --> U
    G --> U
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-016-1 | 顧客存在確認 | 登録する顧客が既存であること | 常時（外部キー制約） |
| BR-016-2 | ポリシー自動採番 | ポリシー番号はシステムで自動採番 | 常時 |
| BR-016-3 | タイムスタンプ自動設定 | RequestDate（LASTCHANGED）は現在時刻で自動設定 | 常時 |
| BR-016-4 | ポリシータイプ設定 | 商業用不動産保険は'C'タイプで登録 | 常時 |
| BR-016-5 | 複合リスク保険料 | 火災、犯罪、洪水、気象の4種類のリスクを個別管理 | 常時 |

### 計算ロジック

特別な計算ロジックは存在しない。入力値はそのまま登録される。総保険料の計算は行われない。

## データベース操作仕様

### 操作別データベース影響一覧

| 操作 | 対象テーブル | 操作種別 | 概要 |
|-----|-------------|---------|------|
| 登録 | POLICY | INSERT | ポリシー基本情報を登録 |
| 登録 | COMMERCIAL | INSERT | 物件詳細情報とリスク保険料を登録 |
| 書込 | KSDSPOLY | WRITE | VSAMファイルにレコード登録 |

### テーブル別操作詳細

#### POLICY

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| INSERT | POLICYNUMBER | DEFAULT（自動採番） | IDENTITY列 |
| INSERT | CUSTOMERNUMBER | :CA-CUSTOMER-NUM | 顧客番号 |
| INSERT | ISSUEDATE | :CA-ISSUE-DATE | StartDate |
| INSERT | EXPIRYDATE | :CA-EXPIRY-DATE | RenewalDate |
| INSERT | POLICYTYPE | 'C' | 商業用不動産保険 |
| INSERT | LASTCHANGED | CURRENT TIMESTAMP | RequestDate |

#### COMMERCIAL

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| INSERT | POLICYNUMBER | :採番されたポリシー番号 | 外部キー |
| INSERT | Address | :CA-B-Address | 物件住所 |
| INSERT | Zipcode | :CA-B-Postcode | 郵便番号 |
| INSERT | LatitudeN | :CA-B-Latitude | 緯度 |
| INSERT | LongitudeW | :CA-B-Longitude | 経度 |
| INSERT | Customer | :CA-B-Customer | 顧客名 |
| INSERT | PropertyType | :CA-B-PropType | 物件タイプ |
| INSERT | FirePeril | :CA-B-FirePeril | 火災リスク |
| INSERT | FirePremium | :CA-B-FirePremium | 火災保険料 |
| INSERT | CrimePeril | :CA-B-CrimePeril | 犯罪リスク |
| INSERT | CrimePremium | :CA-B-CrimePremium | 犯罪保険料 |
| INSERT | FloodPeril | :CA-B-FloodPeril | 洪水リスク |
| INSERT | FloodPremium | :CA-B-FloodPremium | 洪水保険料 |
| INSERT | WeatherPeril | :CA-B-WeatherPeril | 気象リスク |
| INSERT | WeatherPremium | :CA-B-WeatherPremium | 気象保険料 |
| INSERT | Status | :CA-B-Status | ステータス |
| INSERT | RejectionReason | :CA-B-RejectReason | 拒否理由 |

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| 70 | 顧客不在 | SQLCODE=-530（外部キー違反） | 顧客登録を先に実施 |
| 80 | VSAM書込エラー | CICS WRITE FILEでRESP≠NORMAL | エラーログ記録 |
| 90 | DB2登録エラー | SQLCODE≠0 | エラーログ記録、ABEND発行 |
| 98 | COMMAREA長不足 | EIBCALEN < 必要長 | 呼び出し元で対処 |
| 99 | リクエスト不正 | CA-REQUEST-IDが無効 | 呼び出し元で対処 |
| LGCA | ABEND | COMMARCAなし | システム異常 |
| LGSQ | ABEND | COMMERCIALテーブルINSERT失敗 | POLICYテーブル更新をロールバック |

### リトライ仕様

リトライ処理は実装されていない。エラー発生時はABENDまたはエラーコードを返却する。

## トランザクション仕様

- トランザクション境界：LGAPDB01内でPOLICYとCOMMERCIALのINSERTを同一トランザクションで実行
- コミット：呼び出し元で正常終了時に暗黙的コミット
- ロールバック：COMMERCIAL INSERT失敗時はABEND('LGSQ')でロールバック
- 呼び出し元（LGTESTP4）でもCA-RETURN-CODE > 0の場合にSYNCPOINT ROLLBACK実行

## パフォーマンス要件

- レスポンス時間：通常1秒以内
- POLICYテーブルへのINSERTとポリシー番号採番が連続して実行される
- VSAM WRITEはキーによる直接アクセス

## セキュリティ考慮事項

- CICSトランザクションセキュリティによるアクセス制御
- エラー発生時のログ記録（GENAERRS一時ストレージキュー）
- 顧客情報は外部キー制約により整合性を確保

## 備考

- 商業用不動産保険（Commercial Property Insurance）は、事業用物件を複合リスクから保護する保険商品
- 4種類のリスク（火災、犯罪、洪水、気象）を個別に管理し、それぞれに保険料を設定可能
- COMMERCIALテーブルは大容量データ（住所255バイト、顧客名255バイト等）を格納
- ポリシー番号はDb2のIDENTITY列機能を使用して自動採番される

## コードリーディングガイド

本機能のソースコードを理解するための推奨リーディング順序を以下に示す。

### 推奨リーディング順序

| Step | ファイル | 行番号 | 内容 |
|------|----------|--------|------|
| 1 | base/src/lgcmarea.cpy | 全体 | COMMARCAデータ構造の定義 |
| 2 | base/src/lgpolicy.cpy | 全体 | POLICYおよびCOMMERCIAL関連データ項目 |
| 3 | base/src/lgapol01.cbl | 117-135 | リクエストID評価と大文字変換 |
| 4 | base/src/lgapdb01.cbl | 198, 234-235 | '01ACOM'の評価とINSERT-COMMERCIAL呼び出し |
| 5 | base/src/lgapdb01.cbl | 486-555 | INSERT-COMMERCIAL手続き |
| 6 | base/src/lgapvs01.cbl | 全体 | VSAMファイル書き込み処理 |
| 7 | base/src/lgstsq.cbl | 全体 | エラーログ出力処理 |

### Step別詳細ガイド

#### Step 1: COMMARCAデータ構造の理解
`lgcmarea.cpy`でCA-B-Address、CA-B-Postcode、CA-B-Latitude、CA-B-Longitude、CA-B-Customer、CA-B-PropType（物件情報）およびCA-B-FirePeril/Premium、CA-B-CrimePeril/Premium、CA-B-FloodPeril/Premium、CA-B-WeatherPeril/Premium（4種類のリスク保険料）の構造を確認。

#### Step 2: POLICYデータ構造の理解
`lgpolicy.cpy`で商業用不動産保険固有の拡張フィールド（複合リスク項目）の定義を確認。

#### Step 3: リクエストID評価（lgapol01.cbl:117-135）
```cobol
EVALUATE TRUE
  WHEN FUNCTION UPPER-CASE(CA-REQUEST-ID) = '01ACOM'
```
大文字変換後、'01ACOM'（商業用不動産保険登録）を識別してLGAPDB01を呼び出す。

#### Step 4: ポリシータイプ設定と分岐（lgapdb01.cbl:198, 234-235）
```cobol
WHEN '01ACOM'
  MOVE 'C' TO DB2-POLICYTYPE
  ...
WHEN '01ACOM'
  PERFORM INSERT-COMMERCIAL
```
商業用不動産保険はポリシータイプ'C'として登録。

#### Step 5: INSERT-COMMERCIAL手続き（lgapdb01.cbl:486-555）
```cobol
INSERT-COMMERCIAL.
    MOVE CA-B-FirePeril       To DB2-B-FirePeril-Int
    MOVE CA-B-FirePremium     To DB2-B-FirePremium-Int
    MOVE CA-B-CrimePeril      To DB2-B-CrimePeril-Int
    MOVE CA-B-CrimePremium    To DB2-B-CrimePremium-Int
    MOVE CA-B-FloodPeril      To DB2-B-FloodPeril-Int
    MOVE CA-B-FloodPremium    To DB2-B-FloodPremium-Int
    MOVE CA-B-WeatherPeril    To DB2-B-WeatherPeril-Int
    MOVE CA-B-WeatherPremium  To DB2-B-WeatherPremium-Int
    MOVE CA-B-Status          To DB2-B-Status-Int

    EXEC SQL
      INSERT INTO COMMERCIAL
                (PolicyNumber, RequestDate, StartDate, RenewalDate,
                 Address, Zipcode, LatitudeN, LongitudeW,
                 Customer, PropertyType,
                 FirePeril, FirePremium, CrimePeril, CrimePremium,
                 FloodPeril, FloodPremium, WeatherPeril, WeatherPremium,
                 Status, RejectionReason)
      VALUES (:DB2-POLICYNUM-INT, :CA-LASTCHANGED, ...)
    END-EXEC
```
4種類のリスク項目（火災、犯罪、洪水、気象）それぞれにPeril（リスク）とPremium（保険料）をINSERT。

#### Step 6: VSAM書き込み処理（lgapvs01.cbl）
登録情報をVSAM KSDSファイル（KSDSPOLY）に同期書き込み。

### プログラム呼出し階層

```
LGTESTP4（メニュー画面）
  └─ LGAPOL01（業務ロジック層）
       └─ LGAPDB01（DB2アクセス層）
            ├─ INSERT-POLICY（POLICYテーブル）
            ├─ INSERT-COMMERCIAL（COMMERCIALテーブル）
            └─ LGAPVS01（VSAMアクセス層）
                 └─ CICS WRITE FILE('KSDSPOLY')
```

### データフロー図

```
[CA-CUSTOMER-NUM]      ──┐
[CA-ISSUE-DATE]        ──┼──→ [POLICY INSERT]
[CA-EXPIRY-DATE]       ──┘           │
                                     ↓
                         [IDENTITY_VAL_LOCAL()]
                                     │
[CA-B-Address/Postcode]──┐           ↓
[CA-B-Latitude/Longitude]┼──→ [COMMERCIAL INSERT]
[CA-B-Customer/PropType] │
[CA-B-FirePeril/Premium] │
[CA-B-CrimePeril/Premium]│
[CA-B-FloodPeril/Premium]│
[CA-B-WeatherPeril/Premium]
[CA-B-Status/RejectReason]
                                     │
                                     ↓
                          [VSAM WRITE KSDSPOLY]
```

### 関連ファイル一覧

| ファイル | 種別 | 説明 |
|----------|------|------|
| lgcmarea.cpy | COPY句 | COMMARCAデータ構造定義 |
| lgpolicy.cpy | COPY句 | ポリシーデータ構造定義 |
| lgapol01.cbl | COBOL | 業務ロジック層（登録） |
| lgapdb01.cbl | COBOL | DB2アクセス層（登録） |
| lgapvs01.cbl | COBOL | VSAMアクセス層（登録） |
| lgstsq.cbl | COBOL | エラーログ出力 |
| lgtestp4.cbl | COBOL | 商業用不動産保険メニュー画面 |
