# 機能設計書 F017-商業用不動産保険照会

## 概要

本ドキュメントは、保険契約管理システムにおける商業用不動産保険（Commercial）ポリシーの照会機能について、その設計と仕様を詳細に記述したものである。

### 本機能の処理概要

商業用不動産保険照会機能は、既存の商業用不動産保険ポリシー情報をDb2データベースから取得し、画面に表示する機能である。複数の検索モードをサポートし、顧客番号とポリシー番号の組み合わせ、ポリシー番号のみ、顧客番号のみ、または郵便番号による検索が可能である。

**業務上の目的・背景**：商業用不動産保険は複数の物件や複雑なリスク構成を持つため、柔軟な検索機能が必要である。本機能は、様々な条件での契約照会を可能にし、営業担当者や保険審査員が効率的に契約情報にアクセスできるよう支援する。

**機能の利用シーン**：オペレーターが商業用不動産保険ポリシーメニュー画面（SSP4）からオプション1を選択し、検索条件（顧客番号、ポリシー番号、郵便番号のいずれか）を指定して照会を実行する。

**主要な処理内容**：
1. コミュニケーションエリア（COMMAREA）から検索条件を受け取る
2. リクエストIDにより検索モードを判定（01ICOM/02ICOM/03ICOM/05ICOM）
3. LGIPDB01プログラムを呼び出してDb2から情報を取得
4. 検索モードに応じてPOLICYテーブルとCOMMERCIALテーブルからデータを取得
5. 取得したデータをCOMMAREAにセットして返却

**関連システム・外部連携**：Db2データベース（POLICYテーブル、COMMERCIALテーブル）と連携する。

**権限による制御**：本機能に対する特別な権限制御は実装されていない。CICSトランザクション実行権限により制御される。

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 5 | 商業用不動産保険ポリシーメニュー画面 | 主機能 | オプション1選択時にLGIPOL01プログラムをCICS LINKで呼び出し、ポリシー詳細を照会・表示する |

## 機能種別

CRUD操作（Read）

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| CA-REQUEST-ID | X(6) | Yes | リクエスト識別子（'01ICOM'/'02ICOM'/'03ICOM'/'05ICOM'） | 有効なリクエストIDであること |
| CA-CUSTOMER-NUM | 9(10) | Conditional | 顧客番号 | 01ICOM/03ICOMで必須 |
| CA-POLICY-NUM | 9(10) | Conditional | ポリシー番号 | 01ICOM/02ICOMで必須 |
| CA-B-Postcode | X(8) | Conditional | 郵便番号 | 05ICOMで必須 |

### 検索モード

| リクエストID | 検索モード | 検索条件 |
|-------------|----------|---------|
| 01ICOM | 単一ポリシー照会 | 顧客番号 + ポリシー番号 |
| 02ICOM | ポリシー番号照会 | ポリシー番号のみ |
| 03ICOM | 顧客別一覧照会 | 顧客番号のみ（カーソル使用） |
| 05ICOM | 郵便番号照会 | 郵便番号（カーソル使用） |

### 入力データソース

画面入力（商業用不動産保険ポリシーメニュー画面 SSMAPP4）からCOMMARED経由でデータを受け取る。

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| CA-RETURN-CODE | 9(2) | 処理結果コード（00:正常、01:データなし、88:カーソルCLOSEエラー、89:カーソルOPENエラー、90:DB2エラー、98:長さ不足、99:リクエスト不正） |
| CA-CUSTOMER-NUM | 9(10) | 顧客番号（02ICOM/03ICOM/05ICOMで取得） |
| CA-POLICY-NUM | 9(10) | ポリシー番号（03ICOM/05ICOMで取得） |
| CA-ISSUE-DATE | X(10) | 発効日（StartDate） |
| CA-EXPIRY-DATE | X(10) | 満期日（RenewalDate） |
| CA-LASTCHANGED | X(26) | 最終更新タイムスタンプ（RequestDate） |
| CA-B-Address | X(255) | 物件住所 |
| CA-B-Postcode | X(8) | 郵便番号 |
| CA-B-Latitude | X(11) | 緯度 |
| CA-B-Longitude | X(11) | 経度 |
| CA-B-Customer | X(255) | 顧客名 |
| CA-B-PropType | X(255) | 物件タイプ |
| CA-B-FirePeril | 9(4) | 火災リスク |
| CA-B-FirePremium | 9(8) | 火災保険料 |
| CA-B-CrimePeril | 9(4) | 犯罪リスク |
| CA-B-CrimePremium | 9(8) | 犯罪保険料 |
| CA-B-FloodPeril | 9(4) | 洪水リスク |
| CA-B-FloodPremium | 9(8) | 洪水保険料 |
| CA-B-WeatherPeril | 9(4) | 気象リスク |
| CA-B-WeatherPremium | 9(8) | 気象保険料 |
| CA-B-Status | 9(4) | ステータス |
| CA-B-RejectReason | X(255) | 拒否理由 |

### 出力先

- COMMARCA（呼び出し元プログラムへデータ返却）
- エラー時：一時ストレージキュー（GENAERRS）へエラーメッセージ出力

## 処理フロー

### 処理シーケンス（01ICOM: 単一ポリシー照会）

```
1. LGIPOL01: メイン処理開始
   └─ COMMARCAの検証（存在確認）
2. LGIPOL01: LGIPDB01プログラム呼び出し
   └─ CICS LINKでDb2照会処理を実行
3. LGIPDB01: リクエストIDの検証
   └─ '01ICOM'であることを確認
4. LGIPDB01: POLICYとCOMMERCIALテーブルをJOINしてSELECT
   └─ 顧客番号とポリシー番号を条件に検索
5. LGIPDB01: 取得データをCOMMAREAに設定
   └─ 数値型の変換処理を含む
6. LGIPDB01: 終了マーカー設定
   └─ 'FINAL'を設定
7. 呼び出し元へリターン
   └─ リターンコードと取得データを返却
```

### 処理シーケンス（03ICOM: 顧客別一覧照会）

```
1. LGIPDB01: Cust_Cursorカーソル OPEN
   └─ 顧客番号で絞り込んだカーソル
2. LGIPDB01: FETCH処理をループ
   └─ 最大20件まで取得
3. LGIPDB01: 各レコードをCOMMAREAに設定
4. LGIPDB01: Cust_Cursorカーソル CLOSE
5. 呼び出し元へリターン
```

### フローチャート

```mermaid
flowchart TD
    A[開始] --> B{COMMARCAを受信?}
    B -->|No| C[ABEND 'LGCA']
    B -->|Yes| D[LGIPDB01呼び出し]
    D --> E{REQUEST-ID判定}
    E -->|01ICOM| F[単一SELECT実行]
    E -->|02ICOM| G[ポリシー番号のみSELECT]
    E -->|03ICOM| H[Cust_Cursor OPEN/FETCH]
    E -->|05ICOM| I[Zip_Cursor OPEN/FETCH]
    E -->|Other| J[RC='99' で終了]
    F --> K{SQLCODE = 0?}
    G --> K
    H --> L{カーソル処理成功?}
    I --> L
    K -->|SQLCODE=100| M[RC='01' データなし]
    K -->|Error| N[RC='90' エラー]
    K -->|Yes| O[データをCOMMAREAに設定]
    L -->|OPENエラー| P[RC='89']
    L -->|CLOSEエラー| Q[RC='88']
    L -->|Yes| O
    O --> R['FINAL'マーカー設定]
    R --> S[RC='00']
    M --> T[終了]
    N --> T
    P --> T
    Q --> T
    S --> T
    J --> T
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-017-1 | 検索モード自動判定 | 入力された条件により適切なリクエストIDを設定 | 画面レベル |
| BR-017-2 | 一覧照会上限 | 顧客別/郵便番号照会は最大20件まで | 03ICOM/05ICOM |
| BR-017-3 | 終了マーカー | データ末尾に'FINAL'を設定 | 正常取得時 |

### 計算ロジック

計算ロジックは存在しない。Db2から取得した値をそのままCOMMAREAに設定する。

## データベース操作仕様

### 操作別データベース影響一覧

| 操作 | 対象テーブル | 操作種別 | 概要 |
|-----|-------------|---------|------|
| 照会 | POLICY | SELECT | ポリシー基本情報を取得 |
| 照会 | COMMERCIAL | SELECT | 物件詳細情報・リスク保険料を取得（JOIN/Cursor） |

### カーソル定義

#### Cust_Cursor（03ICOM用）

```sql
DECLARE Cust_Cursor INSENSITIVE SCROLL CURSOR FOR
SELECT CustomerNumber, Policy.PolicyNumber, RequestDate, StartDate,
       RenewalDate, Address, Zipcode, LatitudeN, LongitudeW, Customer,
       PropertyType, FirePeril, FirePremium, CrimePeril, CrimePremium,
       FloodPeril, FloodPremium, WeatherPeril, WeatherPremium, Status,
       RejectionReason
FROM POLICY, COMMERCIAL
WHERE POLICY.POLICYNUMBER = COMMERCIAL.POLICYNUMBER
  AND Policy.CustomerNumber = :顧客番号
```

#### Zip_Cursor（05ICOM用）

```sql
DECLARE Zip_Cursor INSENSITIVE SCROLL CURSOR FOR
SELECT CustomerNumber, Policy.PolicyNumber, RequestDate, StartDate,
       RenewalDate, Address, Zipcode, LatitudeN, LongitudeW, Customer,
       PropertyType, FirePeril, FirePremium, CrimePeril, CrimePremium,
       FloodPeril, FloodPremium, WeatherPeril, WeatherPremium, Status,
       RejectionReason
FROM POLICY, COMMERCIAL
WHERE POLICY.POLICYNUMBER = COMMERCIAL.POLICYNUMBER
  AND Commercial.Zipcode = :郵便番号
```

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| 01 | データなし | SQLCODE=100 | 検索条件を確認 |
| 88 | カーソルCLOSEエラー | CLOSE文でSQLCODE≠0 | エラーログ記録 |
| 89 | カーソルOPENエラー | OPEN文でSQLCODE≠0 | エラーログ記録 |
| 90 | DB2照会エラー | SQLCODE≠0かつ≠100 | エラーログ記録 |
| 98 | COMMAREA長不足 | EIBCALEN < 必要長 | 呼び出し元で対処 |
| 99 | リクエスト不正 | CA-REQUEST-IDが無効 | 呼び出し元で対処 |
| LGCA | ABEND | COMMARCAなし | システム異常 |

### リトライ仕様

リトライ処理は実装されていない。エラー発生時は即座にエラーコードを返却する。

## トランザクション仕様

- 照会のみのため、トランザクション管理は不要
- 読み取り専用アクセス
- カーソル使用時もINSENSITIVE属性で一貫性を確保

## パフォーマンス要件

- レスポンス時間：通常1秒以内
- 一覧照会（03ICOM/05ICOM）は最大20件に制限してパフォーマンスを確保
- カーソルはINSENSITIVE SCROLL属性で効率的なアクセス

## セキュリティ考慮事項

- CICSトランザクションセキュリティによるアクセス制御
- 顧客情報の参照履歴は記録されない
- 読み取り専用のため、データ改ざんリスクなし

## 備考

- 4種類の検索モードをサポートする柔軟な照会機能
- 顧客別一覧と郵便番号検索はカーソルを使用して複数レコードを取得
- 一覧照会の件数制限（20件）は、画面表示領域およびCOMMAREAサイズに起因
- 数値型からCOBOL数値型への変換処理が行われる

## コードリーディングガイド

本機能のソースコードを理解するための推奨リーディング順序を以下に示す。

### 推奨リーディング順序

| Step | ファイル | 行番号 | 内容 |
|------|----------|--------|------|
| 1 | base/src/lgcmarea.cpy | 全体 | COMMARCAデータ構造の定義 |
| 2 | base/src/lgpolicy.cpy | 全体 | POLICYおよびCOMMERCIAL関連データ項目 |
| 3 | base/src/lgipol01.cbl | 全体 | 業務ロジック層エントリポイント |
| 4 | base/src/lgipdb01.cbl | 291-310 | リクエストID評価と処理分岐 |
| 5 | base/src/lgipdb01.cbl | 627-724 | GET-Commercial-DB2-INFO-1（単一照会） |
| 6 | base/src/lgipdb01.cbl | 730-809 | GET-Commercial-DB2-INFO-2（ポリシー番号照会） |
| 7 | base/src/lgstsq.cbl | 全体 | エラーログ出力処理 |

### Step別詳細ガイド

#### Step 1: COMMARCAデータ構造の理解
`lgcmarea.cpy`でCA-B-Address、CA-B-Postcode等の商業用不動産情報項目および4種類のリスク保険料（Fire/Crime/Flood/Weather）の構造を確認。

#### Step 2: POLICYデータ構造の理解
`lgpolicy.cpy`で商業用不動産保険固有の拡張フィールド定義を確認。

#### Step 3: 業務ロジック層（lgipol01.cbl）
LGIPDB01への単純なLINK呼び出しを確認。

#### Step 4: リクエストID評価（lgipdb01.cbl:291-310）
```cobol
WHEN '01ICOM'
  INITIALIZE DB2-COMMERCIAL
  PERFORM GET-COMMERCIAL-DB2-INFO-1

WHEN '02ICOM'
  INITIALIZE DB2-COMMERCIAL
  PERFORM GET-COMMERCIAL-DB2-INFO-2

WHEN '03ICOM'
  INITIALIZE DB2-COMMERCIAL
  PERFORM GET-COMMERCIAL-DB2-INFO-3

WHEN '05ICOM'
  INITIALIZE DB2-COMMERCIAL
  PERFORM GET-COMMERCIAL-DB2-INFO-5
```
4種類の検索モード（単一照会/ポリシー番号/顧客別一覧/郵便番号）を識別して処理を分岐。

#### Step 5: GET-Commercial-DB2-INFO-1（lgipdb01.cbl:627-724）
```cobol
GET-Commercial-DB2-INFO-1.
    EXEC SQL
      SELECT RequestDate, StartDate, RenewalDate,
             Address, Zipcode, LatitudeN, LongitudeW,
             Customer, PropertyType,
             FirePeril, FirePremium, CrimePeril, CrimePremium,
             FloodPeril, FloodPremium, WeatherPeril, WeatherPremium,
             Status, RejectionReason
      INTO  :DB2-LASTCHANGED, :DB2-ISSUEDATE, :DB2-EXPIRYDATE,
            :DB2-B-Address, :DB2-B-Postcode, ...
      FROM  POLICY,COMMERCIAL
      WHERE ( POLICY.POLICYNUMBER = COMMERCIAL.POLICYNUMBER
        AND   POLICY.CUSTOMERNUMBER = :DB2-CUSTOMERNUM-INT
        AND   POLICY.POLICYNUMBER = :DB2-POLICYNUM-INT )
    END-EXEC
```
顧客番号とポリシー番号で単一レコードを照会。4種類のリスク項目（FirePeril/Premium等）を全て取得。

#### Step 6: GET-Commercial-DB2-INFO-2（lgipdb01.cbl:730-809）
```cobol
GET-Commercial-DB2-INFO-2.
    EXEC SQL
      SELECT CustomerNumber, RequestDate, StartDate, RenewalDate,
             Address, Zipcode, LatitudeN, LongitudeW, Customer, PropertyType,
             FirePeril, FirePremium, CrimePeril, CrimePremium,
             FloodPeril, FloodPremium, WeatherPeril, WeatherPremium,
             Status, RejectionReason
      INTO  :DB2-CUSTOMERNUM-INT, :DB2-LASTCHANGED, ...
      FROM  POLICY,COMMERCIAL
      WHERE ( POLICY.POLICYNUMBER = COMMERCIAL.POLICYNUMBER
        AND   POLICY.POLICYNUMBER = :DB2-POLICYNUM-INT )
    END-EXEC
```
ポリシー番号のみで照会。顧客番号も取得して返却。

### プログラム呼出し階層

```
LGTESTP4（メニュー画面）
  └─ LGIPOL01（業務ロジック層）
       └─ LGIPDB01（DB2アクセス層）
            ├─ GET-Commercial-DB2-INFO-1（01ICOM:顧客+ポリシー）
            ├─ GET-Commercial-DB2-INFO-2（02ICOM:ポリシーのみ）
            ├─ GET-Commercial-DB2-INFO-3（03ICOM:顧客別一覧）
            └─ GET-Commercial-DB2-INFO-5（05ICOM:郵便番号）
```

### データフロー図

```
[01ICOM] 顧客番号+ポリシー番号 ──→ [GET-Commercial-DB2-INFO-1]
                                        │
[02ICOM] ポリシー番号のみ ─────→ [GET-Commercial-DB2-INFO-2]
                                        │
[03ICOM] 顧客番号（一覧） ─────→ [GET-Commercial-DB2-INFO-3]
                                        │   (Cust_Cursor)
[05ICOM] 郵便番号（一覧） ─────→ [GET-Commercial-DB2-INFO-5]
                                        │   (Zip_Cursor)
                                        ↓
                            [CA-B-Address/Postcode/...]
                            [CA-B-FirePeril/Premium]
                            [CA-B-CrimePeril/Premium]
                            [CA-B-FloodPeril/Premium]
                            [CA-B-WeatherPeril/Premium]
                            [CA-B-Status/RejectReason]
                                        │
                                        ↓
                                   ['FINAL'マーカー]
```

### 関連ファイル一覧

| ファイル | 種別 | 説明 |
|----------|------|------|
| lgcmarea.cpy | COPY句 | COMMARCAデータ構造定義 |
| lgpolicy.cpy | COPY句 | ポリシーデータ構造定義 |
| lgipol01.cbl | COBOL | 業務ロジック層（照会） |
| lgipdb01.cbl | COBOL | DB2アクセス層（照会） |
| lgstsq.cbl | COBOL | エラーログ出力 |
| lgtestp4.cbl | COBOL | 商業用不動産保険メニュー画面 |
