# 機能設計書 F018-商業用不動産保険更新

## 概要

本ドキュメントは、保険契約管理システムにおける商業用不動産保険（Commercial）ポリシーの更新機能について、その設計と仕様を詳細に記述したものである。

### 本機能の処理概要

商業用不動産保険更新機能は、既存の商業用不動産保険ポリシー情報をDb2データベースおよびVSAMファイルで更新する機能である。顧客番号とポリシー番号を指定し、物件情報（住所、郵便番号、緯度経度、物件タイプ）およびリスク保険料（火災、犯罪、洪水、気象）の変更内容を反映する。楽観的ロック機構により同時更新の整合性を確保する。

**業務上の目的・背景**：商業用不動産の契約期間中に、物件の変更、リスク評価の見直し、保険料の改定などが発生した場合、契約内容を更新する必要がある。本機能は、複雑な商業保険契約の変更を効率的に処理し、最新の情報をデータベースに反映させることで、正確な契約管理を実現する。

**機能の利用シーン**：オペレーターが商業用不動産保険ポリシーメニュー画面（SSP4）から照会を行い、その後内容を編集して更新を実行する（現在の画面実装では更新オプションが未実装）。

**主要な処理内容**：
1. コミュニケーションエリア（COMMAREA）から顧客番号・ポリシー番号・更新情報を受け取る
2. リクエストIDが'01UCOM'であることを検証する
3. LGUPDB01プログラムを呼び出してDb2の更新処理を実行
4. SELECT FOR UPDATEでPOLICYテーブルのレコードをロック
5. タイムスタンプ検証で楽観的ロックを実施
6. COMMERCIALテーブルの物件情報とリスク保険料を更新
7. POLICYテーブルの基本情報を更新（新しいタイムスタンプを設定）
8. LGUPVS01プログラムを呼び出してVSAMファイルを更新

**関連システム・外部連携**：Db2データベース（POLICYテーブル、COMMERCIALテーブル）およびVSAM KSDS ファイル（KSDSPOLY）と連携する。

**権限による制御**：本機能に対する特別な権限制御は実装されていない。CICSトランザクション実行権限により制御される。

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 5 | 商業用不動産保険ポリシーメニュー画面 | 主機能 | 更新機能呼び出し（画面実装は今後追加予定） |

## 機能種別

CRUD操作（Update）

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| CA-REQUEST-ID | X(6) | Yes | リクエスト識別子（'01UCOM'） | '01UCOM'であること |
| CA-CUSTOMER-NUM | 9(10) | Yes | 顧客番号 | 数値10桁 |
| CA-POLICY-NUM | 9(10) | Yes | ポリシー番号 | 数値10桁 |
| CA-LASTCHANGED | X(26) | Yes | 最終更新タイムスタンプ（楽観的ロック用） | 照会時の値と一致 |
| CA-ISSUE-DATE | X(10) | Yes | 発効日（StartDate） | 日付形式 |
| CA-EXPIRY-DATE | X(10) | Yes | 満期日（RenewalDate） | 日付形式 |
| CA-B-Address | X(255) | Yes | 物件住所 | - |
| CA-B-Postcode | X(8) | Yes | 郵便番号 | - |
| CA-B-Latitude | X(11) | No | 緯度 | - |
| CA-B-Longitude | X(11) | No | 経度 | - |
| CA-B-Customer | X(255) | No | 顧客名 | - |
| CA-B-PropType | X(255) | No | 物件タイプ | - |
| CA-B-FirePeril | 9(4) | No | 火災リスク | 数値4桁 |
| CA-B-FirePremium | 9(8) | No | 火災保険料 | 数値8桁 |
| CA-B-CrimePeril | 9(4) | No | 犯罪リスク | 数値4桁 |
| CA-B-CrimePremium | 9(8) | No | 犯罪保険料 | 数値8桁 |
| CA-B-FloodPeril | 9(4) | No | 洪水リスク | 数値4桁 |
| CA-B-FloodPremium | 9(8) | No | 洪水保険料 | 数値8桁 |
| CA-B-WeatherPeril | 9(4) | No | 気象リスク | 数値4桁 |
| CA-B-WeatherPremium | 9(8) | No | 気象保険料 | 数値8桁 |
| CA-B-Status | 9(4) | No | ステータス | 数値4桁 |
| CA-B-RejectReason | X(255) | No | 拒否理由 | - |

### 入力データソース

画面入力（商業用不動産保険ポリシーメニュー画面 SSMAPP4）からCOMMARED経由でデータを受け取る。

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| CA-RETURN-CODE | 9(2) | 処理結果コード（00:正常、01:データなし、02:タイムスタンプ不一致、90:DB2エラー、98:長さ不足、99:リクエスト不正） |
| CA-LASTCHANGED | X(26) | 更新後の最終更新タイムスタンプ |

### 出力先

- Db2 POLICYテーブル（レコード更新）
- Db2 COMMERCIALテーブル（レコード更新）
- VSAM KSDSファイル（KSDSPOLY）（レコード更新）
- エラー時：一時ストレージキュー（GENAERRS）へエラーメッセージ出力

## 処理フロー

### 処理シーケンス

```
1. LGUPOL01: メイン処理開始
   └─ COMMARCAの検証（長さ、リクエストID）
2. LGUPOL01: LGUPDB01プログラム呼び出し
   └─ CICS LINKでDb2更新処理を実行
3. LGUPDB01: POLICY_CURSOR OPEN
   └─ SELECT FOR UPDATEでレコードをロック
4. LGUPDB01: レコードFETCH
   └─ 現在のデータを取得
5. LGUPDB01: タイムスタンプ比較
   └─ CA-LASTCHANGED = DB2-LASTCHANGED を確認
6. LGUPDB01: COMMERCIALテーブルUPDATE
   └─ 物件情報とリスク保険料を更新
7. LGUPDB01: POLICYテーブルUPDATE
   └─ 基本情報を更新、LASTCHANGED = CURRENT TIMESTAMP
8. LGUPDB01: 新しいタイムスタンプ取得
   └─ 更新後のLASTCHANGEDをSELECT
9. LGUPDB01: POLICY_CURSOR CLOSE
10. LGUPDB01: LGUPVS01プログラム呼び出し
    └─ CICS LINKでVSAM更新処理を実行
11. 呼び出し元へリターン
    └─ リターンコードと新タイムスタンプを返却
```

### フローチャート

```mermaid
flowchart TD
    A[開始] --> B{COMMARCAを受信?}
    B -->|No| C[ABEND 'LGCA']
    B -->|Yes| D{REQUEST-ID = '01UCOM'?}
    D -->|No| E[RC='99' で終了]
    D -->|Yes| F{COMMARCA長さ十分?}
    F -->|No| G[RC='98' で終了]
    F -->|Yes| H[POLICY_CURSOR OPEN]
    H --> I{OPEN成功?}
    I -->|SQLCODE=-913| J[RC='90' ロック競合]
    I -->|No| K[RC='90' エラー]
    I -->|Yes| L[POLICY_CURSOR FETCH]
    L --> M{FETCH成功?}
    M -->|SQLCODE=100| N[RC='01' データなし]
    M -->|No| O[RC='90' エラー]
    M -->|Yes| P{タイムスタンプ一致?}
    P -->|No| Q[RC='02' 競合検出]
    P -->|Yes| R[COMMERCIALテーブルUPDATE]
    R --> S{UPDATE成功?}
    S -->|No| T[RC='90' エラー]
    S -->|Yes| U[POLICYテーブルUPDATE]
    U --> V{UPDATE成功?}
    V -->|No| W[SYNCPOINT ROLLBACK]
    V -->|Yes| X[新タイムスタンプ取得]
    X --> Y[POLICY_CURSOR CLOSE]
    Y --> Z[LGUPVS01呼び出し]
    Z --> AA[RC='00']
    J --> BB[終了]
    K --> BB
    N --> BB
    O --> BB
    Q --> BB
    T --> BB
    W --> BB
    AA --> BB
    E --> BB
    G --> BB
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-018-1 | 楽観的ロック | 照会時のタイムスタンプと更新時のタイムスタンプが一致すること | 常時 |
| BR-018-2 | 排他ロック | SELECT FOR UPDATEでレコードをロック | 更新処理中 |
| BR-018-3 | タイムスタンプ自動更新 | 更新時にLASTCHANGED（RequestDate）が自動的に現在時刻に更新される | 常時 |
| BR-018-4 | ポリシー存在確認 | 更新対象のポリシーが存在すること | 常時 |
| BR-018-5 | リスク保険料個別更新 | 4種類のリスク保険料を個別に更新可能 | 常時 |

### 計算ロジック

特別な計算ロジックは存在しない。入力値で既存データを上書きする。総保険料の再計算は行われない。

## データベース操作仕様

### 操作別データベース影響一覧

| 操作 | 対象テーブル | 操作種別 | 概要 |
|-----|-------------|---------|------|
| ロック | POLICY | SELECT FOR UPDATE | 排他ロックを取得 |
| 更新 | POLICY | UPDATE | ポリシー基本情報を更新 |
| 更新 | COMMERCIAL | UPDATE | 物件詳細情報・リスク保険料を更新 |
| 更新 | KSDSPOLY | REWRITE | VSAMファイルのレコード更新 |

### テーブル別操作詳細

#### POLICY

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| SELECT | ISSUEDATE, EXPIRYDATE, LASTCHANGED, BROKERID, BROKERSREFERENCE | ロック取得用 | FOR UPDATE |
| UPDATE | ISSUEDATE | :CA-ISSUE-DATE | StartDate |
| UPDATE | EXPIRYDATE | :CA-EXPIRY-DATE | RenewalDate |
| UPDATE | LASTCHANGED | CURRENT TIMESTAMP | RequestDate |
| UPDATE | BROKERID | :CA-BROKERID | ブローカーID |
| UPDATE | BROKERSREFERENCE | :CA-BROKERSREF | ブローカー参照 |

#### COMMERCIAL

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| UPDATE | Address | :CA-B-Address | 物件住所 |
| UPDATE | Zipcode | :CA-B-Postcode | 郵便番号 |
| UPDATE | LatitudeN | :CA-B-Latitude | 緯度 |
| UPDATE | LongitudeW | :CA-B-Longitude | 経度 |
| UPDATE | Customer | :CA-B-Customer | 顧客名 |
| UPDATE | PropertyType | :CA-B-PropType | 物件タイプ |
| UPDATE | FirePeril | :CA-B-FirePeril | 火災リスク |
| UPDATE | FirePremium | :CA-B-FirePremium | 火災保険料 |
| UPDATE | CrimePeril | :CA-B-CrimePeril | 犯罪リスク |
| UPDATE | CrimePremium | :CA-B-CrimePremium | 犯罪保険料 |
| UPDATE | FloodPeril | :CA-B-FloodPeril | 洪水リスク |
| UPDATE | FloodPremium | :CA-B-FloodPremium | 洪水保険料 |
| UPDATE | WeatherPeril | :CA-B-WeatherPeril | 気象リスク |
| UPDATE | WeatherPremium | :CA-B-WeatherPremium | 気象保険料 |
| UPDATE | Status | :CA-B-Status | ステータス |
| UPDATE | RejectionReason | :CA-B-RejectReason | 拒否理由 |

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| 01 | データなし | SQLCODE=100 | 顧客番号・ポリシー番号を確認 |
| 02 | タイムスタンプ不一致 | CA-LASTCHANGED ≠ DB2-LASTCHANGED | 再照会して再更新 |
| 90 | DB2更新エラー | SQLCODE≠0 | エラーログ記録、ロールバック |
| 98 | COMMAREA長不足 | EIBCALEN < 必要長 | 呼び出し元で対処 |
| 99 | リクエスト不正 | CA-REQUEST-IDが無効 | 呼び出し元で対処 |
| LGCA | ABEND | COMMARCAなし | システム異常 |

### リトライ仕様

リトライ処理は実装されていない。タイムスタンプ不一致時は再照会・再更新が必要。

## トランザクション仕様

- トランザクション境界：SELECT FOR UPDATE からカーソルCLOSEまで
- コミット：呼び出し元で正常終了時に暗黙的コミット
- ロールバック：POLICY UPDATE失敗時にSYNCPOINT ROLLBACK
- カーソルはWITH HOLDで定義されているため、SYNCPOINT後もオープン状態

## パフォーマンス要件

- レスポンス時間：通常1秒以内
- SELECT FOR UPDATEによるロック待ち発生の可能性あり
- SQLCODE=-913（タイムアウト）の場合はRC='90'で返却

## セキュリティ考慮事項

- CICSトランザクションセキュリティによるアクセス制御
- 楽観的ロックにより同時更新の整合性を確保
- エラー発生時のログ記録（GENAERRS一時ストレージキュー）

## 備考

- 商業用不動産保険の更新は複雑なリスク構成の変更を伴う可能性がある
- タイムスタンプ検証により、他ユーザーによる更新との競合を検出
- カーソル使用によりレコードレベルの排他制御を実現
- VSAM更新はDb2更新成功後に実行される
- 画面（LGTESTP4）では現在更新オプションが未実装（照会・登録・削除のみ）

## コードリーディングガイド

本機能のソースコードを理解するための推奨リーディング順序を以下に示す。

### 推奨リーディング順序

| Step | ファイル | 行番号 | 内容 |
|------|----------|--------|------|
| 1 | base/src/lgcmarea.cpy | 全体 | COMMARCAデータ構造の定義 |
| 2 | base/src/lgpolicy.cpy | 全体 | POLICYおよびCOMMERCIAL関連データ項目 |
| 3 | base/src/lgupol01.cbl | 117-135 | リクエストID評価と大文字変換 |
| 4 | base/src/lgupdb01.cbl | 206-212 | UPDATE-POLICY-DB2-INFO呼び出しとVSAM連携 |
| 5 | base/src/lgupdb01.cbl | 228-239 | FETCH-DB2-POLICY-ROW（カーソルFETCH） |
| 6 | base/src/lgupvs01.cbl | 全体 | VSAMファイル更新処理 |
| 7 | base/src/lgstsq.cbl | 全体 | エラーログ出力処理 |

### Step別詳細ガイド

#### Step 1: COMMARCAデータ構造の理解
`lgcmarea.cpy`でCA-B-Address、CA-B-Postcode等の商業用不動産情報項目および4種類のリスク保険料（Fire/Crime/Flood/Weather）の構造を確認。

#### Step 2: POLICYデータ構造の理解
`lgpolicy.cpy`で商業用不動産保険固有の拡張フィールド定義を確認。

#### Step 3: リクエストID評価（lgupol01.cbl:117-135）
```cobol
EVALUATE TRUE
  WHEN FUNCTION UPPER-CASE(CA-REQUEST-ID) = '01UCOM'
```
大文字変換後、'01UCOM'（商業用不動産保険更新）を識別してLGUPDB01を呼び出す。

#### Step 4: 更新処理呼び出し（lgupdb01.cbl:206-212）
```cobol
PERFORM UPDATE-POLICY-DB2-INFO.

EXEC CICS LINK Program(LGUPVS01)
     Commarea(DFHCOMMAREA)
     LENGTH(225)
END-EXEC.
```
POLICYテーブル更新後、LGUPVS01でVSAMファイルを更新。

#### Step 5: カーソルFETCH（lgupdb01.cbl:228-239）
```cobol
FETCH-DB2-POLICY-ROW.
    EXEC SQL
      FETCH POLICY_CURSOR
      INTO  :DB2-ISSUEDATE,
            :DB2-EXPIRYDATE,
            :DB2-LASTCHANGED,
            :DB2-BROKERID-INT INDICATOR :IND-BROKERID,
            :DB2-BROKERSREF INDICATOR :IND-BROKERSREF,
            :DB2-PAYMENT-INT INDICATOR :IND-PAYMENT
    END-EXEC
```
SELECT FOR UPDATEでロック取得後、現在値をFETCH。楽観的ロック用のタイムスタンプを取得。

#### Step 6: VSAM更新処理（lgupvs01.cbl）
READ UPDATEでVSAMレコードを取得し、REWRITEで更新内容を書き戻す。

### プログラム呼出し階層

```
LGTESTP4（メニュー画面）
  └─ LGUPOL01（業務ロジック層）
       └─ LGUPDB01（DB2アクセス層）
            ├─ POLICY_CURSOR OPEN（SELECT FOR UPDATE）
            ├─ POLICY_CURSOR FETCH
            ├─ タイムスタンプ比較（楽観的ロック）
            ├─ COMMERCIAL UPDATE
            ├─ POLICY UPDATE
            ├─ POLICY_CURSOR CLOSE
            └─ LGUPVS01（VSAMアクセス層）
                 └─ CICS READ UPDATE + REWRITE
```

### データフロー図

```
[CA-CUSTOMER-NUM]      ──┐
[CA-POLICY-NUM]        ──┼──→ [POLICY_CURSOR OPEN FOR UPDATE]
[CA-LASTCHANGED]       ──┘           │
                                     ↓
                        [POLICY_CURSOR FETCH]
                                     │
                                     ↓
                   [CA-LASTCHANGED = DB2-LASTCHANGED?]
                          │NO             │YES
                          ↓               ↓
                    [RC='02']    [COMMERCIAL UPDATE]
                                     │
[CA-B-FirePeril/Premium] ────────────┤
[CA-B-CrimePeril/Premium]────────────┤
[CA-B-FloodPeril/Premium]────────────┤
[CA-B-WeatherPeril/Premium]──────────┤
                                     ↓
                            [POLICY UPDATE]
                                     │
                                     ↓
                      [VSAM READ UPDATE + REWRITE]
```

### 関連ファイル一覧

| ファイル | 種別 | 説明 |
|----------|------|------|
| lgcmarea.cpy | COPY句 | COMMARCAデータ構造定義 |
| lgpolicy.cpy | COPY句 | ポリシーデータ構造定義 |
| lgupol01.cbl | COBOL | 業務ロジック層（更新） |
| lgupdb01.cbl | COBOL | DB2アクセス層（更新） |
| lgupvs01.cbl | COBOL | VSAMアクセス層（更新） |
| lgstsq.cbl | COBOL | エラーログ出力 |
| lgtestp4.cbl | COBOL | 商業用不動産保険メニュー画面 |

### 備考

現在、lgupdb01.cblには商業用不動産保険（COMMERCIAL）固有の更新手続きは明示的に実装されていない可能性がある。画面（LGTESTP4）でも更新オプションが未実装のため、今後の機能拡張で実装される見込み。
