# 機能設計書 F019-商業用不動産保険削除

## 概要

本ドキュメントは、保険契約管理システムにおける商業用不動産保険（Commercial）ポリシーの削除機能について、その設計と仕様を詳細に記述したものである。

### 本機能の処理概要

商業用不動産保険削除機能は、既存の商業用不動産保険ポリシーレコードをDb2データベースおよびVSAMファイルから完全に削除する機能である。顧客番号とポリシー番号を指定することで、該当するポリシー情報を論理的・物理的に削除し、データの整合性を保ちながら契約終了処理を実行する。

**業務上の目的・背景**：商業用不動産保険契約が満期を迎えた場合、解約が行われた場合、または誤って登録されたポリシーを削除する必要がある場合に、本機能が使用される。商業用不動産保険は複雑なリスク構成を持つため、関連する全てのリスク保険料データも含めて適切に削除処理を行う。

**機能の利用シーン**：オペレーターが商業用不動産保険ポリシーメニュー画面（SSP4）からオプション3を選択し、顧客番号とポリシー番号を指定して削除を実行する。削除前に対象ポリシーの存在確認が行われ、正常に削除された場合は画面にメッセージが表示される。

**主要な処理内容**：
1. コミュニケーションエリア（COMMAREA）から顧客番号・ポリシー番号を受け取る
2. リクエストIDが'01DCOM'であることを検証する
3. LGDPDB01プログラムを呼び出してDb2のPOLICYテーブルからレコードを削除する
4. 外部キー制約によりCOMMERCIALテーブルからも自動的に削除される
5. LGDPVS01プログラムを呼び出してVSAMファイル（KSDSPOLY）からレコードを削除する
6. 処理結果をリターンコードとして返却する

**関連システム・外部連携**：Db2データベース（POLICYテーブル、COMMERCIALテーブル）およびVSAM KSDS ファイル（KSDSPOLY）と連携する。

**権限による制御**：本機能に対する特別な権限制御は実装されていない。CICSトランザクション実行権限により制御される。

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 5 | 商業用不動産保険ポリシーメニュー画面 | 主機能 | オプション3選択時にLGDPOL01プログラムをCICS LINKで呼び出し、ポリシーを削除する |

## 機能種別

CRUD操作（Delete）

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| CA-REQUEST-ID | X(6) | Yes | リクエスト識別子（'01DCOM'） | '01DCOM'であること |
| CA-CUSTOMER-NUM | 9(10) | Yes | 顧客番号 | 数値10桁 |
| CA-POLICY-NUM | 9(10) | Yes | ポリシー番号 | 数値10桁 |

### 入力データソース

画面入力（商業用不動産保険ポリシーメニュー画面 SSMAPP4）からCOMMARED経由でデータを受け取る。

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| CA-RETURN-CODE | 9(2) | 処理結果コード（00:正常、81:VSAMエラー、90:DB2エラー、99:リクエスト不正） |

### 出力先

- Db2 POLICYテーブル（レコード削除）
- Db2 COMMERCIALテーブル（外部キー制約による連鎖削除）
- VSAM KSDSファイル（KSDSPOLY）（レコード削除）
- エラー時：一時ストレージキュー（GENAERRS）へエラーメッセージ出力

## 処理フロー

### 処理シーケンス

```
1. LGDPOL01: メイン処理開始
   └─ COMMARCAの検証（長さ、リクエストID）
2. LGDPOL01: リクエストIDの検証
   └─ '01DCOM'であることを確認
3. LGDPOL01: LGDPDB01プログラム呼び出し
   └─ CICS LINKでDb2削除処理を実行
4. LGDPDB01: Db2 POLICYテーブルから削除
   └─ DELETE文実行、外部キーによりCOMMERCIALも削除
5. LGDPDB01: LGDPVS01プログラム呼び出し
   └─ CICS LINKでVSAM削除処理を実行
6. LGDPVS01: VSAMファイルからレコード削除
   └─ CICS DELETE FILEコマンド実行
7. 呼び出し元へリターン
   └─ リターンコードを設定して終了
```

### フローチャート

```mermaid
flowchart TD
    A[開始] --> B{COMMARCAを受信?}
    B -->|No| C[ABEND 'LGCA']
    B -->|Yes| D{COMMARCA長さ >= 28?}
    D -->|No| E[RC='98' で終了]
    D -->|Yes| F{REQUEST-ID = '01DCOM'?}
    F -->|No| G[RC='99' で終了]
    F -->|Yes| H[LGDPDB01呼び出し]
    H --> I[DB2 POLICYテーブル DELETE]
    I --> J{SQLCODE = 0?}
    J -->|No| K[RC='90' エラー記録]
    J -->|Yes| L[LGDPVS01呼び出し]
    L --> M[VSAM KSDSPOLY DELETE]
    M --> N{RESP = NORMAL?}
    N -->|No| O[RC='81' エラー記録]
    N -->|Yes| P[RC='00']
    K --> Q[終了]
    O --> Q
    P --> Q
    E --> Q
    G --> Q
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-019-1 | ポリシー存在確認 | 削除対象のポリシーが存在すること | 常時 |
| BR-019-2 | 外部キー連鎖削除 | POLICYテーブル削除時にCOMMERCIALも自動削除 | Db2外部キー制約による |
| BR-019-3 | リスク保険料一括削除 | COMMERCIALレコード削除時に4種類のリスク保険料も含めて削除 | COMMERCIALテーブル構造 |
| BR-019-4 | 二重削除許容 | SQLCODE=100（レコード不在）も正常終了扱い | Db2削除時 |

### 計算ロジック

削除機能のため、計算ロジックは存在しない。

## データベース操作仕様

### 操作別データベース影響一覧

| 操作 | 対象テーブル | 操作種別 | 概要 |
|-----|-------------|---------|------|
| 削除 | POLICY | DELETE | 顧客番号・ポリシー番号を条件にレコード削除 |
| 削除 | COMMERCIAL | DELETE | 外部キー制約による連鎖削除（リスク保険料含む） |
| 削除 | KSDSPOLY | DELETE | VSAMファイルからレコード削除 |

### テーブル別操作詳細

#### POLICY

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| DELETE | - | CUSTOMERNUMBER = :顧客番号 AND POLICYNUMBER = :ポリシー番号 | 削除条件 |

#### COMMERCIAL

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| DELETE | - | POLICYNUMBER（外部キー） | POLICYテーブル削除に連動 |

#### KSDSPOLY（VSAMファイル）

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| DELETE | - | キー: リクエストID(1) + 顧客番号(10) + ポリシー番号(10) | キー長21バイト |

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| 81 | VSAM削除エラー | CICS DELETE FILEでRESP≠NORMAL | エラーログ記録、ロールバック検討 |
| 90 | DB2削除エラー | SQLCODE≠0かつ≠100 | エラーログ記録、処理中止 |
| 98 | COMMAREA長不足 | EIBCALEN < 28 | 呼び出し元で対処 |
| 99 | リクエスト不正 | CA-REQUEST-IDが無効 | 呼び出し元で対処 |
| LGCA | ABEND | COMMARCAなし | システム異常 |

### リトライ仕様

リトライ処理は実装されていない。エラー発生時は即座にエラーコードを返却する。

## トランザクション仕様

- トランザクション境界：呼び出し元プログラム（LGTESTP4）で制御
- コミット：呼び出し元で正常終了時に暗黙的コミット
- ロールバック：呼び出し元でCA-RETURN-CODE > 0の場合にSYNCPOINT ROLLBACK実行
- Db2とVSAMの両方を更新するため、一貫性確保が重要

## パフォーマンス要件

- レスポンス時間：通常1秒以内
- Db2 DELETEはPOLICYNUMBERインデックスを使用
- VSAM DELETEはキーによる直接アクセス

## セキュリティ考慮事項

- CICSトランザクションセキュリティによるアクセス制御
- エラー発生時のログ記録（GENAERRS一時ストレージキュー）
- 物理削除のため、削除後のデータ復旧は不可
- 4種類のリスク保険料データも完全に削除される

## 備考

- 商業用不動産保険（Commercial Property Insurance）は複雑なリスク構成を持つ
- Db2の外部キー制約を活用した連鎖削除により、POLICYとCOMMERCIALのデータ整合性を自動的に確保
- COMMERCIALテーブルには4種類のリスク保険料（火災、犯罪、洪水、気象）が含まれ、ポリシー削除時に全て削除される
- VSAMファイルはDb2と同期して削除されるが、Db2削除が失敗してもVSAM削除は試行されない設計

## コードリーディングガイド

本機能のソースコードを理解するための推奨リーディング順序を以下に示す。

### 推奨リーディング順序

| Step | ファイル | 行番号 | 内容 |
|------|----------|--------|------|
| 1 | base/src/lgcmarea.cpy | 全体 | COMMARCAデータ構造の定義 |
| 2 | base/src/lgpolicy.cpy | 全体 | POLICYおよびCOMMERCIAL関連データ項目 |
| 3 | base/src/lgdpol01.cbl | 117-122 | リクエストID評価と大文字変換 |
| 4 | base/src/lgdpdb01.cbl | 160-172 | '01DCOM'評価とDELETE-POLICY-DB2-INFO呼び出し |
| 5 | base/src/lgdpdb01.cbl | 186-202 | DELETE-POLICY-DB2-INFO手続き |
| 6 | base/src/lgdpvs01.cbl | 全体 | VSAMファイル削除処理 |
| 7 | base/src/lgstsq.cbl | 全体 | エラーログ出力処理 |

### Step別詳細ガイド

#### Step 1: COMMARCAデータ構造の理解
`lgcmarea.cpy`でCA-REQUEST-ID、CA-CUSTOMER-NUM、CA-POLICY-NUM等の削除に必要な項目を確認。

#### Step 2: POLICYデータ構造の理解
`lgpolicy.cpy`でDB2テーブルとのマッピング項目を確認。

#### Step 3: リクエストID評価（lgdpol01.cbl:117-122）
```cobol
IF ( FUNCTION UPPER-CASE(CA-REQUEST-ID) NOT EQUAL TO '01DEND' AND
     FUNCTION UPPER-CASE(CA-REQUEST-ID) NOT EQUAL TO '01DHOU' AND
     FUNCTION UPPER-CASE(CA-REQUEST-ID) NOT EQUAL TO '01DCOM' AND
     FUNCTION UPPER-CASE(CA-REQUEST-ID) NOT EQUAL TO '01DMOT' )
```
大文字変換後、有効なリクエストID（'01DCOM'を含む）かを検証。

#### Step 4: 削除処理分岐（lgdpdb01.cbl:160-172）
```cobol
IF ( CA-REQUEST-ID NOT EQUAL TO '01DEND' AND
     CA-REQUEST-ID NOT EQUAL TO '01DHOU' AND
     CA-REQUEST-ID NOT EQUAL TO '01DCOM' AND
     CA-REQUEST-ID NOT EQUAL TO '01DMOT' ) Then
    MOVE '99' TO CA-RETURN-CODE
ELSE
    PERFORM DELETE-POLICY-DB2-INFO
    EXEC CICS LINK PROGRAM(LGDPVS01)
         Commarea(DFHCOMMAREA)
         LENGTH(32500)
    END-EXEC
END-IF.
```
'01DCOM'の場合、DELETE-POLICY-DB2-INFOを呼び出してPOLICYテーブルから削除後、LGDPVS01でVSAMを削除。

#### Step 5: DELETE-POLICY-DB2-INFO手続き（lgdpdb01.cbl:186-202）
```cobol
DELETE-POLICY-DB2-INFO.
    EXEC SQL
      DELETE
        FROM POLICY
        WHERE ( CUSTOMERNUMBER = :DB2-CUSTOMERNUM-INT AND
                POLICYNUMBER  = :DB2-POLICYNUM-INT      )
    END-EXEC
```
POLICYテーブルから削除。外部キー制約によりCOMMERCIALテーブルからも自動的に連鎖削除される。4種類のリスク保険料データも完全に削除。

#### Step 6: VSAM削除処理（lgdpvs01.cbl）
CICS DELETE FILEコマンドでVSAM KSDSファイル（KSDSPOLY）からレコードを削除。

### プログラム呼出し階層

```
LGTESTP4（メニュー画面）
  └─ LGDPOL01（業務ロジック層）
       └─ LGDPDB01（DB2アクセス層）
            ├─ DELETE-POLICY-DB2-INFO
            │    └─ DELETE FROM POLICY（外部キーによりCOMMERCIALも削除）
            └─ LGDPVS01（VSAMアクセス層）
                 └─ CICS DELETE FILE('KSDSPOLY')
```

### データフロー図

```
[CA-REQUEST-ID='01DCOM'] ──→ [リクエストID検証]
[CA-CUSTOMER-NUM]        ──┐      │
[CA-POLICY-NUM]          ──┼──────┘
                           │
                           ↓
               [DELETE FROM POLICY]
                           │
                           ↓
          [外部キー制約によるCOMMERCIAL連鎖削除]
          （FirePeril/Premium, CrimePeril/Premium,
            FloodPeril/Premium, WeatherPeril/Premium含む）
                           │
                           ↓
               [CICS DELETE FILE KSDSPOLY]
                           │
                           ↓
                      [RC='00']
```

### 関連ファイル一覧

| ファイル | 種別 | 説明 |
|----------|------|------|
| lgcmarea.cpy | COPY句 | COMMARCAデータ構造定義 |
| lgpolicy.cpy | COPY句 | ポリシーデータ構造定義 |
| lgdpol01.cbl | COBOL | 業務ロジック層（削除） |
| lgdpdb01.cbl | COBOL | DB2アクセス層（削除） |
| lgdpvs01.cbl | COBOL | VSAMアクセス層（削除） |
| lgstsq.cbl | COBOL | エラーログ出力 |
| lgtestp4.cbl | COBOL | 商業用不動産保険メニュー画面 |
