# 機能設計書 F002-顧客照会

## 概要

本ドキュメントは、CICS-GENAPPシステムにおける顧客照会機能の詳細設計を定義する。顧客番号を指定して顧客情報をDb2データベースから取得する機能である。

### 本機能の処理概要

本機能は、既存顧客の詳細情報を照会・表示するための基幹機能を提供する。

**業務上の目的・背景**：保険業務において、顧客からの問い合わせ対応、契約内容の確認、保険ポリシーの新規作成前の顧客確認など、様々な場面で顧客情報の参照が必要となる。本機能は、顧客番号をキーとして顧客の基本情報（氏名、住所、連絡先等）を迅速に取得し、業務効率の向上を支援する。

**機能の利用シーン**：顧客からの電話問い合わせ時、保険契約の更新・変更時、新規ポリシー作成前の顧客情報確認時など、顧客メニュー画面からオプション1を選択して顧客番号を入力し照会を実行する。

**主要な処理内容**：
1. 顧客番号をキーとしてCOMMAREAから入力を受け取る
2. Db2のCUSTOMERテーブルからSELECTで顧客情報を取得
3. 取得した顧客情報（氏名、生年月日、住所、電話番号、メールアドレス）をCOMMAREAに設定
4. 処理結果を呼び出し元に返却

**関連システム・外部連携**：Db2データベースとの連携のみ。外部システムとの連携なし。

**権限による制御**：本機能は顧客情報閲覧権限を持つオペレーターが実行可能である。

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 1 | 顧客メニュー画面 | 主画面 | オプション1選択時にLGICUS01プログラムをCICS LINKで呼び出し、顧客番号を指定して顧客情報を取得・表示する |

## 機能種別

CRUD操作（Read）/ データ参照処理

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| CA-REQUEST-ID | X(6) | Yes | リクエストID | - |
| CA-CUSTOMER-NUM | 9(10) | Yes | 顧客番号 | 数値のみ |

### 入力データソース

- 画面入力（顧客メニュー画面 SSMAPC1）
- CICS通信領域（COMMAREA）を介したデータ連携

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| CA-RETURN-CODE | 9(2) | 処理結果コード |
| CA-FIRST-NAME | X(10) | 名 |
| CA-LAST-NAME | X(20) | 姓 |
| CA-DOB | X(10) | 生年月日 |
| CA-HOUSE-NAME | X(20) | 建物名 |
| CA-HOUSE-NUM | X(4) | 建物番号 |
| CA-POSTCODE | X(8) | 郵便番号 |
| CA-NUM-POLICIES | 9(3) | ポリシー数 |
| CA-PHONE-MOBILE | X(20) | 携帯電話番号 |
| CA-PHONE-HOME | X(20) | 自宅電話番号 |
| CA-EMAIL-ADDRESS | X(100) | メールアドレス |

### 出力先

- CICS通信領域（COMMAREA）

## 処理フロー

### 処理シーケンス

```
1. COMMAREAの受信と検証
   └─ COMMAREAが存在しない場合はABEND('LGCA')
2. COMMAREAの長さチェック
   └─ 必要な長さ（ヘッダー18バイト + 顧客データ72バイト）を確認
3. LGICDB01プログラム呼び出し
   └─ CICS LINKでDb2アクセス層を呼び出し
4. CUSTOMERテーブルからSELECT（LGICDB01）
   └─ 顧客番号をキーに顧客情報を取得
5. 結果の返却
   └─ 顧客情報とリターンコードをCOMMAREAに設定
```

### フローチャート

```mermaid
flowchart TD
    A[開始] --> B{COMMAREAあり?}
    B -->|No| C[ABEND LGCA]
    B -->|Yes| D{長さチェック}
    D -->|NG| E[RC=98で終了]
    D -->|OK| F[LGICDB01呼出]
    F --> G[CUSTOMERテーブルSELECT]
    G --> H{SQLCODE判定}
    H -->|0| I[RC=00で正常終了]
    H -->|100| J[RC=01 データなし]
    H -->|-913| K[RC=01 ロック競合]
    H -->|Other| L[RC=90 エラー]
    E --> M[終了]
    I --> M
    J --> M
    K --> M
    L --> M
    C --> M
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-001 | 顧客番号必須 | 照会には有効な顧客番号の指定が必須 | 常時 |
| BR-002 | 存在確認 | 指定された顧客番号がCUSTOMERテーブルに存在しない場合は'01'エラー | 照会時 |
| BR-003 | ロック競合許容 | 他トランザクションによるロック競合時は'01'エラーとして扱う | 照会時 |

### 計算ロジック

- 計算ロジックなし（純粋な参照処理）

## データベース操作仕様

### 操作別データベース影響一覧

| 操作 | 対象テーブル | 操作種別 | 概要 |
|-----|-------------|---------|------|
| 顧客情報取得 | CUSTOMER | SELECT | 顧客基本情報の取得 |

### テーブル別操作詳細

#### CUSTOMER

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| SELECT | FIRSTNAME | WHERE CUSTOMERNUMBER = :DB2-CUSTOMERNUMBER-INT | |
| SELECT | LASTNAME | 同上 | |
| SELECT | DATEOFBIRTH | 同上 | |
| SELECT | HOUSENAME | 同上 | |
| SELECT | HOUSENUMBER | 同上 | |
| SELECT | POSTCODE | 同上 | |
| SELECT | PHONEMOBILE | 同上 | |
| SELECT | PHONEHOME | 同上 | |
| SELECT | EMAILADDRESS | 同上 | |

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| 98 | 入力エラー | COMMAREAの長さ不足 | 正しい長さのCOMMAREAで再実行 |
| 01 | 業務エラー | 顧客番号が存在しない（SQLCODE=100） | 正しい顧客番号を指定 |
| 01 | 業務エラー | ロック競合（SQLCODE=-913） | 時間を置いて再実行 |
| 90 | DB2エラー | その他のSQLエラー | エラーログ確認 |
| LGCA | システムエラー | COMMAREAなし | プログラム呼出方法確認 |

### リトライ仕様

- ロック競合（SQLCODE=-913）の場合、リターンコード'01'で終了し、呼び出し元で再試行を判断

## トランザクション仕様

- トランザクションID: SSC1
- 参照のみの処理のため、コミット/ロールバックの影響なし

## パフォーマンス要件

- レスポンス時間: 1秒以内
- 主キーによる単一行SELECT のため高速

## セキュリティ考慮事項

- 顧客情報は個人情報として適切な権限管理が必要
- エラー発生時はLGSTSQプログラムを通じてエラーキューにログを記録
- 照会ログの記録により不正アクセスの追跡が可能

## 備考

- LGICUS01: ビジネスロジック層（LGICDB01を呼び出し）
- LGICDB01: Db2データアクセス層（CUSTOMERテーブルSELECT）
- 単純な参照処理のため、VSAMファイルへのアクセスは行わない

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

まず、プログラム間で受け渡されるデータ構造を理解することが重要である。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | lgcmarea.cpy | `base/src/lgcmarea.cpy` | COMMAREA構造の理解。`CA-REQUEST-ID`（6バイト）、`CA-RETURN-CODE`（2バイト）、`CA-CUSTOMER-NUM`（10桁）が入力、`CA-CUSTOMER-REQUEST`内の顧客情報フィールドが出力となる |
| 1-2 | lgpolicy.cpy | `base/src/lgpolicy.cpy` | `WS-CUSTOMER-LEN`（72バイト）の定義を確認。COMMAREAの長さチェックに使用される |

**読解のコツ**: 顧客照会では、入力として`CA-CUSTOMER-NUM`のみを使用し、出力として`CA-FIRST-NAME`から`CA-EMAIL-ADDRESS`までの顧客情報フィールドにデータが設定される。

#### Step 2: 画面レイアウトを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | ssmap.bms | `base/src/ssmap.bms` | `SSMAPC1`マップ（13-106行目）の顧客メニュー画面。オプション1が「Cust Inquiry」。`ENT1CNO`フィールドに顧客番号を入力して照会を実行 |

**読解のコツ**: 19行目の`INITIAL='1. Cust Inquiry '`がメニューオプション1の定義。29-30行目の`ENT1CNO`が顧客番号入力フィールド。

#### Step 3: エントリーポイント（ビジネスロジック層）

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | lgicus01.cbl | `base/src/lgicus01.cbl` | **MAINLINE SECTION**（77-118行目）: COMMAREAの検証とLGICDB01呼び出し |

**主要処理フロー**:
1. **87-91行目**: COMMAREAなしの場合はABEND('LGCA')
2. **93-96行目**: リターンコードとポリシー数を初期化
3. **102-107行目**: COMMAREAの長さチェック（ヘッダー18バイト + 顧客データ72バイト）
4. **109行目**: `PERFORM GET-CUSTOMER-INFO` でLGICDB01を呼び出し
5. **120-128行目**: CICS LINKでLGICDB01を呼び出し

**読解のコツ**: LGICUS01は薄いラッパー層であり、主要なロジックはLGICDB01に委譲されている。

#### Step 4: データアクセス層（DB2 SELECT処理）

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | lgicdb01.cbl | `base/src/lgicdb01.cbl` | **最も重要なファイル**。DB2からの顧客情報取得処理 |

**主要処理フロー**:
1. **119-123行目**: COMMAREAなしの場合はABEND('LGCA')
2. **137-143行目**: COMMAREAの長さチェック
3. **146行目**: `CA-CUSTOMER-NUM`を`DB2-CUSTOMERNUMBER-INT`に変換
4. **154行目**: `PERFORM GET-CUSTOMER-INFO`でSELECT実行
5. **167-205行目**: `GET-CUSTOMER-INFO`セクション - SQL SELECT実行

**注目すべき詳細**:
- **169-190行目**: CUSTOMERテーブルからのSELECT文。顧客番号をキーに9項目を取得
- **192-203行目**: SQLCODEの評価
  - `SQLCODE=0`: 正常取得、RC='00'
  - `SQLCODE=100`: データなし、RC='01'
  - `SQLCODE=-913`: ロック競合、RC='01'
  - その他: エラー、RC='90'

#### Step 5: 補助機能（エラーログ）

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 5-1 | lgstsq.cbl | `base/src/lgstsq.cbl` | エラーメッセージをTDQ/TSQに書き込む共通ログ機能 |

**主要処理フロー**:
- エラー発生時にLGICUS01/LGICDB01から呼び出される
- TDQ（CSMT）とTSQ（GENAERRS）にエラー情報を記録

### プログラム呼び出し階層図

```
画面操作（オプション1選択 + 顧客番号入力）
    │
    ▼
LGICUS01 (lgicus01.cbl)  ─────────────────┐
    │ CICS LINK                           │ エラー時
    ▼                                     ▼
LGICDB01 (lgicdb01.cbl)              LGSTSQ (lgstsq.cbl)
    │                                     │
    └─ SQL SELECT (CUSTOMER)              └─ TDQ/TSQ書込
           │
           └─▶ 顧客情報をCOMMAREAに設定
```

### データフロー図

```
[入力]                    [処理]                         [出力]

COMMAREA ─────────▶ LGICUS01 ─────▶ LGICDB01 ─────────▶ COMMAREA
 │                                      │                  │
 ├─ CA-CUSTOMER-NUM                     │                  ├─ CA-RETURN-CODE
 │  (照会キー)                          │                  ├─ CA-FIRST-NAME
 │                                      │                  ├─ CA-LAST-NAME
 │                                      ▼                  ├─ CA-DOB
 │                              CUSTOMER (Db2)             ├─ CA-HOUSE-NAME
 │                              ┌──────────┐              ├─ CA-HOUSE-NUM
 └──────────────────────────────┤ SELECT   │              ├─ CA-POSTCODE
                                └──────────┘              ├─ CA-PHONE-MOBILE
                                                          ├─ CA-PHONE-HOME
                                                          └─ CA-EMAIL-ADDRESS
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| lgicus01.cbl | `base/src/lgicus01.cbl` | COBOLプログラム | ビジネスロジック層（エントリーポイント） |
| lgicdb01.cbl | `base/src/lgicdb01.cbl` | COBOLプログラム | Db2データアクセス層（SELECT処理） |
| lgcmarea.cpy | `base/src/lgcmarea.cpy` | コピーブック | COMMAREA構造定義 |
| lgpolicy.cpy | `base/src/lgpolicy.cpy` | コピーブック | ポリシー/顧客データ長定義 |
| ssmap.bms | `base/src/ssmap.bms` | BMSマップ | 画面定義（SSMAPC1が顧客メニュー） |
| lgstsq.cbl | `base/src/lgstsq.cbl` | COBOLプログラム | エラーログ共通機能 |
