# 機能設計書 F020-システム初期化

## 概要

本ドキュメントは、保険契約管理システムにおけるシステム初期化機能について、その設計と仕様を詳細に記述したものである。

### 本機能の処理概要

システム初期化機能は、保険契約管理システムの運用環境を初期状態に設定する機能である。一時ストレージキュー（TSQ）の削除、顧客番号採番用のNamed Counterの再定義、および各種統計カウンタのリセットを行う。主に、Db2データベースの復元後やシステムの再初期化時に使用される。

**業務上の目的・背景**：システムの再初期化、テスト環境のセットアップ、本番環境のリセット、またはDb2データベースの復元後に、CICSリソース（TSQ、Named Counter）をデータベースの状態と同期させる必要がある。本機能は、これらのCICSリソースを適切に初期化し、システムの一貫性を確保する。

**機能の利用シーン**：システム管理者がCICSトランザクション「LGSF」を実行し、オプションとして最大顧客番号を指定する。最大顧客番号が指定されない場合は、デフォルト値（11）が使用される。

**主要な処理内容**：
1. 端末から最大顧客番号をオプションで受け取る
2. 統計・エラー関連のTSQを削除（GENAERRS、GENASTRT、GENASTAT）
3. 制御用TSQ（GENACNTL）を再作成し、顧客番号範囲を設定
4. 顧客番号採番用Named Counter（GENACUSTNUM）を再定義
5. 各種業務カウンタ（約40種類）を削除・再定義
6. 完了メッセージを端末に表示

**関連システム・外部連携**：CICSの一時ストレージキュー（TSQ）およびNamed Counter機能と連携する。Db2との直接連携はないが、Db2復元後の整合性確保に使用される。

**権限による制御**：本機能は管理者用のトランザクションであり、CICSセキュリティによりアクセスが制御されることが想定される。

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| - | コマンドライン | 主機能 | トランザクションLGSFを実行して初期化を行う |

## 機能種別

バッチ処理/管理機能

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| 最大顧客番号 | 9(8) | No | 顧客番号の最大値 | 数値、デフォルト=11 |

### 入力データソース

端末からのCICS RECEIVEコマンドでトランザクションデータを受け取る。

```
LGSF [最大顧客番号]
```

例：`LGSF 1000`（最大顧客番号を1000に設定）

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| 完了メッセージ | X(24) | 'HIGH CUSTOMER=xxxxxxxxxx'形式で最大顧客番号を表示 |

### 出力先

- CICS端末画面：完了メッセージを表示
- CICS TSQ（GENACNTL）：顧客番号範囲情報を書き込み
- CICS Named Counter：各種カウンタを再定義

## 処理フロー

### 処理シーケンス

```
1. LGSETUP: トランザクションデータ受信
   └─ CICS RECEIVEで最大顧客番号を取得
2. LGSETUP: 統計関連TSQ削除
   └─ GENAERRS、GENASTRT、GENASTATを削除
3. LGSETUP: 制御用TSQ再作成
   └─ GENACNTLを削除後、新規作成
4. LGSETUP: TSQにデータ書き込み
   └─ 見出し、最小顧客番号、最大顧客番号を書き込み
5. LGSETUP: Named Counter再定義（顧客番号）
   └─ GENACUSTNUMを削除・定義
6. LGSETUP: Named Counter再定義（業務カウンタ）
   └─ 約40種類のカウンタを削除・定義（値=0）
7. LGSETUP: 完了メッセージ表示
   └─ CICS SEND TEXTで結果を表示
8. LGSETUP: 終了
   └─ CICS RETURNで処理終了
```

### フローチャート

```mermaid
flowchart TD
    A[開始] --> B[CICS RECEIVEでデータ受信]
    B --> C{最大顧客番号指定?}
    C -->|Yes| D[指定値を使用]
    C -->|No| E[デフォルト値11を使用]
    D --> F[GENAERRS TSQ削除]
    E --> F
    F --> G[GENASTRT TSQ削除]
    G --> H[GENASTAT TSQ削除]
    H --> I[GENACNTL TSQ削除]
    I --> J[GENACNTL TSQに書き込み]
    J --> K[GENACUSTNUM Counter再定義]
    K --> L[業務カウンタ再定義ループ]
    L --> M[CICS SEND TEXT完了メッセージ]
    M --> N[CICS RETURN]
    N --> O[終了]
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-020-1 | デフォルト最大顧客番号 | 指定がない場合は11をデフォルト値として使用 | 常時 |
| BR-020-2 | 最小顧客番号固定 | 最小顧客番号は常に1 | 常時 |
| BR-020-3 | カウンタ初期値 | 業務カウンタは全て0で初期化 | 常時 |
| BR-020-4 | TSQ削除エラー無視 | TSQ削除時のエラーは無視して処理継続 | 常時 |
| BR-020-5 | Counter削除エラー無視 | Counter削除時のエラーは無視して処理継続 | 常時 |

### 計算ロジック

特別な計算ロジックは存在しない。入力値または固定値を使用してリソースを初期化する。

## データベース操作仕様

本機能はDb2データベースへの直接アクセスを行わない。

## CICSリソース操作仕様

### 一時ストレージキュー（TSQ）

| キュー名 | 操作 | 内容 |
|---------|------|------|
| GENAERRS | DeleteQ | エラーメッセージ格納用キュー |
| GENASTRT | DeleteQ | 開始情報格納用キュー |
| GENASTAT | DeleteQ | 統計情報格納用キュー |
| GENACNTL | DeleteQ/WriteQ | 制御情報格納用キュー |

### GENACNTLキューの内容

| 項目No | 内容 | 長さ |
|--------|------|------|
| 1 | 見出し（'**** GENAPP CNTL'） | 20バイト |
| 2 | 最小顧客番号（'LOW CUSTOMER=0000000001'） | 23バイト |
| 3 | 最大顧客番号（'HIGH CUSTOMER=xxxxxxxxxx'） | 24バイト |

### Named Counter

| カウンタ名 | プール | 初期値 | 用途 |
|-----------|-------|--------|------|
| GENACUSTNUM | GENA | 最大顧客番号 | 次の顧客番号採番用 |
| GENA01ICUS00-99 | GENA | 0 | 顧客照会カウンタ |
| GENA01ACUS00-99 | GENA | 0 | 顧客登録カウンタ |
| GENA01IMOT00-99 | GENA | 0 | 自動車保険照会カウンタ |
| GENA01AMOT00-99 | GENA | 0 | 自動車保険登録カウンタ |
| GENA01DMOT00-99 | GENA | 0 | 自動車保険削除カウンタ |
| GENA01UMOT00-99 | GENA | 0 | 自動車保険更新カウンタ |
| GENA01IEND00-99 | GENA | 0 | 養老保険照会カウンタ |
| GENA01AEND00-99 | GENA | 0 | 養老保険登録カウンタ |
| GENA01DEND00-99 | GENA | 0 | 養老保険削除カウンタ |
| GENA01UEND00-99 | GENA | 0 | 養老保険更新カウンタ |
| GENA01IHOU00-99 | GENA | 0 | 住宅保険照会カウンタ |
| GENA01AHOU00-99 | GENA | 0 | 住宅保険登録カウンタ |
| GENA01DHOU00-99 | GENA | 0 | 住宅保険削除カウンタ |
| GENA01UHOU00-99 | GENA | 0 | 住宅保険更新カウンタ |
| GENA01ICOM00-99 | GENA | 0 | 商業保険照会カウンタ |
| GENA01ACOM00-99 | GENA | 0 | 商業保険登録カウンタ |
| GENA01DCOM00-99 | GENA | 0 | 商業保険削除カウンタ |
| GENA01UCUS00-99 | GENA | 0 | 顧客更新カウンタ |

## エラー処理

### エラーケース一覧

| エラー種別 | 発生条件 | 対処方法 |
|----------|---------|---------|
| TSQ削除エラー | 対象キューが存在しない | 無視して処理継続 |
| TSQ書き込みエラー | リソース不足等 | エラーとして処理中止は行わない |
| Counter削除エラー | 対象カウンタが存在しない | 無視して処理継続 |
| Counter定義エラー | リソース競合等 | エラーとして処理中止は行わない |

### リトライ仕様

リトライ処理は実装されていない。エラーは無視して処理を継続する。

## トランザクション仕様

- トランザクションID：LGSF
- トランザクション種別：端末開始型
- タイムアウト：デフォルト
- 対話型ではなく、実行後即座に完了

## パフォーマンス要件

- レスポンス時間：通常5秒以内
- 約40種類のNamed Counterを順次処理するため、若干の時間を要する
- 頻繁な実行は想定されていない（システム初期化時のみ）

## セキュリティ考慮事項

- 本機能はシステム管理者専用のトランザクション
- CICSトランザクションセキュリティによるアクセス制御を推奨
- 不正実行により顧客番号採番に影響を与える可能性があるため、厳重なアクセス管理が必要
- 誤操作により統計情報が失われる可能性がある

## 備考

- 本機能はDb2データベースの復元後に実行することを想定
- Db2復元後、GENACUSTNUMカウンタをDb2の最大顧客番号に合わせることで、顧客番号の重複を防ぐ
- 業務カウンタは統計/監視目的で使用され、00と99のペアで管理される
- トランザクションコード「LGSF」はLGSETUP Facilityを意味すると推定
- 端末への出力は最大顧客番号の表示のみで、詳細なログは出力されない

## コードリーディングガイド

本機能のソースコードを理解するための推奨リーディング順序を以下に示す。

### 推奨リーディング順序

| Step | ファイル | 行番号 | 内容 |
|------|----------|--------|------|
| 1 | base/src/lgsetup.cbl | 18-100 | WORKING-STORAGE SECTIONの変数定義 |
| 2 | base/src/lgsetup.cbl | 128-135 | CICS RECEIVEでトランザクションデータ受信 |
| 3 | base/src/lgsetup.cbl | 138-152 | TSQ削除処理（GENAERRS/GENASTRT/GENASTAT/GENACNTL） |
| 4 | base/src/lgsetup.cbl | 154-176 | GENACNTL TSQへのデータ書き込み |
| 5 | base/src/lgsetup.cbl | 179-187 | GENACUSTNUM Counter再定義 |
| 6 | base/src/lgsetup.cbl | 189-400+ | 業務カウンタ（約40種類）の削除・再定義 |

### Step別詳細ガイド

#### Step 1: WORKING-STORAGE変数定義（lgsetup.cbl:18-100）
```cobol
01  FrstCustNum               PIC S9(8)  Value +0000001.
01  LastCustNum               PIC S9(8)  Value +0000011 COMP.
01  GENAcount                 PIC X(16) Value 'GENACUSTNUM'.
01  GENApool                  PIC X(8)  Value 'GENA'.
01  STSQ-STRT                 PIC X(8)  Value 'GENASTRT'.
01  STSQ-STAT                 PIC X(8)  Value 'GENASTAT'.
01  STSQ-ERRS                 PIC X(8)  Value 'GENAERRS'.
```
最小顧客番号（1）、最大顧客番号（デフォルト11）、各種TSQ/Counterの名前を定義。

#### Step 2: トランザクションデータ受信（lgsetup.cbl:128-135）
```cobol
EXEC CICS RECEIVE INTO(WS-RECV)
    LENGTH(WS-RECV-LEN)
    RESP(WS-RESP)
END-EXEC
If WS-RECV-LEN > 5
  Subtract 5 From WS-RECV-LEN
  Move WS-RECV-DATA(1:WS-RECV-LEN)  To LastCustNum
End-if
```
端末から「LGSF [最大顧客番号]」形式でデータを受信。トランザクションID（5バイト）を除いた部分を最大顧客番号として取得。

#### Step 3: TSQ削除処理（lgsetup.cbl:138-152）
```cobol
Exec CICS DeleteQ TS Queue(STSQ-ERRS)
         Resp(WS-RESP)
End-Exec.
Exec CICS DeleteQ TS Queue(STSQ-STRT)
         Resp(WS-RESP)
End-Exec.
Exec CICS DeleteQ TS Queue(STSQ-STAT)
         Resp(WS-RESP)
End-Exec.
Exec CICS DeleteQ TS Queue(STSQ-NAME)
         Resp(WS-RESP)
End-Exec.
```
エラーログ（GENAERRS）、開始情報（GENASTRT）、統計情報（GENASTAT）、制御情報（GENACNTL）のTSQを削除。エラーは無視。

#### Step 4: GENACNTL TSQ書き込み（lgsetup.cbl:154-176）
```cobol
Move FrstCustNum  to WRITE-MSG-LOW
Move LastCustNum  to WRITE-MSG-HIGH

EXEC CICS WRITEQ TS QUEUE(STSQ-NAME)
          FROM(WRITE-MSG-E)
          LENGTH(20)
END-EXEC
EXEC CICS WRITEQ TS QUEUE(STSQ-NAME)
          FROM(WRITE-MSG-L)
          LENGTH(23)
END-EXEC
EXEC CICS WRITEQ TS QUEUE(STSQ-NAME)
          FROM(WRITE-MSG-H)
          LENGTH(24)
END-EXEC
```
GENACNTL TSQに3項目を書き込み：見出し、最小顧客番号、最大顧客番号。

#### Step 5: GENACUSTNUM Counter再定義（lgsetup.cbl:179-187）
```cobol
Exec CICS Delete Counter(GENAcount)
                 Pool(GENApool)
                 Resp(WS-RESP)
End-Exec.
Exec CICS Define Counter(GENAcount)
                 Pool(GENApool)
                 Value(LastCustNum)
                 Resp(WS-RESP)
End-Exec.
```
顧客番号採番用カウンタを削除後、最大顧客番号で再定義。

#### Step 6: 業務カウンタ再定義（lgsetup.cbl:189-400+）
```cobol
Exec CICS Delete Counter(GENACNT100)
                 Pool(GENApool)
End-Exec.
Exec CICS Define Counter(GENACNT100)
                 Pool(GENApool)
                 Value(0)
End-Exec.
```
約40種類の業務カウンタ（01ICUS/01ACUS/01IMOT/01AMOT...）を削除・再定義（初期値0）。

### プログラム構造

```
LGSETUP (トランザクション: LGSF)
  ├─ CICS RECEIVE（トランザクションデータ受信）
  ├─ TSQ削除
  │    ├─ DeleteQ TS Queue(GENAERRS)
  │    ├─ DeleteQ TS Queue(GENASTRT)
  │    ├─ DeleteQ TS Queue(GENASTAT)
  │    └─ DeleteQ TS Queue(GENACNTL)
  ├─ TSQ書き込み
  │    └─ WRITEQ TS Queue(GENACNTL) × 3項目
  ├─ Named Counter再定義
  │    ├─ Delete/Define Counter(GENACUSTNUM)
  │    └─ Delete/Define Counter(GENA01xxxx00/99) × 約40種類
  ├─ CICS SEND TEXT（完了メッセージ）
  └─ CICS RETURN
```

### データフロー図

```
[端末入力: LGSF 1000]
         │
         ↓
    [CICS RECEIVE]
         │
         ↓
[最大顧客番号の取得（デフォルト:11）]
         │
         ↓
[TSQ削除: GENAERRS, GENASTRT, GENASTAT, GENACNTL]
         │
         ↓
[GENACNTL TSQ再作成]
├─ '**** GENAPP CNTL'
├─ 'LOW CUSTOMER=0000000001'
└─ 'HIGH CUSTOMER=xxxxxxxxxx'
         │
         ↓
[GENACUSTNUM Counter再定義（Value=最大顧客番号）]
         │
         ↓
[業務カウンタ再定義（Value=0）× 約40種類]
├─ GENA01ICUS00/99（顧客照会）
├─ GENA01ACUS00/99（顧客登録）
├─ GENA01IMOT00/99（自動車保険照会）
├─ ... 他のカウンタ ...
         │
         ↓
[端末出力: HIGH CUSTOMER=xxxxxxxxxx]
```

### 関連ファイル一覧

| ファイル | 種別 | 説明 |
|----------|------|------|
| lgsetup.cbl | COBOL | システム初期化メインプログラム |

### Named Counter一覧

| カウンタ名パターン | 用途 |
|-------------------|------|
| GENACUSTNUM | 次の顧客番号採番用 |
| GENA01ICUS00/99 | 顧客照会統計 |
| GENA01ACUS00/99 | 顧客登録統計 |
| GENA01UCUS00/99 | 顧客更新統計 |
| GENA01IMOT00/99 | 自動車保険照会統計 |
| GENA01AMOT00/99 | 自動車保険登録統計 |
| GENA01UMOT00/99 | 自動車保険更新統計 |
| GENA01DMOT00/99 | 自動車保険削除統計 |
| GENA01IEND00/99 | 養老保険照会統計 |
| GENA01AEND00/99 | 養老保険登録統計 |
| GENA01UEND00/99 | 養老保険更新統計 |
| GENA01DEND00/99 | 養老保険削除統計 |
| GENA01IHOU00/99 | 住宅保険照会統計 |
| GENA01AHOU00/99 | 住宅保険登録統計 |
| GENA01UHOU00/99 | 住宅保険更新統計 |
| GENA01DHOU00/99 | 住宅保険削除統計 |
| GENA01ICOM00/99 | 商業用不動産保険照会統計 |
| GENA01ACOM00/99 | 商業用不動産保険登録統計 |
| GENA01DCOM00/99 | 商業用不動産保険削除統計 |
