# 機能設計書 F021-VSAMファイル顧客取得

## 概要

本ドキュメントは、VSAMファイルからランダムに顧客番号を取得する機能（F021）の詳細設計を記載したものです。

### 本機能の処理概要

本機能は、VSAM KSDSファイル（KSDSCUST）からランダムに顧客番号を取得し、テスト用・自動化用途に顧客番号を提供します。

**業務上の目的・背景**：本機能は、保険システムのテストや自動化処理において、既存の有効な顧客番号を動的に取得する必要がある場面で利用されます。手動で顧客番号を入力する手間を省き、テストシナリオの自動化やデモンストレーションを容易にすることで、開発・検証作業の効率化を実現します。

**機能の利用シーン**：
- システムテスト時に有効な顧客番号が必要な場合
- 自動化スクリプトからランダムな顧客データを取得する場合
- デモンストレーション用のサンプルデータ取得

**主要な処理内容**：
1. 制御用TSQ（GENACNTL）から顧客番号の範囲（LOW/HIGH）を取得
2. TSQが存在しない場合は初期値を設定してTSQに書き込み
3. 乱数を生成して顧客番号範囲内のランダムな番号を算出
4. VSAMファイル（KSDSCUST）からGTEQ読み取りで顧客レコードを取得
5. 取得した顧客番号を呼び出し元に返却

**関連システム・外部連携**：
- VSAM KSDS顧客ファイル（KSDSCUST）との連携
- 一時ストレージキュー（GENACNTL）による顧客番号範囲管理
- LGTESTC1プログラムからの呼び出し

**権限による制御**：特になし（CICSトランザクション実行権限のみ）

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| - | - | - | 本機能は画面を持たないバックエンド処理です |

## 機能種別

データ取得処理（VSAM読み取り）

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| - | - | No | 入力パラメータなし（トランザクションLGCFまたはCICS LINKで起動） | - |

### 入力データソース

- 起動方法：CICSトランザクション（LGCF）またはCICS LINKによるプログラム呼び出し
- CICS ASSIGN関数により起動コード（STARTCODE）と呼び出し元プログラム（Invokingprog）を判定

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| HIGH CUSTOMER | PIC 9(10) | 取得したランダム顧客番号 |

### 出力先

- CICS LINK呼び出しの場合：COMMAREA経由で顧客番号を返却
- トランザクション直接実行の場合：端末画面にテキスト表示

## 処理フロー

### 処理シーケンス

```
1. 起動方法判定
   └─ STARTCODE/Invokingprogを確認し、LINK呼び出しか直接実行かを判定

2. 顧客番号範囲の初期化
   └─ WS-Cust-Low=0001000001、WS-Cust-High=0001000001を設定

3. TSQリソース排他制御
   └─ GENACNTL キューに対してENQを取得

4. 制御TSQ読み取り
   └─ GENACNTLキューからLOW CUSTOMER/HIGH CUSTOMERを順次読み取り
   └─ 存在しない場合はフラグを設定

5. TSQへの初期値書き込み（必要な場合）
   └─ TSQが存在しない場合、ヘッダーとLOW/HIGH値を書き込み

6. TSQリソース排他解除
   └─ GENACNTLキューに対してDEQを実行

7. 乱数による顧客番号算出
   └─ FUNCTION RANDOM(EIBTASKN)を使用して範囲内の乱数を生成

8. VSAMファイル読み取り
   └─ KSDSCUSTファイルからGTEQで顧客レコードを読み取り

9. 結果返却
   └─ 顧客番号をCOMMAREAまたは画面に出力
```

### フローチャート

```mermaid
flowchart TD
    A[開始] --> B{起動方法判定}
    B -->|LINK呼び出し| C[COMMエリア設定]
    B -->|トランザクション| D[RECEIVE処理]
    C --> E[初期値設定]
    D --> E
    E --> F[TSQ ENQ取得]
    F --> G{TSQ存在確認}
    G -->|存在する| H[LOW/HIGH値読み取り]
    G -->|存在しない| I[フラグ設定]
    H --> J[TSQ DEQ解除]
    I --> K[TSQ初期値書き込み]
    K --> J
    J --> L[乱数生成]
    L --> M[VSAM GTEQ読み取り]
    M --> N{読み取り成功?}
    N -->|Yes| O[顧客番号取得]
    N -->|No| P[エラー処理]
    O --> Q[結果返却]
    P --> Q
    Q --> R[終了]
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-001 | 顧客番号範囲 | 顧客番号はLOW値からHIGH値の範囲内で生成 | 常時 |
| BR-002 | 初期範囲 | 初期状態では0001000001が設定される | TSQが存在しない場合 |
| BR-003 | GTEQ検索 | 指定番号以上の最初のレコードを返却 | VSAM読み取り時 |

### 計算ロジック

乱数による顧客番号算出:
```
WS-Random-Number = Function Integer(
    (Function Random(EIBTASKN) * (WS-Cust-High - WS-Cust-Low)) + WS-Cust-Low
)
```

## データベース操作仕様

### 操作別データベース影響一覧

| 操作 | 対象テーブル | 操作種別 | 概要 |
|-----|-------------|---------|------|
| 顧客取得 | KSDSCUST（VSAM KSDS） | READ | 顧客番号をキーにGTEQ読み取り |

### テーブル別操作詳細

#### KSDSCUST（VSAM KSDSファイル）

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| READ | CA-CUSTOMER-NUM | 乱数で生成した顧客番号以上 | KeyLength=10、GTEQ指定 |

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| QIDERR | TSQエラー | GENACNTLキューが存在しない | 新規にTSQを作成 |
| NOT NORMAL | VSAM読み取りエラー | 該当レコードなし | そのまま処理継続 |

### リトライ仕様

リトライは実装されていません。

## トランザクション仕様

- ENQ/DEQによるTSQリソースの排他制御を実施
- VSAM読み取りは読み取り専用のため、コミット/ロールバックは不要

## パフォーマンス要件

- TSQアクセスとVSAM読み取りのみのため、レスポンスは高速
- ENQ/DEQによる排他制御があるため、同時実行時は待機が発生する可能性あり

## セキュリティ考慮事項

- CICSトランザクション実行権限による制御
- 顧客情報の参照のみで更新は行わない
- 監査ログは本機能では出力しない

## 備考

- 本機能は主にテスト目的で使用される
- LGTESTC1プログラムからも利用される
- 顧客番号範囲はGENACNTL TSQで管理され、顧客登録時に更新される

## コードリーディングガイド

本機能のソースコードを理解するための推奨リーディング順序を以下に示す。

### 推奨リーディング順序

| Step | ファイル | 行番号 | 内容 |
|------|----------|--------|------|
| 1 | base/src/lgicvs01.cbl | 22-76 | WORKING-STORAGE変数定義 |
| 2 | base/src/lgicvs01.cbl | 97-121 | 起動方法判定（LINK/トランザクション） |
| 3 | base/src/lgicvs01.cbl | 123-127 | 顧客番号範囲の初期値設定 |
| 4 | base/src/lgicvs01.cbl | 129-160+ | TSQ読み取りとENQ/DEQ処理 |
| 5 | base/src/lgicvs01.cbl | 乱数生成部 | FUNCTION RANDOMによる顧客番号算出 |
| 6 | base/src/lgicvs01.cbl | VSAM読み取り部 | KSDSCUST GTEQアクセス |

### Step別詳細ガイド

#### Step 1: WORKING-STORAGE変数定義（lgicvs01.cbl:22-76）
```cobol
01  WS-Cust-Low               Pic S9(10).
01  WS-Cust-High              Pic S9(10).
01  WS-Cust-Number            Pic X(10).
01  STSQ.
  03  STSQ-NAME               PIC X(8) Value 'GENACNTL'.
01 CA-AREA.
  03  CA-CUSTOMER-NUM         Pic X(10).
```
顧客番号範囲の低/高値、制御用TSQ名（GENACNTL）、出力用顧客番号領域を定義。

#### Step 2: 起動方法判定（lgicvs01.cbl:97-121）
```cobol
EXEC CICS ASSIGN STARTCODE(WS-STARTCODE)
     RESP(WS-RESP)
END-EXEC.

EXEC CICS ASSIGN Invokingprog(WS-Invokeprog)
     RESP(WS-RESP)
END-EXEC.

IF WS-STARTCODE(1:1) = 'D' or
   WS-Invokeprog Not = Spaces
   MOVE 'C' To WS-FLAG
   MOVE COMMA-DATA  TO WS-COMMAREA
ELSE
   EXEC CICS RECEIVE INTO(WS-RECV)
       LENGTH(WS-RECV-LEN)
   END-EXEC
   MOVE 'R' To WS-FLAG
END-IF.
```
STARTCODEが'D'（Distributed）またはInvokingprogが設定されている場合はLINK呼び出し、それ以外はトランザクション直接実行と判定。

#### Step 3: 顧客番号範囲の初期値設定（lgicvs01.cbl:123-127）
```cobol
Move 0001000001 to WS-Cust-Low
Move 0001000001 to WS-Cust-High
Move 'Y'        to WS-FLAG-TSQE
Move 'Y'        to WS-FLAG-TSQH
Move 'Y'        to WS-FLAG-TSQL
```
初期値として最小/最大顧客番号を1000001に設定。TSQフラグを初期化。

#### Step 4: TSQ読み取りとENQ/DEQ処理（lgicvs01.cbl:129-160+）
```cobol
EXEC CICS ENQ Resource(STSQ-NAME)
              Length(Length Of STSQ-NAME)
END-EXEC.

Exec CICS ReadQ TS Queue(STSQ-NAME)
          Into(READ-MSG)
          Item(1)
End-Exec.

If WS-RESP = DFHRESP(NORMAL) And
   Read-Msg-Msg(1:12) = 'LOW CUSTOMER'
   Move READ-CUST-LOW to WS-Cust-Low
End-If
```
GENACNTLキューに排他ロック（ENQ）を取得後、LOW CUSTOMER/HIGH CUSTOMERの値を読み取り。

#### Step 5: 乱数生成による顧客番号算出
```cobol
WS-Random-Number = Function Integer(
    (Function Random(EIBTASKN) * (WS-Cust-High - WS-Cust-Low)) + WS-Cust-Low
)
```
EIBTASKNをシードとしてRANDOM関数で乱数生成、顧客番号範囲内のランダムな番号を算出。

#### Step 6: VSAM読み取り
```cobol
Exec CICS Read File('KSDSCUST')
          Into(CA-AREA)
          Ridfld(WS-Cust-Number)
          KeyLength(F10)
          GTEQ
End-Exec.
```
KSDSCUSTファイルから指定顧客番号以上（GTEQ）の最初のレコードを読み取り。

### プログラム構造

```
LGICVS01 (トランザクション: LGCF)
  ├─ CICS ASSIGN（起動方法判定）
  │    ├─ STARTCODE
  │    └─ Invokingprog
  ├─ 顧客番号範囲初期化
  ├─ TSQ処理
  │    ├─ ENQ Resource(GENACNTL)
  │    ├─ ReadQ TS Queue(GENACNTL)
  │    │    ├─ Item(1): ヘッダー
  │    │    ├─ 'LOW CUSTOMER=...'
  │    │    └─ 'HIGH CUSTOMER=...'
  │    └─ DEQ Resource(GENACNTL)
  ├─ 乱数生成（FUNCTION RANDOM）
  ├─ VSAM読み取り
  │    └─ Read File('KSDSCUST') GTEQ
  └─ 結果返却
       ├─ LINK: COMMAREA設定
       └─ TRAN: SEND TEXT
```

### データフロー図

```
[GENACNTL TSQ]
├─ LOW CUSTOMER=0001000001
└─ HIGH CUSTOMER=0001000XXX
         │
         ↓
    [乱数生成]
    RANDOM(EIBTASKN) * (HIGH - LOW) + LOW
         │
         ↓
[KSDSCUST VSAM GTEQ読み取り]
         │
         ↓
   [顧客番号取得]
         │
         ↓
[COMMAREA または 画面出力]
```

### 関連ファイル一覧

| ファイル | 種別 | 説明 |
|----------|------|------|
| lgicvs01.cbl | COBOL | VSAMファイル顧客取得メインプログラム |
| KSDSCUST | VSAM KSDS | 顧客ファイル |
| GENACNTL | TSQ | 顧客番号範囲制御用 |
