# 機能設計書 F022-VSAMファイルポリシー取得

## 概要

本ドキュメントは、VSAMファイルからポリシー番号・顧客番号を取得する機能（F022）の詳細設計を記載したものです。

### 本機能の処理概要

本機能は、VSAM KSDSファイル（KSDSPOLY）からポリシータイプを指定してポリシー情報（ポリシー番号・顧客番号）を取得し、テスト用・自動化用途に提供します。

**業務上の目的・背景**：本機能は、保険システムのテストや自動化処理において、既存の有効なポリシー情報を動的に取得する必要がある場面で利用されます。ポリシータイプ（自動車・養老・住宅・商業用不動産）を指定することで、特定種別のポリシーデータを効率的に取得できます。

**機能の利用シーン**：
- システムテスト時に有効なポリシー情報が必要な場合
- 自動化スクリプトから特定タイプのポリシーデータを取得する場合
- ポリシー関連機能のデモンストレーション用データ取得

**主要な処理内容**：
1. 入力パラメータからポリシータイプと顧客番号を取得
2. パーシャルキー（タイプ+顧客番号）を構成
3. VSAMファイル（KSDSPOLY）からGeneric指定でGTEQ読み取り
4. ポリシータイプが一致する場合、ポリシー情報を返却
5. 一致しない場合はエラー情報を返却

**関連システム・外部連携**：
- VSAM KSDSポリシーファイル（KSDSPOLY）との連携
- CICSトランザクションまたはLINK呼び出しでの起動

**権限による制御**：特になし（CICSトランザクション実行権限のみ）

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| - | - | - | 本機能は画面を持たないバックエンド処理です |

## 機能種別

データ取得処理（VSAM読み取り）

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| ポリシータイプ | PIC X(1) | Yes | ポリシー種別（M:自動車, E:養老, H:住宅, C:商業用不動産） | 1文字 |
| 顧客番号 | PIC 9(10) | No | 検索対象の顧客番号 | 数字10桁 |

### 入力データソース

- 起動方法：CICSトランザクション（LGPF）またはCICS LINKによるプログラム呼び出し
- トランザクション実行時：CICS RECEIVE経由で入力データを受信
- LINK呼び出し時：COMMAREA経由で入力データを受け取り

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| テキスト | PIC X(11) | "Policy Key="または"Policy Bad=" |
| ポリシータイプ | PIC X(1) | ポリシー種別 |
| 顧客番号 | PIC 9(10) | 顧客番号 |
| ポリシー番号 | PIC 9(10) | ポリシー番号 |

### 出力先

- CICS LINK呼び出しの場合：COMMAREA経由でポリシー情報を返却
- トランザクション直接実行の場合：端末画面にテキスト表示

## 処理フロー

### 処理シーケンス

```
1. 起動方法判定
   └─ STARTCODE/Invokingprogを確認し、LINK呼び出しか直接実行かを判定

2. 入力データ取得
   └─ COMMエリアまたはRECEIVEでポリシータイプ・顧客番号を取得

3. パーシャルキー構成
   └─ ポリシータイプ(1桁) + 顧客番号(10桁)でキーを作成

4. VSAMファイル読み取り
   └─ KSDSPOLYファイルからGeneric + GTEQで読み取り
   └─ KeyLength=11でパーシャルキー検索

5. 結果判定
   └─ 取得したポリシータイプと入力タイプを比較
   └─ 一致：正常結果を設定
   └─ 不一致：エラー結果を設定

6. 結果返却
   └─ ポリシー情報をCOMMAREAまたは画面に出力
```

### フローチャート

```mermaid
flowchart TD
    A[開始] --> B{起動方法判定}
    B -->|LINK呼び出し| C[COMMエリアから入力取得]
    B -->|トランザクション| D[RECEIVE処理]
    C --> E[パーシャルキー構成]
    D --> E
    E --> F[VSAM Generic+GTEQ読み取り]
    F --> G{読み取り成功かつタイプ一致?}
    G -->|Yes| H[ポリシー情報を設定]
    G -->|No| I[エラー情報を設定]
    H --> J{LINK呼び出し?}
    I --> J
    J -->|Yes| K[COMMエリアに結果設定]
    J -->|No| L[画面にテキスト表示]
    K --> M[終了]
    L --> M
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-001 | ポリシータイプ検証 | 取得したレコードのポリシータイプが指定タイプと一致すること | VSAM読み取り成功時 |
| BR-002 | Generic検索 | パーシャルキー（タイプ+顧客番号）でGTEQ検索 | 常時 |
| BR-003 | エラー番号 | タイプ不一致時はポリシー番号・顧客番号に13を設定 | 不一致時 |

### 計算ロジック

特になし

## データベース操作仕様

### 操作別データベース影響一覧

| 操作 | 対象テーブル | 操作種別 | 概要 |
|-----|-------------|---------|------|
| ポリシー取得 | KSDSPOLY（VSAM KSDS） | READ | パーシャルキーでGeneric+GTEQ読み取り |

### テーブル別操作詳細

#### KSDSPOLY（VSAM KSDSファイル）

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| READ | CA-POLICY-TYPE | ポリシータイプ（キーの1桁目） | Generic検索 |
| READ | CA-CUSTOMER-NUM | 顧客番号（キーの2-11桁目） | GTEQ指定 |
| READ | CA-POLICY-NUM | ポリシー番号 | 取得対象 |

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| NOT NORMAL | VSAM読み取りエラー | 該当レコードなし | "Policy Bad="を返却 |
| タイプ不一致 | 論理エラー | ポリシータイプが入力と異なる | "Policy Bad="を返却 |

### リトライ仕様

リトライは実装されていません。

## トランザクション仕様

- VSAM読み取りは読み取り専用のため、コミット/ロールバックは不要

## パフォーマンス要件

- VSAMのGeneric読み取りのみのため、レスポンスは高速
- KeyLength=11でのパーシャルキー検索により効率的なアクセス

## セキュリティ考慮事項

- CICSトランザクション実行権限による制御
- ポリシー情報の参照のみで更新は行わない
- 監査ログは本機能では出力しない

## 備考

- 本機能は主にテスト目的で使用される
- ポリシータイプは内部的に以下のコードで管理：
  - M: Motor（自動車保険）
  - E: Endowment（養老保険）
  - H: House（住宅保険）
  - C: Commercial（商業用不動産保険）

## コードリーディングガイド

本機能のソースコードを理解するための推奨リーディング順序を以下に示す。

### 推奨リーディング順序

| Step | ファイル | 行番号 | 内容 |
|------|----------|--------|------|
| 1 | base/src/lgipvs01.cbl | 18-58 | WORKING-STORAGE変数定義 |
| 2 | base/src/lgipvs01.cbl | 79-105 | 起動方法判定（LINK/トランザクション） |
| 3 | base/src/lgipvs01.cbl | 107-109 | パーシャルキー構成 |
| 4 | base/src/lgipvs01.cbl | 111-119 | VSAM Generic+GTEQ読み取り |
| 5 | base/src/lgipvs01.cbl | 121-128 | ポリシータイプ検証と結果設定 |
| 6 | base/src/lgipvs01.cbl | 130-141 | 結果返却（COMMAREA/画面） |

### Step別詳細ガイド

#### Step 1: WORKING-STORAGE変数定義（lgipvs01.cbl:18-58）
```cobol
01  WRITE-MSG.
  03 WRITE-MSG-Text           PIC X(11) Value 'Policy Key='.
  03 WRITE-MSG-Key.
    05  WRITE-Msg-Type        Pic X Value 'X'.
    05  WRITE-Msg-CustNum     Pic 9(10).
    05  WRITE-Msg-PolNum      Pic 9(10).

01 PART-KEY.
   03 PART-KEY-Type           PIC X.
   03 PART-KEY-Num            PIC 9(10).

01 CA-AREA.
  03  CA-POLICY-TYPE          Pic X.
  03  CA-CUSTOMER-NUM         Pic X(10).
  03  CA-POLICY-NUM           Pic X(10).
```
出力メッセージ、パーシャルキー（タイプ+顧客番号）、取得データ領域を定義。

#### Step 2: 起動方法判定（lgipvs01.cbl:79-105）
```cobol
EXEC CICS ASSIGN STARTCODE(WS-STARTCODE)
     RESP(WS-RESP)
END-EXEC.

EXEC CICS ASSIGN Invokingprog(WS-Invokeprog)
     RESP(WS-RESP)
END-EXEC.

IF WS-STARTCODE(1:1) = 'D' or
   WS-Invokeprog Not = Spaces
   MOVE 'C' To WS-FLAG
   MOVE COMMA-DATA  TO WS-COMMAREA
ELSE
   EXEC CICS RECEIVE INTO(WS-RECV)
       LENGTH(WS-RECV-LEN)
   END-EXEC
   MOVE 'R' To WS-FLAG
END-IF.
```
STARTCODEまたはInvokingprogでLINK呼び出しかトランザクション直接実行かを判定。

#### Step 3: パーシャルキー構成（lgipvs01.cbl:107-109）
```cobol
Move Spaces                      To CA-Area
Move WS-Commarea(1:1)            To Part-Key-Type
Move WS-Commarea(2:WS-RECV-LEN)  To Part-Key-Num
```
入力データからポリシータイプ（1桁）と顧客番号（10桁）でパーシャルキーを構成。

#### Step 4: VSAM Generic+GTEQ読み取り（lgipvs01.cbl:111-119）
```cobol
Exec CICS Read File('KSDSPOLY')
          Into(CA-AREA)
          Length(F64)
          Ridfld(PART-KEY)
          KeyLength(F11)
          Generic
          RESP(WS-RESP)
          GTEQ
End-Exec.
```
KSDSPOLYファイルに対してパーシャルキー（11バイト）でGeneric＋GTEQ検索を実行。

#### Step 5: ポリシータイプ検証と結果設定（lgipvs01.cbl:121-128）
```cobol
If CA-Policy-Type   Not = Part-Key-Type Or
   WS-RESP NOT          = DFHRESP(NORMAL)
  Move 'Policy Bad='   To Write-Msg-Text
  Move 13              To WRITE-Msg-CustNum
  Move 13              To WRITE-Msg-PolNum
Else
  Move CA-Area to WRITE-MSG-Key
End-If
```
取得したレコードのポリシータイプが入力タイプと一致しない場合は「Policy Bad=」を設定。

#### Step 6: 結果返却（lgipvs01.cbl:130-141）
```cobol
If WS-FLAG = 'R' Then
  EXEC CICS SEND TEXT FROM(WRITE-MSG)
   WAIT ERASE LENGTH(80) FREEKB
  END-EXEC
Else
  Move Spaces          To COMMA-Data
  Move Write-Msg-Text  To COMMA-Data-Text
  Move Write-Msg-Key   To COMMA-Data-Key
End-If.
```
トランザクション実行の場合は画面出力、LINK呼び出しの場合はCOMMAREAに結果を設定。

### プログラム構造

```
LGIPVS01 (トランザクション: LGPF)
  ├─ CICS ASSIGN（起動方法判定）
  │    ├─ STARTCODE
  │    └─ Invokingprog
  ├─ 入力データ取得
  │    ├─ LINK: COMMAREA
  │    └─ TRAN: RECEIVE
  ├─ パーシャルキー構成
  │    ├─ PART-KEY-Type（1桁）
  │    └─ PART-KEY-Num（10桁）
  ├─ VSAM読み取り
  │    └─ Read File('KSDSPOLY') Generic GTEQ KeyLength(11)
  ├─ ポリシータイプ検証
  │    ├─ 一致: 'Policy Key=' + データ
  │    └─ 不一致: 'Policy Bad=' + 13,13
  └─ 結果返却
       ├─ TRAN: SEND TEXT
       └─ LINK: COMMAREA設定
```

### データフロー図

```
[入力データ]
├─ ポリシータイプ（M/E/H/C）
└─ 顧客番号
         │
         ↓
[パーシャルキー構成]
Type(1) + CustomerNum(10) = 11バイト
         │
         ↓
[KSDSPOLY Generic+GTEQ読み取り]
         │
         ↓
[ポリシータイプ検証]
  │              │
  │一致          │不一致
  ↓              ↓
'Policy Key='  'Policy Bad='
Type+CustNum   13+13
+PolicyNum
         │
         ↓
[COMMAREA または 画面出力]
```

### 関連ファイル一覧

| ファイル | 種別 | 説明 |
|----------|------|------|
| lgipvs01.cbl | COBOL | VSAMファイルポリシー取得メインプログラム |
| KSDSPOLY | VSAM KSDS | ポリシーファイル |

### ポリシータイプコード

| コード | 説明 |
|--------|------|
| M | Motor（自動車保険） |
| E | Endowment（養老保険） |
| H | House（住宅保険） |
| C | Commercial（商業用不動産保険） |
