# 機能設計書 F023-トランザクション統計更新

## 概要

本ドキュメントは、トランザクションカウントを名前付きカウンタで更新する機能（F023）の詳細設計を記載したものです。

### 本機能の処理概要

本機能は、CICSイベントアダプタからトリガーされ、トランザクション実行回数を名前付きカウンタ（Named Counter Server）で更新します。ビジネス監視およびシステム統計収集のための基盤機能です。

**業務上の目的・背景**：保険システムにおける各種トランザクション（顧客登録、ポリシー照会等）の実行回数を統計的に把握することで、システム利用状況の監視、性能分析、キャパシティプランニングに活用します。イベント駆動型アーキテクチャにより、業務処理に影響を与えずに統計情報を収集できます。

**機能の利用シーン**：
- 各業務トランザクション実行後のカウンタ更新
- ビジネス監視ダッシュボードへのデータ提供
- トランザクション成功/失敗の統計収集

**主要な処理内容**：
1. CICSイベントコンテナからリクエストIDとリターンコードを取得
2. コンテナが取得できない場合はCOMMAREAから取得
3. 統計TSQ（GENASTRT）の存在確認と初期化
4. リクエストIDに基づくカウンタ名を構成
5. 名前付きカウンタ（GENAプール）の値を取得・更新

**関連システム・外部連携**：
- CICSイベントアダプタ（Transaction_Counters.evbind）
- 名前付きカウンタサーバー（GENAプール）
- 一時ストレージキュー（GENASTRT）

**権限による制御**：特になし（CICSトランザクション実行権限のみ）

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| - | - | - | 本機能は画面を持たないバックエンド処理です |

## 機能種別

統計更新処理（カウンタ更新）

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| WS-Data-Req | PIC X(6) | Yes | リクエストID（例：01ICUS, 01ACUS） | 6文字 |
| WS-Data-RC | PIC X(2) | Yes | リターンコード（00:成功、その他:エラー） | 2文字 |

### 入力データソース

- CICSイベントコンテナ（DFHEP.DATA.00001、DFHEP.DATA.00002）
- またはCOMMエリア（CA-REQUEST-ID、CA-RETURN-CODE）

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| Trancount | PIC S9(8) COMP | 名前付きカウンタの現在値 |

### 出力先

- 名前付きカウンタサーバー（GENAプール）のカウンタ更新

## 処理フロー

### 処理シーケンス

```
1. ヘッダー情報初期化
   └─ EIBTRNID、EIBTRMID、EIBTASKN、EIBCALENを取得

2. イベントコンテナからデータ取得
   └─ DFHEP.DATA.00001からリクエストID
   └─ DFHEP.DATA.00002からリターンコード

3. コンテナ取得失敗時のフォールバック
   └─ COMMエリアが空の場合はRETURN
   └─ COMMエリアからCA-REQUEST-ID、CA-RETURN-CODEを取得

4. 統計TSQ確認・初期化
   └─ GENASTRTキューの存在確認
   └─ 存在しない場合は日時情報を書き込み

5. カウンタ名の正規化
   └─ 02ACUS → 01ACUS（カウンタ名を統一）
   └─ 02ICOM/03ICOM/05ICOM → 01ICOM
   └─ リターンコード00以外 → 99（エラーカウンタ）

6. 名前付きカウンタ取得
   └─ GENAプールからカウンタ値を取得（自動インクリメント）

7. 終了
```

### フローチャート

```mermaid
flowchart TD
    A[開始] --> B[ヘッダー情報初期化]
    B --> C[イベントコンテナからデータ取得]
    C --> D{コンテナ取得成功?}
    D -->|Yes| E[リクエストID/RC設定]
    D -->|No| F{EIBCALEN > 0?}
    F -->|No| G[RETURN終了]
    F -->|Yes| H[COMMエリアからデータ取得]
    H --> E
    E --> I{統計TSQ存在?}
    I -->|No| J[日時情報でTSQ初期化]
    I -->|Yes| K[カウンタ名正規化]
    J --> K
    K --> L[名前付きカウンタ取得]
    L --> M[RETURN終了]
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-001 | カウンタ名統一 | 02ACUSは01ACUSとしてカウント | リクエストID=02ACUS |
| BR-002 | 商業保険統一 | 02ICOM/03ICOM/05ICOMは01ICOMとしてカウント | 該当リクエストID |
| BR-003 | エラーカウント | リターンコード00以外は99（エラー）としてカウント | RC != 00 |
| BR-004 | カウンタ名形式 | GENA + リクエストID + リターンコード | 常時 |

### 計算ロジック

カウンタ名構成:
```
GENAcount = 'GENA' + GENAcounter(6桁) + GENAtype(2桁)
例: GENA01ICUS00（顧客照会成功）、GENA01ACUS99（顧客登録エラー）
```

## データベース操作仕様

### 操作別データベース影響一覧

| 操作 | 対象テーブル | 操作種別 | 概要 |
|-----|-------------|---------|------|
| カウンタ取得 | Named Counter（GENAプール） | GET | カウンタ値を取得（自動インクリメント） |
| TSQ読み書き | GENASTRT（TSQ） | READ/WRITE | 統計開始日時の管理 |

### テーブル別操作詳細

#### Named Counter（GENAプール）

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| GET | GENAcount | カウンタ名でアクセス | 取得と同時にインクリメント |

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| QIDERR | TSQエラー | GENASTRTキューが存在しない | 新規にTSQを作成 |
| EIBCALEN=0 | 入力なし | COMMエリアが空 | 即座にRETURN |

### リトライ仕様

リトライは実装されていません。

## トランザクション仕様

- イベント駆動型のため、元トランザクションとは独立して実行
- カウンタ更新は自動的に永続化

## パフォーマンス要件

- イベントアダプタ経由の非同期実行
- 名前付きカウンタへの高速アクセス

## セキュリティ考慮事項

- CICSトランザクション実行権限による制御
- 統計情報の更新のみで業務データへのアクセスなし

## 備考

- トランザクションコードはLGST
- イベントバインディング定義：Transaction_Counters.evbind
- カウンタプール：GENA
- 統計TSQ：GENASTRT

## コードリーディングガイド

本機能のソースコードを理解するための推奨リーディング順序を以下に示す。

### 推奨リーディング順序

| Step | ファイル | 行番号 | 内容 |
|------|----------|--------|------|
| 1 | base/src/lgastat1.cbl | 13-55 | WORKING-STORAGE変数定義 |
| 2 | base/src/lgastat1.cbl | 69-78 | ヘッダー情報初期化 |
| 3 | base/src/lgastat1.cbl | 79-99 | イベントコンテナからデータ取得 |
| 4 | base/src/lgastat1.cbl | 100以降 | カウンタ名正規化と取得 |

### Step別詳細ガイド

#### Step 1: WORKING-STORAGE変数定義（lgastat1.cbl:13-55）
```cobol
01  WS-Qname                   Pic X(8) value 'GENASTRT'.
01  WS-CHANname1       Pic X(16) value 'DFHEP.DATA.00001'.
01  WS-CHANname2       Pic X(16) value 'DFHEP.DATA.00002'.
01  WS-Data-Req                Pic X(6).
01  WS-Data-RC                 Pic X(2).
01  GENAcount.
  03 Filler                    Pic X(4) Value 'GENA'.
  03 GENAcounter               Pic X(6).
  03 GENAtype                  Pic X(2).
77  GENApool                   PIC X(8)  Value 'GENA'.
```
統計TSQ名（GENASTRT）、イベントコンテナ名（DFHEP.DATA.00001/00002）、カウンタ名構成用変数を定義。

#### Step 2: ヘッダー情報初期化（lgastat1.cbl:69-78）
```cobol
INITIALIZE WS-HEADER.
MOVE EIBTRNID TO WS-TRANSID.
MOVE EIBTRMID TO WS-TERMID.
MOVE EIBTASKN TO WS-TASKNUM.
MOVE EIBCALEN TO WS-CALEN.
```
EIBからトランザクション情報を取得し、ヘッダーに設定。

#### Step 3: イベントコンテナからデータ取得（lgastat1.cbl:79-99）
```cobol
Exec CICS Get Container(WS-CHANname1)
              Into(WS-Data-Req)
              Resp(WS-RESP)
End-Exec.

Exec CICS Get Container(WS-CHANname2)
              Into(WS-Data-RC)
              Resp(WS-RESP)
End-Exec.

If WS-RESP = DFHRESP(NORMAL)
  Move WS-Data-REQ  To  GENACounter
  Move WS-Data-RC   To  GENAType
Else
  IF EIBCALEN IS EQUAL TO ZERO
      EXEC CICS RETURN END-EXEC
  Else
    Move CA-REQUEST-ID  To GENAcounter
    Move CA-RETURN-CODE To GENAtype
  End-if
End-if.
```
CICSイベントアダプタのコンテナからリクエストID/リターンコードを取得。失敗時はCOMMAREAからフォールバック。

#### Step 4: カウンタ取得（lgastat1.cbl:100以降）
```cobol
Exec CICS Get Counter(GENAcount)
              Pool(GENApool)
              Value(Trancount)
              Resp(WS-RESP)
End-Exec.
```
構成したカウンタ名（GENA + リクエストID + リターンコード）でNamed Counterにアクセスし、自動インクリメント。

### プログラム構造

```
LGASTAT1 (トランザクション: LGST)
  ├─ ヘッダー初期化（EIB情報取得）
  ├─ イベントコンテナからデータ取得
  │    ├─ DFHEP.DATA.00001 → リクエストID
  │    └─ DFHEP.DATA.00002 → リターンコード
  ├─ フォールバック（コンテナ取得失敗時）
  │    └─ COMMAREA → CA-REQUEST-ID/CA-RETURN-CODE
  ├─ TSQ確認（GENASTRT）
  ├─ カウンタ名正規化
  │    ├─ 02ACUS → 01ACUS
  │    └─ RC != 00 → 99（エラー）
  └─ Named Counter取得（GET Counter）
```

### データフロー図

```
[CICSイベントアダプタ]
├─ DFHEP.DATA.00001（リクエストID）
└─ DFHEP.DATA.00002（リターンコード）
         │
         ↓
[イベントコンテナ取得失敗?]
  │Yes            │No
  ↓               ↓
[COMMAREA]    [コンテナデータ]
         │
         ↓
[カウンタ名構成]
GENA + リクエストID(6) + リターンコード(2)
例: GENA01ICUS00
         │
         ↓
[Named Counter GET]
（GENAプール）
```

### 関連ファイル一覧

| ファイル | 種別 | 説明 |
|----------|------|------|
| lgastat1.cbl | COBOL | トランザクション統計更新メインプログラム |
| lgcmarea.cpy | COPY句 | COMMARCAデータ構造定義 |
| GENASTRT | TSQ | 統計開始情報 |
| GENAプール | Named Counter | トランザクションカウンタ格納 |
