# 機能設計書 F024-統計データ収集

## 概要

本ドキュメントは、ビジネス監視用に統計データを一時ストレージキューに収集する機能（F024）の詳細設計を記載したものです。

### 本機能の処理概要

本機能は、名前付きカウンタサーバー（GENAプール）から各種トランザクション統計を取得し、一時ストレージキュー（TSQ）に格納します。60秒間隔で自動的に再実行され、継続的な統計収集を行います。

**業務上の目的・背景**：保険システムの運用監視において、トランザクション実行状況をリアルタイムに把握することが重要です。本機能は名前付きカウンタから統計値を収集し、ビジネス監視ツールやダッシュボードから参照可能な形式でTSQに格納します。これにより、システム管理者は業務処理量の推移を監視し、異常検知や容量計画に活用できます。

**機能の利用シーン**：
- ビジネス監視ダッシュボードへのデータ提供
- トランザクション実行率の分析
- システム負荷の監視

**主要な処理内容**：
1. 現在時刻を取得し、前回実行からの経過時間を計算
2. 各トランザクションカウンタ（顧客照会、顧客登録、各種ポリシー操作等）の値を取得
3. 成功/エラー件数を集計
4. 各カウンタ値をTSQに格納（現在値、前回値、差分）
5. 60秒後に自身を再スケジュール（CICS START）

**関連システム・外部連携**：
- 名前付きカウンタサーバー（GENAプール）
- 一時ストレージキュー（GENA*プレフィックス）
- CICS STARTによる自己再スケジュール

**権限による制御**：特になし（CICSトランザクション実行権限のみ）

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| - | - | - | 本機能は画面を持たないバックエンド処理です |

## 機能種別

バッチ処理（定期実行統計収集）

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| - | - | No | 入力パラメータなし（自動スケジュール実行） | - |

### 入力データソース

- 名前付きカウンタサーバー（GENAプール）の各カウンタ
- 前回実行時刻（TSQ GENA000V）

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| 経過時間 | PIC 9(6) | 前回からの経過秒数 |
| カウンタ値 | PIC 9(9) | 各トランザクションの累計実行回数 |
| 成功件数 | PIC 9(9) | 全トランザクション成功件数 |
| エラー件数 | PIC 9(9) | 全トランザクションエラー件数 |

### 出力先

- 一時ストレージキュー（GENAプレフィックス）
  - GENA000V: 経過時間
  - GENA100V-GENAH99V: 各カウンタ値
  - GENAX00V-GENAX04V: 集計値

## 処理フロー

### 処理シーケンス

```
1. ヘッダー情報初期化
   └─ トランザクションID、端末ID、タスク番号を設定

2. 時刻取得と経過時間計算
   └─ 現在時刻を取得（ASKTIME/FORMATTIME）
   └─ 前回実行時刻をTSQから取得
   └─ 経過秒数を計算

3. 各カウンタ値取得・TSQ格納
   └─ 顧客照会（01ICUS）成功/エラー
   └─ 顧客登録（01ACUS）成功/エラー
   └─ 自動車保険照会/登録/削除/更新
   └─ 養老保険照会/登録/削除/更新
   └─ 住宅保険照会/登録/削除/更新
   └─ 商業保険照会/登録/削除
   └─ その他（GENAOTHER）

4. 集計処理
   └─ 成功件数合計
   └─ エラー件数合計
   └─ 操作種別（照会/登録/更新/削除）ごとの集計

5. APPLID取得
   └─ CICS ASSIGN APPLIDで取得

6. 再スケジュール
   └─ CICS START TRANSID('SSST') AFTER MINUTES(1)

7. 終了
```

### フローチャート

```mermaid
flowchart TD
    A[開始] --> B[ヘッダー初期化]
    B --> C[時刻取得]
    C --> D[経過時間計算]
    D --> E[顧客カウンタ取得]
    E --> F[自動車保険カウンタ取得]
    F --> G[養老保険カウンタ取得]
    G --> H[住宅保険カウンタ取得]
    H --> I[商業保険カウンタ取得]
    I --> J[その他カウンタ取得]
    J --> K[成功/エラー集計]
    K --> L[操作種別集計]
    L --> M[APPLID取得]
    M --> N[60秒後再スケジュール]
    N --> O[終了]
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-001 | 実行間隔 | 60秒間隔で自動実行 | 常時 |
| BR-002 | TSQ構造 | 各TSQは3レコード（現在値、前回値、差分） | カウンタごと |
| BR-003 | 初期値 | TSQ未存在時は経過時間120秒を仮定 | 初回実行時 |

### 計算ロジック

経過時間計算:
```
現在秒数 = (時 * 3600) + (分 * 60) + 秒
経過時間 = 現在秒数 - 前回秒数
```

トランザクションレート:
```
差分値 = 現在カウンタ値 - 前回カウンタ値
```

## データベース操作仕様

### 操作別データベース影響一覧

| 操作 | 対象テーブル | 操作種別 | 概要 |
|-----|-------------|---------|------|
| カウンタ照会 | Named Counter（GENAプール） | QUERY | 各カウンタ値の取得 |
| TSQ読み書き | GENA*（TSQ群） | READ/DELETE/WRITE | 統計値の格納 |

### テーブル別操作詳細

#### Named Counter（GENAプール）

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| QUERY | GENACUSTNUM | 顧客番号カウンタ | 参照のみ |
| QUERY | GENA01ICUS00 | 顧客照会成功 | 参照のみ |
| QUERY | GENA01ICUS99 | 顧客照会エラー | 参照のみ |
| QUERY | GENA01ACUS00 | 顧客登録成功 | 参照のみ |
| ... | ... | その他多数 | 全30種以上 |

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| NOT NORMAL | TSQ読み取りエラー | TSQ未存在 | 初期値（120秒）を使用 |
| COUNTER ERROR | カウンタエラー | カウンタ未存在 | エラーを無視して継続 |

### リトライ仕様

- エラー発生時も処理を継続
- 60秒後に自動的に再実行

## トランザクション仕様

- 読み取り専用処理のため、コミット/ロールバックは不要
- CICS STARTによる自己再スケジュール

## パフォーマンス要件

- 60秒間隔の定期実行
- 全カウンタ（30種以上）の一括取得

## セキュリティ考慮事項

- CICSトランザクション実行権限による制御
- 統計情報の参照のみで業務データへのアクセスなし

## 備考

- トランザクションコードはSSST
- 初回起動はLGSETUPまたは手動で実行
- TSQプレフィックス：GENA
- カウンタ一覧：
  - GENACUSTNUM: 顧客番号カウンタ
  - GENA01ICUS00/99: 顧客照会
  - GENA01ACUS00/99: 顧客登録
  - GENA01IMOT00/99: 自動車保険照会
  - GENA01AMOT00/99: 自動車保険登録
  - GENA01DMOT00/99: 自動車保険削除
  - GENA01UMOT00/99: 自動車保険更新
  - GENA01IEND00/99: 養老保険照会
  - GENA01AEND00/99: 養老保険登録
  - GENA01DEND00/99: 養老保険削除
  - GENA01UEND00/99: 養老保険更新
  - GENA01IHOU00/99: 住宅保険照会
  - GENA01AHOU00/99: 住宅保険登録
  - GENA01DHOU00/99: 住宅保険削除
  - GENA01UHOU00/99: 住宅保険更新
  - GENA01ICOM00/99: 商業保険照会
  - GENA01ACOM00/99: 商業保険登録
  - GENA01DCOM00/99: 商業保険削除
  - GENAOTHER: その他

## コードリーディングガイド

本機能のソースコードを理解するための推奨リーディング順序を以下に示す。

### 推奨リーディング順序

| Step | ファイル | 行番号 | 内容 |
|------|----------|--------|------|
| 1 | base/src/lgwebst5.cbl | 全体 | 統計データ収集メインプログラム |

### Step別詳細ガイド

#### 主要処理概要
本プログラムは60秒間隔で自動実行され、Named Counterから各トランザクションの統計値を取得してTSQに格納します。

#### 時刻取得と経過時間計算
```cobol
EXEC CICS ASKTIME ABSTIME(WS-ABSTIME)
END-EXEC.
EXEC CICS FORMATTIME ABSTIME(WS-ABSTIME)
          TIME(WS-TIME)
          YYYYMMDD(WS-DATE)
END-EXEC.
```
現在時刻を取得し、前回実行時刻との差分（経過時間）を計算。

#### カウンタ値取得
```cobol
Exec CICS Query Counter(GENACNT100)
              Pool(GENApool)
              Value(WS-Count100)
              Resp(WS-RESP)
End-Exec.
```
Named Counter（GENAプール）から各カウンタの現在値をQUERYコマンドで取得（更新なし）。

#### TSQ書き込み
```cobol
EXEC CICS DELETEQ TS Queue(GENA100V)
          RESP(WS-RESP)
END-EXEC.
EXEC CICS WRITEQ TS Queue(GENA100V)
          FROM(WS-COUNT100)
          LENGTH(LENGTH OF WS-COUNT100)
END-EXEC.
```
前回値を削除後、現在値・差分をTSQに格納。

#### 再スケジュール
```cobol
EXEC CICS START TRANSID('SSST')
          AFTER MINUTES(1)
          RESP(WS-RESP)
END-EXEC.
```
60秒後に自身を再スケジュール。

### プログラム構造

```
LGWEBST5 (トランザクション: SSST)
  ├─ ヘッダー初期化
  ├─ 時刻取得
  │    └─ ASKTIME/FORMATTIME
  ├─ 前回時刻取得（TSQ GENA000V）
  ├─ 経過時間計算
  ├─ カウンタ値取得ループ
  │    ├─ QUERY Counter（GENA01ICUS00/99）
  │    ├─ QUERY Counter（GENA01ACUS00/99）
  │    ├─ ... 他のカウンタ ...
  │    └─ TSQ書き込み（現在値、前回値、差分）
  ├─ 集計処理
  │    ├─ 成功件数合計
  │    └─ エラー件数合計
  ├─ APPLID取得
  └─ 再スケジュール
       └─ START TRANSID('SSST') AFTER MINUTES(1)
```

### データフロー図

```
[Named Counter（GENAプール）]
├─ GENA01ICUS00（顧客照会成功）
├─ GENA01ICUS99（顧客照会エラー）
├─ GENA01ACUS00（顧客登録成功）
├─ ... 他のカウンタ（30種以上）...
         │
         ↓
    [QUERY Counter]
         │
         ↓
[TSQ群（GENAプレフィックス）]
├─ GENA000V（経過時間）
├─ GENA100V（顧客照会成功）
├─ GENA199V（顧客照会エラー）
├─ GENAX00V（成功合計）
├─ GENAX99V（エラー合計）
         │
         ↓
[CICS START TRANSID('SSST') AFTER MINUTES(1)]
         │
         ↓（60秒後）
    [再実行]
```

### 関連ファイル一覧

| ファイル | 種別 | 説明 |
|----------|------|------|
| lgwebst5.cbl | COBOL | 統計データ収集メインプログラム |
| GENAプール | Named Counter | トランザクションカウンタ格納 |
| GENA*V | TSQ群 | 統計値格納用 |
