# 機能設計書 F025-エラーメッセージ記録

## 概要

本ドキュメントは、エラーメッセージを一時ストレージキューに書き込む機能（F025）の詳細設計を記載したものです。

### 本機能の処理概要

本機能は、システム内で発生したエラーメッセージをTDQ（Transient Data Queue）およびTSQ（Temporary Storage Queue）に記録します。エラーログの集中管理と後続の分析・調査を可能にします。

**業務上の目的・背景**：保険システムの運用において、エラー発生時の迅速な原因特定と対処が重要です。本機能はエラーメッセージをCSMT（CICSシステムメッセージ）TDQとGENAERRS TSQに記録することで、システム管理者がエラー状況を把握し、適切な対応を取れるようにします。

**機能の利用シーン**：
- 業務処理でエラーが発生した場合のログ記録
- システム障害調査のためのエラー履歴参照
- エラー発生傾向の分析

**主要な処理内容**：
1. 呼び出し方法（LINK/トランザクション）を判定
2. 入力メッセージを取得
3. キュー名パラメータ（Q=nnnn）の解析
4. システムID（SYSID）を付加
5. TDQ（CSMT）にエラーメッセージを書き込み
6. TSQ（GENAERRSまたは指定キュー）にエラーメッセージを書き込み

**関連システム・外部連携**：
- TDQ（CSMT）：CICSシステムメッセージログ
- TSQ（GENAERRS）：アプリケーションエラーログ
- 各業務プログラムからのLINK呼び出し

**権限による制御**：特になし（CICSトランザクション実行権限のみ）

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| - | - | - | 本機能は画面を持たないバックエンド処理です |

## 機能種別

ログ記録処理（エラーログ出力）

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| Q=nnnn | PIC X(6) | No | キュー名サフィックス指定（省略時はERRS） | Q=で始まる6文字 |
| メッセージ | PIC X(90) | Yes | エラーメッセージ本文 | 最大90文字 |

### 入力データソース

- CICS LINK呼び出し時：COMMAREA経由でメッセージを受信
- トランザクション直接実行時：CICS RECEIVE経由で入力データを受信

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| SYSID | PIC X(4) | CICSシステムID |
| 区切り | PIC X(1) | スペース |
| メッセージ | PIC X(90) | エラーメッセージ本文 |

### 出力先

- TDQ（CSMT）：CICSシステムメッセージログ
- TSQ（GENAERRS または GENAnnnn）：アプリケーションエラーログ

## 処理フロー

### 処理シーケンス

```
1. 初期化
   └─ 作業領域のクリア

2. SYSID取得
   └─ CICS ASSIGN SYSIDでシステムIDを取得

3. 呼び出し方法判定
   └─ Invokingprogを確認し、LINK呼び出しか直接実行かを判定

4. 入力データ取得
   └─ LINK: COMMエリアからメッセージ取得
   └─ 直接: CICS RECEIVEでメッセージ取得

5. キュー名決定
   └─ デフォルト: GENAERRS
   └─ Q=nnnn指定時: GENAnnnn

6. TDQ書き込み
   └─ CSMTキューにSYSID+メッセージを書き込み

7. TSQ書き込み
   └─ 決定したキュー名にSYSID+メッセージを書き込み
   └─ NOSUSPEND指定（容量不足時はスキップ）

8. 応答処理
   └─ 直接実行時: 画面にスペースを表示

9. 終了
   └─ CICS RETURN
```

### フローチャート

```mermaid
flowchart TD
    A[開始] --> B[作業領域初期化]
    B --> C[SYSID取得]
    C --> D{LINK呼び出し?}
    D -->|Yes| E[COMMエリアからメッセージ取得]
    D -->|No| F[RECEIVEでメッセージ取得]
    E --> G{Q=指定あり?}
    F --> G
    G -->|Yes| H[キュー名をGENAnnnnに設定]
    G -->|No| I[キュー名をGENAERRSに設定]
    H --> J[TDQ CSMT書き込み]
    I --> J
    J --> K[TSQ書き込み]
    K --> L{直接実行?}
    L -->|Yes| M[画面表示]
    L -->|No| N[RETURN]
    M --> N
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-001 | デフォルトキュー | Q=指定がない場合はGENAERRSを使用 | 常時 |
| BR-002 | カスタムキュー | Q=nnnn形式でキュー名を指定可能 | Q=で始まる入力 |
| BR-003 | NOSUSPEND | TSQ容量不足時は書き込みをスキップ | 常時 |
| BR-004 | SYSID付加 | 全メッセージにシステムIDを付加 | 常時 |

### 計算ロジック

キュー名決定:
```
IF メッセージ(1:2) = 'Q=' THEN
    STSQ-NAME = 'GENA' + メッセージ(3:4)
    メッセージ本文 = メッセージ(8:83)
ELSE
    STSQ-NAME = 'GENAERRS'
END-IF
```

## データベース操作仕様

### 操作別データベース影響一覧

| 操作 | 対象テーブル | 操作種別 | 概要 |
|-----|-------------|---------|------|
| TDQ書き込み | CSMT（TDQ） | WRITEQ TD | システムメッセージログへの出力 |
| TSQ書き込み | GENAERRS/GENAnnnn（TSQ） | WRITEQ TS | アプリケーションログへの出力 |

### テーブル別操作詳細

#### TDQ（CSMT）

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| WRITEQ TD | WRITE-MSG | SYSID+スペース+メッセージ | 最大95バイト |

#### TSQ（GENAERRS/GENAnnnn）

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| WRITEQ TS | WRITE-MSG | SYSID+スペース+メッセージ | NOSUSPEND指定 |

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| TSQ FULL | 容量エラー | TSQ容量不足 | NOSUSPENDにより書き込みスキップ |
| TDQ ERROR | TDQエラー | CSMTキュー障害 | エラーを無視して継続 |

### リトライ仕様

- リトライは実装されていない
- TSQ容量不足時はNOSUSPENDにより処理継続

## トランザクション仕様

- ログ書き込みは即時反映（コミット不要）
- 業務トランザクションとは独立

## パフォーマンス要件

- TDQ/TSQ書き込みのみの軽量処理
- NOSUSPENDによりブロッキングを回避

## セキュリティ考慮事項

- CICSトランザクション実行権限による制御
- ログにはSYSIDが付加され、発生元を特定可能
- 機密情報がログに含まれないよう業務側で制御

## 備考

- プログラム名：LGSTSQ
- デフォルトTDQ：CSMT
- デフォルトTSQ：GENAERRS
- トランザクションコードは機能一覧では「-」（LINKによる呼び出しが主）
- TSQはアプリケーションレベルのエラーログとして活用
- TDQはCICSシステムレベルのログとして活用

## コードリーディングガイド

本機能のソースコードを理解するための推奨リーディング順序を以下に示す。

### 推奨リーディング順序

| Step | ファイル | 行番号 | 内容 |
|------|----------|--------|------|
| 1 | base/src/lgstsq.cbl | 15-41 | WORKING-STORAGE変数定義 |
| 2 | base/src/lgstsq.cbl | 57-66 | 初期化とSYSID取得 |
| 3 | base/src/lgstsq.cbl | 68-80 | 呼び出し方法判定とメッセージ取得 |
| 4 | base/src/lgstsq.cbl | 82-88 | キュー名決定ロジック |
| 5 | base/src/lgstsq.cbl | 94-111 | TDQ/TSQ書き込み処理 |

### Step別詳細ガイド

#### Step 1: WORKING-STORAGE変数定義（lgstsq.cbl:15-41）
```cobol
01  WRITE-MSG.
  03 WRITE-MSG-SYSID          PIC X(4).
  03 FILLER-X                 PIC X Value SPACES.
  03 WRITE-MSG-MSG            PIC X(90).
01  FILLER REDEFINES WRITE-MSG.
  03 FILLER                   PIC X(5).
  03 FILLER                   PIC X(7).
  03 WRITE-MSG-REST           PIC X(83).
01  STSQ.
  03  STSQ-NAME                 PIC X(8).
01  FILLER REDEFINES STSQ.
  03 FILLER                   PIC X(4).
  03 STSQ-EXT                 PIC X(4).
77 STDQ-NAME                  PIC X(4)  VALUE 'CSMT'.
```
出力メッセージ構造（SYSID + スペース + メッセージ）とキュー名（STSQ-NAME）を定義。REDEFINESによりQ=パラメータ解析用の再定義を提供。

#### Step 2: 初期化とSYSID取得（lgstsq.cbl:57-66）
```cobol
MOVE SPACES TO WRITE-MSG.
MOVE SPACES TO WS-RECV.

EXEC CICS ASSIGN SYSID(WRITE-MSG-SYSID)
     RESP(WS-RESP)
END-EXEC.

EXEC CICS ASSIGN INVOKINGPROG(WS-INVOKEPROG)
     RESP(WS-RESP)
END-EXEC.
```
作業領域を初期化後、CICSシステムID（SYSID）と呼び出し元プログラム名を取得。

#### Step 3: 呼び出し方法判定とメッセージ取得（lgstsq.cbl:68-80）
```cobol
IF WS-INVOKEPROG NOT = SPACES
   MOVE 'C' To WS-FLAG
   MOVE COMMA-DATA  TO WRITE-MSG-MSG
   MOVE EIBCALEN    TO WS-RECV-LEN
ELSE
   EXEC CICS RECEIVE INTO(WS-RECV)
       LENGTH(WS-RECV-LEN)
       RESP(WS-RESP)
   END-EXEC
   MOVE 'R' To WS-FLAG
   MOVE WS-RECV-DATA  TO WRITE-MSG-MSG
   SUBTRACT 5 FROM WS-RECV-LEN
END-IF.
```
INVOKINGPROGが設定されている場合はCOMMAREA経由（LINK呼び出し）、それ以外はRECEIVE経由（トランザクション直接実行）でメッセージを取得。

#### Step 4: キュー名決定ロジック（lgstsq.cbl:82-88）
```cobol
MOVE 'GENAERRS' TO STSQ-NAME.
IF WRITE-MSG-MSG(1:2) = 'Q=' THEN
   MOVE WRITE-MSG-MSG(3:4) TO STSQ-EXT
   MOVE WRITE-MSG-REST TO TEMPO
   MOVE TEMPO          TO WRITE-MSG-MSG
   SUBTRACT 7 FROM WS-RECV-LEN
END-IF.
```
デフォルトはGENAERRS。メッセージ先頭が「Q=」の場合、続く4文字をキュー名サフィックスとして使用（GENAnnnn）。Q=パラメータ部分はメッセージから除去。

#### Step 5: TDQ/TSQ書き込み処理（lgstsq.cbl:94-111）
```cobol
EXEC CICS WRITEQ TD QUEUE(STDQ-NAME)
          FROM(WRITE-MSG)
          RESP(WS-RESP)
          LENGTH(WS-RECV-LEN)
END-EXEC.

EXEC CICS WRITEQ TS QUEUE(STSQ-NAME)
          FROM(WRITE-MSG)
          RESP(WS-RESP)
          NOSUSPEND
          LENGTH(WS-RECV-LEN)
END-EXEC.
```
TDQ（CSMT）とTSQ（GENAERRS/GENAnnnn）の両方に同じメッセージを書き込み。TSQはNOSUSPEND指定により容量不足時もブロックせず処理継続。

### プログラム構造

```
LGSTSQ
  ├─ 初期化
  │    ├─ WRITE-MSG/WS-RECV クリア
  │    └─ CICS ASSIGN SYSID
  ├─ 呼び出し判定
  │    ├─ CICS ASSIGN INVOKINGPROG
  │    ├─ LINK呼び出し: COMMAREA → WRITE-MSG-MSG
  │    └─ トランザクション: RECEIVE → WRITE-MSG-MSG
  ├─ キュー名決定
  │    ├─ デフォルト: GENAERRS
  │    └─ Q=nnnn指定: GENAnnnn
  ├─ ログ出力
  │    ├─ WRITEQ TD (CSMT)
  │    └─ WRITEQ TS (GENAERRS/GENAnnnn) NOSUSPEND
  └─ 応答処理
       ├─ トランザクション: SEND TEXT
       └─ CICS RETURN
```

### データフロー図

```
[呼び出し元プログラム]
├─ LINK呼び出し: COMMAREA(90バイト)
└─ トランザクション: RECEIVE(79バイト)
         │
         ↓
[メッセージ解析]
├─ 先頭2バイト = 'Q=' ?
│    │Yes           │No
│    ↓              ↓
│  [Q=パラメータ抽出]  [デフォルト]
│  STSQ-EXT = nnnn    STSQ-NAME = GENAERRS
│  メッセージ = 残り
│    │
│    ↓
│  STSQ-NAME = GENAnnnn
         │
         ↓
[出力メッセージ構成]
SYSID(4) + ' '(1) + メッセージ(最大90)
         │
    ┌────┴────┐
    ↓         ↓
[TDQ CSMT]  [TSQ GENAERRS/GENAnnnn]
(WRITEQ TD)  (WRITEQ TS NOSUSPEND)
```

### 関連ファイル一覧

| ファイル | 種別 | 説明 |
|----------|------|------|
| lgstsq.cbl | COBOL | エラーメッセージ記録メインプログラム |
| CSMT | TDQ | CICSシステムメッセージログ |
| GENAERRS | TSQ | アプリケーションエラーログ（デフォルト） |
| GENAnnnn | TSQ | アプリケーションエラーログ（カスタム） |

### 呼び出し元プログラム例

```
[各業務プログラム]
├─ lgacdb01.cbl（顧客登録）
├─ lgicdb01.cbl（顧客照会）
├─ lgapdb01.cbl（ポリシー登録）
├─ lgipdb01.cbl（ポリシー照会）
├─ lgupdb01.cbl（ポリシー更新）
├─ lgdpdb01.cbl（ポリシー削除）
└─ その他業務プログラム
         │
         ↓ EXEC CICS LINK PROGRAM('LGSTSQ') COMMAREA(...)
         │
    [LGSTSQ]
         │
    ┌────┴────┐
    ↓         ↓
[TDQ CSMT]  [TSQ GENAERRS]
```
