# 機能設計書 F026-顧客メニュー

## 概要

本ドキュメントは、顧客関連操作のメニュー画面を提供する機能（F026）の詳細設計を記載したものです。

### 本機能の処理概要

本機能は、顧客管理に関する操作（照会・登録・更新）のメニュー画面を表示し、ユーザーの選択に応じて対応する業務プログラムを呼び出します。

**業務上の目的・背景**：保険システムにおいて、顧客情報の管理は基盤となる機能です。本メニュー画面は、オペレーターが顧客の照会・登録・更新を効率的に行えるよう、統一されたインターフェースを提供します。3270端末からの操作を想定し、シンプルで分かりやすい画面設計となっています。

**機能の利用シーン**：
- 新規顧客の登録作業
- 既存顧客情報の照会
- 顧客情報の更新・修正

**主要な処理内容**：
1. 顧客メニュー画面（SSMAPC1）を表示
2. ユーザーからオプション選択を受信
3. オプションに応じて対応プログラムをCICS LINKで呼び出し
   - オプション1: 顧客照会（LGICUS01）
   - オプション2: 顧客登録（LGACUS01）
   - オプション4: 顧客更新（照会後にLGUCUS01）
4. 処理結果を画面に表示
5. 次の操作に備えてトランザクションを継続

**関連システム・外部連携**：
- LGICUS01: 顧客照会プログラム
- LGACUS01: 顧客登録プログラム
- LGUCUS01: 顧客更新プログラム
- GENACNTL TSQ: 顧客番号範囲管理

**権限による制御**：特になし（CICSトランザクション実行権限のみ）

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 1 | 顧客メニュー画面 | 主機能 | LGTESTC1プログラムが画面SSMAPC1を表示し、顧客操作のメニュー機能を提供 |

## 機能種別

画面処理（メニュー画面）

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| ENT1OPT | PIC X(1) | Yes | オプション選択（1:照会、2:登録、4:更新） | 1, 2, 4のいずれか |
| ENT1CNO | PIC 9(10) | Yes（照会・更新時） | 顧客番号 | 10桁数字 |
| ENT1FNA | PIC X(10) | Yes（登録時） | 名（First Name） | 最大10文字 |
| ENT1LNA | PIC X(20) | Yes（登録時） | 姓（Last Name） | 最大20文字 |
| ENT1DOB | PIC X(10) | Yes（登録時） | 生年月日 | 日付形式 |
| ENT1HNM | PIC X(20) | No | 家屋名 | 最大20文字 |
| ENT1HNO | PIC X(4) | No | 家屋番号 | 最大4文字 |
| ENT1HPC | PIC X(8) | No | 郵便番号 | 最大8文字 |
| ENT1HP1 | PIC X(20) | No | 自宅電話番号 | 最大20文字 |
| ENT1HP2 | PIC X(20) | No | 携帯電話番号 | 最大20文字 |
| ENT1HMO | PIC X(100) | No | メールアドレス | 最大100文字 |

### 入力データソース

- BMS画面（SSMAPC1）からの入力

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| ENT1CNO | PIC 9(10) | 顧客番号 |
| ENT1FNA | PIC X(10) | 名 |
| ENT1LNA | PIC X(20) | 姓 |
| ENT1DOB | PIC X(10) | 生年月日 |
| ENT1HNM | PIC X(20) | 家屋名 |
| ENT1HNO | PIC X(4) | 家屋番号 |
| ENT1HPC | PIC X(8) | 郵便番号 |
| ENT1HP1 | PIC X(20) | 自宅電話番号 |
| ENT1HP2 | PIC X(20) | 携帯電話番号 |
| ENT1HMO | PIC X(100) | メールアドレス |
| ERRFLD | PIC X(79) | エラー/成功メッセージ |

### 出力先

- BMS画面（SSMAPC1）への表示

## 処理フロー

### 処理シーケンス

```
1. 初回表示判定
   └─ EIBCALENが0なら初期化して画面表示
   └─ 0より大きければ継続処理へ

2. 画面初期化（初回のみ）
   └─ 入出力エリアの初期化
   └─ 顧客番号フィールドを0で初期化
   └─ SSMAPC1画面を送信

3. ユーザー入力受信
   └─ CLEARキー: 画面クリア
   └─ PF3キー: トランザクション終了
   └─ その他: オプション処理

4. オプション処理
   ├─ オプション1（照会）
   │  └─ LGICUS01を呼び出し
   │  └─ 結果を画面に表示
   ├─ オプション2（登録）
   │  └─ LGACUS01を呼び出し
   │  └─ GENACNTL TSQを更新
   │  └─ 新規顧客番号を画面に表示
   └─ オプション4（更新）
      └─ LGICUS01で照会
      └─ ユーザーに修正入力させる
      └─ LGUCUS01で更新

5. トランザクション継続
   └─ CICS RETURN TRANSID('SSC1')
```

### フローチャート

```mermaid
flowchart TD
    A[開始] --> B{初回起動?}
    B -->|Yes| C[画面初期化]
    B -->|No| D[入力受信]
    C --> E[画面送信]
    E --> D
    D --> F{入力キー判定}
    F -->|CLEAR| G[画面クリア]
    F -->|PF3| H[終了]
    F -->|ENTER| I{オプション判定}
    I -->|1| J[顧客照会]
    I -->|2| K[顧客登録]
    I -->|4| L[顧客更新]
    I -->|Other| M[エラー表示]
    J --> N{成功?}
    N -->|Yes| O[結果表示]
    N -->|No| P[エラー表示]
    K --> Q{成功?}
    Q -->|Yes| R[TSQ更新]
    Q -->|No| S[ロールバック]
    R --> T[顧客番号表示]
    S --> U[エラー表示]
    L --> V[照会実行]
    V --> W[修正入力待ち]
    W --> X[更新実行]
    O --> Y[トランザクション継続]
    P --> Y
    T --> Y
    U --> Y
    X --> Y
    M --> Y
    G --> Y
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-001 | 有効オプション | オプションは1, 2, 4のいずれか | 常時 |
| BR-002 | 顧客番号必須 | 照会・更新時は顧客番号が必須 | オプション1, 4 |
| BR-003 | 郵便番号大文字変換 | 登録・更新時に郵便番号を大文字に変換 | オプション2, 4 |
| BR-004 | 登録時TSQ更新 | 新規登録時にGENACNTL TSQを更新 | オプション2成功時 |
| BR-005 | エラー時ロールバック | 登録失敗時はSyncpoint Rollback | オプション2失敗時 |

### 計算ロジック

特になし

## データベース操作仕様

### 操作別データベース影響一覧

| 操作 | 対象テーブル | 操作種別 | 概要 |
|-----|-------------|---------|------|
| 顧客照会 | CUSTOMER（Db2/VSAM） | SELECT/READ | LGICUS01経由 |
| 顧客登録 | CUSTOMER（Db2/VSAM） | INSERT/WRITE | LGACUS01経由 |
| 顧客更新 | CUSTOMER（Db2/VSAM） | UPDATE/REWRITE | LGUCUS01経由 |
| TSQ更新 | GENACNTL（TSQ） | READ/WRITE | 顧客番号範囲管理 |

### テーブル別操作詳細

#### GENACNTL（TSQ）

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| READ/REWRITE | HIGH CUSTOMER | 新規顧客番号 | 登録成功時に更新 |

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| CA-RETURN-CODE > 0 | 業務エラー | 照会/登録/更新失敗 | エラーメッセージ表示 |
| MAPFAIL | 画面エラー | 画面入力失敗 | トランザクション終了 |

### リトライ仕様

- リトライは実装されていない
- エラー発生時は画面にエラーメッセージを表示し、再入力を促す

## トランザクション仕様

- 登録処理失敗時：Syncpoint Rollbackを実行
- 画面遷移：CICS RETURN TRANSID('SSC1')でトランザクション継続
- 終了時：PF3キーまたはMAPFAILでトランザクション終了

## パフォーマンス要件

- 画面応答時間：通常操作で数秒以内
- Db2/VSAMアクセスは各業務プログラムで実行

## セキュリティ考慮事項

- CICSトランザクション実行権限による制御
- 顧客個人情報（氏名、住所、連絡先）を取り扱うため、アクセス制御が重要
- 画面操作ログは標準のCICSログに記録

## 備考

- プログラム名：LGTESTC1
- トランザクションコード：SSC1
- 画面マップ：SSMAPC1
- マップセット：SSMAP
- 関連業務プログラム：
  - LGICUS01: 顧客照会
  - LGACUS01: 顧客登録
  - LGUCUS01: 顧客更新
- COMMエリア長：32500バイト

## コードリーディングガイド

本機能のソースコードを理解するための推奨リーディング順序を以下に示す。

### 推奨リーディング順序

| Step | ファイル | 行番号 | 内容 |
|------|----------|--------|------|
| 1 | base/src/lgtestc1.cbl | 16-47 | WORKING-STORAGE変数定義とCOPY句 |
| 2 | base/src/lgtestc1.cbl | 52-82 | 初期表示とユーザー入力受信 |
| 3 | base/src/lgtestc1.cbl | 84-222 | オプション処理（EVALUATE文） |
| 4 | base/src/lgtestc1.cbl | 283-347 | GENACNTL TSQ更新処理 |

### Step別詳細ガイド

#### Step 1: WORKING-STORAGE変数定義（lgtestc1.cbl:16-47）
```cobol
01  READ-MSG.
  03 READ-MSG-MSG             PIC X(80).
01  FILLER REDEFINES Read-MSG.
  03 FILLER                   PIC X(14).
  03 READ-CUST-HIGH           PIC 9(10).
01  WRITE-MSG.
  03 WRITE-MSG-E            PIC X(20) Value '**** GENAPP CNTL'.
  03 WRITE-MSG-L            PIC X(13) Value 'LOW CUSTOMER='.
  03 WRITE-MSG-LOW          PIC 9(10).
  03 WRITE-MSG-H            PIC X(14) Value 'HIGH CUSTOMER='.
  03 WRITE-MSG-High         PIC 9(10).
01  STSQ.
  03  STSQ-NAME             PIC X(8) Value 'GENACNTL'.

COPY SSMAP.
01 COMM-AREA.
COPY LGCMAREA.
```
TSQ読み書き用メッセージ構造、BMS画面定義（SSMAP）、COMMAREA定義（LGCMAREA）をCOPY句で取り込み。

#### Step 2: 初期表示とユーザー入力受信（lgtestc1.cbl:52-82）
```cobol
IF EIBCALEN > 0
   GO TO A-GAIN.

Initialize SSMAPC1I.
Initialize SSMAPC1O.
Initialize COMM-AREA.
MOVE '0000000000'   To ENT1CNOO

EXEC CICS SEND MAP ('SSMAPC1')
          FROM(SSMAPC1O)
          MAPSET ('SSMAP')
          ERASE
END-EXEC.

A-GAIN.
    EXEC CICS HANDLE AID
              CLEAR(CLEARIT)
              PF3(ENDIT) END-EXEC.
    EXEC CICS RECEIVE MAP('SSMAPC1')
              INTO(SSMAPC1I) ASIS
              MAPSET('SSMAP') END-EXEC.
```
初回起動時（EIBCALEN=0）は画面初期化、継続時は入力受信。CLEARキーとPF3キーのハンドラを設定。

#### Step 3: オプション処理（lgtestc1.cbl:84-222）
```cobol
EVALUATE ENT1OPTO

  WHEN '1'
      Move '01ICUS'   To CA-REQUEST-ID
      Move ENT1CNOO   To CA-CUSTOMER-NUM
      EXEC CICS LINK PROGRAM('LGICUS01')
                COMMAREA(COMM-AREA)
                LENGTH(32500)
      END-EXEC
      ...結果を画面フィールドに設定...

  WHEN '2'
      Move '01ACUS'   To CA-REQUEST-ID
      ...入力データをCOMMAREAに設定...
      EXEC CICS LINK PROGRAM('LGACUS01')
                COMMAREA(COMM-AREA)
                LENGTH(32500)
      END-EXEC
      IF CA-RETURN-CODE > 0
        Exec CICS Syncpoint Rollback End-Exec
      END-IF
      Perform WRITE-GENACNTL

  WHEN '4'
      ...照会→修正入力→更新の2段階処理...
      EXEC CICS LINK PROGRAM('LGICUS01')...
      EXEC CICS RECEIVE MAP...
      EXEC CICS LINK PROGRAM('LGUCUS01')...

END-EVALUATE.
```
オプション番号に応じて対応する業務プログラムをLINK呼び出し。

#### Step 4: GENACNTL TSQ更新処理（lgtestc1.cbl:283-347）
```cobol
WRITE-GENACNTL.
    EXEC CICS ENQ Resource(STSQ-NAME)
              Length(Length Of STSQ-NAME)
    END-EXEC.

    Exec CICS ReadQ TS Queue(STSQ-NAME)
              Into(READ-MSG)
              Item(1)
    End-Exec.

    If Read-Msg-Msg(1:13) = 'HIGH CUSTOMER'
       Move CA-Customer-Num To Write-Msg-High
       Exec CICS WriteQ TS Queue(STSQ-NAME)
           From(Write-Msg-H)
           ReWrite
           Item(WS-Item-Count)
       End-Exec
    End-If

    EXEC CICS DEQ Resource(STSQ-NAME)
              Length(Length Of STSQ-NAME)
    END-EXEC.
```
顧客登録成功時にGENACNTL TSQのHIGH CUSTOMER値を更新。ENQ/DEQで排他制御。

### プログラム構造

```
LGTESTC1 (トランザクション: SSC1)
  ├─ MAINLINE SECTION
  │    ├─ 初回起動判定（EIBCALEN）
  │    ├─ 画面初期化
  │    │    └─ SEND MAP ('SSMAPC1')
  │    └─ A-GAIN（入力受信ループ）
  │         ├─ HANDLE AID（CLEAR/PF3）
  │         ├─ RECEIVE MAP
  │         └─ EVALUATE ENT1OPTO
  │              ├─ '1': LINK LGICUS01（照会）
  │              ├─ '2': LINK LGACUS01（登録）
  │              │    └─ WRITE-GENACNTL
  │              ├─ '4': LINK LGICUS01→LGUCUS01（更新）
  │              └─ OTHER: エラー表示
  ├─ ENDIT-STARTIT
  │    └─ RETURN TRANSID('SSC1')
  ├─ ENDIT / CLEARIT
  ├─ NO-UPD / NO-ADD / NO-DATA / ERROR-OUT
  └─ WRITE-GENACNTL
       ├─ ENQ Resource(GENACNTL)
       ├─ ReadQ TS / WriteQ TS ReWrite
       └─ DEQ Resource(GENACNTL)
```

### データフロー図

```
[BMS画面 SSMAPC1]
├─ オプション（1:照会/2:登録/4:更新）
├─ 顧客番号
└─ 顧客情報（名/姓/生年月日/住所等）
         │
         ↓
[EVALUATE処理]
  │
  ├─ オプション1 ──→ [LGICUS01] ──→ Db2/VSAM照会
  │                        │
  │                        └─→ 画面に結果表示
  │
  ├─ オプション2 ──→ [LGACUS01] ──→ Db2/VSAM登録
  │                        │
  │                  成功 ─┴─ 失敗
  │                   │      │
  │                   ↓      ↓
  │         [WRITE-GENACNTL] [Syncpoint Rollback]
  │              │
  │              ↓
  │         [GENACNTL TSQ]
  │         HIGH CUSTOMER更新
  │
  └─ オプション4 ──→ [LGICUS01] ──→ 照会
                          │
                          ↓
                     [画面表示]
                          │
                          ↓
                     [RECEIVE MAP]
                          │
                          ↓
                    [LGUCUS01] ──→ Db2/VSAM更新
```

### 関連ファイル一覧

| ファイル | 種別 | 説明 |
|----------|------|------|
| lgtestc1.cbl | COBOL | 顧客メニューメインプログラム |
| ssmap.cpy | BMS | 画面マップ定義（SSMAPC1含む） |
| lgcmarea.cpy | COPY句 | COMMAREA構造定義 |
| lgicus01.cbl | COBOL | 顧客照会プログラム |
| lgacus01.cbl | COBOL | 顧客登録プログラム |
| lgucus01.cbl | COBOL | 顧客更新プログラム |
| GENACNTL | TSQ | 顧客番号範囲管理 |
