# 機能設計書 F027-自動車保険メニュー

## 概要

本ドキュメントは、自動車保険関連操作のメニュー画面を提供する機能（F027）の詳細設計を記載したものです。

### 本機能の処理概要

本機能は、自動車保険（Motor Policy）に関する操作（照会・登録・更新・削除）のメニュー画面を表示し、ユーザーの選択に応じて対応する業務プログラムを呼び出します。

**業務上の目的・背景**：自動車保険は保険商品の中核をなす商品であり、契約管理業務の効率化が重要です。本メニュー画面は、オペレーターが自動車保険ポリシーの照会・登録・更新・削除を統一されたインターフェースで行えるよう設計されています。車両情報（メーカー、モデル、登録番号、色、CC、製造年等）と保険情報（発効日、満期日、保険料、事故歴等）を一画面で管理できます。

**機能の利用シーン**：
- 新規自動車保険契約の登録
- 既存契約の照会・内容確認
- 契約内容の変更・更新
- 契約の解約・削除

**主要な処理内容**：
1. 自動車保険メニュー画面（SSMAPP1）を表示
2. ユーザーからオプション選択を受信
3. オプションに応じて対応プログラムをCICS LINKで呼び出し
   - オプション1: ポリシー照会（LGIPOL01）
   - オプション2: ポリシー登録（LGAPOL01）
   - オプション3: ポリシー削除（LGDPOL01）
   - オプション4: ポリシー更新（照会後にLGUPOL01）
4. 処理結果を画面に表示
5. 次の操作に備えてトランザクションを継続

**関連システム・外部連携**：
- LGIPOL01: ポリシー照会プログラム
- LGAPOL01: ポリシー登録プログラム
- LGDPOL01: ポリシー削除プログラム
- LGUPOL01: ポリシー更新プログラム

**権限による制御**：特になし（CICSトランザクション実行権限のみ）

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 2 | 自動車保険ポリシーメニュー画面 | 主機能 | LGTESTP1プログラムが画面SSMAPP1を表示し、自動車保険の操作メニュー機能を提供 |

## 機能種別

画面処理（メニュー画面）

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| ENP1OPT | PIC X(1) | Yes | オプション選択（1:照会、2:登録、3:削除、4:更新） | 1, 2, 3, 4のいずれか |
| ENP1CNO | PIC 9(10) | Yes | 顧客番号 | 10桁数字 |
| ENP1PNO | PIC 9(10) | Yes（照会・削除・更新時） | ポリシー番号 | 10桁数字 |
| ENP1IDA | PIC X(10) | Yes（登録・更新時） | 発効日（Issue Date） | 日付形式 |
| ENP1EDA | PIC X(10) | Yes（登録・更新時） | 満期日（Expiry Date） | 日付形式 |
| ENP1CMK | PIC X(15) | Yes（登録・更新時） | 車両メーカー | 最大15文字 |
| ENP1CMO | PIC X(15) | Yes（登録・更新時） | 車両モデル | 最大15文字 |
| ENP1VAL | PIC 9(6) | Yes（登録・更新時） | 車両価値 | 6桁数字 |
| ENP1REG | PIC X(7) | Yes（登録・更新時） | 登録番号 | 最大7文字 |
| ENP1COL | PIC X(8) | No | 車両色 | 最大8文字 |
| ENP1CC | PIC 9(5) | No | 排気量（CC） | 5桁数字 |
| ENP1MAN | PIC X(10) | No | 製造年 | 日付/年形式 |
| ENP1PRE | PIC 9(6) | No | 保険料 | 6桁数字 |
| ENP1ACC | PIC 9(6) | No | 事故歴件数 | 6桁数字 |

### 入力データソース

- BMS画面（SSMAPP1）からの入力

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| ENP1CNO | PIC 9(10) | 顧客番号 |
| ENP1PNO | PIC 9(10) | ポリシー番号 |
| ENP1IDA | PIC X(10) | 発効日 |
| ENP1EDA | PIC X(10) | 満期日 |
| ENP1CMK | PIC X(15) | 車両メーカー |
| ENP1CMO | PIC X(15) | 車両モデル |
| ENP1VAL | PIC 9(6) | 車両価値 |
| ENP1REG | PIC X(7) | 登録番号 |
| ENP1COL | PIC X(8) | 車両色 |
| ENP1CC | PIC 9(5) | 排気量 |
| ENP1MAN | PIC X(10) | 製造年 |
| ENP1PRE | PIC 9(6) | 保険料 |
| ENP1ACC | PIC 9(6) | 事故歴件数 |
| ERP1FLD | PIC X(79) | エラー/成功メッセージ |

### 出力先

- BMS画面（SSMAPP1）への表示

## 処理フロー

### 処理シーケンス

```
1. 初回表示判定
   └─ EIBCALENが0なら初期化して画面表示
   └─ 0より大きければ継続処理へ

2. 画面初期化（初回のみ）
   └─ 入出力エリアの初期化
   └─ 数値フィールドを0で初期化
   └─ SSMAPP1画面を送信

3. ユーザー入力受信
   └─ CLEARキー: 画面クリア
   └─ PF3キー: トランザクション終了
   └─ その他: オプション処理

4. オプション処理
   ├─ オプション1（照会）
   │  └─ LGIPOL01を呼び出し（リクエストID: 01IMOT）
   │  └─ 結果を画面に表示
   ├─ オプション2（登録）
   │  └─ LGAPOL01を呼び出し（リクエストID: 01AMOT）
   │  └─ 新規ポリシー番号を画面に表示
   ├─ オプション3（削除）
   │  └─ LGDPOL01を呼び出し（リクエストID: 01DMOT）
   │  └─ 削除完了メッセージを表示
   └─ オプション4（更新）
      └─ LGIPOL01で照会
      └─ ユーザーに修正入力させる
      └─ LGUPOL01で更新（リクエストID: 01UMOT）

5. トランザクション継続
   └─ CICS RETURN TRANSID('SSP1')
```

### フローチャート

```mermaid
flowchart TD
    A[開始] --> B{初回起動?}
    B -->|Yes| C[画面初期化]
    B -->|No| D[入力受信]
    C --> E[画面送信]
    E --> D
    D --> F{入力キー判定}
    F -->|CLEAR| G[画面クリア]
    F -->|PF3| H[終了]
    F -->|ENTER| I{オプション判定}
    I -->|1| J[ポリシー照会]
    I -->|2| K[ポリシー登録]
    I -->|3| L[ポリシー削除]
    I -->|4| M[ポリシー更新]
    I -->|Other| N[エラー表示]
    J --> O[結果表示]
    K --> P{成功?}
    P -->|Yes| Q[ポリシー番号表示]
    P -->|No| R[ロールバック]
    L --> S{成功?}
    S -->|Yes| T[削除完了表示]
    S -->|No| U[ロールバック]
    M --> V[照会→修正→更新]
    O --> W[トランザクション継続]
    Q --> W
    R --> W
    T --> W
    U --> W
    V --> W
    N --> W
    G --> W
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-001 | 有効オプション | オプションは1, 2, 3, 4のいずれか | 常時 |
| BR-002 | 顧客存在確認 | 登録時に顧客番号が存在することを確認 | オプション2 |
| BR-003 | リクエストID | 01IMOT(照会), 01AMOT(登録), 01DMOT(削除), 01UMOT(更新) | 各オプション |
| BR-004 | エラー時ロールバック | 登録/削除失敗時はSyncpoint Rollback | オプション2, 3失敗時 |
| BR-005 | リターンコード70 | 顧客が存在しない場合のエラーコード | 登録失敗時 |

### 計算ロジック

特になし

## データベース操作仕様

### 操作別データベース影響一覧

| 操作 | 対象テーブル | 操作種別 | 概要 |
|-----|-------------|---------|------|
| ポリシー照会 | POLICY/MOTOR（Db2/VSAM） | SELECT/READ | LGIPOL01経由 |
| ポリシー登録 | POLICY/MOTOR（Db2/VSAM） | INSERT/WRITE | LGAPOL01経由 |
| ポリシー削除 | POLICY/MOTOR（Db2/VSAM） | DELETE | LGDPOL01経由 |
| ポリシー更新 | POLICY/MOTOR（Db2/VSAM） | UPDATE/REWRITE | LGUPOL01経由 |

### テーブル別操作詳細

業務プログラム（LGIPOL01, LGAPOL01, LGDPOL01, LGUPOL01）を通じてアクセス

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| 70 | 顧客不存在 | 登録時に指定顧客が存在しない | 'Customer does not exist'を表示 |
| CA-RETURN-CODE > 0 | 業務エラー | その他の失敗 | 各オプション用エラーメッセージ表示 |
| MAPFAIL | 画面エラー | 画面入力失敗 | トランザクション終了 |

### リトライ仕様

- リトライは実装されていない
- エラー発生時は画面にエラーメッセージを表示し、再入力を促す

## トランザクション仕様

- 登録/削除処理失敗時：Syncpoint Rollbackを実行
- 画面遷移：CICS RETURN TRANSID('SSP1')でトランザクション継続
- 終了時：PF3キーまたはMAPFAILでトランザクション終了

## パフォーマンス要件

- 画面応答時間：通常操作で数秒以内
- Db2/VSAMアクセスは各業務プログラムで実行

## セキュリティ考慮事項

- CICSトランザクション実行権限による制御
- 保険契約情報を取り扱うため、アクセス制御が重要

## 備考

- プログラム名：LGTESTP1
- トランザクションコード：SSP1
- 画面マップ：SSMAPP1
- マップセット：SSMAP
- 関連業務プログラム：
  - LGIPOL01: ポリシー照会
  - LGAPOL01: ポリシー登録
  - LGDPOL01: ポリシー削除
  - LGUPOL01: ポリシー更新
- COMMエリア長：32500バイト
- リクエストIDプレフィックス：01（Motor系）

## コードリーディングガイド

本機能のソースコードを理解するための推奨リーディング順序を以下に示す。

### 推奨リーディング順序

| Step | ファイル | 行番号 | 内容 |
|------|----------|--------|------|
| 1 | base/src/lgtestp1.cbl | 16-24 | WORKING-STORAGE変数定義とCOPY句 |
| 2 | base/src/lgtestp1.cbl | 30-64 | 初期表示とユーザー入力受信 |
| 3 | base/src/lgtestp1.cbl | 66-249 | オプション処理（EVALUATE文） |
| 4 | base/src/lgtestp1.cbl | 286-318 | エラー処理パラグラフ |

### Step別詳細ガイド

#### Step 1: WORKING-STORAGE変数定義（lgtestp1.cbl:16-24）
```cobol
77 MSGEND                       PIC X(24) VALUE
                                 'Transaction ended      '.

COPY SSMAP.
01 COMM-AREA.
COPY LGCMAREA.
```
BMS画面定義（SSMAP）、COMMAREA定義（LGCMAREA）をCOPY句で取り込み。

#### Step 2: 初期表示とユーザー入力受信（lgtestp1.cbl:30-64）
```cobol
IF EIBCALEN > 0
   GO TO A-GAIN.

Initialize SSMAPP1I.
Initialize SSMAPP1O.
Initialize COMM-AREA.
MOVE '0000000000'   To ENP1CNOO.
MOVE '0000000000'   To ENP1PNOO.
MOVE '000000'       To ENP1VALO.

EXEC CICS SEND MAP ('SSMAPP1')
          MAPSET ('SSMAP')
          ERASE
END-EXEC.

A-GAIN.
    EXEC CICS HANDLE AID
              CLEAR(CLEARIT)
              PF3(ENDIT) END-EXEC.
    EXEC CICS RECEIVE MAP('SSMAPP1')
              INTO(SSMAPP1I)
              MAPSET('SSMAP') END-EXEC.
```
初回起動時は画面初期化、継続時は入力受信。数値フィールドを0で初期化。

#### Step 3: オプション処理（lgtestp1.cbl:66-249）
```cobol
EVALUATE ENP1OPTO

  WHEN '1'
      Move '01IMOT'   To CA-REQUEST-ID
      Move ENP1CNOO   To CA-CUSTOMER-NUM
      Move ENP1PNOO   To CA-POLICY-NUM
      EXEC CICS LINK PROGRAM('LGIPOL01')
                COMMAREA(COMM-AREA)
                LENGTH(32500)
      END-EXEC
      ...車両情報を画面フィールドに設定...

  WHEN '2'
      Move '01AMOT'   To CA-REQUEST-ID
      ...車両情報をCOMMAREAに設定...
      EXEC CICS LINK PROGRAM('LGAPOL01')
                COMMAREA(COMM-AREA)
                LENGTH(32500)
      END-EXEC
      IF CA-RETURN-CODE > 0
        Exec CICS Syncpoint Rollback End-Exec
      END-IF

  WHEN '3'
      Move '01DMOT'   To CA-REQUEST-ID
      EXEC CICS LINK PROGRAM('LGDPOL01')...
      IF CA-RETURN-CODE > 0
        Exec CICS Syncpoint Rollback End-Exec
      END-IF

  WHEN '4'
      ...照会→修正入力→更新の2段階処理...
      Move '01IMOT'   To CA-REQUEST-ID
      EXEC CICS LINK PROGRAM('LGIPOL01')...
      EXEC CICS RECEIVE MAP...
      Move '01UMOT'   To CA-REQUEST-ID
      EXEC CICS LINK PROGRAM('LGUPOL01')...

END-EVALUATE.
```
オプション番号に応じて対応する業務プログラムをLINK呼び出し。リクエストIDでMOTOR系を識別。

#### Step 4: エラー処理（lgtestp1.cbl:286-318）
```cobol
NO-ADD.
    Evaluate CA-RETURN-CODE
      When 70
        Move 'Customer does not exist'          To  ERP1FLDO
      When Other
        Move 'Error Adding Motor Policy'        To  ERP1FLDO
    End-Evaluate.

NO-UPD.
    Move 'Error Updating Motor Policy'    To  ERP1FLDO.

NO-DELETE.
    Move 'Error Deleting Motor Policy'    To  ERP1FLDO.

ERROR-OUT.
    EXEC CICS SEND MAP ('SSMAPP1')
              FROM(SSMAPP1O)
              MAPSET ('SSMAP')
    END-EXEC.
    Initialize SSMAPP1I.
    Initialize SSMAPP1O.
    Initialize COMM-AREA.
    GO TO ENDIT-STARTIT.
```
リターンコード70は顧客不存在エラー。エラー後は画面を初期化してトランザクション継続。

### プログラム構造

```
LGTESTP1 (トランザクション: SSP1)
  ├─ MAINLINE SECTION
  │    ├─ 初回起動判定（EIBCALEN）
  │    ├─ 画面初期化（数値フィールド0初期化）
  │    │    └─ SEND MAP ('SSMAPP1')
  │    └─ A-GAIN（入力受信ループ）
  │         ├─ HANDLE AID（CLEAR/PF3）
  │         ├─ RECEIVE MAP
  │         └─ EVALUATE ENP1OPTO
  │              ├─ '1': 01IMOT → LINK LGIPOL01（照会）
  │              ├─ '2': 01AMOT → LINK LGAPOL01（登録）
  │              ├─ '3': 01DMOT → LINK LGDPOL01（削除）
  │              ├─ '4': 01IMOT/01UMOT → 照会→更新
  │              └─ OTHER: エラー表示
  ├─ ENDIT-STARTIT
  │    └─ RETURN TRANSID('SSP1')
  ├─ ENDIT / CLEARIT
  └─ NO-ADD / NO-UPD / NO-DELETE / NO-DATA / ERROR-OUT
```

### データフロー図

```
[BMS画面 SSMAPP1]
├─ オプション（1:照会/2:登録/3:削除/4:更新）
├─ 顧客番号/ポリシー番号
└─ 車両情報（メーカー/モデル/登録番号/価値/色/CC/製造年/保険料/事故歴）
         │
         ↓
[EVALUATE処理]
  │
  ├─ オプション1（01IMOT）──→ [LGIPOL01] ──→ Db2/VSAM照会
  │                                │
  │                                └─→ 画面に結果表示
  │
  ├─ オプション2（01AMOT）──→ [LGAPOL01] ──→ Db2/VSAM登録
  │                                │
  │                          成功 ─┴─ 失敗
  │                           │      │
  │                           ↓      ↓
  │                    [ポリシー番号表示] [Syncpoint Rollback]
  │
  ├─ オプション3（01DMOT）──→ [LGDPOL01] ──→ Db2/VSAM削除
  │
  └─ オプション4 ──→ [LGIPOL01]（01IMOT）──→ 照会
                          │
                          ↓
                     [画面表示/修正入力]
                          │
                          ↓
                    [LGUPOL01]（01UMOT）──→ Db2/VSAM更新
```

### 関連ファイル一覧

| ファイル | 種別 | 説明 |
|----------|------|------|
| lgtestp1.cbl | COBOL | 自動車保険メニューメインプログラム |
| ssmap.cpy | BMS | 画面マップ定義（SSMAPP1含む） |
| lgcmarea.cpy | COPY句 | COMMAREA構造定義 |
| lgipol01.cbl | COBOL | ポリシー照会プログラム |
| lgapol01.cbl | COBOL | ポリシー登録プログラム |
| lgdpol01.cbl | COBOL | ポリシー削除プログラム |
| lgupol01.cbl | COBOL | ポリシー更新プログラム |

### リクエストID対応表

| リクエストID | 操作 | 説明 |
|-------------|------|------|
| 01IMOT | 照会 | 自動車保険ポリシー照会 |
| 01AMOT | 登録 | 自動車保険ポリシー登録 |
| 01DMOT | 削除 | 自動車保険ポリシー削除 |
| 01UMOT | 更新 | 自動車保険ポリシー更新 |
