# 機能設計書 F003-顧客更新

## 概要

本ドキュメントは、CICS-GENAPPシステムにおける顧客更新機能の詳細設計を定義する。既存顧客の情報をDb2データベースおよびVSAMファイルで更新する機能である。

### 本機能の処理概要

本機能は、既に登録されている顧客の基本情報を更新するための基幹機能を提供する。

**業務上の目的・背景**：顧客の住所変更、電話番号の変更、メールアドレスの更新など、顧客情報は時間の経過とともに変更が必要となる。本機能は、これらの変更を迅速かつ正確にシステムに反映し、顧客との適切なコミュニケーションと契約管理を維持する。情報の鮮度を保つことは、保険契約の通知送付や緊急連絡において重要である。

**機能の利用シーン**：顧客から住所変更や連絡先変更の申し出があった際、オペレーターが顧客メニュー画面からオプション4を選択し、まず顧客情報を照会した後、変更内容を入力して更新を実行する。

**主要な処理内容**：
1. リクエストID('01UCUS')とCOMMAREAの検証
2. LGUCDB01プログラムを呼び出してDb2のCUSTOMERテーブルをUPDATE
3. LGUCVS01プログラムを呼び出してVSAMファイル（KSDSCUST）を更新
4. 処理結果を呼び出し元に返却

**関連システム・外部連携**：Db2データベース、VSAMファイルとの連携。

**権限による制御**：本機能は顧客情報更新権限を持つオペレーターのみが実行可能である。

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 1 | 顧客メニュー画面 | 主画面 | オプション4選択時にまずLGICUS01で照会後、LGUCUS01プログラムをCICS LINKで呼び出し、顧客情報を更新する |

## 機能種別

CRUD操作（Update）/ データ更新処理

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| CA-REQUEST-ID | X(6) | Yes | リクエストID | '01UCUS'固定 |
| CA-CUSTOMER-NUM | 9(10) | Yes | 顧客番号 | 存在する顧客番号 |
| CA-FIRST-NAME | X(10) | Yes | 名 | - |
| CA-LAST-NAME | X(20) | Yes | 姓 | - |
| CA-DOB | X(10) | Yes | 生年月日 | 日付形式 |
| CA-HOUSE-NAME | X(20) | No | 建物名 | - |
| CA-HOUSE-NUM | X(4) | No | 建物番号 | - |
| CA-POSTCODE | X(8) | Yes | 郵便番号 | - |
| CA-PHONE-MOBILE | X(20) | No | 携帯電話番号 | - |
| CA-PHONE-HOME | X(20) | No | 自宅電話番号 | - |
| CA-EMAIL-ADDRESS | X(100) | No | メールアドレス | - |

### 入力データソース

- 画面入力（顧客メニュー画面 SSMAPC1）
- CICS通信領域（COMMAREA）を介したデータ連携

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| CA-RETURN-CODE | 9(2) | 処理結果コード |

### 出力先

- CICS通信領域（COMMAREA）
- Db2 CUSTOMERテーブル（更新）
- VSAMファイル（KSDSCUST）（更新）

## 処理フロー

### 処理シーケンス

```
1. COMMAREAの受信と検証
   └─ COMMAREAが存在しない場合はABEND('LGCA')
2. リクエストIDの検証
   └─ '01UCUS'でない場合は'99'エラーで終了
3. LGUCDB01プログラム呼び出し
   └─ CICS LINKでDb2アクセス層を呼び出し
4. CUSTOMERテーブルのUPDATE（LGUCDB01）
   └─ 顧客番号をキーに9項目を更新
5. LGUCVS01プログラム呼び出し（LGUCDB01から）
   └─ VSAMファイルを更新
6. 結果の返却
   └─ リターンコードをCOMMAREAに設定
```

### フローチャート

```mermaid
flowchart TD
    A[開始] --> B{COMMAREAあり?}
    B -->|No| C[ABEND LGCA]
    B -->|Yes| D{REQUEST-ID='01UCUS'?}
    D -->|No| E[RC=99で終了]
    D -->|Yes| F[LGUCDB01呼出]
    F --> G[CUSTOMERテーブルUPDATE]
    G --> H{SQLCODE判定}
    H -->|0| I[LGUCVS01呼出]
    H -->|100| J[RC=01 データなし]
    H -->|Other| K[RC=90 エラー]
    I --> L[VSAMファイルREAD FOR UPDATE]
    L --> M[VSAMファイルREWRITE]
    M --> N{成功?}
    N -->|Yes| O[RC=00で正常終了]
    N -->|No| P[ABENDで終了]
    E --> Q[終了]
    J --> Q
    K --> Q
    O --> Q
    P --> Q
    C --> Q
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-001 | リクエストID検証 | リクエストIDが'01UCUS'でない場合は処理を拒否 | 常時 |
| BR-002 | 存在確認 | 指定された顧客番号が存在しない場合は'01'エラー | 更新時 |
| BR-003 | 二重更新防止 | Db2とVSAMの両方を更新し整合性を維持 | 常時 |

### 計算ロジック

- 計算ロジックなし（純粋な更新処理）

## データベース操作仕様

### 操作別データベース影響一覧

| 操作 | 対象テーブル | 操作種別 | 概要 |
|-----|-------------|---------|------|
| 顧客情報更新 | CUSTOMER | UPDATE | 顧客基本情報の更新 |

### テーブル別操作詳細

#### CUSTOMER

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| UPDATE | FIRSTNAME | :CA-FIRST-NAME | WHERE CUSTOMERNUMBER = :DB2-CUSTOMERNUM-INT |
| UPDATE | LASTNAME | :CA-LAST-NAME | 同上 |
| UPDATE | DATEOFBIRTH | :CA-DOB | 同上 |
| UPDATE | HOUSENAME | :CA-HOUSE-NAME | 同上 |
| UPDATE | HOUSENUMBER | :CA-HOUSE-NUM | 同上 |
| UPDATE | POSTCODE | :CA-POSTCODE | 同上 |
| UPDATE | PHONEMOBILE | :CA-PHONE-MOBILE | 同上 |
| UPDATE | PHONEHOME | :CA-PHONE-HOME | 同上 |
| UPDATE | EMAILADDRESS | :CA-EMAIL-ADDRESS | 同上 |

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| 99 | 入力エラー | リクエストIDが'01UCUS'でない | 正しいリクエストIDを設定 |
| 01 | 業務エラー | 顧客番号が存在しない（SQLCODE=100） | 正しい顧客番号を指定 |
| 90 | DB2エラー | その他のSQLエラー | エラーログ確認 |
| 81 | VSAMエラー | VSAMファイルREAD失敗 | ファイル状態確認 |
| 82 | VSAMエラー | VSAMファイルREWRITE失敗 | ファイル状態確認 |
| LGCA | システムエラー | COMMAREAなし | プログラム呼出方法確認 |
| LGV1 | VSAMエラー | VSAM READ FOR UPDATE異常 | ファイル定義確認 |
| LGV2 | VSAMエラー | VSAM REWRITE異常 | ファイル定義確認 |

### リトライ仕様

- VSAMエラー時はリトライなし（ABENDで終了）
- DB2エラー時はリトライなし

## トランザクション仕様

- トランザクションID: SSC1
- コミット: 正常終了時にCICS RETURNで暗黙コミット
- ロールバック: ABEND発生時にCICSにより自動ロールバック

## パフォーマンス要件

- レスポンス時間: 1秒以内
- 主キーによる単一行UPDATE のため高速

## セキュリティ考慮事項

- 顧客情報の更新には適切な権限管理が必要
- 更新前の照会で現在の情報を確認してから更新を実行
- エラー発生時はLGSTSQプログラムを通じてエラーキューにログを記録

## 備考

- LGUCUS01: ビジネスロジック層（LGUCDB01を呼び出し）
- LGUCDB01: Db2データアクセス層（CUSTOMERテーブルUPDATE、LGUCVS01呼び出し）
- LGUCVS01: VSAMデータアクセス層（KSDSCUSTファイル更新）
- 更新処理の前に必ず照会（F002）を実行して現在の顧客情報を取得することを推奨

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

まず、プログラム間で受け渡されるデータ構造を理解することが重要である。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | lgcmarea.cpy | `base/src/lgcmarea.cpy` | COMMAREA構造の理解。`CA-REQUEST-ID`が'01UCUS'で更新処理を識別。`CA-CUSTOMER-NUM`が更新対象キー、`CA-CUSTOMER-REQUEST`内の各フィールドが更新データ |
| 1-2 | lgpolicy.cpy | `base/src/lgpolicy.cpy` | `WS-CUSTOMER-LEN`（72バイト）の定義を確認 |

**読解のコツ**: 顧客更新は`CA-REQUEST-ID='01UCUS'`で識別される。照会（'01ICUS'）と異なるリクエストIDに注意。

#### Step 2: 画面レイアウトを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | ssmap.bms | `base/src/ssmap.bms` | `SSMAPC1`マップ（13-106行目）。オプション4が「Cust Update」（25行目）。照会後に変更データを入力して更新を実行 |

**読解のコツ**: 25行目の`INITIAL='4. Cust Update  '`がメニューオプション4の定義。

#### Step 3: エントリーポイント（ビジネスロジック層）

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | lgucus01.cbl | `base/src/lgucus01.cbl` | **MAINLINE SECTION**（83-123行目）: リクエストIDの検証とLGUCDB01呼び出し |

**主要処理フロー**:
1. **99-103行目**: COMMAREAなしの場合はABEND('LGCA')
2. **105-108行目**: リターンコード初期化
3. **110-113行目**: リクエストIDチェック。'01UCUS'でない場合はRC='99'で終了
4. **116行目**: `PERFORM UPDATE-CUSTOMER-INFO`でLGUCDB01を呼び出し
5. **126-133行目**: CICS LINKでLGUCDB01を呼び出し

**読解のコツ**: リクエストID検証（110-113行目）が照会（LGICUS01）との大きな違い。

#### Step 4: データアクセス層（DB2 UPDATE処理）

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | lgucdb01.cbl | `base/src/lgucdb01.cbl` | **最も重要なファイル**。DB2のCUSTOMERテーブル更新とLGUCVS01呼び出し |

**主要処理フロー**:
1. **117-121行目**: COMMAREAなしの場合はABEND('LGCA')
2. **129行目**: `CA-CUSTOMER-NUM`を`DB2-CUSTOMERNUM-INT`に変換
3. **134行目**: `PERFORM UPDATE-CUSTOMER-INFO`でUPDATE実行
4. **136-139行目**: CICS LINKでLGUCVS01を呼び出し（VSAM更新）

**注目すべき詳細**:
- **152-181行目** `UPDATE-CUSTOMER-INFO`: CUSTOMERテーブルのUPDATE文
  - **155-169行目**: 9項目（FIRSTNAME〜EMAILADDRESS）を更新
  - **171-180行目**: SQLCODEの評価
    - `SQLCODE=100`: データなし、RC='01'
    - その他: エラー、RC='90'

#### Step 5: VSAM処理層

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 5-1 | lgucvs01.cbl | `base/src/lgucvs01.cbl` | KSDSCUSTファイルのREAD FOR UPDATE → REWRITE処理 |

**主要処理フロー**:
1. **69-83行目**: CICS READ FILEでUPDATEオプション付き読み込み
   - 失敗時: RC='81'、ABEND('LGV1')
2. **85-96行目**: CICS REWRITEで更新書き込み
   - 失敗時: RC='82'、ABEND('LGV2')

**読解のコツ**: VSAMの更新は「READ FOR UPDATE → REWRITE」の2段階処理。READでレコードをロックし、REWRITEで更新する。

#### Step 6: 補助機能（エラーログ）

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 6-1 | lgstsq.cbl | `base/src/lgstsq.cbl` | エラーメッセージをTDQ/TSQに書き込む共通ログ機能 |

### プログラム呼び出し階層図

```
画面操作（オプション4選択 + 更新データ入力）
    │
    ▼
LGUCUS01 (lgucus01.cbl)  ─────────────────┐
    │ CICS LINK                           │ エラー時
    ▼                                     ▼
LGUCDB01 (lgucdb01.cbl)              LGSTSQ (lgstsq.cbl)
    │                                     │
    ├─ SQL UPDATE (CUSTOMER)              └─ TDQ/TSQ書込
    │
    └─ CICS LINK ──▶ LGUCVS01 (lgucvs01.cbl)
                         │
                         ├─ CICS READ FILE (UPDATE)
                         │
                         └─ CICS REWRITE FILE
```

### データフロー図

```
[入力]                    [処理]                         [出力]

COMMAREA ─────────▶ LGUCUS01 ─────▶ LGUCDB01 ─────────▶ CUSTOMER (Db2)
 │                                      │                 [UPDATE]
 ├─ CA-REQUEST-ID                       │
 │  ('01UCUS')                          │
 ├─ CA-CUSTOMER-NUM                     │
 │  (更新キー)                          │
 ├─ CA-FIRST-NAME                       ▼
 ├─ CA-LAST-NAME                  LGUCVS01 ───────────▶ KSDSCUST (VSAM)
 ├─ CA-DOB                             │                 [REWRITE]
 ├─ CA-HOUSE-NAME                      │
 ├─ CA-HOUSE-NUM                       ▼
 ├─ CA-POSTCODE                   COMMAREA
 ├─ CA-PHONE-MOBILE                    │
 ├─ CA-PHONE-HOME                      └─ CA-RETURN-CODE
 └─ CA-EMAIL-ADDRESS
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| lgucus01.cbl | `base/src/lgucus01.cbl` | COBOLプログラム | ビジネスロジック層（エントリーポイント） |
| lgucdb01.cbl | `base/src/lgucdb01.cbl` | COBOLプログラム | Db2データアクセス層（UPDATE処理） |
| lgucvs01.cbl | `base/src/lgucvs01.cbl` | COBOLプログラム | VSAMデータアクセス層（REWRITE処理） |
| lgcmarea.cpy | `base/src/lgcmarea.cpy` | コピーブック | COMMAREA構造定義 |
| lgpolicy.cpy | `base/src/lgpolicy.cpy` | コピーブック | ポリシー/顧客データ長定義 |
| ssmap.bms | `base/src/ssmap.bms` | BMSマップ | 画面定義（SSMAPC1が顧客メニュー） |
| lgstsq.cbl | `base/src/lgstsq.cbl` | COBOLプログラム | エラーログ共通機能 |
