# 機能設計書 F030-商業用不動産保険メニュー

## 概要

本ドキュメントは、商業用不動産保険関連操作のメニュー画面を提供する機能（F030）の詳細設計を記載したものです。

### 本機能の処理概要

本機能は、商業用不動産保険（Commercial Policy）に関する操作（照会・登録・削除）のメニュー画面を表示し、ユーザーの選択に応じて対応する業務プログラムを呼び出します。

**業務上の目的・背景**：商業用不動産保険は、事業用物件を対象とした包括的な保険商品であり、複数のリスク（火災、犯罪、洪水、天候）に対する補償を提供します。本メニュー画面は、オペレーターが商業用不動産保険ポリシーの照会・登録・削除を行えるよう設計されています。物件情報（住所、緯度経度、物件タイプ等）と各種リスク補償（危険度、保険料）を一画面で管理できます。

**機能の利用シーン**：
- 新規商業用不動産保険契約の登録
- 既存契約の照会・内容確認（複数の検索条件対応）
- 契約の解約・削除

**主要な処理内容**：
1. 商業用不動産保険メニュー画面（SSMAPP4）を表示
2. ユーザーからオプション選択を受信
3. オプションに応じて対応プログラムをCICS LINKで呼び出し
   - オプション1: ポリシー照会（LGIPOL01）- 複数の検索条件対応
   - オプション2: ポリシー登録（LGAPOL01）
   - オプション3: ポリシー削除（LGDPOL01）
4. 処理結果を画面に表示
5. 次の操作に備えてトランザクションを継続

**関連システム・外部連携**：
- LGIPOL01: ポリシー照会プログラム
- LGAPOL01: ポリシー登録プログラム
- LGDPOL01: ポリシー削除プログラム

**権限による制御**：特になし（CICSトランザクション実行権限のみ）

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 5 | 商業用不動産保険ポリシーメニュー画面 | 主機能 | LGTESTP4プログラムが画面SSMAPP4を表示し、商業用不動産保険の操作メニュー機能を提供 |

## 機能種別

画面処理（メニュー画面）

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| ENP4OPT | PIC X(1) | Yes | オプション選択（1:照会、2:登録、3:削除） | 1, 2, 3のいずれか |
| ENP4CNO | PIC 9(10) | Yes（登録・削除時） | 顧客番号 | 10桁数字 |
| ENP4PNO | PIC 9(10) | Yes（削除時） | ポリシー番号 | 10桁数字 |
| ENP4IDA | PIC X(10) | Yes（登録時） | 発効日（Issue Date） | 日付形式 |
| ENP4EDA | PIC X(10) | Yes（登録時） | 満期日（Expiry Date） | 日付形式 |
| ENP4ADD | PIC X(255) | No | 物件住所 | 最大255文字 |
| ENP4HPC | PIC X(8) | No | 郵便番号 | 最大8文字 |
| ENP4LAT | PIC X(11) | No | 緯度（Latitude） | 11文字 |
| ENP4LON | PIC X(11) | No | 経度（Longitude） | 11文字 |
| ENP4CUS | PIC X(255) | No | 顧客名 | 最大255文字 |
| ENP4PTY | PIC X(255) | No | 物件タイプ | 最大255文字 |
| ENP4FPE | PIC 9(4) | No | 火災危険度 | 4桁数字 |
| ENP4FPR | PIC 9(8) | No | 火災保険料 | 8桁数字 |
| ENP4CPE | PIC 9(4) | No | 犯罪危険度 | 4桁数字 |
| ENP4CPR | PIC 9(8) | No | 犯罪保険料 | 8桁数字 |
| ENP4XPE | PIC 9(4) | No | 洪水危険度 | 4桁数字 |
| ENP4XPR | PIC 9(8) | No | 洪水保険料 | 8桁数字 |
| ENP4WPE | PIC 9(4) | No | 天候危険度 | 4桁数字 |
| ENP4WPR | PIC 9(8) | No | 天候保険料 | 8桁数字 |
| ENP4STA | PIC 9(4) | No | ステータス | 4桁数字 |
| ENP4REJ | PIC X(255) | No | 却下理由 | 最大255文字 |

### 入力データソース

- BMS画面（SSMAPP4）からの入力

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| ENP4CNO | PIC 9(10) | 顧客番号 |
| ENP4PNO | PIC 9(10) | ポリシー番号 |
| ENP4IDA | PIC X(10) | 発効日 |
| ENP4EDA | PIC X(10) | 満期日 |
| ENP4ADD | PIC X(255) | 物件住所 |
| ENP4HPC | PIC X(8) | 郵便番号 |
| ENP4LAT | PIC X(11) | 緯度 |
| ENP4LON | PIC X(11) | 経度 |
| ENP4CUS | PIC X(255) | 顧客名 |
| ENP4PTY | PIC X(255) | 物件タイプ |
| ENP4FPE/FPR | PIC 9(4)/9(8) | 火災危険度/保険料 |
| ENP4CPE/CPR | PIC 9(4)/9(8) | 犯罪危険度/保険料 |
| ENP4XPE/XPR | PIC 9(4)/9(8) | 洪水危険度/保険料 |
| ENP4WPE/WPR | PIC 9(4)/9(8) | 天候危険度/保険料 |
| ENP4STA | PIC 9(4) | ステータス |
| ENP4REJ | PIC X(255) | 却下理由 |
| ERP4FLD | PIC X(79) | エラー/成功メッセージ |

### 出力先

- BMS画面（SSMAPP4）への表示

## 処理フロー

### 処理シーケンス

```
1. 初回表示判定
   └─ EIBCALENが0なら初期化して画面表示
   └─ 0より大きければ継続処理へ

2. 画面初期化（初回のみ）
   └─ 入出力エリアの初期化
   └─ 数値フィールドをLOW-VALUESで初期化
   └─ SSMAPP4画面を送信

3. ユーザー入力受信
   └─ CLEARキー: 画面クリア
   └─ PF3キー: トランザクション終了
   └─ その他: オプション処理

4. オプション処理
   ├─ オプション1（照会）- 複数検索条件対応
   │  └─ 顧客番号+ポリシー番号: 01ICOM
   │  └─ ポリシー番号のみ: 02ICOM
   │  └─ 顧客番号のみ: 03ICOM
   │  └─ 郵便番号のみ: 05ICOM
   │  └─ LGIPOL01を呼び出し
   ├─ オプション2（登録）
   │  └─ LGAPOL01を呼び出し（リクエストID: 01ACOM）
   │  └─ 新規ポリシー番号を画面に表示
   └─ オプション3（削除）
      └─ LGDPOL01を呼び出し（リクエストID: 01DCOM）
      └─ 削除完了メッセージを表示

5. トランザクション継続
   └─ CICS RETURN TRANSID('SSP4')
```

### フローチャート

```mermaid
flowchart TD
    A[開始] --> B{初回起動?}
    B -->|Yes| C[画面初期化]
    B -->|No| D[入力受信]
    C --> E[画面送信]
    E --> D
    D --> F{入力キー判定}
    F -->|CLEAR| G[画面クリア]
    F -->|PF3| H[終了]
    F -->|ENTER| I{オプション判定}
    I -->|1| J{検索条件判定}
    J -->|顧客+ポリシー| K[01ICOM]
    J -->|ポリシーのみ| L[02ICOM]
    J -->|顧客のみ| M[03ICOM]
    J -->|郵便番号のみ| N[05ICOM]
    K --> O[照会実行]
    L --> O
    M --> O
    N --> O
    I -->|2| P[ポリシー登録]
    I -->|3| Q[ポリシー削除]
    I -->|Other| R[エラー表示]
    O --> S[結果表示]
    P --> T{成功?}
    T -->|Yes| U[ポリシー番号表示]
    T -->|No| V[ロールバック]
    Q --> W{成功?}
    W -->|Yes| X[削除完了表示]
    W -->|No| Y[ロールバック]
    S --> Z[トランザクション継続]
    U --> Z
    V --> Z
    X --> Z
    Y --> Z
    R --> Z
    G --> Z
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-001 | 有効オプション | オプションは1, 2, 3のいずれか（更新なし） | 常時 |
| BR-002 | 複数検索条件 | 顧客番号+ポリシー番号、ポリシー番号のみ、顧客番号のみ、郵便番号のみで検索可能 | オプション1 |
| BR-003 | リクエストID | 01ICOM/02ICOM/03ICOM/05ICOM(照会), 01ACOM(登録), 01DCOM(削除) | 各オプション |
| BR-004 | エラー時ロールバック | 登録/削除失敗時はSyncpoint Rollback | オプション2, 3失敗時 |
| BR-005 | リターンコード70 | 顧客が存在しない場合のエラーコード | 登録失敗時 |

### 計算ロジック

検索条件判定ロジック:
```
IF 顧客番号 AND ポリシー番号が有効 THEN
    リクエストID = '01ICOM'
ELSE IF ポリシー番号のみ有効 THEN
    リクエストID = '02ICOM'
ELSE IF 顧客番号のみ有効 THEN
    リクエストID = '03ICOM'
ELSE IF 郵便番号が有効 THEN
    リクエストID = '05ICOM'
END-IF
```

## データベース操作仕様

### 操作別データベース影響一覧

| 操作 | 対象テーブル | 操作種別 | 概要 |
|-----|-------------|---------|------|
| ポリシー照会 | POLICY/COMMERCIAL（Db2/VSAM） | SELECT/READ | LGIPOL01経由 |
| ポリシー登録 | POLICY/COMMERCIAL（Db2/VSAM） | INSERT/WRITE | LGAPOL01経由 |
| ポリシー削除 | POLICY/COMMERCIAL（Db2/VSAM） | DELETE | LGDPOL01経由 |

### テーブル別操作詳細

業務プログラム（LGIPOL01, LGAPOL01, LGDPOL01）を通じてアクセス

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| 70 | 顧客不存在 | 登録時に指定顧客が存在しない | 'Customer does not exist'を表示 |
| CA-RETURN-CODE > 0 | 業務エラー | その他の失敗 | 各オプション用エラーメッセージ表示 |
| MAPFAIL | 画面エラー | 画面入力失敗 | トランザクション終了 |

### リトライ仕様

- リトライは実装されていない
- エラー発生時は画面にエラーメッセージを表示し、再入力を促す

## トランザクション仕様

- 登録/削除処理失敗時：Syncpoint Rollbackを実行
- 画面遷移：CICS RETURN TRANSID('SSP4')でトランザクション継続
- 終了時：PF3キーまたはMAPFAILでトランザクション終了

## パフォーマンス要件

- 画面応答時間：通常操作で数秒以内
- Db2/VSAMアクセスは各業務プログラムで実行

## セキュリティ考慮事項

- CICSトランザクション実行権限による制御
- 商業用不動産保険契約情報を取り扱うため、アクセス制御が重要
- 物件の位置情報（緯度経度）含む詳細情報の管理

## 備考

- プログラム名：LGTESTP4
- トランザクションコード：SSP4
- 画面マップ：SSMAPP4
- マップセット：SSMAP
- 関連業務プログラム：
  - LGIPOL01: ポリシー照会
  - LGAPOL01: ポリシー登録
  - LGDPOL01: ポリシー削除
- COMMエリア長：32500バイト
- リクエストIDプレフィックス：01-05（Commercial系、接尾辞COM）
- 特徴：更新機能（オプション4）は実装されていない
- リスク種別：
  - 火災（Fire）
  - 犯罪（Crime）
  - 洪水（Flood）
  - 天候（Weather）

## コードリーディングガイド

本機能のソースコードを理解するための推奨リーディング順序を以下に示す。

### 推奨リーディング順序

| Step | ファイル | 行番号 | 内容 |
|------|----------|--------|------|
| 1 | base/src/lgtestp4.cbl | 16-24 | WORKING-STORAGE変数定義とCOPY句 |
| 2 | base/src/lgtestp4.cbl | 30-69 | 初期表示とユーザー入力受信 |
| 3 | base/src/lgtestp4.cbl | 71-154 | オプション1：複数検索条件による照会 |
| 4 | base/src/lgtestp4.cbl | 156-234 | オプション2-3：登録・削除処理 |
| 5 | base/src/lgtestp4.cbl | 286-318 | エラー処理パラグラフ |

### Step別詳細ガイド

#### Step 1: WORKING-STORAGE変数定義（lgtestp4.cbl:16-24）
```cobol
77 MSGEND                       PIC X(24) VALUE
                                 'Transaction ended      '.

COPY SSMAP.
01 COMM-AREA.
COPY LGCMAREA.
```
BMS画面定義（SSMAP）、COMMAREA定義（LGCMAREA）をCOPY句で取り込み。

#### Step 2: 初期表示とユーザー入力受信（lgtestp4.cbl:30-69）
```cobol
IF EIBCALEN > 0
   GO TO A-GAIN.

Initialize SSMAPP4I.
Initialize SSMAPP4O.
Initialize COMM-AREA.
MOVE '0000000000'   To ENP4CNOO.
MOVE '0000000000'   To ENP4PNOO.
MOVE LOW-VALUES     To ENP4FPEO.
MOVE LOW-VALUES     To ENP4FPRO.
MOVE LOW-VALUES     To ENP4CPEO.
...（他のリスクフィールドも同様）

EXEC CICS SEND MAP ('SSMAPP4')
          MAPSET ('SSMAP')
          ERASE
END-EXEC.

A-GAIN.
    EXEC CICS HANDLE AID
              CLEAR(CLEARIT)
              PF3(ENDIT) END-EXEC.
    EXEC CICS RECEIVE MAP('SSMAPP4')
              INTO(SSMAPP4I)
              MAPSET('SSMAP') END-EXEC.
```
初回起動時は画面初期化。リスク関連フィールドはLOW-VALUESで初期化。

#### Step 3: オプション1：複数検索条件による照会（lgtestp4.cbl:71-154）
```cobol
WHEN '1'
    If (ENP4CNOO Not = Spaces AND ...) AND
       (ENP4PNOO Not = Spaces AND ...)
           Move '01ICOM'   To CA-REQUEST-ID
           Move ENP4CNOO   To CA-CUSTOMER-NUM
           Move ENP4PNOO   To CA-POLICY-NUM
    Else
    If (ENP4PNOO Not = Spaces AND ...)
           Move '02ICOM'   To CA-REQUEST-ID
           Move ENP4PNOO   To CA-POLICY-NUM
    Else
    If (ENP4CNOO Not = Spaces AND ...)
           Move '03ICOM'   To CA-REQUEST-ID
           Move ENP4CNOO   To CA-CUSTOMER-NUM
    Else
    If (ENP4HPCO NOT = Spaces AND ...)
           Move '05ICOM'   To CA-REQUEST-ID
           Move ENP4HPCO   To CA-B-PostCode
    End-If
    End-If
    End-If
    End-If

    EXEC CICS LINK PROGRAM('LGIPOL01')
              COMMAREA(COMM-AREA)
              LENGTH(32500)
    END-EXEC

    Move CA-B-FirePeril       To  ENP4FPEI
    Move CA-B-FirePremium     To  ENP4FPRI
    Move CA-B-CrimePeril      To  ENP4CPEI
    ...（4種のリスク情報を画面に設定）
```
入力条件の組み合わせにより異なるリクエストIDを使用。顧客+ポリシー、ポリシーのみ、顧客のみ、郵便番号のみの4パターン。

#### Step 4: オプション2-3：登録・削除処理（lgtestp4.cbl:156-234）
```cobol
WHEN '2'
    Move '01ACOM'             To  CA-REQUEST-ID
    Move ENP4CNOO             To  CA-CUSTOMER-NUM
    Move ENP4FPEO             To  CA-B-FirePeril
    Move ENP4FPRO             To  CA-B-FirePremium
    Move ENP4CPEO             To  CA-B-CrimePeril
    Move ENP4CPRO             To  CA-B-CrimePremium
    Move ENP4XPEO             To  CA-B-FloodPeril
    Move ENP4XPRO             To  CA-B-FloodPremium
    Move ENP4WPEO             To  CA-B-WeatherPeril
    Move ENP4WPRO             To  CA-B-WeatherPremium
    ...
    EXEC CICS LINK PROGRAM('LGAPOL01')...

WHEN '3'
    Move '01DCOM'   To CA-REQUEST-ID
    Move ENP4CNOO   To CA-CUSTOMER-NUM
    Move ENP4PNOO   To CA-POLICY-NUM
    EXEC CICS LINK PROGRAM('LGDPOL01')...
```
登録時は4種類のリスク情報（火災・犯罪・洪水・天候）をCOMMAREAに設定。

#### Step 5: エラー処理（lgtestp4.cbl:286-318）
```cobol
NO-ADD.
    Evaluate CA-RETURN-CODE
      When 70
        Move 'Customer does not exist'        To  ERP4FLDO
      When Other
        Move 'Error Adding Commercial Policy' To  ERP4FLDO
    End-Evaluate.

NO-DELETE.
    Move 'Error Deleting Commercial Policy'   To  ERP4FLDO.

ERROR-OUT.
    EXEC CICS SEND MAP ('SSMAPP4')
              FROM(SSMAPP4O)
              MAPSET ('SSMAP')
    END-EXEC.
    GO TO ENDIT-STARTIT.
```
Commercial Policy（商業用不動産保険）固有のエラーメッセージを設定。

### プログラム構造

```
LGTESTP4 (トランザクション: SSP4)
  ├─ MAINLINE SECTION
  │    ├─ 初回起動判定（EIBCALEN）
  │    ├─ 画面初期化（LOW-VALUESで初期化）
  │    │    └─ SEND MAP ('SSMAPP4')
  │    └─ A-GAIN（入力受信ループ）
  │         ├─ HANDLE AID（CLEAR/PF3）
  │         ├─ RECEIVE MAP
  │         └─ EVALUATE ENP4OPTO
  │              ├─ '1': 検索条件判定
  │              │    ├─ 顧客+ポリシー → 01ICOM
  │              │    ├─ ポリシーのみ → 02ICOM
  │              │    ├─ 顧客のみ → 03ICOM
  │              │    └─ 郵便番号のみ → 05ICOM
  │              │    └─ LINK LGIPOL01（照会）
  │              ├─ '2': 01ACOM → LINK LGAPOL01（登録）
  │              ├─ '3': 01DCOM → LINK LGDPOL01（削除）
  │              └─ OTHER: エラー表示
  │              （※オプション'4'は未実装）
  ├─ ENDIT-STARTIT
  │    └─ RETURN TRANSID('SSP4')
  ├─ ENDIT / CLEARIT
  └─ NO-ADD / NO-UPD / NO-DELETE / NO-DATA / ERROR-OUT
```

### データフロー図

```
[BMS画面 SSMAPP4]
├─ オプション（1:照会/2:登録/3:削除）※更新なし
├─ 顧客番号/ポリシー番号/郵便番号（検索条件）
├─ 物件情報（住所/緯度経度/物件タイプ）
└─ リスク情報（火災/犯罪/洪水/天候）×（危険度/保険料）
         │
         ↓
[EVALUATE処理]
  │
  ├─ オプション1 ──→ [検索条件判定]
  │                      │
  │      ┌───────┼───────┐───────┐
  │      ↓       ↓       ↓       ↓
  │   01ICOM  02ICOM  03ICOM  05ICOM
  │   (顧客+   (ポリシー (顧客    (郵便番号
  │   ポリシー)  のみ)    のみ)     のみ)
  │      │       │       │       │
  │      └───────┴───────┴───────┘
  │                      │
  │                      ↓
  │              [LGIPOL01] ──→ Db2/VSAM照会
  │                      │
  │                      └─→ 画面に結果表示
  │
  ├─ オプション2（01ACOM）──→ [LGAPOL01] ──→ Db2/VSAM登録
  │                                │
  │                          成功 ─┴─ 失敗
  │                           │      │
  │                           ↓      ↓
  │                    [ポリシー番号表示] [Syncpoint Rollback]
  │
  └─ オプション3（01DCOM）──→ [LGDPOL01] ──→ Db2/VSAM削除
```

### 関連ファイル一覧

| ファイル | 種別 | 説明 |
|----------|------|------|
| lgtestp4.cbl | COBOL | 商業用不動産保険メニューメインプログラム |
| ssmap.cpy | BMS | 画面マップ定義（SSMAPP4含む） |
| lgcmarea.cpy | COPY句 | COMMAREA構造定義 |
| lgipol01.cbl | COBOL | ポリシー照会プログラム |
| lgapol01.cbl | COBOL | ポリシー登録プログラム |
| lgdpol01.cbl | COBOL | ポリシー削除プログラム |

### リクエストID対応表

| リクエストID | 操作 | 検索条件 | 説明 |
|-------------|------|----------|------|
| 01ICOM | 照会 | 顧客番号+ポリシー番号 | 特定契約の照会 |
| 02ICOM | 照会 | ポリシー番号のみ | ポリシー番号による照会 |
| 03ICOM | 照会 | 顧客番号のみ | 顧客の契約一覧照会 |
| 05ICOM | 照会 | 郵便番号のみ | 地域による照会 |
| 01ACOM | 登録 | - | 新規契約登録 |
| 01DCOM | 削除 | - | 契約削除 |

### リスク種別対応表

| リスク種別 | 危険度フィールド | 保険料フィールド |
|-----------|-----------------|-----------------|
| 火災（Fire） | ENP4FPE / CA-B-FirePeril | ENP4FPR / CA-B-FirePremium |
| 犯罪（Crime） | ENP4CPE / CA-B-CrimePeril | ENP4CPR / CA-B-CrimePremium |
| 洪水（Flood） | ENP4XPE / CA-B-FloodPeril | ENP4XPR / CA-B-FloodPremium |
| 天候（Weather） | ENP4WPE / CA-B-WeatherPeril | ENP4WPR / CA-B-WeatherPremium |
