# 機能設計書 F004-自動車保険登録

## 概要

本ドキュメントは、CICS-GENAPPシステムにおける自動車保険登録機能の詳細設計を定義する。新規の自動車保険ポリシーをDb2データベースおよびVSAMファイルに登録する機能である。

### 本機能の処理概要

本機能は、顧客に対して新規の自動車保険ポリシーを作成・登録するための基幹機能を提供する。

**業務上の目的・背景**：自動車保険は、顧客の自動車に対する損害や事故時の補償を提供する保険商品である。本機能は、顧客が新規に自動車保険に加入する際、車両情報（メーカー、モデル、登録番号、車両価値等）と保険情報（保険料、発効日、満期日等）をシステムに登録し、一意のポリシー番号を発行する。これにより、契約管理と保険金請求処理の基盤を構築する。

**機能の利用シーン**：顧客が新規に自動車保険の契約を希望する際、オペレーターが自動車保険追加画面からPF4キーを押下し、顧客番号と車両情報、保険詳細を入力して登録を実行する。

**主要な処理内容**：
1. リクエストID('01AMOT')とCOMMAREAの検証
2. LGAPOL01プログラムを呼び出しビジネスロジックを実行
3. LGAPDB01プログラムでPOLICYテーブルとMOTORテーブルにINSERT
4. Db2のIDENTITY機能で自動採番されたポリシー番号を取得
5. LGAPVS01プログラムでVSAMファイル（KSDSPOLY）に登録
6. 処理結果とポリシー番号を呼び出し元に返却

**関連システム・外部連携**：Db2データベース、VSAMファイルとの連携。

**権限による制御**：本機能は保険ポリシー作成権限を持つオペレーターのみが実行可能である。

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 6 | 自動車保険追加画面 | 主画面 | PF4キー押下時にLGAPOL01プログラムをCICS LINKで呼び出し、自動車保険ポリシーを新規登録する |

## 機能種別

CRUD操作（Create）/ データ登録処理

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| CA-REQUEST-ID | X(6) | Yes | リクエストID | '01AMOT'固定 |
| CA-CUSTOMER-NUM | 9(10) | Yes | 顧客番号 | 存在する顧客番号 |
| CA-ISSUE-DATE | X(10) | Yes | 発効日 | 日付形式（YYYY-MM-DD） |
| CA-EXPIRY-DATE | X(10) | Yes | 満期日 | 日付形式 |
| CA-BROKERID | 9(10) | No | ブローカーID | - |
| CA-BROKERSREF | X(10) | No | ブローカー参照番号 | - |
| CA-PAYMENT | 9(6) | No | 支払額 | - |
| CA-M-MAKE | X(15) | Yes | メーカー | - |
| CA-M-MODEL | X(15) | Yes | モデル | - |
| CA-M-VALUE | 9(6) | Yes | 車両価値 | - |
| CA-M-REGNUMBER | X(7) | Yes | 登録番号 | - |
| CA-M-COLOUR | X(8) | No | 色 | - |
| CA-M-CC | 9(4) | No | 排気量(cc) | - |
| CA-M-MANUFACTURED | X(10) | No | 製造年 | - |
| CA-M-PREMIUM | 9(6) | Yes | 保険料 | - |
| CA-M-ACCIDENTS | 9(6) | No | 事故件数 | - |

### 入力データソース

- 画面入力（自動車保険追加画面 SSMAPM2A）
- CICS通信領域（COMMAREA）を介したデータ連携

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| CA-RETURN-CODE | 9(2) | 処理結果コード |
| CA-POLICY-NUM | 9(10) | 発行されたポリシー番号 |
| CA-LASTCHANGED | X(26) | 最終更新タイムスタンプ |

### 出力先

- CICS通信領域（COMMAREA）
- Db2 POLICYテーブル
- Db2 MOTORテーブル
- VSAMファイル（KSDSPOLY）

## 処理フロー

### 処理シーケンス

```
1. COMMAREAの受信と検証
   └─ COMMAREAが存在しない場合はABEND('LGCA')
2. COMMAREAの長さチェック
   └─ ヘッダー28バイト + 自動車保険データ137バイトを確認
3. LGAPDB01プログラム呼び出し
   └─ CICS LINKでDb2アクセス層を呼び出し
4. POLICYテーブルへのINSERT（LGAPDB01）
   └─ ポリシー共通情報を登録、ポリシー番号を自動採番
5. MOTORテーブルへのINSERT（LGAPDB01）
   └─ 自動車固有情報を登録
6. VSAMファイルへの書き込み（LGAPVS01）
   └─ KSDSPOLYファイルにポリシーレコードを登録
7. 結果の返却
   └─ ポリシー番号とリターンコードをCOMMAREAに設定
```

### フローチャート

```mermaid
flowchart TD
    A[開始] --> B{COMMAREAあり?}
    B -->|No| C[ABEND LGCA]
    B -->|Yes| D{長さチェック}
    D -->|NG| E[RC=98で終了]
    D -->|OK| F{REQUEST-ID='01AMOT'?}
    F -->|No| G[RC=99で終了]
    F -->|Yes| H[LGAPDB01呼出]
    H --> I[POLICYテーブルINSERT]
    I --> J{SQLCODE判定}
    J -->|0| K[IDENTITY_VAL_LOCAL取得]
    J -->|-530| L[RC=70 FK違反]
    J -->|Other| M[RC=90 エラー]
    K --> N[MOTORテーブルINSERT]
    N --> O{SQLCODE=0?}
    O -->|Yes| P[LGAPVS01呼出]
    O -->|No| Q[ABEND LGSQでロールバック]
    P --> R[VSAMファイル書込]
    R --> S[RC=00で正常終了]
    E --> T[終了]
    G --> T
    L --> T
    M --> T
    Q --> T
    S --> T
    C --> T
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-001 | 顧客存在確認 | 登録前に顧客番号の存在を外部キー制約で確認 | 常時 |
| BR-002 | ポリシー番号自動採番 | IDENTITY列によりポリシー番号を自動発行 | 常時 |
| BR-003 | タイムスタンプ設定 | CURRENT TIMESTAMPで最終更新日時を自動設定 | 登録時 |
| BR-004 | ポリシータイプ設定 | 自動車保険は'M'（Motor）をPOLICYTYPEに設定 | 常時 |
| BR-005 | トランザクション整合性 | POLICYとMOTORの両方が成功しないとロールバック | 常時 |

### 計算ロジック

- ポリシー番号: Db2 IDENTITY_VAL_LOCAL()関数で取得
- 最終更新日時: CURRENT TIMESTAMP（Db2現在タイムスタンプ）

## データベース操作仕様

### 操作別データベース影響一覧

| 操作 | 対象テーブル | 操作種別 | 概要 |
|-----|-------------|---------|------|
| ポリシー情報登録 | POLICY | INSERT | 保険ポリシー共通情報の登録 |
| 自動車情報登録 | MOTOR | INSERT | 自動車保険固有情報の登録 |

### テーブル別操作詳細

#### POLICY

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| INSERT | POLICYNUMBER | DEFAULT | IDENTITY列で自動採番 |
| INSERT | CUSTOMERNUMBER | :DB2-CUSTOMERNUM-INT | |
| INSERT | ISSUEDATE | :CA-ISSUE-DATE | |
| INSERT | EXPIRYDATE | :CA-EXPIRY-DATE | |
| INSERT | POLICYTYPE | 'M' | Motor固定 |
| INSERT | LASTCHANGED | CURRENT TIMESTAMP | |
| INSERT | BROKERID | :DB2-BROKERID-INT | |
| INSERT | BROKERSREFERENCE | :CA-BROKERSREF | |
| INSERT | PAYMENT | :DB2-PAYMENT-INT | |

#### MOTOR

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| INSERT | POLICYNUMBER | :DB2-POLICYNUM-INT | POLICYから取得 |
| INSERT | MAKE | :CA-M-MAKE | メーカー |
| INSERT | MODEL | :CA-M-MODEL | モデル |
| INSERT | VALUE | :DB2-M-VALUE-INT | 車両価値 |
| INSERT | REGNUMBER | :CA-M-REGNUMBER | 登録番号 |
| INSERT | COLOUR | :CA-M-COLOUR | 色 |
| INSERT | CC | :DB2-M-CC-SINT | 排気量 |
| INSERT | YEAROFMANUFACTURE | :CA-M-MANUFACTURED | 製造年 |
| INSERT | PREMIUM | :DB2-M-PREMIUM-INT | 保険料 |
| INSERT | ACCIDENTS | :DB2-M-ACCIDENTS-INT | 事故件数 |

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| 98 | 入力エラー | COMMAREAの長さ不足 | 正しい長さのCOMMAREAで再実行 |
| 99 | 入力エラー | リクエストIDが不正 | 正しいリクエストIDを設定 |
| 70 | 業務エラー | 顧客番号が存在しない（SQLCODE=-530） | 正しい顧客番号を指定 |
| 90 | DB2エラー | その他のSQLエラー | エラーログ確認 |
| LGCA | システムエラー | COMMAREAなし | プログラム呼出方法確認 |
| LGSQ | DB2エラー | MOTORテーブルINSERT失敗 | ABENDでロールバック |

### リトライ仕様

- SQLエラー時はリトライなし
- ABEND('LGSQ')によりトランザクション全体がロールバック

## トランザクション仕様

- トランザクションID: SSC1
- コミット: 正常終了時にCICS RETURNで暗黙コミット
- ロールバック: ABEND('LGSQ')発生時、POLICYテーブルへの登録も含めてロールバック
- 注意: MOTORテーブルINSERT失敗時は、POLICYテーブルINSERTも含めてロールバックされる

## パフォーマンス要件

- レスポンス時間: 1秒以内
- IDENTITY列使用によりシーケンス取得が高速

## セキュリティ考慮事項

- 保険ポリシー作成には適切な権限管理が必要
- 顧客番号の外部キー制約により、存在しない顧客への登録を防止
- エラー発生時はLGSTSQプログラムを通じてエラーキューにログを記録

## 備考

- LGAPOL01: ビジネスロジック層（LGAPDB01を呼び出し）
- LGAPDB01: Db2データアクセス層（POLICY/MOTORテーブルINSERT、LGAPVS01呼び出し）
- LGAPVS01: VSAMデータアクセス層（KSDSPOLYファイル書込）
- 自動車保険固有の長さ定義: WS-FULL-MOTOR-LEN = 137バイト

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

まず、プログラム間で受け渡されるデータ構造を理解することが重要である。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | lgcmarea.cpy | `base/src/lgcmarea.cpy` | COMMAREA構造の理解。`CA-REQUEST-ID='01AMOT'`で自動車保険登録を識別。`CA-POLICY-REQUEST`内の`CA-MOTOR`構造体（メーカー、モデル、車両価値等）が入力データ |
| 1-2 | lgpolicy.cpy | `base/src/lgpolicy.cpy` | `WS-FULL-MOTOR-LEN`（137バイト）の定義を確認。ヘッダー28バイト + 自動車保険データで長さチェック |

**読解のコツ**: 自動車保険は`CA-MOTOR`構造体に固有データを持つ。`DB2-MOTOR`構造体との対応関係を理解することが重要。

#### Step 2: 画面レイアウトを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | ssmap.bms | `base/src/ssmap.bms` | `SSMAPM2A`マップが自動車保険追加画面。PF4キーで登録処理を実行 |

**読解のコツ**: 自動車保険関連の画面は`SSMAPM`で始まる（Motor用）。

#### Step 3: エントリーポイント（ビジネスロジック層）

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | lgapol01.cbl | `base/src/lgapol01.cbl` | **MAINLINE SECTION**（80-129行目）: COMMAREA検証とLGAPDB01呼び出し。このプログラムは全ポリシータイプ（養老、住宅、自動車、商業用）で共通 |

**主要処理フロー**:
1. **98-102行目**: COMMAREAなしの場合はABEND('LGCA')
2. **105行目**: リターンコードを'00'で初期化
3. **108-116行目**: COMMAREA長チェック（不足時RC='98'）
4. **121-124行目**: CICS LINKでLGAPDB01を呼び出し

**読解のコツ**: LGAPOL01は薄いラッパー層。リクエストID別の分岐はLGAPDB01で行われる。

#### Step 4: データアクセス層（DB2 INSERT処理）

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | lgapdb01.cbl | `base/src/lgapdb01.cbl` | **最も重要なファイル**。POLICYテーブル + MOTORテーブルへのINSERT |

**主要処理フロー**:
1. **165-169行目**: COMMAREAなしの場合はABEND('LGCA')
2. **184-207行目**: リクエストIDに応じた長さ計算とポリシータイプ設定
   - `'01AMOT'`: WS-FULL-MOTOR-LEN追加、ポリシータイプ='M'
3. **219行目**: `PERFORM INSERT-POLICY` でPOLICYテーブルINSERT
4. **231-232行目**: `PERFORM INSERT-MOTOR` でMOTORテーブルINSERT
5. **243-246行目**: CICS LINKでLGAPVS01を呼び出し（VSAM書込）

**注目すべき詳細**:
- **261-322行目** `INSERT-POLICY`: POLICYテーブルへのINSERT
  - **268-288行目**: POLICYNUMBERはDEFAULT（IDENTITY列で自動採番）
  - **290-305行目**: SQLCODE評価（-530は外部キー違反でRC='70'）
  - **308-311行目**: `IDENTITY_VAL_LOCAL()`でポリシー番号取得
  - **316-321行目**: LASTCHANGEDタイムスタンプ取得
- **440-481行目** `INSERT-MOTOR`: MOTORテーブルへのINSERT
  - **442-446行目**: 数値フィールドをDB2整数型に変換
  - **449-471行目**: 10項目をINSERT
  - **473-479行目**: エラー時はABEND('LGSQ')でPOLICYも含めロールバック

#### Step 5: VSAM処理層

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 5-1 | lgapvs01.cbl | `base/src/lgapvs01.cbl` | KSDSPOLYファイルへのポリシーレコード書込 |

**主要処理フロー**:
1. **99-101行目**: リクエストID、ポリシー番号、顧客番号をキーに設定
2. **103-132行目**: ポリシータイプ別にデータを移動
   - `'M'`（124-128行目）: 自動車保険データ（メーカー、モデル、車両価値、登録番号）
3. **135-147行目**: CICS WRITE FILEでKSDSPOLYに書込
   - 失敗時: RC='80'

**読解のコツ**: VSAMキーは「リクエストID(1) + 顧客番号(10) + ポリシー番号(10)」の21バイト。

#### Step 6: 補助機能（エラーログ）

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 6-1 | lgstsq.cbl | `base/src/lgstsq.cbl` | エラーメッセージをTDQ/TSQに書き込む共通ログ機能 |

### プログラム呼び出し階層図

```
画面操作（PF4キー押下 + 自動車保険データ入力）
    │
    ▼
LGAPOL01 (lgapol01.cbl)  ─────────────────┐
    │ CICS LINK                           │ エラー時
    ▼                                     ▼
LGAPDB01 (lgapdb01.cbl)              LGSTSQ (lgstsq.cbl)
    │                                     │
    ├─ SQL INSERT (POLICY)                └─ TDQ/TSQ書込
    │      └─ IDENTITY_VAL_LOCAL()
    │
    ├─ SQL INSERT (MOTOR)
    │      └─ エラー時 ABEND('LGSQ')
    │
    └─ CICS LINK ──▶ LGAPVS01 (lgapvs01.cbl)
                         │
                         └─ CICS WRITE FILE (KSDSPOLY)
```

### データフロー図

```
[入力]                    [処理]                         [出力]

COMMAREA ─────────▶ LGAPOL01 ─────▶ LGAPDB01 ─────────▶ POLICY (Db2)
 │                                      │                [INSERT]
 ├─ CA-REQUEST-ID                       │                 │
 │  ('01AMOT')                          │                 ▼
 ├─ CA-CUSTOMER-NUM                     │              MOTOR (Db2)
 ├─ CA-ISSUE-DATE                       │                [INSERT]
 ├─ CA-EXPIRY-DATE                      │
 ├─ CA-BROKERID                         │
 ├─ CA-BROKERSREF                       ▼
 ├─ CA-PAYMENT                    LGAPVS01 ───────────▶ KSDSPOLY (VSAM)
 ├─ CA-M-MAKE                          │                 [WRITE]
 ├─ CA-M-MODEL                         │
 ├─ CA-M-VALUE                         ▼
 ├─ CA-M-REGNUMBER                COMMAREA
 ├─ CA-M-COLOUR                        │
 ├─ CA-M-CC                            ├─ CA-RETURN-CODE
 ├─ CA-M-MANUFACTURED                  ├─ CA-POLICY-NUM（自動採番）
 ├─ CA-M-PREMIUM                       └─ CA-LASTCHANGED
 └─ CA-M-ACCIDENTS
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| lgapol01.cbl | `base/src/lgapol01.cbl` | COBOLプログラム | ビジネスロジック層（エントリーポイント） |
| lgapdb01.cbl | `base/src/lgapdb01.cbl` | COBOLプログラム | Db2データアクセス層（POLICY/MOTOR INSERT） |
| lgapvs01.cbl | `base/src/lgapvs01.cbl` | COBOLプログラム | VSAMデータアクセス層（KSDSPOLY書込） |
| lgcmarea.cpy | `base/src/lgcmarea.cpy` | コピーブック | COMMAREA構造定義 |
| lgpolicy.cpy | `base/src/lgpolicy.cpy` | コピーブック | ポリシー/自動車保険データ長定義 |
| ssmap.bms | `base/src/ssmap.bms` | BMSマップ | 画面定義（SSMAPM2Aが自動車保険追加） |
| lgstsq.cbl | `base/src/lgstsq.cbl` | COBOLプログラム | エラーログ共通機能 |
